<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
header('Content-Type: application/json');

session_start(); 
require_once '../../../../xd-assets/backend/config/dbconfig.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(["error" => "Database connection failed: " . $e->getMessage()]);
    exit;
}

// Get org_id (from session or request)
$org_id = $_SESSION['orgid'] ?? $_GET['orgid'] ?? null;

if (!$org_id) {
    echo json_encode(["error" => "Missing organization ID"]);
    exit;
}

$query = "
    SELECT 
        po.id,
        po.po_number,
        po.supplier_id,
        po.po_date,
        po.expected_delivery_date, 
        po.requisition_id, 
        po.updated_at,
        s.supplier_name,
        s.phone AS supplier_phone,
        s.email AS supplier_email,
        s.address AS supplier_address,
        d.name AS department_name,
        w.warehouse_name
    FROM purchase_order po
    LEFT JOIN supplier s ON po.supplier_id = s.id
      LEFT JOIN warehouse w ON po.warehouse_id = w.id
    LEFT JOIN departments d ON po.department_id = d.id
    WHERE po.org_id = :org_id AND po.status != 'Received'
";

try {
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':org_id', $org_id, PDO::PARAM_INT);
    $stmt->execute();
} catch (PDOException $e) {
    echo json_encode(["error" => "Query failed: " . $e->getMessage()]);
    exit;
}

$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (empty($rows)) {
    echo json_encode(["details" => [], "numofrows" => 0]);
    exit;
}

echo json_encode([
    "details" => $rows,
    "numofrows" => count($rows)
]);
exit;
?>
