<?php
/**
 * Get Requisition Details (for converting to PO)
 * File: xd-modules/inventory/procurement/backend/get_requisition_details.php
 */

session_start();
require_once '../../../../xd-assets/backend/config/dbconfig.php';
header('Content-Type: application/json');

$response = ['success' => false, 'requisition' => null, 'items' => [], 'message' => ''];

try {
    $reqId = $_GET['id'] ?? null;

    if (!$reqId) {
        throw new Exception('Requisition ID is required');
    }

    $orgId = $_SESSION['orgid'] ?? null;

    // Get requisition header
    $stmt = $conn->prepare("
        SELECT 
            pr.id,
            pr.requisition_number,
            pr.requisition_date,
            pr.required_by_date,
            pr.priority,
            pr.department,
            pr.justification,
            pr.status,
            pr.requested_by,
            pr.org_id,
            u.names AS requested_by_name,
            d.name AS department_name
        FROM purchase_requisition pr
        LEFT JOIN users u ON pr.requested_by = u.id
        LEFT JOIN departments d ON pr.department = d.id
        WHERE pr.id = :req_id
        AND pr.org_id = :org_id
    ");
    $stmt->execute([
        ':req_id' => $reqId,
        ':org_id' => $orgId
    ]);
    $requisition = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$requisition) {
        throw new Exception('Requisition not found');
    }

    // Get requisition items
    $stmt = $conn->prepare("
        SELECT 
            pri.id,
            pri.requisition_id,
            pri.product_id,
            pri.quantity_requested,
            pri.estimated_unit_price,
            pri.estimated_total,
            pri.notes,
            p.name AS product_name,
            p.product_code,
            p.units,
            p.image,
            p.category
        FROM purchase_requisition_item pri
        LEFT JOIN tblproduct p ON pri.product_id = p.id
        WHERE pri.requisition_id = :req_id
        ORDER BY pri.id
    ");
    $stmt->execute([':req_id' => $reqId]);
    $items = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $response = [
        'success' => true,
        'requisition' => $requisition,
        'items' => $items,
        'item_count' => count($items),
        'message' => 'Requisition details retrieved successfully.'
    ];

} catch (Exception $e) {
    $response['message'] = $e->getMessage();
    error_log("Get Requisition Details Error: " . $e->getMessage());
}

echo json_encode($response);
?>