<?php
session_start();
require_once '../../../../xd-assets/backend/config/dbconfig.php';
header('Content-Type: application/json');

$response = ['success' => false, 'data' => [], 'message' => ''];

try {
    $orgId  = $_SESSION['orgid'] ?? null;
    $userId = $_SESSION['userid'] ?? null;

    // Optional filter by user or department
    $filterBy = '';
    $params = [];

    if (isset($_GET['mine']) && $_GET['mine'] == '1') {
        $filterBy = 'WHERE pr.requested_by = :userid';
        $params[':userid'] = $userId;
    } elseif ($orgId) {
        $filterBy = 'WHERE pr.org_id = :orgid';
        $params[':orgid'] = $orgId;
    }

    // Main query: requisition summary
    $query = "
        SELECT 
            pr.id,
            pr.requisition_number,
            pr.requisition_date,
            pr.required_by_date,
            pr.priority,
            pr.department AS department_id,
            dp.name AS department,
            pr.justification,
            pr.status,
            u.names AS requested_by_name,
            COUNT(pri.id) AS item_count,
            SUM(pri.estimated_total) AS total_estimated
        FROM purchase_requisition pr
        LEFT JOIN purchase_requisition_item pri ON pr.id = pri.requisition_id
         LEFT JOIN departments dp ON pr.department = dp.id
        LEFT JOIN users u ON pr.requested_by = u.id
        $filterBy
        GROUP BY pr.id
        ORDER BY pr.id DESC
    ";

    $stmt = $conn->prepare($query);
    $stmt->execute($params);
    $requisitions = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $response = [
        'success' => true,
        'data' => $requisitions,
        'message' => 'Requisitions retrieved successfully.'
    ];
} catch (Exception $e) {
    $response['message'] = $e->getMessage();
}

echo json_encode($response);
