<?php
 session_start();
require_once '../../../../xd-assets/backend/config/dbconfig.php';
header('Content-Type: application/json');

$response = ['success' => false, 'data' => [], 'message' => ''];

try {
    $orgId = $_SESSION['orgid'] ?? null;
    $userId = $_SESSION['userid'] ?? null;

    if (!$orgId) {
        throw new Exception('Organization ID not found in session');
    }

    // Optional filters from GET parameters
    $filters = [
        'status' => $_GET['status'] ?? null,
        'supplier_id' => $_GET['supplier_id'] ?? null,
        'search' => $_GET['search'] ?? null,
        'start_date' => $_GET['start_date'] ?? null,
        'end_date' => $_GET['end_date'] ?? null,
        'priority' => $_GET['priority'] ?? null
    ];

    // Base SQL query
    $sql = "
        SELECT 
            po.id,
            po.po_number,
            po.supplier_id,
            po.po_date,
            po.expected_delivery_date,
            po.payment_terms,
            po.priority,
            po.subtotal,
            po.tax_amount,
            po.discount_amount,
            po.shipping_cost,
            po.total_amount AS grand_total,
            po.status,
            po.notes,
            po.requisition_id,
            po.created_by,
            po.created_at,
            po.updated_at,
            s.supplier_name,
            s.phone AS supplier_phone,
            s.email AS supplier_email,
            u.names AS created_by_name,
            COUNT(DISTINCT poi.id) AS item_count,
            SUM(poi.quantity_received) AS total_quantity
        FROM purchase_order po
        LEFT JOIN supplier s ON po.supplier_id = s.id
        LEFT JOIN users u ON po.created_by = u.id
        LEFT JOIN purchase_order_item poi ON po.id = poi.po_id
        WHERE po.org_id = :org_id
    ";

    $params = ['org_id' => $orgId];

    // Add dynamic filters
    if (!empty($filters['status'])) {
        $sql .= " AND po.status = :status";
        $params['status'] = $filters['status'];
    }

    if (!empty($filters['supplier_id'])) {
        $sql .= " AND po.supplier_id = :supplier_id";
        $params['supplier_id'] = $filters['supplier_id'];
    }

    if (!empty($filters['search'])) {
        $sql .= " AND (
            po.po_number LIKE :search 
            OR s.supplier_name LIKE :search 
            OR po.notes LIKE :search
        )";
        $params['search'] = '%' . $filters['search'] . '%';
    }

    if (!empty($filters['start_date'])) {
        $sql .= " AND po.po_date >= :start_date";
        $params['start_date'] = $filters['start_date'];
    }

    if (!empty($filters['end_date'])) {
        $sql .= " AND po.po_date <= :end_date";
        $params['end_date'] = $filters['end_date'];
    }

    if (!empty($filters['priority'])) {
        $sql .= " AND po.priority = :priority";
        $params['priority'] = $filters['priority'];
    }

    // Group by and order
    $sql .= " 
        GROUP BY po.id 
        ORDER BY po.id DESC
    ";

    // Execute query
    $stmt = $conn->prepare($sql);
    $stmt->execute($params);
    $orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Format data for frontend
    foreach ($orders as &$order) {
        // Ensure numeric values
        $order['subtotal'] = floatval($order['subtotal'] ?? 0);
        $order['tax_amount'] = floatval($order['tax_amount'] ?? 0);
        $order['discount_amount'] = floatval($order['discount_amount'] ?? 0);
        $order['shipping_cost'] = floatval($order['shipping_cost'] ?? 0);
        $order['grand_total'] = floatval($order['grand_total'] ?? 0);
        $order['item_count'] = intval($order['item_count'] ?? 0);
        $order['total_quantity'] = floatval($order['total_quantity'] ?? 0);

        // Format dates
        if ($order['po_date']) {
            $order['po_date'] = date('Y-m-d', strtotime($order['po_date']));
        }
        if ($order['expected_delivery_date']) {
            $order['expected_delivery_date'] = date('Y-m-d', strtotime($order['expected_delivery_date']));
        }
    }

    $response = [
        'success' => true,
        'data' => $orders,
        'count' => count($orders),
        'message' => 'Purchase orders retrieved successfully.',
        'filters_applied' => array_filter($filters) // Show which filters were used
    ];

} catch (Exception $e) {
    $response['message'] = $e->getMessage();
    error_log("Get Purchase Orders Error: " . $e->getMessage());
}

$conn = null;
echo json_encode($response);
?>