
<?php
/**
 * Get Purchase Order Details
 * File: xd-modules/inventory/procurement/backend/get_po_details.php
 */

session_start();
require_once '../../../../xd-assets/backend/config/dbconfig.php';
header('Content-Type: application/json');

$response = ['success' => false, 'po' => null, 'items' => [], 'message' => ''];

try {
    $poId = $_GET['id'] ?? null;

    if (!$poId) {
        throw new Exception('PO ID is required');
    }

    // Get PO header
    $stmt = $conn->prepare("
        SELECT 
            po.*,
            s.supplier_name,
            s.email AS supplier_email,
            s.phone AS supplier_phone,
            s.address AS supplier_address,
            u.names AS created_by_name
        FROM purchase_order po
        LEFT JOIN supplier s ON po.supplier_id = s.id
        LEFT JOIN users u ON po.created_by = u.id
        WHERE po.id = :po_id
    ");
    $stmt->execute([':po_id' => $poId]);
    $po = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$po) {
        throw new Exception('Purchase Order not found');
    }

    // Get PO items
    $stmt = $conn->prepare("
        SELECT 
            poi.*,
            p.name AS product_name,
            p.product_code,
            p.units
        FROM purchase_order_item poi
        LEFT JOIN tblproduct p ON poi.product_id = p.id
        WHERE poi.po_id = :po_id
        ORDER BY poi.id
    ");
    $stmt->execute([':po_id' => $poId]);
    $items = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $response = [
        'success' => true,
        'po' => $po,
        'items' => $items,
        'message' => 'PO details retrieved successfully.'
    ];

} catch (Exception $e) {
    $response['message'] = $e->getMessage();
    error_log("Get PO Details Error: " . $e->getMessage());
}

echo json_encode($response);
?>