<?php
/**
 * Get GRN Details (Single Record)
 * File: xd-modules/inventory/procurement/backend/get_grn_details.php
 * Purpose: View complete details of a single GRN
 */

session_start();
require_once '../../../../xd-assets/backend/config/dbconfig.php';
header('Content-Type: application/json');

$response = ['success' => false, 'grn' => null, 'items' => [], 'message' => ''];

try {
    $grnId = $_GET['id'] ?? null;
    $orgId = $_SESSION['orgid'] ?? null;

    if (!$grnId) {
        throw new Exception('GRN ID is required');
    }

    if (!$orgId) {
        throw new Exception('Organization ID not found in session');
    }

    // Get GRN header with all related information
    $stmt = $conn->prepare("
        SELECT 
            gr.id,
            gr.grn_number,
            gr.po_id,
            gr.warehouse_id,
            gr.receipt_date,
            gr.received_by,
            gr.total_amount,
            gr.notes,
            gr.status,
            gr.created_at,
            po.po_number,
            po.po_date,
            po.expected_delivery_date,
            s.id AS supplier_id,
            s.supplier_name,
            s.phone AS supplier_phone,
            s.email AS supplier_email,
            s.address AS supplier_address,
            w.warehouse_name,
            w.address AS warehouse_address,
            u.names AS received_by_name,
            u.phone AS received_by_phone
        FROM goods_receipt gr
        LEFT JOIN purchase_order po ON gr.po_id = po.id
        LEFT JOIN supplier s ON po.supplier_id = s.id
        LEFT JOIN warehouse w ON gr.warehouse_id = w.id
        LEFT JOIN users u ON gr.received_by = u.id
        WHERE gr.id = :grn_id
        AND gr.org_id = :org_id
    ");
    
    $stmt->execute([
        ':grn_id' => $grnId,
        ':org_id' => $orgId
    ]);
    
    $grn = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$grn) {
        throw new Exception('Goods Receipt not found');
    }

    // Get GRN items with product details
    $stmt = $conn->prepare("
        SELECT 
            gri.id,
            gri.grn_id,
            gri.po_item_id,
            gri.product_id,
            gri.quantity_received,
            gri.unit_cost,
            gri.line_total,
            gri.batch_number,
            gri.expiry_date,
            gri.created_at,
            p.name AS product_name,
            p.product_code,
            p.units,
            p.category,
            p.image,
            poi.quantity AS ordered_quantity
        FROM goods_receipt_item gri
        LEFT JOIN tblproduct p ON gri.product_id = p.id
        LEFT JOIN purchase_order_item poi ON gri.po_item_id = poi.id
        WHERE gri.grn_id = :grn_id
        ORDER BY gri.id ASC
    ");
    
    $stmt->execute([':grn_id' => $grnId]);
    $items = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Format data
    $grn['total_amount'] = floatval($grn['total_amount'] ?? 0);
    
    foreach ($items as &$item) {
        $item['quantity_received'] = floatval($item['quantity_received'] ?? 0);
        $item['unit_cost'] = floatval($item['unit_cost'] ?? 0);
        $item['line_total'] = floatval($item['line_total'] ?? 0);
        $item['ordered_quantity'] = floatval($item['ordered_quantity'] ?? 0);
    }

    $response = [
        'success' => true,
        'grn' => $grn,
        'items' => $items,
        'item_count' => count($items),
        'message' => 'GRN details retrieved successfully'
    ];

} catch (Exception $e) {
    $response['message'] = $e->getMessage();
    error_log("Get GRN Details Error: " . $e->getMessage());
}

$conn = null;
echo json_encode($response);
?>