<?php
session_start();
require_once '../../../../xd-assets/backend/config/dbconfig.php';
header('Content-Type: application/json');

$response = ['status' => 'error'];

try {
    // --- Read from $_POST since you're sending form data ---
    $requisitionDate = $_POST['requisitionDate'] ?? date('Y-m-d');
    $requiredByDate  = $_POST['requiredByDate'] ?? date('Y-m-d');
    $justification   = $_POST['justification'] ?? '';
    $priority        = $_POST['priority'] ?? 'medium';
    $department      = $_POST['department'] ?? null;
    $orderDetails    = $_POST['orderDetails'] ?? '[]';

    $orgId  = $_SESSION['orgid']; // fallback for testing
    $userId = $_SESSION['userid']; // fallback for testing

    if (!$department) {
        throw new Exception("Department is required.");
    }

    $items = json_decode($orderDetails, true);
    if (!$items || count($items) === 0) {
        throw new Exception("At least one item is required.");
    }

    // --- Get latest requisition number ---
    $stmt = $conn->query("SELECT requisition_number FROM purchase_requisition WHERE org_id='$orgId' ORDER BY id DESC LIMIT 1");
    $lastReq = $stmt->fetch(PDO::FETCH_ASSOC);
    $nextNumber = ($lastReq && isset($lastReq['requisition_number'])) ? ((int)$lastReq['requisition_number'] + 1) : 1;

    // --- Begin transaction ---
    $conn->beginTransaction();

    // --- Insert requisition ---
    $stmt = $conn->prepare("
        INSERT INTO purchase_requisition
        (requisition_number, requisition_date, requested_by, department, priority, required_by_date, justification, org_id)
        VALUES (:req_number, :req_date, :requested_by, :dept, :priority, :required_by, :justification, :org_id)
    ");
    $stmt->execute([
        ':req_number'   => $nextNumber,
        ':req_date'     => $requisitionDate,
        ':requested_by' => $userId,
        ':dept'         => $department,
        ':priority'     => $priority,
        ':required_by'  => $requiredByDate,
        ':justification'=> $justification,
        ':org_id'       => $orgId
    ]);
    $requisitionId = $conn->lastInsertId();

    // --- Insert items ---
    $stmtItem = $conn->prepare("
        INSERT INTO purchase_requisition_item
        (requisition_id, product_id, quantity_requested, estimated_unit_price, estimated_total, notes)
        VALUES (:req_id, :product_id, :qty, :unit_price, :total, :notes)
    ");

    foreach ($items as $item) {
        $stmtItem->execute([
            ':req_id'      => $requisitionId,
            ':product_id'  => $item['id'] ?? $item['product_id'] ?? 0,
            ':qty'         => $item['quantity'] ?? $item['quantity_requested'] ?? 0,
            ':unit_price'  => $item['price'] ?? $item['estimated_unit_price'] ?? 0,
            ':total'       => $item['total'] ?? $item['estimated_total'] ?? 0,
            ':notes'       => $item['notes'] ?? ''
        ]);
    }

    $conn->commit();

    $response = [
        'status' => 'created',
        'requisitionnumber' => $nextNumber,
        'date' => $requisitionDate,
        'requisition_id' => $requisitionId,
        'message' => 'Requisition created successfully.'
    ];

} catch (Exception $e) {
    if ($conn->inTransaction()) $conn->rollBack();
    $response['message'] = $e->getMessage();
}

echo json_encode($response);
?>
