<?php
/**
 * Create Purchase Order (PDO version)
 * File: xd-modules/inventory/procurement/backend/create_purchase_order.php
 */

session_start();
require_once '../../../../xd-assets/backend/config/dbconfig.php';
header('Content-Type: application/json');

$response = ['status' => 'error', 'message' => ''];

try {
    // Validate input
    if (empty($_POST['orderDetails'])) {
        throw new Exception("Missing order details.");
    }

    // Collect form data
    $departmentId  = $_POST['departmentId'] ?? null;
    $requisitionId = $_POST['requisitionNumber'] ?? null;
    $supplierId    = $_POST['supplierId'] ?? null;
    $warehouseId   = $_POST['po-deliverplace'] ?? null;
    $poDate        = $_POST['poDate'] ?? date('Y-m-d');
    $deliveryDate  = $_POST['deliveryDate'] ?? date('Y-m-d');
    $paymentTerm   = $_POST['paymentTerm'] ?? 'Immediate';
    $status        = $_POST['status'] ?? 'draft';
    $priority      = $_POST['priority'] ?? 'Normal';
    $justification = $_POST['justification'] ?? '';
    $orderDetails  = json_decode($_POST['orderDetails'], true);

    $org_id  = $_SESSION["orgid"] ?? 1;
    $user_id = $_SESSION["userid"] ?? 1;

    // === Generate PO Number ===
    $stmt = $conn->query("SELECT po_number FROM purchase_order WHERE org_id=$org_id  ORDER BY id DESC LIMIT 1");
    $lastPo = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($lastPo && preg_match('/PO-(\d+)/', $lastPo['po_number'], $matches)) {
        $nextNumber = (int)$matches[1] + 1;
    } else {
        $nextNumber = 1;
    }

    $po_number = 'PO-' . str_pad($nextNumber, 6, '0', STR_PAD_LEFT);

    // === Begin transaction ===
    $conn->beginTransaction();

    // === Insert into purchase_order ===
    $stmt = $conn->prepare("
        INSERT INTO purchase_order (
            po_number, po_date, supplier_id, requisition_id, warehouse_id,
            department_id, expected_delivery_date, payment_terms, status,
            priority, created_by, org_id, subtotal, total_amount
        ) VALUES (
            :po_number, :po_date, :supplier_id, :requisition_id, :warehouse_id,
            :department_id, :expected_delivery_date, :payment_terms, :status,
            :priority, :created_by, :org_id, :subtotal, :total_amount
        )
    ");

    // Calculate totals
    $subtotal = 0;
    foreach ($orderDetails as $item) {
        $subtotal += $item['price'] * $item['count'];
    }

    $stmt->execute([
        ':po_number'             => $po_number,
        ':po_date'               => $poDate,
        ':supplier_id'           => $supplierId,
        ':requisition_id'        => $requisitionId,
        ':warehouse_id'          => $warehouseId,
        ':department_id'         => $departmentId,
        ':expected_delivery_date'=> $deliveryDate,
        ':payment_terms'         => $paymentTerm,
        ':status'                => $status,
        ':priority'              => $priority,
        ':created_by'            => $user_id,
        ':org_id'                => $org_id,
        ':subtotal'              => $subtotal,
        ':total_amount'          => $subtotal, // can adjust for tax/discount later
    ]);

    $po_id = $conn->lastInsertId();

    // === Insert items ===
    $itemStmt = $conn->prepare("
        INSERT INTO purchase_order_item (
            po_id, product_id, quantity_ordered, unit_price, line_total
        ) VALUES (
            :po_id, :product_id, :quantity_ordered, :unit_price, :line_total
        )
    ");

    foreach ($orderDetails as $item) {
        $quantity = $item['count'] ?? 0;
        $unitPrice = $item['price'] ?? 0;
        $lineTotal = $quantity * $unitPrice;

        $itemStmt->execute([
            ':po_id'            => $po_id,
            ':product_id'       => $item['id'] ?? null,
            ':quantity_ordered' => $quantity,
            ':unit_price'       => $unitPrice,
            ':line_total'       => $lineTotal
        ]);
    }

    // === Commit transaction ===
    $conn->commit();

    $response = [
        'status' => 'created',
        'po_number' => $po_number,
        'message' => 'Purchase order created successfully.'
    ];

} catch (Exception $e) {
    if ($conn->inTransaction()) {
        $conn->rollBack();
    }
    $response['message'] = $e->getMessage();
}

echo json_encode($response);
