<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../../xd-assets/backend/config/dbconfig.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo "Connection failed: " . $e->getMessage();
    exit;
}

$startDateInput = filter_input(INPUT_POST, "startDate");
$endDateInput = filter_input(INPUT_POST, "endDate");
$searchKey = filter_input(INPUT_POST, "searchKey");
$selectworkforce = filter_input(INPUT_POST, "selectworkForce");
$status = filter_input(INPUT_POST, "status");

$conditions = [];
$parameters = [];

if (!empty($startDateInput)) {
    $conditions[] = "users.signup >= :start_date";
    $parameters[':start_date'] = date('Y-m-d', strtotime($startDateInput));
}

if (!empty($endDateInput)) {
    $conditions[] = "users.signup <= :end_date";
    $parameters[':end_date'] = date('Y-m-d', strtotime($endDateInput));
}

if (!empty($searchKey)) {
    $conditions[] = "(supplier.supplier_name LIKE :search_key OR supplier.company_name LIKE :search_key OR users.email LIKE :search_key OR users.names LIKE :search_key OR users.phone LIKE :search_key OR users.nrc LIKE :search_key OR users.tpin LIKE :search_key)";
    $parameters[':search_key'] = '%' . $searchKey . '%';
}

// Add all columns from supplier table to the SELECT statement
$getproductsquery = "SELECT DISTINCT 
    supplier.id,
    supplier.supplier_code,
    supplier.supplier_name,
    supplier.company_name,
    supplier.email AS supplier_email,
    supplier.phone AS supplier_phone,
    supplier.mobile,
    supplier.website,
    supplier.tax_id,
    supplier.payment_terms,
    supplier.credit_limit,
    supplier.currency,
    supplier.address AS supplier_address,
    supplier.city,
    supplier.state,
    supplier.country,
    supplier.postal_code,
    supplier.contact_person,
    supplier.contact_phone,
    supplier.contact_email,
    supplier.rating,
    supplier.lead_time_days,
    supplier.is_active,
    supplier.notes,
    supplier.org_id,
    supplier.created_by,
    supplier.created_at,
    supplier.updated_at,
    supplier.role_id,
    roles.role_name,
    supplier.status,  
    users.id AS user_id,
    users.email AS email,
    users.names,
    users.phone AS phone,
    users.address AS address,
    users.nrc,
    users.avatar,
    users.company_registration_number,
    users.tpin,
    users.area,
    users.plot_number,
    users.user_type
FROM supplier
INNER JOIN users ON supplier.user_id = users.id
INNER JOIN user_roles ON supplier.role_id = user_roles.role_id AND supplier.org_id = user_roles.org_id  
INNER JOIN roles ON supplier.role_id = roles.role_id AND supplier.org_id = roles.org_id";

if (!empty($status)) {
    $getproductsquery .= " AND supplier.status = :status";
    $parameters[':status'] = $status;
}

if (!empty($conditions)) {
    $getproductsquery .= " AND " . implode(" AND ", $conditions);
}

$getproductsquery .= " ORDER BY users.names ASC LIMIT 1000";

try {
    $getproducts = $conn->prepare($getproductsquery);
    $getproducts->execute($parameters);
} catch (PDOException $e) {
    echo "Query execution failed: " . $e->getMessage();
    exit;
}

$getproducts->setFetchMode(PDO::FETCH_ASSOC);

$totalrecords = $getproducts->rowCount();

$nestedData = [];

while ($row = $getproducts->fetch()) {
    $nestedData[] = $row;
}

if ($totalrecords === 0) {
    echo json_encode(["error" => "No workforce found"]);
    exit;
}

$json_data = [
    "details" => $nestedData,
    'numofrows' => $totalrecords
];

echo json_encode($json_data);
exit;
?>