function warehouseHeader(){
  let today = new Date().toISOString().slice(0, 10);
  $('#page-options').empty(); 
  $('#page-options').append('<select class="warehouseSelectKey101" style="border:none;outline:none;background-color:transparent;text-transform:uppercase;color:gray;"><option value="warehouseList">Warehouses</option></select> <span id="record01" class="topNavTotals"></span>');
 $('#right_nav_options0').empty();
  $('#right_nav_options0').append('<a href="#" id="bankAccountDepositIconDiv" class="w3-hide-small top-right-navigation-icons101"><span class="fontx fx-file depositSlipIcon1"></span></a>');
 
  $('#right_nav_options0').append('<div class="top-right-navigation-icons101 w3-hide-small"><input type="checkbox" class="checkThemAll fontx" style="margin-left:2.5px;margin-bottom:5px;"/></div>');
  $('#right_nav_options0').append('<div class="w3-hide-small mainPrintBtn102  w3-hide-small top-right-navigation-icons101"><span class="fontx fx-printer"></span></div>');
 $('#right_nav_options0').append('<div id="exportTransactioins" class="w3-hide-small top-right-navigation-icons101"><span class="fontx fx-share-2"></span></div>');
 $('#right_nav_options0').append('<div  class="downloadData w3-hide-small top-right-navigation-icons101"><span class="fontx fx-download"></span></div>');
   $('#right_nav_options0').append('<div  class="w3-hide-small top-right-navigation-icons101 addWarehouse101"><span class="fontx fx-plus"></span></div>');
  
  $('#sub_top_nav').empty(); 
  $('#sub_top_nav').append('<div id="searchContainer0" class="w3-col l12 m12 s12 w3-center"><div class="w3-col l1 m1 s1 w3-center w3-hide-small" style="padding-top: 5px;"><span class="fontx fx-search" style="color:gray;font-size:1.5em"></span></div><div class="w3-col l4 m4 s7 w3-center"><input id="searchWarehouse101" type="text" placeholder="Type to search..." style="font-weight:400;outline:none;color:black;border:none;border-bottom:none;width:100%;height:30px;background-color:transparent;padding-left:7px;"/></div><div class="w3-col l2 m2 s2 w3-center" style="padding-top:5px;"><span style="float:right"><span class="fontx fx-pie-chart" style="color:var(--primary-color);margin-top:5px;"></span><select id="revenueReportDisplayType" class="reduceSizeOnSmallScreen"  style="background-color:transparent;border:none;outline:none;color:gray;"><option value="Charts">Charts</option><option value="Normal">Normal</option><option value="Display All">Display All</option><option value="Map">Map</option></select></span><div/></div><div class="w3-col l5 m5 s3 w3-center" style="padding-left:7px;padding-top:3px;color:gray;background-color:;"><span style="float:right;"><input type="date" value="'+today+'" id="revenueReportStartDate" class="reduceSizeOnSmallScreen" style="color:var(--primary-color);border:none;outline:none;font-weight:100;background-color:transparent;"/><input type="date" value="'+today+'" id="revenueReportEndDate" class="reduceSizeOnSmallScreen" style="color:var(--primary-color);border:none;outline:none;font-weight:100;background-color:transparent;"/></span></div>');

 }
// Load warehouses on click
$(document).on('click', '.warehouses101', async function() {
    warehouseHeader();
    $('#main-body').empty().append('<center><div class="body-loader"></div><br/></center>');
    await fetchWarehouses();
});
 
// Trigger search on keyup/change
$(document).on('keyup change', '#searchWarehouse101', function () { 
    const searchKey = $("#searchWarehouse101").val().trim();
    const selectKey = $(".warehouseSelectKey101").val();

    if (selectKey === "warehouseList") {
        fetchWarehouses(searchKey); // searchKey can be empty
    }
});

// Fetch warehouses (optional searchKey)
async function fetchWarehouses(searchKey = '') {
    try {
        const url = `xd-modules/inventory/backend/list_warehouses.php?search=${encodeURIComponent(searchKey)}`;
        const response = await fetch(url);
        const data = await response.json();

        const container = $('#main-body');
        container.empty();

        if (!data.success) {
            container.append('<p style="color:red;">' + data.message + '</p>');
            return;
        }

        // Header
        container.append(`
            <div class="inner-data-div w3-col l12 m12 s12 w3-hide-small" style="font-weight:600;">
                <div class="w3-col l3 m3 s12" style="padding-left:10px;">Warehouse</div>
                <div class="w3-col l1 m1 s2">Type</div>
                <div class="w3-col l1 m1 s12">Capacity</div>
                <div class="w3-col l1 m1 s12">Utilization</div>
                <div class="w3-col l1 m1 s12">Products</div>
                <div class="w3-col l2 m2 s12">Stock Value</div>
                <div class="w3-col l2 m2 s12">Address</div>
                <div class="w3-col l1 m1 s2 hideOnPrint">Action</div>
            </div>
        `);

        // Data rows
        data.details.forEach(w => {
            const utilizationPercentage = w.utilization_percentage || 0;
            const utilizationColor = utilizationPercentage >= 90 ? 'red' : utilizationPercentage >= 70 ? 'orange' : 'var(--primary-color)';

            container.append(`
                <div class="inner-data-div w3-col l12 m12 s12" style="cursor:pointer; border-bottom:1px solid #ddd; padding:4px 0;">
                    <div class="w3-col l3 m3 s12" style="padding-left:10px; font-weight:600; color:var(--primary-color);">
                        <span style="color:gray;">${w.warehouse_code}</span> ${w.warehouse_name}
                    </div>
                    <div class="w3-col l1 m1 s2">${w.warehouse_type_label}</div>
                    <div class="w3-col l1 m1 s12">${w.capacity}</div>
                    <div class="w3-col l1 m1 s12" style="color:${utilizationColor};">${w.current_utilization} (${utilizationPercentage}%)</div>
                    <div class="w3-col l1 m1 s12">${w.product_count}</div>
                    <div class="w3-col l2 m2 s12">$${w.total_stock_value.toFixed(2)}</div>
                    <div class="w3-col l2 m2 s12">${w.address || 'N/A'}</div>
                    <div class="w3-col l1 m1 s2">
                        <select class="innerDivWarehouseSelectKey inner-data-more-actions2 hideOnPrint" data-id="${w.id}">
                            <option value="select-actions">More</option>
                            <option value="view-more-details">Details</option>
                            <option value="view-more-details">Zones</option>
                            <option value="Deletes">Delete</option>
                            <option value="Active">Activate</option>
                            <option value="Suspend">Suspend</option>
                        </select>
                    </div>
                </div>
            `);
        });

    } catch (err) {
        console.error(err);
        $('#main-body').html('<p style="color:red;">Failed to load warehouses.</p>');
    }
}


 
 

// Handle dropdown actions
$(document).on('change', '.innerDivWarehouseSelectKey', async function() {
    const action = $(this).val();
    const warehouseId = $(this).data('id');

    if (action === 'view-more-details') {
        await showWarehouseDetails(warehouseId);
    } else if (action === 'Deletes') {
        if (confirm('Are you sure you want to delete this warehouse?')) {
            alert(`Deleting warehouse ID: ${warehouseId}`);
        }
    } else if (action === 'Active') {
        alert(`Activating warehouse ID: ${warehouseId}`);
    } else if (action === 'Suspend') {
        alert(`Suspending warehouse ID: ${warehouseId}`);
    }

    $(this).val('select-actions'); // Reset dropdown
});

async function showWarehouseDetails(id) {
    try {
        const response = await fetch(`xd-modules/inventory/backend/get_warehouse.php?id=${id}`);
        const data = await response.json();

        if (!data.success) {
            alert('Failed to load warehouse details.');
            return;
        }

        const warehouse = data.details;
 
        // Reset and create modal
        $('#external_page_contents').empty().append(`
            <div id="invoice_modal" class="w3-modal w3-center" 
                 style="background-color:rgba(255,255,255,1);z-index:999999999999;">
            </div>
        `);

        // Modal Header
        $('#invoice_modal').append(`
            <div class="w3-col l12 m12 s12 w3-card-2 hideOnPrint" 
                 style="height:40px;color:gray;">
                <span class="close_invoice_modal" 
                      style="float:left;cursor:pointer;margin-top:5px;margin-left:10px;"
                      onclick="$('#invoice_modal').fadeOut();">
                      <span class="fontx fx-arrow-left" 
                            style="font-size:2em;color:var(--primary-color);"></span>
                </span>
                <span style="float:left;color:var(--primary-color);margin-top:10px;margin-left:10px;">
                    VIEW WAREHOUSE DETAILS
                </span>
            </div>
        `);

        // Form structure
        $('#invoice_modal').append(`
            <form method="post" id="warehouse_form" enctype="multipart/form-data" style="margin-top:40px;">
                <div class="main-body-left-div w3-col l7 m7 s12"></div>
                <div class="main-body-right-div w3-col l5 m5 s12"></div>
            </form>
        `);

        // LEFT SIDE - Map
        $('.main-body-left-div').empty().append(`
            <div style="padding:5px;"> 
                <div id="warehouse_map" style="width:100%;height:100vh;border:1px solid #ddd;border-radius:8px;"></div>
            </div>
        `);

        // RIGHT SIDE - Form fields (same layout as createWarehouse101)
        $('.main-body-right-div').empty().append(`
            <div id="create_warehouse_form" style="padding:10px;padding-bottom:50px;">

             <div class="input-cont" style="width:100%;display:none;">
                    <input type="text" id="warehouse_id" name="warehouse_id" autocomplete="off" required value="${warehouse.id}">
                    <label for="warehouse_code" class="label-name">
                        <span class="content-name">Warehouse Code (e.g., WH-001)</span>
                    </label>
                </div>
                <div class="input-cont" style="width:100%;">
                    <input type="text" id="warehouse_code" name="warehouse_code" autocomplete="off" required value="${warehouse.warehouse_code || ''}">
                    <label for="warehouse_code" class="label-name">
                        <span class="content-name">Warehouse Code (e.g., WH-001)</span>
                    </label>
                </div>

                <div class="input-cont" style="width:100%;">
                    <input type="text" id="warehouse_name" name="warehouse_name" autocomplete="off" required value="${warehouse.warehouse_name || ''}">
                    <label for="warehouse_name" class="label-name">
                        <span class="content-name">Warehouse Name</span>
                    </label>
                </div>

                <select id="warehouse_type" name="warehouse_type" class="select2Styles" style="border:none;outline:none;background-color:transparent;width:100%;" required>
                    <option value="">Select Warehouse Type</option>
                    <option value="main" ${warehouse.warehouse_type === 'main' ? 'selected' : ''}>Main Warehouse</option>
                    <option value="branch" ${warehouse.warehouse_type === 'branch' ? 'selected' : ''}>Branch Warehouse</option>
                    <option value="transit" ${warehouse.warehouse_type === 'transit' ? 'selected' : ''}>Transit Hub</option>
                    <option value="virtual" ${warehouse.warehouse_type === 'virtual' ? 'selected' : ''}>Virtual Warehouse</option>
                </select>

                <div class="input-cont" style="width:100%;">
                    <input type="text" id="address" name="address" autocomplete="off" required value="${warehouse.address || ''}">
                    <label for="address" class="label-name">
                        <span class="content-name">Address</span>
                    </label>
                </div>

                <div class="input-cont" style="width:100%;">
                    <input type="text" id="latitude" name="latitude" autocomplete="off" value="${warehouse.lat || ''}">
                    <label for="latitude" class="label-name">
                        <span class="content-name">Latitude</span>
                    </label>
                </div>

                <div class="input-cont" style="width:100%;">
                    <input type="text" id="longitude" name="longitude" autocomplete="off" value="${warehouse.lng || ''}">
                    <label for="longitude" class="label-name">
                        <span class="content-name">Longitude</span>
                    </label>
                </div>

                <div class="input-cont" style="width:100%;">
                    <input type="text" id="city" name="city" autocomplete="off" required value="${warehouse.city || ''}">
                    <label for="city" class="label-name">
                        <span class="content-name">City</span>
                    </label>
                </div>

                <div class="input-cont" style="width:100%;">
                    <input type="text" id="state" name="state" autocomplete="off" value="${warehouse.state || ''}">
                    <label for="state" class="label-name">
                        <span class="content-name">State/Province</span>
                    </label>
                </div>

                <div class="input-cont" style="width:100%;">
                    <input type="text" id="country" name="country" autocomplete="off" required value="${warehouse.country || 'Zambia'}">
                    <label for="country" class="label-name">
                        <span class="content-name">Country</span>
                    </label>
                </div>

                <div class="input-cont" style="width:100%;">
                    <input type="text" id="postal_code" name="postal_code" autocomplete="off" value="${warehouse.postal_code || ''}">
                    <label for="postal_code" class="label-name">
                        <span class="content-name">Postal Code</span>
                    </label>
                </div>

                <div class="input-cont" style="width:100%;">
                    <input type="tel" id="phone" name="phone" autocomplete="off" value="${warehouse.phone || ''}">
                    <label for="phone" class="label-name">
                        <span class="content-name">Phone Number</span>
                    </label>
                </div>

                <div class="input-cont" style="width:100%;">
                    <input type="email" id="email" name="email" autocomplete="off" value="${warehouse.email || ''}">
                    <label for="email" class="label-name">
                        <span class="content-name">Email Address</span>
                    </label>
                </div>

                <select id="manager_id" name="manager_id" class="select2Styles" style="border:none;outline:none;background-color:transparent;width:100%;">
                    <option value="">Select Warehouse Manager (Optional)</option>
                </select>

                <div class="input-cont" style="width:100%;">
                    <input type="number" id="capacity" name="capacity" step="0.01" autocomplete="off" value="${warehouse.capacity || ''}">
                    <label for="capacity" class="label-name">
                        <span class="content-name">Storage Capacity (cubic meters)</span>
                    </label>
                </div>

                <select id="is_active" name="is_active" class="select2Styles" style="border:none;outline:none;background-color:transparent;width:100%;" required>
                    <option value="1" ${warehouse.is_active == 1 ? 'selected' : ''}>Active</option>
                    <option value="0" ${warehouse.is_active == 0 ? 'selected' : ''}>Inactive</option>
                </select>

                <div id="submitDiv" style="margin-top:20px;">
                    <button id="update_warehouse_btn" type="button" style="background-color:var(--primary-color);cursor:pointer;color:white;height:40px;line-height:40px;width:100%;border-radius:8px;border:none;">
                        Update Warehouse
                    </button>
                </div>
            </div>
        `);

        // Populate manager dropdown
        $.getJSON('xd-modules/admin-modules/backend/allStaff.php', function(data) {
            $.each(data.freelancedetails, function(i, staff) {
                const selected = staff.id == warehouse.manager_id ? 'selected' : '';
                $('#manager_id').append(`<option value="${staff.id}" ${selected}>${staff.names} (${staff.phone})</option>`);
            });
        });

        // Initialize select2 dropdowns
        $('.select2Styles').select2({
            allowClear: true,
            width: '100%',
            dropdownParent: $('#invoice_modal')
        });

        // Show modal
        $('#invoice_modal').fadeIn('slow').css('display', 'block');

        // Initialize map with coordinates
        setTimeout(() => {
            initializeWarehouseMap(parseFloat(warehouse.lat), parseFloat(warehouse.lng), warehouse.warehouse_name);
        }, 500);

    } catch (error) {
        console.error(error);
        alert('Error loading warehouse details.');
    }
}

// Initialize Map function
function initializeWarehouseMap(lat, lng, name) {
    const mapDiv = document.getElementById('warehouse_map');
    if (!mapDiv) return;

    const mapLat = lat || -15.3875;
    const mapLng = lng || 28.3228;

    const map = L.map(mapDiv).setView([mapLat, mapLng], 13);

    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '&copy; OpenStreetMap contributors'
    }).addTo(map);

    L.marker([mapLat, mapLng])
        .addTo(map)
        .bindPopup(`<b>${name}</b><br>Lat: ${mapLat}<br>Lng: ${mapLng}`)
        .openPopup();

    map.invalidateSize();
}

///updating warehouse details///updating warehouse details///updating warehouse details///updating warehouse details///updating warehouse details///updating warehouse details
 $(document).on('click', '#update_warehouse_btn', function(event) {
    event.preventDefault();
    
    // Validate required fields
    if (!$('#warehouse_code').val() || !$('#warehouse_name').val() || !$('#warehouse_type').val()) {
        alert('Please fill in all required fields (Code, Name, Type)');
        return;
    }

    if (!$('#latitude').val() || !$('#longitude').val()) {
        alert('Please select a location on the map');
        return;
    }

    // Collect form data
    const warehouseData = {
        id: $('#warehouse_id').val(),
        warehouse_code: $('#warehouse_code').val(),
        warehouse_name: $('#warehouse_name').val(),
        warehouse_type: $('#warehouse_type').val(),
        address: $('#address').val(),
        city: $('#city').val(),
        state: $('#state').val(),
        country: $('#country').val(),
        postal_code: $('#postal_code').val(),
        phone: $('#phone').val(),
        email: $('#email').val(),
        manager_id: $('#manager_id').val() || null,
        capacity: $('#capacity').val() || null,
        lat: $('#latitude').val(),
        lng: $('#longitude').val(),
        is_active: $('#is_active').val(),
        org_id: sessionStorage.getItem('org_id') || '', // Adjust based on your session management
        created_by: sessionStorage.getItem('user_id') || '' // Adjust based on your session management
    };

    // Show loading state
    $('#create_warehouse_btn').html('<i class="fa fa-spinner fa-spin"></i> Creating...').prop('disabled', true);

    // Submit to backend
    $.ajax({
        url: 'xd-modules/inventory/backend/update_warehouse.php',
        type: 'POST',
        data: JSON.stringify(warehouseData),
        contentType: 'application/json',
        dataType: 'json',
        success: function(response) {
            if (response.success) { 
             $('#submitDiv').empty().append('<button type="button" style="background-color:green;cursor:pointer;color:white;height:40px;line-height:40px;width:100%;border-radius:8px;border:none;margin-top:0px;">Warehouse Created  </button>');
            fetchWarehouses();
            setTimeout(function () { 
            $('.close_invoice_modal').click(); // Close modal
            }, 3000);
               
                // Optionally refresh warehouse list
                if (typeof loadWarehouseList === 'function') {
                    loadWarehouseList();
                }
            } else {
                alert('Error: ' + (response.message || 'Failed to create warehouse'));
                $('#create_warehouse_btn').html('Create Warehouse').prop('disabled', false);
            }
        },
        error: function(xhr, status, error) {
            alert('Error creating warehouse: ' + error);
            $('#create_warehouse_btn').html('Create Warehouse').prop('disabled', false);
        }
    });
});


/// CREATING WAREHOUSE/// CREATING WAREHOUSE/// CREATING WAREHOUSE/// CREATING WAREHOUSE/// CREATING WAREHOUSE/// CREATING WAREHOUSE/// CREATING WAREHOUSE
 // Trigger to open warehouse creation modal
$(document).on('click', '.addWarehouse101', function(event) {
    event.preventDefault();
    event.stopPropagation(); 
    createWarehouse101();
});

function createWarehouse101() {
    $('#external_page_contents').empty().append('<div id="invoice_modal" class="w3-modal w3-center" style="background-color:rgba(255,255,255,1);z-index:99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999"></div>');
     
    // Modal action buttons
    $('#invoice_modal').append('<div class="w3-col l12 m12 s12 w3-card-2 hideOnPrint" style="height:40px;color:gray;"><span class="close_invoice_modal" style="float:left;cursor:pointer;margin-top:5px;margin-right:10px;margin-left:10px;"><span class="fontx fx-arrow-left" style="font-size:2em;color:var(--primary-color);"></span></span><span style="float:left;color:var(--primary-color);margin-top:10px;margin-left:10px;">CREATE WAREHOUSE</span></div>');
    
    $('#invoice_modal').append('<form method="post" id="warehouse_form" enctype="multipart/form-data" style="margin-top:40px;"><div class="main-body-left-div w3-col l7 m7 s12"></div><div class="main-body-right-div w3-col l5 m5 s12"></div></form>');
    
    // LEFT SIDE - Map for location selection
    $('.main-body-left-div').empty(); 
    $('.main-body-left-div').append(`
        <div style="padding:5px;"> 
            
            <div id="warehouse_map" style="width:100%;height:100vh;border:1px solid #ddd;border-radius:8px;"></div>
          </div>
    `);

    // RIGHT SIDE - Form fields
    $('.main-body-right-div').empty().append(`
        <div id="create_warehouse_form" style="padding:10px;padding-bottom:50px;">
            
            <!-- Warehouse Code -->
            <div class="input-cont" style="width:100%;">
                <input type="text" id="warehouse_code" name="warehouse_code" autocomplete="off" required>
                <label for="warehouse_code" class="label-name">
                    <span class="content-name">Warehouse Code (e.g., WH-001)</span>
                </label>
            </div>

            <!-- Warehouse Name -->
            <div class="input-cont" style="width:100%;">
                <input type="text" id="warehouse_name" name="warehouse_name" autocomplete="off" required>
                <label for="warehouse_name" class="label-name">
                    <span class="content-name">Warehouse Name</span>
                </label>
            </div>

            <!-- Warehouse Type -->
            <select id="warehouse_type" name="warehouse_type" class="select2Styles" style="border:none;outline:none;background-color:transparent;width:100%;" required>
                <option value="">Select Warehouse Type</option>
                <option value="main">Main Warehouse</option>
                <option value="branch">Branch Warehouse</option>
                <option value="transit">Transit Hub</option>
                <option value="virtual">Virtual Warehouse</option>
            </select>

            <!-- Address (Auto-filled from map) -->
            <div class="input-cont" style="width:100%;">
                <input type="text" id="address" name="address" autocomplete="off" required>
                <label for="address" class="label-name">
                    <span class="content-name">Address</span>
                </label>
            </div>
         
     <!--  GPS coordinates -->
             <div class="input-cont" style="width:100%;">
                <input type="text"  id="latitude" name="latitude" value="" autocomplete="off">
                <label for="capacity" class="label-name">
                    <span class="content-name">Latitue</span>
                </label>
            </div>
               <div class="input-cont" style="width:100%;">
                <input type="text"  id="longitude" name="longitude" value=""autocomplete="off">
                <label for="capacity" class="label-name">
                    <span class="content-name">Longitude</span>
                </label>
            </div>

            <!-- City -->
            <div class="input-cont" style="width:100%;">
                <input type="text" id="city" name="city" autocomplete="off" required>
                <label for="city" class="label-name">
                    <span class="content-name">City</span>
                </label>
            </div>

            <!-- State/Province -->
            <div class="input-cont" style="width:100%;">
                <input type="text" id="state" name="state" autocomplete="off">
                <label for="state" class="label-name">
                    <span class="content-name">State/Province</span>
                </label>
            </div>

            <!-- Country -->
            <div class="input-cont" style="width:100%;">
                <input type="text" id="country" name="country" value="Zambia" autocomplete="off" required>
                <label for="country" class="label-name">
                    <span class="content-name">Country</span>
                </label>
            </div>

            <!-- Postal Code -->
            <div class="input-cont" style="width:100%;">
                <input type="text" id="postal_code" name="postal_code" autocomplete="off">
                <label for="postal_code" class="label-name">
                    <span class="content-name">Postal Code</span>
                </label>
            </div>

            <!-- Phone -->
            <div class="input-cont" style="width:100%;">
                <input type="tel" id="phone" name="phone" autocomplete="off">
                <label for="phone" class="label-name">
                    <span class="content-name">Phone Number</span>
                </label>
            </div>

            <!-- Email -->
            <div class="input-cont" style="width:100%;">
                <input type="email" id="email" name="email" autocomplete="off">
                <label for="email" class="label-name">
                    <span class="content-name">Email Address</span>
                </label>
            </div>
           
       

            <!-- Manager (link to users table) -->
            <select id="manager_id" name="manager_id" class="select2Styles" style="border:none;outline:none;background-color:transparent;width:100%;">
                <option value="">Select Warehouse Manager (Optional)</option>
            </select>

            <!-- Capacity (in cubic meters or your preferred unit) -->
            <div class="input-cont" style="width:100%;">
                <input type="number" id="capacity" name="capacity" step="0.01" autocomplete="off">
                <label for="capacity" class="label-name">
                    <span class="content-name">Storage Capacity (cubic meters)</span>
                </label>
            </div>

         
            
            <!-- Status -->
            <select id="is_active" name="is_active" class="select2Styles" style="border:none;outline:none;background-color:transparent;width:100%;" required>
                <option value="1" selected>Active</option>
                <option value="0">Inactive</option>
            </select>

            <!-- Submit Button -->
            <div id="submitDiv" style="margin-top:20px;">
                <button id="create_warehouse_btn" type="button" style="background-color:var(--primary-color);cursor:pointer;color:white;height:40px;line-height:40px;width:100%;border-radius:8px;border:none;margin-top:0px;">
                    Create Warehouse
                </button>
            </div>
        </div>
    `);

$.getJSON('xd-modules/admin-modules/backend/allStaff.php',function(data){
 $.each(data.freelancedetails, function(i,freelance) {

     $('#manager_id').append('<option value="'+freelance.id+'" data-usernames="'+freelance.names+'">'+freelance.names+' ('+freelance.phone+')</option>');
     
  });
   
});
 

    // Initialize Select2
    $('.select2Styles').select2({
        allowClear: true,   
        width: '100%',
        dropdownParent: $('#invoice_modal')
    });

    // Initialize Map
    initializeWarehouseMap();

    // Show modal
    $('#invoice_modal').fadeIn('slow');
    $('#invoice_modal').css('display', 'block');
}

// Initialize Google Maps
function initializeWarehouseMap() {
    // Default center (Lusaka, Zambia)
    const defaultCenter = { lat: -15.3875, lng: 28.3228 };
    
    // Create map
    const map = new google.maps.Map(document.getElementById('warehouse_map'), {
        center: defaultCenter,
        zoom: 13,
        mapTypeControl: true,
        streetViewControl: true,
        fullscreenControl: true
    });

    // Create marker
    let marker = new google.maps.Marker({
        map: map,
        draggable: true,
        animation: google.maps.Animation.DROP,
        position: defaultCenter
    });

    // Geocoder for reverse geocoding (get address from coordinates)
    const geocoder = new google.maps.Geocoder();

    // Function to update location info
    function updateLocationInfo(latLng) {
        // Update hidden fields
        $('#latitude').val(latLng.lat());
        $('#longitude').val(latLng.lng());
        
        // Update coordinates display
       // $('#selected_coordinates').text(`Lat: ${latLng.lat().toFixed(6)}, Lng: ${latLng.lng().toFixed(6)}`);
        
        // Reverse geocode to get address
        geocoder.geocode({ location: latLng }, function(results, status) {
            if (status === 'OK' && results[0]) {
                const addressComponents = results[0].address_components;
                const formattedAddress = results[0].formatted_address;
                
                // Update location name
                $('#selected_location_name').text(formattedAddress);
                
                // Auto-fill address fields
                $('#address').val(formattedAddress).focus().blur();
                
                // Extract city, state, country
                addressComponents.forEach(component => {
                    if (component.types.includes('locality')) {
                        $('#city').val(component.long_name).focus().blur();
                    }
                    if (component.types.includes('administrative_area_level_1')) {
                        $('#state').val(component.long_name).focus().blur();
                    }
                    if (component.types.includes('country')) {
                        $('#country').val(component.long_name).focus().blur();
                    }
                    if (component.types.includes('postal_code')) {
                        $('#postal_code').val(component.long_name).focus().blur();
                    }
                });
            }
        });
    }

    // Click on map to place marker
    map.addListener('click', function(event) {
        marker.setPosition(event.latLng);
        updateLocationInfo(event.latLng);
    });

    // Drag marker to update location
    marker.addListener('dragend', function(event) {
        updateLocationInfo(event.latLng);
    });

    // Try to get user's current location
    if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(
            function(position) {
                const userLocation = {
                    lat: position.coords.latitude,
                    lng: position.coords.longitude
                };
                map.setCenter(userLocation);
                marker.setPosition(userLocation);
                updateLocationInfo(userLocation);
            },
            function() {
                // If geolocation fails, use default (already set)
                updateLocationInfo(defaultCenter);
            }
        );
    } else {
        // Browser doesn't support geolocation
        updateLocationInfo(defaultCenter);
    }

    // Add search box for location search
    const input = document.createElement('input');
    input.type = 'text';
    input.placeholder = 'Search location...';
    input.style.cssText = 'margin:10px;padding:10px;width:300px;border:1px solid #ddd;border-radius:5px;box-shadow:0 2px 6px rgba(0,0,0,0.3);';
    
    const searchBox = new google.maps.places.SearchBox(input);
    map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);

    searchBox.addListener('places_changed', function() {
        const places = searchBox.getPlaces();
        if (places.length === 0) return;

        const place = places[0];
        if (!place.geometry || !place.geometry.location) return;

        map.setCenter(place.geometry.location);
        map.setZoom(15);
        marker.setPosition(place.geometry.location);
        updateLocationInfo(place.geometry.location);
    });
}

// Handle form submission
$(document).on('click', '#create_warehouse_btn', function(event) {
    event.preventDefault();
    
    // Validate required fields
    if (!$('#warehouse_code').val() || !$('#warehouse_name').val() || !$('#warehouse_type').val()) {
        alert('Please fill in all required fields (Code, Name, Type)');
        return;
    }

    if (!$('#latitude').val() || !$('#longitude').val()) {
        alert('Please select a location on the map');
        return;
    }

    // Collect form data
    const warehouseData = {
        warehouse_code: $('#warehouse_code').val(),
        warehouse_name: $('#warehouse_name').val(),
        warehouse_type: $('#warehouse_type').val(),
        address: $('#address').val(),
        city: $('#city').val(),
        state: $('#state').val(),
        country: $('#country').val(),
        postal_code: $('#postal_code').val(),
        phone: $('#phone').val(),
        email: $('#email').val(),
        manager_id: $('#manager_id').val() || null,
        capacity: $('#capacity').val() || null,
        lat: $('#latitude').val(),
        lng: $('#longitude').val(),
        is_active: $('#is_active').val(),
        org_id: sessionStorage.getItem('org_id') || '', // Adjust based on your session management
        created_by: sessionStorage.getItem('user_id') || '' // Adjust based on your session management
    };

    // Show loading state
    $('#create_warehouse_btn').html('<i class="fa fa-spinner fa-spin"></i> Creating...').prop('disabled', true);

    // Submit to backend
    $.ajax({
        url: 'xd-modules/inventory/backend/create_warehouse.php',
        type: 'POST',
        data: JSON.stringify(warehouseData),
        contentType: 'application/json',
        dataType: 'json',
        success: function(response) {
            if (response.success) { 
             $('#submitDiv').empty().append('<button type="button" style="background-color:green;cursor:pointer;color:white;height:40px;line-height:40px;width:100%;border-radius:8px;border:none;margin-top:0px;">Warehouse Created  </button>');
              fetchWarehouses();
            setTimeout(function () { 
            $('.close_invoice_modal').click(); // Close modal
            }, 3000);
               
                // Optionally refresh warehouse list
                if (typeof loadWarehouseList === 'function') {
                    loadWarehouseList();
                }
            } else {
                alert('Error: ' + (response.message || 'Failed to create warehouse'));
                $('#create_warehouse_btn').html('Create Warehouse').prop('disabled', false);
            }
        },
        error: function(xhr, status, error) {
            alert('Error creating warehouse: ' + error);
            $('#create_warehouse_btn').html('Create Warehouse').prop('disabled', false);
        }
    });
});

// Close modal handler
$(document).on('click', '.close_invoice_modal', function() {
    $('#invoice_modal').fadeOut('slow', function() {
        $(this).remove();
    });
});

/// CREATING WAREHOUSE/// CREATING WAREHOUSE/// CREATING WAREHOUSE/// CREATING WAREHOUSE/// CREATING WAREHOUSE/// CREATING WAREHOUSE/// CREATING WAREHOUSE