<?php  
header('Access-Control-Allow-Origin: *');  
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');     
session_start();   
require_once '../../../xd-assets/backend/config/dbconfig.php'; 
require '../../../xd-assets/vendor/autoload.php'; // Path to Composer autoload.php for PhpSpreadsheet

use PhpOffice\PhpSpreadsheet\IOFactory;

$conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
$conn->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION); 

$userloggedid = $_SESSION["userid"];
$orgid = $_SESSION["orgid"];

// --- Excel Bulk Upload Section ---
if (isset($_FILES['excelFile']) && $_FILES['excelFile']['error'] === UPLOAD_ERR_OK) {
    $fileTmpPath = $_FILES['excelFile']['tmp_name'];
    $spreadsheet = IOFactory::load($fileTmpPath);
    $sheet = $spreadsheet->getActiveSheet();
    $rows = $sheet->toArray();

    // Fix: filter nulls and trim headers, then make header keys uppercase
    $rawHeader = $rows[0];
    $header = array_map(function($h) {
        return $h !== null ? strtoupper(trim($h)) : '';
    }, $rawHeader);
    // Map normalized header keys to expected fields
    $headerMap = [];
    foreach ($header as $idx => $h) {
        $key = preg_replace('/[^A-Z]/', '', $h); // Remove non-letters for matching
        if (in_array($key, ['FULLNAMES','NAMES','NAME'])) $headerMap['name'] = $idx;
        if (in_array($key, ['PHONENUMBER','PHONE'])) $headerMap['phone'] = $idx;
        if (in_array($key, ['EMAIL'])) $headerMap['email'] = $idx;
        if (in_array($key, ['TYPEOFBUSINESS','BUSINESSCATEGORY'])) $headerMap['businesscategory'] = $idx;
        if (in_array($key, ['BUSINESSLOCATION','ADDRESS','LOCATION','BISINESSLOCATION'])) $headerMap['address'] = $idx;
        if (in_array($key, ['ID','NRC'])) $headerMap['nrc'] = $idx;
    }
    // Debug: If name column is not mapped, return headers and mapping
    if (!isset($headerMap['name'])) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Could not detect a name column. Please check your Excel header row.',
            'detected_headers' => $header,
            'header_map' => $headerMap
        ]);
        exit;
    }
    $results = [];
    for ($i = 1; $i < count($rows); $i++) {
        $row = $rows[$i];
        $name = isset($headerMap['name']) ? trim($row[$headerMap['name']]) : '';
        $phone = isset($headerMap['phone']) ? trim($row[$headerMap['phone']]) : '';
        $email = (isset($headerMap['email']) && !empty($row[$headerMap['email']])) ? trim($row[$headerMap['email']]) : '';
        $businesscategory = isset($headerMap['businesscategory']) ? trim($row[$headerMap['businesscategory']]) : '';
        $depotName = '';
        if (isset($headerMap['businesslocation'])) {
            $depotName = trim($row[$headerMap['businesslocation']]);
        } elseif (isset($headerMap['address'])) {
            $depotName = trim($row[$headerMap['address']]);
        }
        $address = isset($headerMap['address']) ? trim($row[$headerMap['address']]) : 1;
        $nrc = isset($headerMap['nrc']) ? trim($row[$headerMap['nrc']]) : '';
        if (empty($nrc)) {
            $nrc = '0000';
        }
        $accountType = 'Business';
       
        // Generate random email if missing
        if (empty($email)) {
            $base = !empty($phone) ? preg_replace('/\D/', '', $phone) : uniqid();
            $email = 'user' . $base . '@cyberdesk.live';
        }
        // Skip if name is empty
        if (empty($name)) {
            $results[] = ['row' => $i+1, 'status' => 'error', 'name' => $name, 'email' => $email, 'message' => 'Name is required'];
            continue;
        }
        // Get bc_id from business_categories table
        $bc_id = null;
        if (!empty($businesscategory)) {
            $bcQuery = "SELECT bc_id FROM business_categories WHERE category_name LIKE :category_name LIMIT 1";
            $bcStmt = $conn->prepare($bcQuery);
            $bcStmt->execute([':category_name' => "%$businesscategory%"]);
            $bcRow = $bcStmt->fetch(PDO::FETCH_ASSOC);
            if ($bcRow && isset($bcRow['bc_id'])) {
                $bc_id = $bcRow['bc_id'];
            }
        }
        // If bc_id is still null, set to default value 70
        if (empty($bc_id)) {
            $bc_id = 70;
        }
        // Get depot_id from depots table (case-insensitive, ignore extra spaces)
        $depot_id = null;
        if (!empty($depotName)) {
            // Debug: log attempted depot name and query result
            // Uncomment the next line to debug: error_log('Depot lookup: ' . $depotName);
            $depotQuery = "SELECT depot_id FROM depots WHERE TRIM(LOWER(depot_name)) = :depot_name LIMIT 1";
            $depotStmt = $conn->prepare($depotQuery);
            $depotStmt->execute([':depot_name' => strtolower(trim($depotName))]);
            $depotRow = $depotStmt->fetch(PDO::FETCH_ASSOC);
            if ($depotRow && isset($depotRow['depot_id'])) {
                $depot_id = $depotRow['depot_id'];
            } else {
                // Uncomment the next line to debug: error_log('Depot not found for: ' . $depotName);
            }
        }
        if (empty($depot_id)) {
            $depot_id = 1;
        }
        try {
            $checkQuery = "SELECT id FROM users WHERE email = :email OR phone = :phone LIMIT 1";
            $checkStmt = $conn->prepare($checkQuery);
            $checkStmt->execute([':email' => $email, ':phone' => $phone]);
            $existingUser = $checkStmt->fetch(PDO::FETCH_ASSOC);
            $userid = null;
            if ($existingUser) {
                $userid = $existingUser['id'];
            } else {
                $insertnewuserQuery = "INSERT INTO users (email, names, phone, address, nrc, avatar, status, sessionUserId) VALUES (:email, :name, :phone, :address, :nrc, :avatar, :status, :userloggedid)";
                $insertnewUser = $conn->prepare($insertnewuserQuery);
                $insertnewUser->execute([
                    ':email' => $email,
                    ':name' => $name,
                    ':phone' => $phone,
                    ':address' => $address,
                    ':nrc' => $nrc,
                    ':status' => 'Active',
                    ':userloggedid' => $userloggedid,
                    ':avatar' => 'xd-uploads/user-pictures/avatar.png'
                ]);
                $userid = $conn->lastInsertId();
            }
            if ($userid) {
                $roleQuery = "SELECT role_id FROM roles WHERE role_name = :role_name LIMIT 1";
                $roleStmt = $conn->prepare($roleQuery);
                $roleStmt->execute([':role_name' => 'Client']);
                $roleRow = $roleStmt->fetch(PDO::FETCH_ASSOC);
                if ($roleRow && isset($roleRow['role_id'])) {
                    $role_id = $roleRow['role_id'];
                    $checkUserRoleQuery = "SELECT id FROM user_roles WHERE user_id = :user_id AND role_id = :role_id AND org_id = :org_id LIMIT 1";
                    $checkUserRoleStmt = $conn->prepare($checkUserRoleQuery);
                    $checkUserRoleStmt->execute([
                        ':user_id' => $userid,
                        ':role_id' => $role_id,
                        ':org_id' => $orgid
                    ]);
                    if (!$checkUserRoleStmt->fetch(PDO::FETCH_ASSOC)) {
                        $insertUserRoleQuery = "INSERT INTO user_roles (user_id, role_id, status, created_by, org_id) VALUES (:user_id, :role_id, :status, :created_by, :org_id)";
                        $insertUserRole = $conn->prepare($insertUserRoleQuery);
                        $insertUserRole->execute([
                            ':user_id' => $userid,
                            ':role_id' => $role_id,
                            ':status' => 'Active',
                            ':created_by' => $userloggedid,
                            ':org_id' => $orgid
                        ]);
                    }
                }
                $checkClientQuery = "SELECT user_id FROM clients WHERE user_id = :user_id AND org_id = :org_id LIMIT 1";
                $checkClientStmt = $conn->prepare($checkClientQuery);
                $checkClientStmt->execute([
                    ':user_id' => $userid,
                    ':org_id' => $orgid
                ]);
                if (!$checkClientStmt->fetch(PDO::FETCH_ASSOC)) {
                    $insertClientQuery = "INSERT INTO clients (user_id, status, business_category, account_type, depot_id, created_by, org_id) VALUES (:client_id, :status, :business_category, :account_type, :depotId, :created_by, :org_id)";
                    $insertClient = $conn->prepare($insertClientQuery);
                    $insertClient->execute([
                        ':client_id' => $userid,
                        ':org_id' => $orgid,
                        ':account_type' => $accountType,
                        ':business_category' => $bc_id, // Use bc_id instead of businesscategory string
                        ':depotId' => $depot_id, // Use depot_id from depots table
                        ':created_by' => $userloggedid,
                        ':status' => 'Active'
                    ]);
                }
                $results[] = ['row' => $i+1, 'status' => 'success', 'name' => $name, 'phone' => $phone, 'email' => $email];
            } else {
                $results[] = ['row' => $i+1, 'status' => 'error', 'name' => $name, 'phone' => $phone, 'email' => $email, 'message' => 'User insert failed'];
            }
        } catch (Exception $e) {
            $results[] = ['row' => $i+1, 'status' => 'error', 'name' => $name, 'phone' => $phone, 'email' => $email, 'message' => $e->getMessage()];
        }
    }
    echo json_encode(['status' => 'bulk', 'results' => $results]);
    exit;
}
?>