// ************************************************
// Shopping Cart API
// ************************************************

var shoppingCart = (function() {
  // =============================
  // Private methods and propeties
  // =============================
  cart = [];

  // Constructor
 function Item(name, price, count, id, productcode,category,categorycode,depot,depotid,depotcode) {
    this.name = name;
    this.price = price;
    this.count = count;
    this.id = id;
    this.productcode = productcode;
    this.category = category;
    this.categorycode = categorycode;
    this.depot = depot;
    this.depotid = depotid;
    this.depotcode = depotcode;
  }
  // Save cart
  function saveCart() {
    sessionStorage.setItem('shoppingCart', JSON.stringify(cart));
  }
    // Load cart
  function loadCart() {
    cart = JSON.parse(sessionStorage.getItem('shoppingCart'));
  }
  if (sessionStorage.getItem("shoppingCart") != null) {
    loadCart();
  }
  // =============================
  // Public methods and propeties
  // =============================
  var obj = {};
  
  // Add to cart
  // Add to cart
  obj.addItemToCart = function(name, price, count, id, productcode, category, categorycode, depot, depotid, depotcode) {
    for(var item in cart) {
      if(cart[item].name === name) {
        cart[item].count ++;
        saveCart();
        return;
      }
    }
    var item = new Item(name, price, count, id, productcode, category, categorycode, depot, depotid, depotcode);
    cart.push(item);
    saveCart();
  }
  
  // Set count from item
  obj.setCountForItem = function(name, count) {
    for(var i in cart) {
      if (cart[i].name === name) {
        cart[i].count = count;
        break;
      }
    }
  };
  // Remove item from cart
  obj.removeItemFromCart = function(name) {
      for(var item in cart) {
        if(cart[item].name === name) {
          cart[item].count --;
          if(cart[item].count === 0) {
            cart.splice(item, 1);
          }
          break;
        }
    }
    saveCart();
  }

  // Remove all items from cart
  obj.removeItemFromCartAll = function(name) {
    for(var item in cart) {
      if(cart[item].name === name) {
        cart.splice(item, 1);
        break;
      }
    }
    saveCart();
  }

  // Clear cart
  obj.clearCart = function() {
    cart = [];
    saveCart();
  }
  // Count cart 
  obj.totalCount = function() {
    var totalCount = 0;
    for(var item in cart) {
      totalCount += cart[item].count;
    }
    return totalCount;
  }
  // Total cart
  obj.totalCart = function() {
    var totalCart = 0;
    for(var item in cart) {
      totalCart += cart[item].price * cart[item].count;
    }
    return Number(totalCart.toFixed(2));
  }
  // List cart
  obj.listCart = function() {
    var cartCopy = [];
    for(i in cart) {
      item = cart[i];
      itemCopy = {};
      for(p in item) {
        itemCopy[p] = item[p];

      }
      itemCopy.total = Number(item.price * item.count).toFixed(2);
      cartCopy.push(itemCopy)
    }
    return cartCopy;
  }

  // cart : Array
  // Item : Object/Class
  // addItemToCart : Function
  // removeItemFromCart : Function
  // removeItemFromCartAll : Function
  // clearCart : Function
  // countCart : Function
  // totalCart : Function
  // listCart : Function
  // saveCart : Function
  // loadCart : Function
  return obj;
})();


// *****************************************
// Triggers / Events
// ***************************************** 
// Add item

 $(document).on('click','#addInvoiceItem045',function (event){
    var name = $(this).data('name');
    var category = $(this).data('category');
    var price = Number($(this).data('price'));
    var id = ($(this).data('id'));
    var categorycode = ($(this).data('categorycode'));
    var productcode = ($(this).data('productcode'));

    var depot = $(this).data('depot');
    var depotid= ($(this).data('depotid'));
    var depotcode = ($(this).data('depotcode')); 
   //alert(category);alert(categorycode);alert(productcode);
   // alert('iam here');
   // alert(id);alert(name);alert(price);
    //var user_id = ($(this).data('userid'));
    //var productdeliverycharge = ($(this).data('deliverycharge'));
    //var lat = ($(this).data('lat'));
    //var lng = ($(this).data('lng'));
   // var distance = Number($(this).data('distance'));
   // var productdeliverycharge2 = distance*productdeliverycharge;
 
   shoppingCart.addItemToCart(name, price, 1, id,  productcode, category, categorycode,depot,depotid,depotcode);
  displayCart();
  $('#invoiceItemsList').append('<div class="invoiceItemDiv0" class="w3-col l12 m12 s12"><div class="w3-col l7 m7 s7"><span class="invoiceItemId" style="display:none;">'+id+'</span><span class="invoiceItemName" style="float:left;margin-left: 60px;font-weight:400;">'+name+'</span></div><div class="w3-col l2 m2 s2"><input class="invoiceUnits0" value="1" type="number" style="float:left;width:100%;height:20px;border:none;background-color:rgba(0,0,0,0.02);cursor:pointer;"/></div><div class="w3-col l1 m1 s1"><span class="invoiceItemPrice0" style="float:right;">'+price+'</span></div><div class="w3-col l2 m2 s2"><span class="invoiceItemTotalPrice0" style="float:right;margin-right:0px;">'+price+'</span></div></div>');
   
  var total = 0;
  $('.invoiceItemTotalPrice0').each(function(){
    total += parseFloat($(this).text().replace(/,/g,''))
  });
  
  //$('.total').text(total)
  //alert(total);
  $('#invoiceSubTotal').empty();
  $('#invoiceSubTotal').append(total);
  //invoiceTaxTotal0
  var taxPercent = total*0.10;
  $('#invoiceTaxTotal0').empty();
  $('#invoiceTaxTotal0').append(taxPercent);
  //invoiceTotal0
  var invoiceTotal = total-taxPercent;
  $('#invoiceTotal0').empty();
  $('#invoiceTotal0').append(invoiceTotal);
 

	$('#cart-count0').addClass('cart-count-style0');
	setTimeout(function(){
	  $('#bottom_toast345').fadeOut('slow'); 
	$('#bottom_toast345').empty(); 
	$('#cart-count0').removeClass('cart-count-style0');

	}, 2500);
  
});

 
 // add product delivery charge


// MAKE PAYMENT
$(document).on('click','.transact0',function (event) {
  $('#initiatorModal').fadeOut('slow');
  transact101();
});
function transact101(){
  //alert('iam trasact');	
  $('#transact_modal').fadeIn('slow');
  addInvoicedItem();
  // Extract the updated query string
  var queryString = location.search.slice(1);
  var queryParams = queryString.split("&");

  var phoneParam = queryParams.find(param => param.startsWith("phone="));
  var useridParam = queryParams.find(param => param.startsWith("user_id="));

  var companynameParam = queryParams.find(param => param.startsWith("companyname="));
  var addressParam = queryParams.find(param => param.startsWith("address="));
  var emailParam = queryParams.find(param => param.startsWith("email="));
  var pacraParam = queryParams.find(param => param.startsWith("pacra="));
  var tpinParam = queryParams.find(param => param.startsWith("tpin="));
  var nrcParam = queryParams.find(param => param.startsWith("nrc="));
  var areaParam = queryParams.find(param => param.startsWith("area="));
  var plotnumberParam = queryParams.find(param => param.startsWith("plotnumber="));
  var businessCategoryParam = queryParams.find(param => param.startsWith("businessCategory="));
 // var invoiceNoParam = queryParams.find(param => param.startsWith("invoice_no="));

  var phone = phoneParam ? phoneParam.split("=")[1] : '';
  var user_id = useridParam ? useridParam.split("=")[1] : '';
  var companyname = companynameParam ? companynameParam.split("=")[1] : '';
  var address = addressParam ? addressParam.split("=")[1] : '';
  var email = emailParam ? emailParam.split("=")[1] : '';
  var pacra = pacraParam ? pacraParam.split("=")[1] : '';
  var tpin = tpinParam ? tpinParam.split("=")[1] : '';
  var nrc = nrcParam ? nrcParam.split("=")[1] : '';
  var area = areaParam ? areaParam.split("=")[1] : '';
  var plotnumber = plotnumberParam ? plotnumberParam.split("=")[1] : '';
  var businessCategory = businessCategoryParam ? businessCategoryParam.split("=")[1] : '';

 // var invoice_no = invoiceNoParam ? invoiceNoParam.split("=")[1] : '';
  // Decode username if necessary
  var usernameParam = queryParams.find(param => param.startsWith("username="));
 var username = usernameParam ? decodeURIComponent(usernameParam.split("=")[1]) : '';
 //alert(user_id);alert(phone);alert(username);

 $('#invoicedClientId0').empty();
 $('#invoicedClientId0').append(user_id);
 document.getElementById('invoicedClientName0').vallue='';
 document.getElementById('invoicedClientName0').value=companyname;
 $('#invoicedClientName1').empty();
 $('#invoicedClientName1').append(username);
 document.getElementById('invoicedClientAddress0').value='';
 document.getElementById('invoicedClientAddress0').value=address;
 document.getElementById('plotnumber07').value='';
 document.getElementById('plotnumber07').value= plotnumber;
 document.getElementById('area07').value='';
 document.getElementById('area07').value=area;
 document.getElementById('nrc07').vallue='';
 document.getElementById('nrc07').vallue=nrc;
 document.getElementById('invoicedClientEmail0').value='';
 document.getElementById('invoicedClientEmail0').value=email;
  $('#invoicedClientId0').empty();
  $('#invoicedClientId0').append(user_id);
 $('#pacra00').empty();
 $('#pacra00').append(pacra); 
 $('#tpin00').empty();
 $('#tpin00').append(tpin); 
 $('#businesscategory00').empty();
 $('#businesscategory00').append(businessCategory);
document.getElementById('invoicedClientPhone0').value ='';
document.getElementById('invoicedClientPhone0').value = phone;



  $('#payment-btns01').empty();
  $('#payment-btns01').append('<center><div class="momoTransact0" style="font-weight: 600;height:35px;line-height: 30px;">Mobile Money Transact</div></center>');
  $('#paymentresponseDivBottom').empty(); 
  $('#addInvoicedItemDiv').empty();
  $('#addInvoicedItemDiv').append('<span  id="addInvoicedItem0" style="float:left;margin-left:7px;cursor: pointer;">Product/Service <span class="fontx fx-plus" style="color:rgba(96, 146, 205,1);cursor: pointer;"></span></span>');
  $('#addInvoiceClientDiv').empty();
  $('#addInvoiceClientDiv').append('<button type="button" id="addInvoiceClient0" style="float:left;font-weight:600;color:rgba(96, 146, 205,1);height: 25px;background-color:transparent;border:none;outline:none;margin-left:-5px;">BILLED TO:</button>');
 
  $('#modeOfPayment').empty(); 
 $('#modeOfPayment').append('<option value="MOMO">Mobile Money</option><option value="BANK">Bank Deposit</option>'); 
  
 $('.bankAccoutDiv101').fadeOut('slow'); 
 
  $('#invoiceType').empty();
  $('#invoiceType').append('<option value="RECEIPT"> RECEIPT</option>');
   // empty the print div
   $('#printReceiptDiv102').empty();
  
  //var randReceipt=(Math.floor(100000 + Math.random() * 900000));
  //$('#invoiceNumber').empty();
  //$('#invoiceNumber').append(randReceipt);
 // let today = new Date().toLocaleDateString();
  document.getElementById('invoiceDueDate').value ='';
  //document.getElementById('invoiceDueDate').value = today;
//payment-btns01
//paymentresponseDivBottom
$('#paymentresponseDivBottom').show();
$('#payment-btns01').show();


}

$(document).on('click','.close_transact_modal',function (event) {
	 event.preventDefault();
    event.stopPropagation(); 
    $('#transact_modal').fadeOut('slow');
     $('#invoiceNumber').empty();
   $('#invoicedClientName0').empty();
   $('#invoicedClientAddress0').empty();
   $('#invoicedClientEmail0').empty();
   $('#invoicedClientId0').empty();
   $('#payment-btns01').empty(); 
   $('#payment-btns01').append('<center><div class="cashTransact01 w3-col" style="font-weight: 600;height:35px;line-height: 30px;">Make cash  transaction</div></center>'); 
   $('#paymentresponseDivBottom').empty(); 
  
   $('#paymentresponseDivBottom').empty();

   $('#plotnumber07').empty();
   $('#area07').empty();
   $('#nrc07').empty();
   document.getElementById('invoiceDueDate').value ='';
	 document.getElementById('trasactionTime34').value ='';
   document.getElementById('invoicedClientPhone0').value ='';
	 document.getElementById('invoiceDueDate').value ='';
    shoppingCart.clearCart();
    displayCart(); 
	       
});
// Clear items
$('.clear-cart').click(function() {
  shoppingCart.clearCart();
  displayCart();
});
// Delete item button

$(document).on("click", ".delete-item", function(event) {
	//alert('Hello');
  var name = $(this).data('name');
  shoppingCart.removeItemFromCartAll(name);
  displayCart();
})
 
// Item count input 
$('.show-cart').on("keyup", ".item-count", function(event) {
   var name = $(this).data('name');
   var count = Number($(this).val());
  shoppingCart.setCountForItem(name, count);
  displayCart(); 
});

$('.show-cart').on("change", ".item-count", function(event) {
   var name = $(this).data('name');
   var count = Number($(this).val());
  shoppingCart.setCountForItem(name, count);
  displayCart(); 
});

function displayCart() {
  var cartArray = shoppingCart.listCart();
  var output = "";
  for(var i in cartArray) {
    output+="<div class='w3-col l12 m12 s12' style='float:left;padding-left:0px;'>"
    +"<div class='w3-col l6 m6 s7' style='float:left;padding-left:5px;text-align:left;'>"+cartArray[i].name+"</div>" 
    +"<div class='w3-col l2 m2 s2' style='float:left;'>K"+cartArray[i].price+"</div>"
    +"<div class='w3-col l1 m1 s1' style='border-right:1px solid gray'><div class='input-group'>"
    +"<input type='number' step='0.1' class='item-count form-control' data-name='"+cartArray[i].name+"' value='"+cartArray[i].count+"' style='max-width:40px;border:none;font-size:0.7em'>"
   +"</div></div>"
   +"<div class='w3-col l1 m1 s1 w3-hide-small' style='float:left;'>0.00</div>"
   +"<div class='w3-col l2 m2 s2'><b>"+cartArray[i].total+"</b></div>" 
 //  +"<div class='w3-col l1 m1 s1 w3-hide-small' style='float:left;'>0.00</div>"
  
// + "<div class='w3-col l1 m1 s1' style='background-color:purple;'><span class='delete-item fontx fx-trash-2' data-name=" + cartArray[i].name + "></span></div>"
    
    +"</div>";
 //alert(cartArray[i].id); 
 //alert(cartArray); 

  
	  
  }
  
  	// var json = JSON.stringify(cartArray);
    // alert(json);
	 
  $('.show-cart').html(output);
  $('.total-cart').html(shoppingCart.totalCart());
  $('.total-count').html(shoppingCart.totalCount());
  
   //alert(output);
    
}

 
displayCart();

var orderDetails = JSON.stringify(cart);
      
$(document).ready( function () { 
  // transact101();
  // invoicing();
});

$(document).on('click','.invoices0',function (event) {
  invoicing();
});

function invoicing() {

     // Extract the updated query string
     var queryString = location.search.slice(1);
     var queryParams = queryString.split("&");
    var useridParam = queryParams.find(param => param.startsWith("user_id="));
     var user_id = useridParam ? useridParam.split("=")[1] : '';
     
  $('#sub_top_nav').empty();
  $('#sub_top_nav').append('<div class="w3-col l12 m12 s12 w3-center" style="height:30px;background-color:#eee;margin-top:-1px;border-bottom:1px solid aliceblue;"><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-search" style="color:gray;font-size:1.5em"></span></div><div class="w3-col l10 m10 s10 w3-center"><input id="searchAgentInvoices" type="text" placeholder="Search invoices..." style="font-weight:400;outline:none;color:black;border:none;border-bottom:none;width:100%;height:30px;background-color:transparent;padding-left:7px;"/></div><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-filter" style="color:rgba(0,0,0,0.3);font-size:1.3em"></span></div></div>');
  $('#sub_top_nav').append('<ul id="tabs" class="tabs"><li class="invoices0" style="color:rgba(96, 146, 205,1);background-color:#fff;border:1px solid rgba(96, 146, 205,1);border-radius:10px;">My Invoices</li><li class="trasactions0">My Trasactions</li><li class="trackTrasactions0">Track payment</li><li  class="transact0">Make Payment</li></ul>');
  $('#right_nav_options0').empty();
  $('#main-body').empty(); 
  $('#main-body').append('<center><div class="body-loader"></div><br/></center>');

  datastring='searchKey='+user_id;
  $('#main-body').empty(); 
  $('#main-body').append('<center><div class="body-loader"></div><br/></center>');

  $.ajax({ 
      data:datastring,
     url: "https://lukulutowncouncil.cyberdesk.one/xd-modules/client-portal/backend/due_invoices.php",
      type: "POST"
    
   }).done (function(data) {

   // $('#main-body').empty();  
   var data= JSON.parse(data); 
    
   if(data.details=='No Data'){

    //alert('No Data');
    $('#main-body').empty();
    $('#main-body').append('<center style="margin-top:17%;"><p>You have no invoices. Click the transact button to start make a trasaction.</p></center>');
    //transactions();
    
   }else{
       $('#main-body').empty();
       $('#record01').empty();
       $('#record01').append('<span>K'+data.total+' ('+data.numofrows+')</span>');
        $('#main-body').append('</br></br>');
       $.each(data.details,function(i,cyberdesk) {
        if(cyberdesk.balance=='0'){
        // alert(cyberdesk.product_name);
         $('#main-body').append('<div class="inner-data-div w3-col l12 m12 s12" id="invoiceMakePayment0" data-userid="'+cyberdesk.client_id+'" data-names="'+cyberdesk.client_name+'" data-companyname="'+cyberdesk.company_name+'" data-phone="'+cyberdesk.phone_contact+'" data-email="'+cyberdesk.email_contact+'" data-address="'+cyberdesk.delivery_address+'" data-productid="'+cyberdesk.product_id+'" data-productname="'+cyberdesk.product_name+'" data-productcharge="'+cyberdesk.balance+'" data-pacra="'+cyberdesk.company_registration_number+'" data-tpin="'+cyberdesk.tpin+'" data-businesscategory="'+cyberdesk.business_category+'"  data-plotnumber="'+cyberdesk.plot_number+'" data-area="'+cyberdesk.area+'" data-nrc="'+cyberdesk.nrc+'" data-productcode="'+cyberdesk.product_code+'" data-category="'+cyberdesk.category+'" data-categorycode="'+cyberdesk.category_code+'" data-depot="'+cyberdesk.depot+'" data-depotid="'+cyberdesk.depot_id+'" data-depotcode="'+cyberdesk.depot_code+'" style="cursor:pointer;float:left;transition: all 1s;margin-top:0px;text-align:left;font-size:1em;color:gray;background-color:trasparent;padding-left:10px;line-height:23px;"><span class="w3-col l8 m8 s12"><span style="color:black;font-weight:400;">'+cyberdesk.product_name+': <span style="float:right;padding-right:7px;">Inv. no: <span style="color:red;">'+cyberdesk.invoice_no+'</span></span></span></span><span class="w3-col l2 m2 s6" style="color:rgba(96, 146, 205,1);"> <span  class="fontx fx-star" style="color:green;"> Paid: K'+cyberdesk.paid+'</span></span><span class="w3-col l2 m2 s6" style="color:rgba(96, 146, 205,1);padding-right:5px;"><span style="float:right;color:green"> Balance: K'+cyberdesk.balance+'</span></span></div>');
     
        }else{
          $('#main-body').append('<div class="inner-data-div w3-col l12 m12 s12" id="invoiceMakePayment0" data-userid="'+cyberdesk.client_id+'" data-names="'+cyberdesk.client_name+'" data-companyname="'+cyberdesk.company_name+'" data-phone="'+cyberdesk.phone_contact+'" data-email="'+cyberdesk.email_contact+'" data-address="'+cyberdesk.delivery_address+'" data-productid="'+cyberdesk.product_id+'" data-productname="'+cyberdesk.product_name+'" data-productcharge="'+cyberdesk.balance+'" data-pacra="'+cyberdesk.company_registration_number+'" data-tpin="'+cyberdesk.tpin+'" data-businesscategory="'+cyberdesk.business_category+'"  data-plotnumber="'+cyberdesk.plot_number+'" data-area="'+cyberdesk.area+'" data-nrc="'+cyberdesk.nrc+'" data-productcode="'+cyberdesk.product_code+'" data-category="'+cyberdesk.category+'" data-categorycode="'+cyberdesk.category_code+'" data-depot="'+cyberdesk.depot+'" data-depotid="'+cyberdesk.depot_id+'" data-depotcode="'+cyberdesk.depot_code+'" style="cursor:pointer;float:left;transition: all 1s;margin-top:0px;text-align:left;font-size:1em;color:gray;background-color:trasparent;padding-left:10px;line-height:23px;"><span class="w3-col l8 m8 s12"><span style="color:black;font-weight:400;">'+cyberdesk.product_name+': <span style="float:right;padding-right:7px;">Inv. no: <span style="color:red;">'+cyberdesk.invoice_no+'</span></span></span></span><span class="w3-col l2 m2 s6" style="color:gray;">Paid: K'+cyberdesk.paid+'</span><span class="w3-col l2 m2 s6" style="color:gray;padding-right:5px;"><span style="float:right;">Balance: <span style="color:red;">K'+cyberdesk.balance+'</span></span></span></div>');
     
        }
      
     });
     }
 

 }); 	



 }

  //  SEARCH invoices
$(document).on('change keyup','#searchAgentInvoices',function (event) {
	event.preventDefault(); 
  event.stopPropagation();  

    // Extract the updated query string
    var queryString = location.search.slice(1);
    var queryParams = queryString.split("&");
  var useridParam = queryParams.find(param => param.startsWith("user_id="));
   var user_id = useridParam ? useridParam.split("=")[1] : '';
 

  if($("#searchAgentInvoices").val()=='') {	
	invoicing();
  } else{ 
	 var searchKey = $("#searchAgentInvoices").val();
	  //var key45 = ($("#searchKey45").text());	 
	 datastring='searchKey='+searchKey+'&user_id='+user_id;
   $('#main-body').empty(); 
   $('#main-body').append('<center><div class="body-loader"></div><br/></center>');
 
			 
	 $.ajax({
				  
		   data:datastring,
	   url: "https://lukulutowncouncil.cyberdesk.one/xd-modules/client-portal/backend/searchDueInvoices.php",
		   type: "POST"
	   
	  }).done (function(data) {

	   $('#main-body').empty();  
	  var details0 = JSON.parse(data); 
    $('#main-body').empty();
    //record01
    $('#record01').empty();
    $('#record01').append('<span>K'+details0.total+' ('+details0.numofrows+')</span>');
 
    if(details0.numofrows>0){
      $('#main-body').append('</br></br>');
      $.each(details0.details,function(i,cyberdesk) {
        if(cyberdesk.balance=='0'){
          // alert(cyberdesk.product_name);
           $('#main-body').append('<div class="inner-data-div w3-col l12 m12 s12" id="invoiceMakePayment0" data-userid="'+cyberdesk.client_id+'" data-names="'+cyberdesk.client_name+'" data-companyname="'+cyberdesk.company_name+'" data-phone="'+cyberdesk.phone_contact+'" data-email="'+cyberdesk.email_contact+'" data-address="'+cyberdesk.delivery_address+'" data-productid="'+cyberdesk.product_id+'" data-productname="'+cyberdesk.product_name+'" data-productcharge="'+cyberdesk.balance+'" data-pacra="'+cyberdesk.company_registration_number+'" data-tpin="'+cyberdesk.tpin+'" data-businesscategory="'+cyberdesk.business_category+'"  data-plotnumber="'+cyberdesk.plot_number+'" data-area="'+cyberdesk.area+'" data-nrc="'+cyberdesk.nrc+'" data-productcode="'+cyberdesk.product_code+'" data-category="'+cyberdesk.category+'" data-categorycode="'+cyberdesk.category_code+'" data-depot="'+cyberdesk.depot+'" data-depotid="'+cyberdesk.depot_id+'" data-depotcode="'+cyberdesk.depot_code+'" style="cursor:pointer;float:left;transition: all 1s;margin-top:0px;text-align:left;font-size:1em;color:gray;background-color:trasparent;padding-left:10px;line-height:23px;"><span class="w3-col l8 m8 s12"><span style="color:black;font-weight:400;">'+cyberdesk.product_name+': <span style="float:right;padding-right:7px;">Inv. no: <span style="color:red;">'+cyberdesk.invoice_no+'</span></span></span></span><span class="w3-col l2 m2 s6" style="color:rgba(96, 146, 205,1);"> <span  class="fontx fx-star" style="color:green;"> Paid: K'+cyberdesk.paid+'</span></span><span class="w3-col l2 m2 s6" style="color:rgba(96, 146, 205,1);padding-right:5px;"><span style="float:right;color:green"> Balance: K'+cyberdesk.balance+'</span></span></div>');
       
          }else{
            $('#main-body').append('<div class="inner-data-div w3-col l12 m12 s12" id="invoiceMakePayment0" data-userid="'+cyberdesk.client_id+'" data-names="'+cyberdesk.client_name+'" data-companyname="'+cyberdesk.company_name+'" data-phone="'+cyberdesk.phone_contact+'" data-email="'+cyberdesk.email_contact+'" data-address="'+cyberdesk.delivery_address+'" data-productid="'+cyberdesk.product_id+'" data-productname="'+cyberdesk.product_name+'" data-productcharge="'+cyberdesk.balance+'" data-pacra="'+cyberdesk.company_registration_number+'" data-tpin="'+cyberdesk.tpin+'" data-businesscategory="'+cyberdesk.business_category+'"  data-plotnumber="'+cyberdesk.plot_number+'" data-area="'+cyberdesk.area+'" data-nrc="'+cyberdesk.nrc+'" data-productcode="'+cyberdesk.product_code+'" data-category="'+cyberdesk.category+'" data-categorycode="'+cyberdesk.category_code+'" data-depot="'+cyberdesk.depot+'" data-depotid="'+cyberdesk.depot_id+'" data-depotcode="'+cyberdesk.depot_code+'" style="cursor:pointer;float:left;transition: all 1s;margin-top:0px;text-align:left;font-size:1em;color:gray;background-color:trasparent;padding-left:10px;line-height:23px;"><span class="w3-col l8 m8 s12"><span style="color:black;font-weight:400;">'+cyberdesk.product_name+': <span style="float:right;padding-right:7px;">Inv. no: <span style="color:red;">'+cyberdesk.invoice_no+'</span></span></span></span><span class="w3-col l2 m2 s6" style="color:gray;">Paid: K'+cyberdesk.paid+'</span><span class="w3-col l2 m2 s6" style="color:gray;padding-right:5px;"><span style="float:right;">Balance: <span style="color:red;">K'+cyberdesk.balance+'</span></span></span></div>');
       
          }
    });
    }else{
      $('#main-body').append('<center><p style="margin-top:20%">There are no results for your search.</p></center>');
    }
 
	}); 	
	

  } 
    
});
// end of SEARCH invoices
// SELECT IVOICES CATEGORIES 
$(document).on('change keyup','.invoicesSelect0',function (event) {
  var searchCategory = $(".invoicesSelect0").val(); 
  //  alert(searchCategory);
  datastring='searchCategory='+searchCategory;
  $('#main-body').empty(); 
  $('#main-body').append('<center><div class="body-loader"></div><br/></center>');
  
  $.ajax({
      
  data:datastring,
  url: "https://lukulutowncouncil.cyberdesk.one/xd-modules/agent-module/backend/searchDueInvoicesByCategory.php",
  type: "POST"
  
  }).done (function(data) {
  $('#main-body').empty();  
  var details0 = JSON.parse(data);
  //alert(details.numofrows);
  // alert(details0.details);
  //var details1 = JSON.stringify(details.freelancedetails);
  $('#main-body').empty();
  //record01
  $('#record01').empty();
  $('#record01').append('<span>K'+details0.total+' ('+details0.numofrows+')</span>');
  
  if(details0.numofrows>0){
  $('#main-body').append('</br></br>');
  $.each(details0.details,function(i,cyberdesk) {
    $('#main-body').append('<div class="inner-data-div w3-col l12 m12 s12" id="invoiceMakePayment0" data-userid="'+cyberdesk.client_id+'" data-names="'+cyberdesk.client_name+'" data-companyname="'+cyberdesk.company_name+'" data-phone="'+cyberdesk.phone_contact+'" data-email="'+cyberdesk.email_contact+'" data-address="'+cyberdesk.delivery_address+'" data-productid="'+cyberdesk.product_id+'" data-productname="'+cyberdesk.product_name+'" data-productcharge="'+cyberdesk.balance+'" data-pacra="'+cyberdesk.company_registration_number+'" data-tpin="'+cyberdesk.tpin+'" data-businesscategory="'+cyberdesk.business_category+'"  data-plotnumber="'+cyberdesk.plot_number+'" data-area="'+cyberdesk.area+'" data-nrc="'+cyberdesk.nrc+'" data-productcode="'+cyberdesk.product_code+'" data-category="'+cyberdesk.category+'" data-categorycode="'+cyberdesk.category_code+'" data-depot="'+cyberdesk.depot+'" data-depotid="'+cyberdesk.depot_id+'" data-depotcode="'+cyberdesk.depot_code+'" style="cursor:pointer;font-weight:600;float:left;transition: all 1s;margin-top:0px;text-align:left;font-size:1em;color:gray;background-color:trasparent;padding-left:10px;line-height:23px;"><div class="w3-col l4 m4 s12 w3-hide-small" style="font-size:0.8em"><span style="color:black;"><span style="text-transform:uppercase;font-weight:600;">'+cyberdesk.company_name+'</span> <span style="color:gray">('+cyberdesk.business_category+')</span></span><br/><span style="color:gray;">'+cyberdesk.client_name+' ('+cyberdesk.phone_contact+') <a href="#" id="sendSms0" data-id="'+cyberdesk.b_id+'" data-names="'+cyberdesk.client_name+'" data-phone="'+cyberdesk.phone_contact+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/sms.png"style="height:15px;width:15px;"/></a><a href="#" id="sendEmail0" data-email="'+cyberdesk.email_contact+'" data-names="'+cyberdesk.client_name+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/mail2.png" style="height:15px;width:15px;"/></a></span></div><div class="w3-col l4 m4 s12 w3-hide-large" style="font-size:0.8em"><span style="color:gray;"><span style="color:black;text-transform:uppercase">'+cyberdesk.company_name+'</span> ('+cyberdesk.client_name+') <a href="#" id="sendSms0" data-id="'+cyberdesk.b_id+'" data-names="'+cyberdesk.client_name+'" data-phone="'+cyberdesk.phone_contact+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/sms.png"style="height:15px;width:15px;"/></a><a href="#" id="sendEmail0" data-email="'+cyberdesk.email_contact+'" data-names="'+cyberdesk.client_name+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/mail2.png" style="height:15px;width:15px;"/></a></span></div><div class="w3-col l2 m2 s12 w3-hide-small" style="font-size:0.8em;color:#6092cd;font-weight:400;"><span class="w3-col l12 m12 s12"><span style="color:black;">TPIN: </span> '+cyberdesk.tpin+'</span><span class="w3-col l12 m12 s12"><span style="color:black;">REG NO:</span> '+cyberdesk.company_registration_number+'</span></div><div class="w3-col l3 m3 s12  w3-hide-small" style="font-size:0.8em;font-weight:400;"><div class="w3-col l12 m12 s12"><a href="#"><span class="fontx fx-map-pin" style="color:#6092cd;"></span> '+cyberdesk.delivery_address+'</a></div><div class="w3-col l12 m12 s12">'+cyberdesk.plot_number+' '+cyberdesk.area+'</div></div><div class="w3-col l3 m3 s12" style="font-size:0.8em"><span class="w3-col l12 m12 s12"><span style="color:gray;font-weight:400;"><b>'+cyberdesk.product_name+':</b></span> <span style="float:right;margin-right:10px;color:rgba(96, 146, 205,1);font-weight:600;">K'+cyberdesk.total_charge+'</span></span><span class="w3-col l12 m12 s12"><span style="color:rgba(96, 146, 205,1);font-weight:600;">Paid: K'+cyberdesk.paid+'</span> <span style="color:rgba(96, 146, 205,1);float:right;margin-right:10px;font-weight:600;"><span>Balance:</span> K'+cyberdesk.balance+'</span></span></div></div>');
    
  });
  }else{
  $('#main-body').append('<center><p style="margin-top:20%">There are no results for your search.</p></center>');
  }
  
  
  }); 
  
  });
  //ed of SELECT IVOICE CATEGORY
  $(document).on('click', '.invoiceTransactions0', function(event){
    event.preventDefault();
    event.stopPropagation();
    var productname = $(this).data('productname');
     var names = $(this).data('names');
    // var companyname = $(this).data('companyname');
    var userid = $(this).data('userid');
    $('#generalmodalLarge').fadeIn('slow');
    $('#generalmodalLargeMainDiv').hide();
    //$('#generalmodalLarge').append();
    $('#generalmodalLarge').append('<div id="tempDiv00"></div>');
    $('#tempDiv00').append('<div class="w3-top" style="height:50px;width:100%;color:#eee;background-color:rgba(96, 146, 205,1);"><div class="w3-col l1 m1 s1" style="margin-top:12px;"><span class="fontx fx-arrow-left closeLargeModal99" style="font-size:1.6em;cursor:pointer;float:left;padding-left:10px;"></span></div><div class="w3-col l10 m10 s10"><div id="userTitle93" class="w3-col l12 m12 s12" style="text-transform:uppercase;float:left;"></div><div id="productTitle93" class="w3-col l12 m12 s12"></div></div><div class="w3-col l1 m1 s1" style="margin-top:12px;"><span class="fontx fx-more-vertical" style="font-size:1.6em;cursor:pointer;float:right;"></span><span id="productuserid93" style="display:none"></span></div></div>');
    $('#tempDiv00').append('<div class="w3-top w3-center" style="height:30px;background-color:#eee;margin-top:50px;border-bottom:1px solid aliceblue;"><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-search" style="color:gray;font-size:1.5em"></span></div><div class="w3-col l10 m10 s10 w3-center"><input id="searchInvoiceTrasactions" type="text" placeholder="Search invoice transactions..." style="font-weight:400;outline:none;color:black;border:none;border-bottom:none;width:100%;height:30px;background-color:transparent;padding-left:7px;"/></div><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-filter" style="color:rgb(95, 44, 62);font-size:1.3em"></span></div></div>');
   $('#tempDiv00').append('<div id="tempTransactionsDiv" class="w3-col l12 m12 s12" style="background-color:#fff;height:100vh;margin-top:-50px;padding-top:80px"><center><div class="body-loader"></div><br/></center></div>')
  $('#userTitle93').empty();
   $('#userTitle93').append(names);
   $('#productTitle93').empty();
   $('#productTitle93').append(productname);
   $('#productuserid93').empty();
   $('#productuserid93').append(userid);
  
   if(productname=='' && userid=='') {	
    // do nothing
    } else{
     //var searchKey = $("#searchInvoices0").val();
      //var key45 = ($("#searchKey45").text());	 
     datastring='productname='+productname+'&userid='+userid;
         
     $.ajax({
            
         data:datastring,
       url: "https://lukulutowncouncil.cyberdesk.one/xd-modules/agent-module/backend/invoiceTransactions.php",
         type: "POST"
      }).done (function(data) {
  
        $('#tempTransactionsDiv').empty();
      var details = JSON.parse(data);
      var details1 = JSON.stringify(details.freelancedetails);
      //alert(details.numofrows);
      var arr = JSON.parse(details1);
     for (i in arr) {
     var companyname= arr[i].cfname;
     var clientname= arr[i].clname;
     var payment_mode= arr[i].payment_mode;
     var transaction_date= arr[i].transaction_date;
     var transaction_time= arr[i].transaction_time;
     //var invoiceNumber= arr[i].invoiceNumber;
     var cphone= arr[i].cphone;
     var cemail= arr[i].cemail;
     var delivery_address= arr[i].delivery_address;
     var receipt_date= arr[i].receipt_date;
     var user_id = arr[i].user_id;
     var businessCategory = arr[i].business_category;
     var transaction_status = arr[i].transaction_status;
     var transaction_reference = arr[i].transaction_reference;
     var area = arr[i].area;
     var plot_no = arr[i].plot_no;
     var receipt_no = arr[i].receipt_no;
     var bank_name = arr[i].bank_name;
     var bank_account_name = arr[i].bank_account_name;
     var bank_deposit_slip = arr[i].bank_deposit_slip;
     var bank_deposit_id = arr[i].bank_deposit_id;
    
     //alert(payment_mode);
    var detailsxy = JSON.parse(arr[i].order_details);
     // alert(detailsxy);
    
    // $('#tempTransactionsDiv').append('<br/>');
      for (i in detailsxy) {
    //	alert(detailsxy[i].name);
    if(payment_mode=='BANK'){
    $('#tempTransactionsDiv').append('<div class="inner-data-div w3-col l12 m12 s12" style="font-weight:600;float:left;transition: all 1s;margin-left:10px;text-align:left;font-size:0.7em;color:gray;background-color:rgba(0,0,0,0.0);padding:0px;line-height:25px;border-bottom:2px solid #eee;"><div class="w3-col l3 m3 s12"><span class="w3-col l12 m12 s12" style="color:black;font-weight:600;"> <span style="text-transform:uppercase;">'+companyname+'</span> <span style="color:gray">('+businessCategory+')</span></span><span class="w3-col l12 m12 s12" style="color:gray">'+clientname+' ('+cphone+')</span></div><div class="w3-col l3 m3 s12" style=""><span class="w3-col l12 m12 s12" style="color:black;font-weight:600;"><span class="fontx fx-map-pin" style="color:#6092cd;"></span> '+delivery_address+'</span><span class="w3-col l12 m12 s12">'+plot_no+'</span></div><div class="w3-col l2 m2 s12"><span class="class="w3-col l12 m12 s12"><b style="color:black;">Ref:</b>'+transaction_reference+'</span><span class="w3-col l12 m12 s12"><b style="color:black">Date:</b> '+transaction_date+' ('+transaction_time+')</span></div><div class="w3-col l3 m3 s12"><b style="color:gray;">  <span class="w3-col l12 m12 s12"><span style="color:black;font-weight:600;">'+detailsxy[i].name+':</span> <span style="float:right;margin-right:10px;color:rgba(96, 146, 205,1);">K'+detailsxy[i].price+'</span></span><span class="w3-col l12 m12 s12"><span>Rpt no: <span style="color:red;">'+receipt_no+'</span></span> <span style="color:rgba(96, 146, 205,1);float:right;margin-right:10px;">K'+detailsxy[i].total+'<span style="color:gray;">('+payment_mode+')</span></span></span></div><div class="w3-col l1 m1 s12" style="padding-top:10px;"><span id="invoicePayment0" class="fontx fx-printer" data-invoicenumber="'+receipt_no+'" data-names="'+clientname+'" data-email="'+cemail+'" data-phone="'+cphone+'" data-address="'+delivery_address+'" data-userid="'+user_id+'" style="margin-right:12px;float:right;cursor:pointer;background-color:transparent;padding-left:3px;padding-right:3px;color:gray;margin-top:0px;border-radius:3px;font-size:1.5em"></span><span class="fontx fx-file-text bankdepositslip0" data-invoicenumber="'+receipt_no+'" data-names="'+clientname+'" data-bankname="'+bank_name+'" data-bankaccountname="'+bank_account_name+'" data-bankdepositslip="'+bank_deposit_slip+'" data-bankdepositid="'+bank_deposit_id+'" style="margin-right:7px;float:right;cursor:pointer;background-color:transparent;padding-left:3px;padding-right:3px;color:gray;margin-top:0px;border-radius:3px;font-size:1.5em"></span></div></div>');
    
    }else{
    $('#tempTransactionsDiv').append('<div class="inner-data-div w3-col l12 m12 s12" style="font-weight:600;float:left;transition: all 1s;margin-left:10px;text-align:left;font-size:0.7em;color:gray;background-color:rgba(0,0,0,0.0);padding:0px;line-height:25px;border-bottom:2px solid #eee;"><div class="w3-col l3 m3 s12"><span class="w3-col l12 m12 s12" style="color:black;font-weight:600;"> <span style="text-transform:uppercase;">'+companyname+'</span> <span style="color:gray">('+businessCategory+')</span></span><span class="w3-col l12 m12 s12" style="color:gray">'+clientname+' ('+cphone+')</span></div><div class="w3-col l3 m3 s12" style=""><span class="w3-col l12 m12 s12" style="color:black;font-weight:600;"><span class="fontx fx-map-pin" style="color:#6092cd;"></span> '+delivery_address+'</span><span class="w3-col l12 m12 s12">'+plot_no+'</span></div><div class="w3-col l2 m2 s12"><span class="class="w3-col l12 m12 s12"><b style="color:black;">Ref:</b>'+transaction_reference+'</span><span class="w3-col l12 m12 s12"><b style="color:black">Date:</b> '+transaction_date+' ('+transaction_time+')</span></div><div class="w3-col l3 m3 s12"><b style="color:gray;">  <span class="w3-col l12 m12 s12"><span style="color:black;font-weight:600;">'+detailsxy[i].name+':</span> <span style="float:right;margin-right:10px;color:rgba(96, 146, 205,1);">K'+detailsxy[i].price+'</span></span><span class="w3-col l12 m12 s12"><span>Rpt no: <span style="color:red;">'+receipt_no+'</span></span> <span style="color:rgba(96, 146, 205,1);float:right;margin-right:10px;">K'+detailsxy[i].total+'<span style="color:gray;">('+payment_mode+')</span></span></span></div><div class="w3-col l1 m1 s12" style="padding-top:10px;"><span id="invoicePayment0" class="fontx fx-printer" data-invoicenumber="'+receipt_no+'" data-names="'+clientname+'" data-email="'+cemail+'" data-phone="'+cphone+'" data-address="'+delivery_address+'" data-userid="'+user_id+'" style="margin-right:12px;float:right;cursor:pointer;background-color:transparent;padding-left:3px;padding-right:3px;color:gray;margin-top:0px;border-radius:3px;font-size:1.5em"></span></div></div>');
    
    }
    
      }
    }
      
     
    }); 	
    
    
  
    } 
    
  });
  // searchInvoiceTrasactions
  // search products or chart of A/C
  $(document).on('change keyup','#searchInvoiceTrasactions',function (event) {
    event.preventDefault(); 
    event.stopPropagation();  
    if($("#searchInvoiceTrasactions").val()=='') {	
    //addInvoicedItem();
    } else{
     //var searchCategory = $(".invoicesSelect0").val();
     var searchKey = $("#searchInvoiceTrasactions").val(); 
     var productuserid = $("#productuserid93").html();
     var productTitle = $("#productTitle93").html();
     datastring='searchKey='+searchKey+'&productuserid='+productuserid+'&productTitle='+productTitle;
     $('#tempTransactionsDiv').empty(); 
     $('#tempTransactionsDiv').append('<center><div class="body-loader"></div><br/></center>');
        
     $.ajax({
            
         data:datastring,
       url: "https://lukulutowncouncil.cyberdesk.one/xd-modules/agent-module/backend/searchInvoiceTrasactions.php",
         type: "POST"
       
      }).done (function(data) {
    
       $('#tempTransactionsDiv').empty();
      var details = JSON.parse(data);
      var details1 = JSON.stringify(details.freelancedetails);
      //alert(details.numofrows);
      var arr = JSON.parse(details1);
     for (i in arr) {
     var companyname= arr[i].cfname;
     var clientname= arr[i].clname;
     var payment_mode= arr[i].payment_mode;
     var transaction_date= arr[i].transaction_date;
     var transaction_time= arr[i].transaction_time;
     var invoiceNumber= arr[i].invoiceNumber;
     var cphone= arr[i].cphone;
     var cemail= arr[i].cemail;
     var delivery_address= arr[i].delivery_address;
     var receipt_date= arr[i].receipt_date;
     var user_id = arr[i].user_id;
     var businessCategory = arr[i].business_category;
     var transaction_status = arr[i].transaction_status;
     var transaction_reference = arr[i].transaction_reference;
     var area = arr[i].area;
     var plot_no = arr[i].plot_no;
     var receipt_no = arr[i].receipt_no;
     var bank_name = arr[i].bank_name;
     var bank_account_name = arr[i].bank_account_name;
     var bank_deposit_slip = arr[i].bank_deposit_slip;
     var bank_deposit_id = arr[i].bank_deposit_id;
    
     //alert(payment_mode);
    var detailsxy = JSON.parse(arr[i].order_details);
     // alert(detailsxy);
    
    // $('#tempTransactionsDiv').append('<br/>');
      for (i in detailsxy) {
    //	alert(detailsxy[i].name);
    if(payment_mode=='BANK'){
    $('#tempTransactionsDiv').append('<div class="inner-data-div w3-col l12 m12 s12" style="font-weight:600;float:left;transition: all 1s;margin-left:10px;text-align:left;font-size:0.7em;color:gray;background-color:rgba(0,0,0,0.0);padding:0px;line-height:25px;border-bottom:2px solid #eee;"><div class="w3-col l3 m3 s12"><span class="w3-col l12 m12 s12" style="color:black;font-weight:600;"> <span style="text-transform:uppercase;">'+companyname+'</span> <span style="color:gray">('+businessCategory+')</span></span><span class="w3-col l12 m12 s12" style="color:gray">'+clientname+' ('+cphone+')</span></div><div class="w3-col l3 m3 s12" style=""><span class="w3-col l12 m12 s12" style="color:black;font-weight:600;"><span class="fontx fx-map-pin" style="color:#6092cd;"></span> '+delivery_address+'</span><span class="w3-col l12 m12 s12">'+plot_no+'</span></div><div class="w3-col l2 m2 s12"><span class="class="w3-col l12 m12 s12"><b style="color:black;">Ref:</b>'+transaction_reference+'</span><span class="w3-col l12 m12 s12"><b style="color:black">Date:</b> '+transaction_date+' ('+transaction_time+')</span></div><div class="w3-col l3 m3 s12"><b style="color:gray;">  <span class="w3-col l12 m12 s12"><span style="color:black;font-weight:600;">'+detailsxy[i].name+':</span> <span style="float:right;margin-right:10px;color:rgba(96, 146, 205,1);">K'+detailsxy[i].price+'</span></span><span class="w3-col l12 m12 s12"><span>Rpt no: <span style="color:red;">'+receipt_no+'</span></span> <span style="color:rgba(96, 146, 205,1);float:right;margin-right:10px;">K'+detailsxy[i].total+'<span style="color:gray;">('+payment_mode+')</span></span></span></div><div class="w3-col l1 m1 s12" style="padding-top:10px;"><span id="invoicePayment0" class="fontx fx-printer" data-invoicenumber="'+receipt_no+'" data-names="'+clientname+'" data-email="'+cemail+'" data-phone="'+cphone+'" data-address="'+delivery_address+'" data-userid="'+user_id+'" style="margin-right:12px;float:right;cursor:pointer;background-color:transparent;padding-left:3px;padding-right:3px;color:gray;margin-top:0px;border-radius:3px;font-size:1.5em"></span><span class="fontx fx-file-text bankdepositslip0" data-invoicenumber="'+receipt_no+'" data-names="'+clientname+'" data-bankname="'+bank_name+'" data-bankaccountname="'+bank_account_name+'" data-bankdepositslip="'+bank_deposit_slip+'" data-bankdepositid="'+bank_deposit_id+'" style="margin-right:7px;float:right;cursor:pointer;background-color:transparent;padding-left:3px;padding-right:3px;color:gray;margin-top:0px;border-radius:3px;font-size:1.5em"></span></div></div>');
    
    }else{
    $('#tempTransactionsDiv').append('<div class="inner-data-div w3-col l12 m12 s12" style="font-weight:600;float:left;transition: all 1s;margin-left:10px;text-align:left;font-size:0.7em;color:gray;background-color:rgba(0,0,0,0.0);padding:0px;line-height:25px;border-bottom:2px solid #eee;"><div class="w3-col l3 m3 s12"><span class="w3-col l12 m12 s12" style="color:black;font-weight:600;"> <span style="text-transform:uppercase;">'+companyname+'</span> <span style="color:gray">('+businessCategory+')</span></span><span class="w3-col l12 m12 s12" style="color:gray">'+clientname+' ('+cphone+')</span></div><div class="w3-col l3 m3 s12" style=""><span class="w3-col l12 m12 s12" style="color:black;font-weight:600;"><span class="fontx fx-map-pin" style="color:#6092cd;"></span> '+delivery_address+'</span><span class="w3-col l12 m12 s12">'+plot_no+'</span></div><div class="w3-col l2 m2 s12"><span class="class="w3-col l12 m12 s12"><b style="color:black;">Ref:</b>'+transaction_reference+'</span><span class="w3-col l12 m12 s12"><b style="color:black">Date:</b> '+transaction_date+' ('+transaction_time+')</span></div><div class="w3-col l3 m3 s12"><b style="color:gray;">  <span class="w3-col l12 m12 s12"><span style="color:black;font-weight:600;">'+detailsxy[i].name+':</span> <span style="float:right;margin-right:10px;color:rgba(96, 146, 205,1);">K'+detailsxy[i].price+'</span></span><span class="w3-col l12 m12 s12"><span>Rpt no: <span style="color:red;">'+receipt_no+'</span></span> <span style="color:rgba(96, 146, 205,1);float:right;margin-right:10px;">K'+detailsxy[i].total+'<span style="color:gray;">('+payment_mode+')</span></span></span></div><div class="w3-col l1 m1 s12" style="padding-top:10px;"><span id="invoicePayment0" class="fontx fx-printer" data-invoicenumber="'+receipt_no+'" data-names="'+clientname+'" data-email="'+cemail+'" data-phone="'+cphone+'" data-address="'+delivery_address+'" data-userid="'+user_id+'" style="margin-right:12px;float:right;cursor:pointer;background-color:transparent;padding-left:3px;padding-right:3px;color:gray;margin-top:0px;border-radius:3px;font-size:1.5em"></span></div></div>');
    
    }
    
      }
    }
     
    }); 	
    
    
  
    } 
    
        
  });
  // end of search products or chart of A/C
  
    // selectig mode of paymet
     $(document).on('change keyup','#modeOfPayment',function (event) {
	   var modeOfPayment = $("#modeOfPayment").val(); 
        
       if(modeOfPayment=="BANK"){
               
          $('#bankName').empty();
          $('#bankName').append('<option>Select bank </option><option value="Zanaco main account">Zanaco main account</option><option value="Zanaco Development Account">Zanaco Development A/C</option><option value="Indo transit account">Indo transit account </option><option value="Indo Fire Account">Indo Fire Account</option><option value="Indo Waste Account">Indo Waste Account</option><option value="Indo Capital Account">Indo Capital Account</option><option value="Airtel money account">Airtel money account</option><option value="MTN Money Account">MTN Money Account</option>');
          $('#payment-btns-div01').show();
          $('#payment-btns01').empty();
          $('#payment-btns01').append('<center><div class="bankTransact0" style="font-weight: 600;height:35px;line-height: 30px;">Make bank transaction</div></center>');
          $('#bankNameDiv0').fadeIn('slow');
          $('#bankDepositSlipIdDiv').fadeIn('slow');
            }else if(modeOfPayment=="MOMO"){
              
              $('#payment-btns-div01').show();
              $('#payment-btns01').empty();
              $('#payment-btns01').append('<center><div class="momoTransact0" style="font-weight: 600;height:35px;line-height: 30px;">Mobile Money Transact</div></center>');
              $('#bankNameDiv0').hide();
              $('#bankDepositSlipIdDiv').hide();
            }
    });

$(document).on('change keyup','#invoiceType',function (event) {
	
  //var report = $("#reports101 option:selected" ).text();
  var invoiceType = $("#invoiceType").val(); 
		 if(invoiceType=="INVOICE"){
       $('.dropdown').show();
      $('#billingCycle').show();
      $('#payment-btns01').hide();
        $('#print_invoice').show();
        $('#payment-btns-div01').append('<div id="createInvoice0" class="w3-col l12 m12 s12" style="color:white;"> <span><a href="#" id="print_invoice"  class="fontx fx-printer" onclick="window.print()" style="margin-top:10px;margin-right: 10px;float:right;display: none;color: gray;"></a></span>Submit</div>');
      
        }else if(invoiceType=="QUOTATION"){
          //
        }
});

$(document).on('click', '#createInvoice0', function(event){
  event.preventDefault();
  event.stopPropagation();
   var amount = $('.total-cart').html();
   var userid = $("#invoicedClientId0").html();
   var fname = $("#invoicedClientName0").html();
   var lname = 'Muliwana';
   var email = $("#invoicedClientEmail0").html();
    var deliveryaddress = $("#invoicedClientAddress0").html();
   var transtype = $("#invoiceType").val();
    var phone =  $("#invoicedClientPhone0").val();
    var invoiceNumber= $("#invoiceNumber").html();
    var invoiceDueDate= $("#invoiceDueDate").val();
    var deliverylat = $('#lat0').val();
    var deliverylng = $('#lng0').val();
  
    var billingCycle=$('#billingCycle').val();
    var cardname02 = $('#cardname02').val();
    var cardnumber02 = $('#cardnumber02').val();
    var cardnumber02 = $('#cardnumber02').val();
    var cardexpirydate02 = $('#cardexpirydate02').val();
    var cardcsv02 = $('#cardcsv02').val();
    var autorenew = $('#autorenew').val();

   var cartlist = shoppingCart.listCart();
   var cartlistDetails = JSON.stringify(cartlist);
  // alert(cartlistDetails);

  if(phone != '' && cartlistDetails != '')
  {
    $("#topInvoiceNavContents").hide();
    $("#payment-btns01").hide();
    $("#paymentresponseDivTop").empty();
    $("#paymentresponseDivTop").show();
  $("#paymentresponseDivTop").append('<center><span class="w3-col l12 s12 m12" style="color:white;font-weight:600;" id="topResponse98" class="w3-animate-fading">Please wait!</span></center>');
  $("#paymentresponseDivBottom").empty();
  $("#paymentresponseDivBottom").show();
  $("#paymentresponseDivBottom").append('<center><div id="container_count_down">Saving and printing...<div id="countdown"><span id="timer"></span></div></center>');
 

     datastring='userid='+userid+'&phone='+phone+'&fname='+fname+'&lname='+lname+'&email='+email+'&orderDetails='+cartlistDetails+'&amount='+amount+'&deliverylat='+deliverylat+'&deliverylng='+deliverylng+'&deliveryaddress='+deliveryaddress+'&transtype='+transtype+'&invoiceNumber='+invoiceNumber+'&invoiceDueDate='+invoiceDueDate+'&billingCycle='+billingCycle+'&cardname02='+cardname02+'&cardnumber02'+cardnumber02+'&cardexpirydate02='+cardexpirydate02+'&cardcsv02='+cardcsv02+'&autorenew='+autorenew;
      
    $.ajax({
                 
        data:datastring,
    url: "https://lukulutowncouncil.cyberdesk.one/xd-modules/admin-modules/backend/createInvoice.php",
        type: "POST"	
      
    }).done (function(data) {
     var response = JSON.parse(data);

     if(response.status=='created'){
   $("#topInvoiceNavContents").hide();
   $("#topResponse98").empty();
   $("#topResponse98").append('Invoice created!');  
   $("#payment-btns01").hide();
   $("#paymentresponseDivBottom").empty();
   $("#paymentresponseDivBottom").show();
   $("#paymentresponseDivBottom").append('<center><span id="closeInvoiceProcess" style="width:100%;height:30px;">Okay!</span></center>');
 
     }else{
      $("#paymentresponseDivBottom").empty();
      $("#paymentresponseDivBottom").append('<center><span id="closeInvoiceProcess" style="width:100%;height:30px;">Okay!</span></center>');
 
     }

      //console.log(newdata.transactionReference);
   
        
  }); 	
  
   
  }
  else
  {
  
      //location.reload();
       alert('Please fill in all data!');
  }
  
  
});

$(document).on('click','#closeInvoiceProcess',function (event){
  $("#paymentresponseDivTop").empty();
  $("#paymentresponseDivTop").hide();
 $("#paymentresponseDivBottom").empty();
  $("#paymentresponseDivBottom").hide();
  $("#topInvoiceNavContents").show();
  $("#payment-btns01").show();
  document.getElementsByClassName('carddetailsinput').value ='';
  $('.dropdown').show();
  $('#billingCycle').show();
  $('#payment-btns01').hide();
    $('#print_invoice').show();
    $('#payment-btns-div01').append('<div id="createInvoice0" class="w3-col l12 m12 s12" style="color:white;"> <span><a href="#" id="print_invoice"  class="fontx fx-printer" onclick="window.print()" style="margin-top:10px;margin-right: 10px;float:right;display: none;color: gray;"></a></span>Submit</div>');
  
  //clear-cart
  //shoppingCart.clearCart();
  //displayCart();
  var randReceipt=(Math.floor(100000 + Math.random() * 900000));
 $('#invoiceNumber').empty();
 $('#invoiceNumber').append(randReceipt);
 let today = new Date().toLocaleDateString();
 document.getElementById('invoiceDueDate').value ='';
 document.getElementById('invoiceDueDate').value = today;

});

// close large modal
$(document).on('click','.closeLargeModal99',function (event) {
  $('#tempDiv00').remove();
  $('#generalmodalLarge').fadeOut();
 $('#generalmodalLargeMainDiv').show();
});

//bankrefid
$(document).on('click', '.bankdepositslip0', function(event){
  event.preventDefault();
  event.stopPropagation();
  var bankname = $(this).data('bankname');
  var bankaccountname = $(this).data('bankaccountname');
  var bankdepositslip = $(this).data('bankdepositslip');
  var bankdepositid = $(this).data('bankdepositid');
  $('#generalmodalLarge').fadeIn('slow');
  $('#div_title342').empty();
	$('#div_title342').append('<h4 style="margin-top:-7px;font-weight:600;">DEPOSIT SLIP DETAILS</h4>');
	$('#div_body342').empty();
  $('#div_body342').append('<b>'+bankname+'</b>: <span>'+bankaccountname+'</span><br/>');
  $('#div_body342').append('<b>Referece Id</b>: <span>'+bankdepositid+'</span>');
  $('#div_body342').append('<img src="xd-uploads/documents/deposits-slips/'+bankdepositslip+'" style="margin-top:20px;height:500px;width:100%;"/>');
  //$('#div_body342').append('<p id="closeModal876" style="background-color:transparent;color:green;height:35px;line-height:30px;width:100px;border-radius:15px;border:2px solid green;font-weight:600;cursor:pointer;">Send</p>');

});

// MAKIG PAYMET FOR DUE IVOICES
$(document).on('click', '#invoiceMakePayment0', function(event){
  event.preventDefault();
  event.stopPropagation(); 
  $('#transact_modal').fadeIn('slow');
  $('#invoiceType').empty();
  $('#invoiceType').append('<option value="RECEIPT">RECEIPT</option>');
  //var invoiceNumber = $(this).data('invoicenumber');

   //empty the print div
   $('#printReceiptDiv102').empty();
  
  $('#modeOfPayment').empty(); 
  $('#modeOfPayment').append('<option value="MOMO">Mobile Money</option><option value="BANK">Bank Deposit</option>'); 
   
  $('#paymentresponseDivBottom').empty();
  $('#payment-btns01').show();
  $('#payment-btns01').empty();
  $('#payment-btns01').append('<center><div class="momoTransact0" style="font-weight: 600;height:35px;line-height: 30px;">Mobile Money Transact</div></center>');
  

    var clientname = $(this).data('names');
    var companyname = $(this).data('companyname');
  // alert(companyname);
    var phone = $(this).data('phone');
     var email = $(this).data('email');
    var address = $(this).data('address');
    var userid = $(this).data('userid');
    shoppingCart.clearCart();
    var id = $(this).data('productid'); 
    var name = $(this).data('productname');
    var price = $(this).data('productcharge');
    var pacra =$(this).data('pacra');
    var plotnumber =$(this).data('plotnumber');
    var area = $(this).data('area');
    var nrc = $(this).data('nrc'); 
     var tpin =$(this).data('tpin');
    var businessCategory=$(this).data('businesscategory');

    var productcode=$(this).data('productcode');
    var category=$(this).data('category');
    var categorycode=$(this).data('categorycode'); 

    var depot= $(this).data('depot');
    var depotid= $(this).data('depotid');
    var depotcode = $(this).data('depotcode');
    
    shoppingCart.addItemToCart(name,price,1,id,productcode,category,categorycode,depot,depotid,depotcode);
    displayCart();
  $('#productid').empty();
  $('#productid').append(id);
  //$('#addInvoicedItemDiv').empty();
  //$('#addInvoicedItemDiv').append('<span style="float:left;margin-left:60px;cursor: pointer;">ITEM </span>');
  $('#addInvoiceClientDiv').empty();
  $('#addInvoiceClientDiv').append('<span style="float:left;font-weight:600;color:rgba(96, 146, 205,1);">BILLED TO: </span>');
  document.getElementById('invoicedClientName0').value='';
	if(companyname==''){
       document.getElementById('invoicedClientName0').value=clientname;
	}else{
	  document.getElementById('invoicedClientName0').value=companyname;
	}
  $('#invoicedClientName1').empty();
  $('#invoicedClientName1').append(clientname);
  document.getElementById('invoicedClientAddress0').vallue='';
  document.getElementById('invoicedClientAddress0').value=address;
  document.getElementById('plotnumber07').value='';
  document.getElementById('plotnumber07').value=plotnumber;
  document.getElementById('area07').value='';
  document.getElementById('area07').value=area;
  document.getElementById('nrc07').value='';
  document.getElementById('nrc07').value=nrc;
  document.getElementById('invoicedClientEmail0').value='';
  document.getElementById('invoicedClientEmail0').value=email;
  $('#invoicedClientId0').empty();
  $('#invoicedClientId0').append(userid);
  $('#pacra00').empty();
  $('#pacra00').append(pacra); 
  $('#tpin00').empty();
  $('#tpin00').append(tpin); 
  $('#businesscategory00').empty();
  $('#businesscategory00').append(businessCategory); 
  document.getElementById('invoicedClientPhone0').value ='';
  document.getElementById('invoicedClientPhone0').value = phone;
  let today = new Date().toLocaleDateString();
  document.getElementById('invoiceDueDate').value ='';
 // document.getElementById('invoiceDueDate').value = today;
  //var randReceipt=(Math.floor(100000 + Math.random() * 900000));
  $('#invoiceNumber').empty();
 // $('#invoiceNumber').append(randReceipt);
 


});

// invoicePayment0
$(document).on('click','.reprintReceipt0',function (event) { 
  // alert('Reprint charge @K20 will apply!');
   event.preventDefault();
   event.stopPropagation(); 
   $('#transact_modal').fadeIn('slow');
   $('#invoiceType').empty();
   $('#invoiceType').append('<option value="REPRINT"> RECEIPT <span style="color:red;"> (REPRINT)</span></option>');
   $('#printReceiptDiv102').empty();
   $('#printReceiptDiv102').append('<span class="clear-cart fontx fx-printer printReceiptBtn102" style="font-size:1.3em;margin-top:10px;margin-right:20px;float:right;"></span>');
  
   var invoicenumber = $(this).data('invoicenumber');
   var payment_mode = $(this).data('paymentmode');
   var bankname = $(this).data('bankname');
   var bankdepositslip = $(this).data('bankdepositslip');

    if(payment_mode=='BANK'){
    $('#modeOfPayment').empty();
    $('#modeOfPayment').append('<option value="BANK">Bank Deposit</option>');
    $('#bankName').empty();
    $('#bankName').append('<option value="'+bankname+'">'+bankname+'</option>');
     document.getElementById('bankDepositSlipId').value ='';
    document.getElementById('bankDepositSlipId').value = bankdepositslip;

   }

   shoppingCart.clearCart();
   $('.'+invoicenumber+'').each(function() { 
   // alert(productname2);
    var id = $(this).data('productid'); 
    var name = $(this).data('productname');
    var price = $(this).data('productprice');
   ///alert(id);alert(name);alert(price);
   
    var category = ($(this).data('category'));
      var categorycode = ($(this).data('categorycode'));
    var productcode = ($(this).data('productcode'));
    var depot = $(this).data('depot');
    var depotid= ($(this).data('depotid'));
    var depotcode = ($(this).data('depotcode'));  
 
   shoppingCart.addItemToCart(name, price, 1, id,  productcode, category, categorycode,depot,depotid,depotcode);
  displayCart();
   
 
   $('#invoiceNumber').empty();
   $('#invoiceNumber').append(invoicenumber);
     var clientname = $(this).data('names');
     var companyname = $(this).data('companyname');
     var phone = $(this).data('phone');
     var email = $(this).data('cemail');
     //alert(email);
     var address = $(this).data('address');
     var userid = $(this).data('userid');
     var transactiontime = $(this).data('transactiontime');
     var transactiondate = $(this).data('transactiondate');
     
    var pacra =$(this).data('pacra');
     var plotnumber =$(this).data('plotnumber');
     var area = $(this).data('area');
     var nrc = $(this).data('nrc');
     var tpin =$(this).data('tpin');
     var businessCategory=$(this).data('businesscategory');
    
   $('#productid').empty();
   $('#productid').append(id);
   $('#addInvoicedItemDiv').empty();
   $('#addInvoicedItemDiv').append('<span style="float:left;margin-left:7px;cursor: pointer;">Product/Service </span>');
   $('#addInvoiceClientDiv').empty();
   $('#addInvoiceClientDiv').append('<span style="float:left;font-weight:600;color:rgba(96, 146, 205,1);">BILLED TO: </span>');
  // document.getElementById('invoicedClientName0').value='';
   if(companyname==''){
        //document.getElementById('invoicedClientName0').value=clientname;
        $('.invoicedClientName0Div').empty();
        $('.invoicedClientName0Div').append('<input id="invoicedClientName0" value="'+clientname+'" type="text" style="float:left;border:none;background-color:transparent;outline:none;" readonly/>');
        
   }else{
    // document.getElementById('invoicedClientName0').value=companyname;
     $('.invoicedClientName0Div').empty();
     $('.invoicedClientName0Div').append('<input id="invoicedClientName0" value="'+companyname+'" type="text" style="float:left;border:none;background-color:transparent;outline:none;" readonly/>');
    }

   $('#invoicedClientName1').empty();
   $('#invoicedClientName1').append(clientname);
   $('.plotnumber07Div').empty();
   $('.plotnumber07Div').append('<input id="plotnumber07" value="'+plotnumber+'" type="text" style="float:left;border:none;background-color:transparent;outline:none;width:100px;" readonly/>');
   $('.plotnumber07Div').append('<input id="invoicedClientAddress0" value="'+address+'" type="address" style="float:left;border:none;background-color:transparent;outline:none;" readonly/>');
   $('.plotnumber07Div').append('<input id="area07" value="'+area+'" type="text" class="w3-hide-small" style="float:left;border:none;background-color:transparent;outline:none;" readonly/>');
  // $('#invoicedClientAddress0').empty();
   //$('#invoicedClientAddress0').append(address);
  // $('#plotnumber07').empty();
  // $('#plotnumber07').append(plotnumber);
  // $('#area07').empty();
  // $('#area07').append(area); 
   
   $('.nrc07Div').empty();
    $('.nrc07Div').append('<input id="nrc07" value="'+nrc+'" type="text" style="float:left;border:none;background-color:transparent;outline:none;max-width: 150px;" readonly/>');
    //$('#nrc07').empty();
   //$('#nrc07').append(nrc);

  // $('#invoicedClientEmail0').empty();
  // $('#invoicedClientEmail0').append(email); 
   $('.invoicedClientEmail0Div').empty();
   $('.invoicedClientEmail0Div').append('<input id="invoicedClientEmail0" value="'+email+'" type="email"  style="float:left;border:none;background-color:transparent;outline:none;" readonly/>');
   $('.invoicedClientEmail0Div').append('<input id="invoicedClientPhone0" value="'+phone+'" type="number" style="float:left;border:none;background-color:transparent;outline:none;max-width: 130px;" readonly/>');
    
   $('#invoicedClientId0').empty();
   $('#invoicedClientId0').append(userid);
   $('#pacra00').empty();
   $('#pacra00').append(pacra); 
   $('#tpin00').empty();
   $('#tpin00').append(tpin); 
   $('#businesscategory00').empty();
   $('#businesscategory00').append(businessCategory); 
   //document.getElementById('invoicedClientPhone0').value ='';
  // document.getElementById('invoicedClientPhone0').value = phone;

   document.getElementById('invoiceDueDate').value ='';
   document.getElementById('invoiceDueDate').value = transactiondate;
   document.getElementById('trasactionTime34').value ='';
   document.getElementById('trasactionTime34').value = transactiontime;

  });
  // GETTIG REPRIT CHARGE
  $.getJSON('https://lukulutowncouncil.cyberdesk.one/xd-modules/cashier-module/backend/reprintCharge.php',function(data){

    $('#paymentresponseDivBottom').empty();
    $('#payment-btns01').show();
    $('#payment-btns01').empty();
     $.each(data.freelancedetails, function(i,cyberdesk) {
    $('#payment-btns01').append('<center><div id="cashReprintTransact0" data-id="'+cyberdesk.id+'" data-name="'+cyberdesk.name+'" data-productcode="'+cyberdesk.product_code+'" data-price="'+cyberdesk.price+'" style="font-weight: 600;height:35px;line-height: 30px;">Click To Re-print (@ K'+cyberdesk.price+')</div></center>');
     
  });
   
      });

});

$(document).on('click','#reverseTransaction0',function (event) {
	event.preventDefault();
   event.stopPropagation();
   alert('Reversal not activated');
});



  //paymentresponseDivBottom
  $(document).on('click','.printDivOnClick',function (event){
    //invoicing();
    window.print();

    //shoppingCart.clearCart();
   // $('#transact_modal').fadeOut('slow');
  //  $("#paymentresponseDivTop").empty();
   // $("#paymentresponseDivTop").hide();
  // $("#paymentresponseDivBottom").empty();
  //  $("#paymentresponseDivBottom").hide();
    $("#topInvoiceNavContents").show();
    $("#payment-btns01").empty();
    $("#payment-btns01").hide();
   // $('#plotnumber07').empty();
   //$('#area07').empty();
   // $('#nrc07').empty();
  //  document.getElementsByClassName('carddetailsinput').value ='';
    //clear-cart
    //shoppingCart.clearCart();
    //displayCart();

    setTimeout(function(){
     //location.reload(); 
    // $("#paymentresponseDivBottom").empty();
     // $("#paymentresponseDivBottom").hide();
     $("payment-btns01").show();
     $("paymentresponseDivBottom").hide();
      //document.getElementById('invoiceDueDate').value ='';
      //document.getElementById('invoiceDueDate').value = today;
      $('#printReceiptDiv102').empty();
      $('#printReceiptDiv102').append('<span class="clear-cart fontx fx-printer printReceiptBtn102" style="font-size:1.3em;margin-top:10px;margin-right:20px;float:right;"></span>');
     
    }, 800);
  

  });


  // MOMO TRANSACTION

  $(document).on('click', '.momoTransact0', function(event){
    event.preventDefault();
    event.stopPropagation();
    var amount = $('.total-cart').html();
    var userid = $("#invoicedClientId0").html();
    var fname = $("#invoicedClientName0").val();
    var lname =  $("#invoicedClientName1").html();
    var email = $("#invoicedClientEmail0").val();
    var productid = $("#productid").html();
    var deliveryaddress = $("#invoicedClientAddress0").val();
    var pacra = $("#pacra00").html(); 
    var tpin = $("#tpin00").html(); 
    var businessCategory = $("#businesscategory00").html();
    var plotnumber = $("#plotnumber07").val(); 
    var area = $("#area07").val(); 
    var nrc = $("#nrc07").val();
    var transtype = $("#invoiceType").val();
    var phone =  $("#invoicedClientPhone0").val();
    var invoiceNumber= $("#invoiceNumber").html();
    var invoiceDueDate= $("#invoiceDueDate").val();
    var deliverylat = $('#lat0').val();
    var deliverylng = $('#lng0').val();   
    var cartlist = shoppingCart.listCart();
    var cartlistDetails = JSON.stringify(cartlist);
    

		if(phone != '' && cartlistDetails != '')
		{
      datastring='userid='+userid+'&phone='+phone+'&fname='+fname+'&lname='+lname+'&email='+email+'&orderDetails='+cartlistDetails+'&amount='+amount+'&deliverylat='+deliverylat+'&deliverylng='+deliverylng+'&deliveryaddress='+deliveryaddress+'&transtype='+transtype+'&invoiceNumber='+invoiceNumber+'&invoiceDueDate='+invoiceDueDate+'&productid='+productid+'&businessCategory='+businessCategory+'&pacra='+pacra+'&tpin='+tpin+'&plotnumber='+plotnumber+'&area='+area+'&nrc='+nrc;
		   
	    $.ajax({
				 					
	        data:datastring,
			url: "https://lukulutowncouncil.cyberdesk.one/xd-modules/payment-processing/momoPay.php",
	        type: "POST"	
				
	    }).done (function(data) {
			  
			 var newdata = JSON.parse(data);
			
    $("#topInvoiceNavContents").hide();
    $("#payment-btns01").hide(); 
    $("#paymentresponseDivTop").show();
    $("#paymentresponseDivTop").append('<center><span class="w3-col l12 s12 m12" style="color:black;font-weight:600;" id="topResponse98" class="w3-animate-fading">Please wait!</span><span class="w3-col l12 s12 m12" style="color:black;font-weight:600;"> <span id="transactioReferenceStorage01"></span></span></center>');
    $("#paymentresponseDivBottom").empty();
    $("#paymentresponseDivBottom").show();
    $("#paymentresponseDivBottom").append('<center><div id="container_count_down">Wait for prompt in: <div id="countdown"><span id="timer"></span></div></center>');
   
    function cntDown() {
      let sec = 45;
      const el = document.getElementById("timer");
      const timer = setInterval(() => {
        el.innerHTML = sec--;
        if (sec < 15) el.style.color = "#ff0";
        if (sec < 7) el.style.color = "#f00";
        if (sec < 0){
          clearInterval(timer);
          $("#paymentresponseDivBottom").empty();
          $("#paymentresponseDivBottom").append('<center><a href="" style="width:100%;height:30px;">Click to try again!</a></center>');
         
        }
      }, 1000);
    }
   
    cntDown();
    
			 $('#transactioReferenceStorage01').empty();
			 $('#transactioReferenceStorage01').append(newdata.transactionReference);
			 //var reference = ;
			 
			 
	 setInterval(function(){
                
                      var tref = $('#transactioReferenceStorage01').html();
		
                   if(tref != ''){
					 
						datastring='tref='+tref;

						$.ajax({

						data:datastring,
						url: "https://lukulutowncouncil.cyberdesk.one/xd-modules/payment-processing/verifyPayment.php",
						type: "POST"	

						}).done (function(data) {

						 var newdata = JSON.parse(data);
						 
						  //alert(data);
                          // alert(newdata.transaction_status);
						  
							$.each(newdata.details, function(i,cyberdesk) {
 
     if(cyberdesk.transaction_status == 'approved'){
 
      $("#paymentresponseDivTop").show();
      $("#topResponse98").empty();
     $("#transactioReferenceStorage01").empty();
     $("#topResponse98").remove();
     $("#transactioReferenceStorage01").remove();

     $("#paymentresponseDivBottom").empty();
     $("#paymentresponseDivBottom").show();
     $("#paymentresponseDivBottom").append('<center><span class="printDivOnClick" style="width:100%;height:30px;">Success. Print receipt!</span></center>');
       $("#topResponse98").empty();
    
      $("#topInvoiceNavContents").hide();
      $('#invoiceNumber').empty();
      $('#invoiceNumber').append(cyberdesk.receipt_no);
     document.getElementById('invoiceDueDate').value ='';
     document.getElementById('invoiceDueDate').value =cyberdesk.transaction_date;
     document.getElementById('trasactionTime34').value = '';
	   document.getElementById('trasactionTime34').value = cyberdesk.transaction_time;
      $("#payment-btns01").empty(); 
      $("#payment-btns01").hide();
      
      // print the documet
      setTimeout(function(){ 
     // window.print(); 
      }, 100);
      // print the documet

      setTimeout(function(){ 
      $("#topInvoiceNavContents").show();
      }, 700);


	} else if(cyberdesk.transaction_status == 'failed'){
                    
    $("#topInvoiceNavContents").hide();
    $("#topResponse98").empty();
    $("#topResponse98").append('Payment failed!');  
    $("#payment-btns01").hide();
    $("#paymentresponseDivBottom").empty();
    $("#paymentresponseDivBottom").show();
    $("#paymentresponseDivBottom").append('<center><a href="" style="width:100%;height:30px;">Failed please try again!</a></center>');
   
    }
 
							
	});
						  
						}); 
			 
					}else{
						
						
					}
				 

             }, 6000);
     //console.log(newdata.transactionReference);
		 
				  
		}); 	
		
		 
		}
		else
		{
		
		    //location.reload();
         alert('Please fill in all data!');
		}
		
		
	});
  //MOMO TRASACTIO

  
 
//bankTransact0
$(document).on('click', '.bankTransact0', function(event){
	event.preventDefault();
		event.stopPropagation();
    //alert('Bank');
		 var amount = $('.total-cart').html();
		 var userid = $("#invoicedClientId0").html();
     var fname = $("#invoicedClientName0").val();
		 var lname =  $("#invoicedClientName1").html();
		 var email = $("#invoicedClientEmail0").val();
      var deliveryaddress = $("#invoicedClientAddress0").val();
      var productid = $("#productid").html();
      var pacra = $("#pacra00").html(); 
      var tpin = $("#tpin00").html(); 
      var businessCategory = $("#businesscategory00").html();
      var plotnumber = $("#plotnumber07").val(); 
      var area = $("#area07").val(); 
      var nrc = $("#nrc07").val();
     var transtype = $("#invoiceType").val();
		  var phone =  $("#invoicedClientPhone0").val();
     // var invoiceNumber= $("#invoiceNumber").html();
      var invoiceDueDate= $("#invoiceDueDate").val();
      var deliverylat = $('#lat0').val();
      var deliverylng = $('#lng0').val();
      var bankDepositSlipId = $('#bankDepositSlipId').val();
      var bankAccountName = $('#bankName').val();
      var bankName = $('#bankName').val();
      var cartlist = shoppingCart.listCart();
		  var cartlistDetails = JSON.stringify(cartlist);
     //alert(bankAccountName);
    
		if(phone != '' && cartlistDetails != '' && bankDepositSlipId != '' && bankAccountName != '' && bankName != '')
		{
		   datastring='userid='+userid+'&phone='+phone+'&fname='+fname+'&lname='+lname+'&email='+email+'&orderDetails='+cartlistDetails+'&amount='+amount+'&deliverylat='+deliverylat+'&deliverylng='+deliverylng+'&deliveryaddress='+deliveryaddress+'&transtype='+transtype+'&invoiceDueDate='+invoiceDueDate+'&bankDepositSlipId='+bankDepositSlipId+'&bankAccountName='+bankAccountName+'&bankName='+bankName+'&productid='+productid+'&businessCategory='+businessCategory+'&pacra='+pacra+'&tpin='+tpin+'&plotnumber='+plotnumber+'&area='+area+'&nrc='+nrc;
		  
    $.ajax({
                 
        data:datastring,
        url: "https://lukulutowncouncil.cyberdesk.one/xd-modules/agent-module/backend/bankTransact.php",
        type: "POST"	
      
    }).done (function(data) {
     var response = JSON.parse(data);

     if(response.status=='created'){
      invoicing();
      $("#topInvoiceNavContents").hide();
      $('#invoiceNumber').empty();
      $('#invoiceNumber').append(response.receiptnumber);
     document.getElementById('invoiceDueDate').value ='';
     document.getElementById('invoiceDueDate').value =response.date;
     document.getElementById('trasactionTime34').value = '';
	   document.getElementById('trasactionTime34').value = response.time;
      $("#payment-btns01").empty(); 
      $("#payment-btns01").hide();
      $("#paymentresponseDivBottom").empty();
      $("#paymentresponseDivBottom").show();
     // $("#paymentresponseDivBottom").append('<center><span class="printDivOnClick" style="width:100%;height:100px;padding-top:7px;padding-bottom:7px">Success click to print!<span  class="fontx fx-printer"><span></span></center>');
    // $('#paymentresponseDivTop').fadeOut();
     
     setTimeout(function(){ 
      window.print(); 
    }, 100);
    setTimeout(function(){ 
      $("#topInvoiceNavContents").show();
      $('#printReceiptDiv102').empty();
      $('#printReceiptDiv102').append('<span class="clear-cart fontx fx-printer printReceiptBtn102" style="font-size:1.3em;margin-top:10px;margin-right:20px;float:right;"></span>');
     
    }, 700);

      //$('#payment-btns-div01').append('<form id="depositslipform" method="post" enctype="multipart/form-data"></form>');
      //$('#depositslipform').append('<div class="w3-col l12 m12 s12" style="color:white;"><p>Capture or upload bank deposit slip</p><span id="capture-camera"><span class="fontx fx-camera" style="background-color:white;color:rgba(96, 146, 205,1);padding:12px;border-radius:50%;height:100px;width:100%;font-size:3.5em"></span></span> <p>Or</p><p> <input type="file" name="file" accept="image/*" id="imageInput" style="border-radius:6px;height:38px;"/><input type="text" name="invoiceNumber01" value="'+invoiceNumber01+'" style="display:none;"/></p>');
      //$('#depositslipform').append('<center><input type="submit" name="action" id="bankTransact03" class="w3-btn" value="Later" style="background-color:rgba(96, 146, 205,1);border-radius:6px;height:38px;width:80px;cursor:pointer;color:white;outline:none;border:1px solid white;margin-top:15px;font-family:segoe ui light;margin-right:15px"/> <input type="submit" name="action" id="bankTransact02" class="w3-btn" value="Upload" style="background-color:white;border-radius:6px;height:38px;width:80px;cursor:pointer;color:rgba(96, 146, 205,1);outline:none;border: none;margin-top:15px;font-family:segoe ui light"/></center><p style=""color:rgba(96, 146, 205,1);>&copy; MMC</p>');
    
     }else{
      $("#paymentresponseDivBottom").empty();
      $("#paymentresponseDivBottom").append('<center><span id="closeInvoiceProcess" style="width:100%;height:30px;">Failed! Okay</span></center>');
 
     }

      //console.log(newdata.transactionReference);
   
        
  }); 	
  
   
  }
  else
  {
  
      //location.reload();
       alert('Please fill in all data!');
  }
  
  
});
//bankTransact02
$(document).on('submit', '#depositslipform', function(event){
  event.preventDefault();
  event.stopPropagation();
   var invoiceNumber01 = $('#invoiceNumber01').val();
   
  var extension = $('#imageInput').val().split('.').pop().toLowerCase();
   
  if(extension != ''){
      if(jQuery.inArray(extension, ['gif','png','jpg','jpeg']) == -1)
      {
          alert("Invalid Image File");
          $('#imageInput').val('');
          return false;
      }
  }	
    
  
  if(extension != '')
  {
   $('#payment-btns-div01').empty();
   $('#payment-btns-div01').append('<center><p>Uploading...</p></center>');
        
      $.ajax({
          url:"https://lukulutowncouncil.cyberdesk.one/xd-modules/payment-processing/uploadDepositSlip.php",
          method:'POST',
          data:new FormData(this),
          contentType:false,
          processData:false,
          catche:false,
          success:function(data)
          {
          
          var postStatus = JSON.parse(data);
             
             
                if(postStatus.status=='uploaded'){
                
              $("#depositslipform").trigger('reset'); //jquery
              $("#topInvoiceNavContents").hide();
              $("#topResponse98").empty();
              $("#topResponse98").append('Payment succesful!');  
              $('#payment-btns-div01').empty();
              $('#payment-btns-div01').append('<a href="" id="closeDepositSlipProcess" class="w3-col l12 m12 s12" style="color:white;"><p style="background-color:white;width:100px;color:rgba(96, 146, 205,1);padding:7px;border-radius:4px;">CLose</p></a>');     
                  
            } else{
              $("#depositslipform").trigger('reset'); //jquery
              
              
             }
                     
              
              
                
          }
      });
  }
  else
  {
  
            // $('#upload_media_form0946').hide();
             $('#status44').empty();
             $('#status44').append('Please fill in all data!');
                
  }
});
/// opting out of uploadig deposit slip
$(document).on('click', '#bankTransact03', function(event){
 // alert('you can upload or capture deposit slip later ');
  shoppingCart.clearCart();
  displayCart();
  $('#plotnumber07').empty();
  $('#area07').empty();
  $('#nrc07').empty();
  $('#transact_modal').fadeOut('slow');
  setTimeout(function(){
   // location.reload();
	}, 500);
});
/// opting out of uploadig deposit slip

//closeDepositSlipProcess
$(document).on('click','#closeDepositSlipProcess',function (event){
  $("#paymentresponseDivTop").empty();
  $("#paymentresponseDivTop").hide();
  $("#paymentresponseDivBottom").empty();
  $("#paymentresponseDivBottom").hide();
  $("#topInvoiceNavContents").show();
  $('#plotnumber07').empty();
  $('#area07').empty();
  $('#nrc07').empty();
  $('#transact_modal').fadeOut('slow');
//  $("#payment-btns-div0").hide();
  $("#payment-btns01").show();
  document.getElementsByClassName('carddetailsinput').value ='';
  //clear-cart
  shoppingCart.clearCart();
  displayCart();
  //var randReceipt=(Math.floor(100000 + Math.random() * 900000));
 //$('#invoiceNumber').empty();
 //$('#invoiceNumber').append(randReceipt);
 let today = new Date().toLocaleDateString();
 document.getElementById('invoiceDueDate').value ='';
 document.getElementById('invoiceDueDate').value = today;

});

 

//addInvoiceItem0
$(document).on('click','#addInvoiceClient0',function (event) {
	addInvoiceClient();
  });
  function addInvoiceClient() {
	   
   $('#invoiceAddClients').fadeIn('slow');
	$('.invoice_modal_contents345').fadeOut('slow');
  $('#backToInvoice0').remove();
	$('#invoiceAddClientsTopnav').empty();
	$('#invoiceAddClientsTopnav').append('<div class="w3-col l12 m12 s12 w3-top w3-card-2" style="background-color:#fff;height:40px;line-height:40px;"><div class="close_invoiceAddClients_div w3-col l1 m1 s1" style="padding-top: 5px;cursor:pointer;"><span class="fontx fx-arrow-left" style="color:rgba(96, 146, 205,1);font-size:1.5em;"></span></div><div class="w3-col l10 m10 s10" style="color:rgba(96, 146, 205,1);font-weight:600;"><div class="w3-col l12 m12 s12 w3-center" style="margin-top:0px;"><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-search" style="color:rgba(0,0,0,0.3);font-size:1.5em"></span></div><div class="w3-col l10 m10 s10 w3-center"><input class="searchUsersForReceiptInvoice" type="text" placeholder="Search clients..." style="font-weight:400;outline:none;color:gray;border:none;border-bottom:none;width:100%;height:30px;background-color:transparent;padding-left:7px;"/></div><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-filter" style="color:rgba(0,0,0,0.3);font-size:1.3em"></span></div></div></div><div class="w3-col l1 m1 s1" style="padding-top: 5px;"><span class="fontx fx-more-vertical" style="color:rgba(96, 146, 205,1);font-size:1.3em;"></span></div></div>');
	//$('#invoiceAddClientsTopnav').append('<div class="w3-col l12 m12 s12 w3-top" style="background-color:rgba(96, 146, 205,1);height:40px;line-height:40px;"><div class="close_invoiceAddClients_div w3-col l1 m1 s1" style="padding-top: 5px;cursor:pointer;"><span class="fontx fx-arrow-left" style="color:#fff;font-size:1.5em;"></span></div><div class="w3-col l9 m9 s9" style="color:rgba(96, 146, 205,1);font-weight:600;"><div class="w3-col l12 m12 s12 w3-center" style="margin-top:0px;"><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-search" style="color:#eee;font-size:1.5em"></span></div><div class="w3-col l10 m10 s10 w3-center"><input class="searchProductsForReceiptInvoice" type="text" placeholder="Search..." style="font-weight:400;outline:none;color:#eee;border:none;border-bottom:none;width:100%;height:30px;background-color:transparent;padding-left:7px;"/></div><div class="w3-col l1 m1 s1 w3-center" style="display:none;padding-top: 5px;"><span class="fontx fx-filter" style="color:#eee;font-size:1.3em"></span></div></div></div><div class="w3-col l2 m2 s2" style="padding-top: 5px;"><a href="#" id="cart-btn" style="text-decoration:none;outline:none;background-color:transparent;color:#eee;padding-top:0px;font-size:1.3em;margin-top:5px;float:right;"><span id="cart-count0" class="total-count w3-col l12 m12 s12" style="color:white;margin-left:25px;line-height:12px;height:14px;width:14px;background-color:orange;border-radius:50%;font-size:0.7em;padding-left:0px;padding-top:1px;">0</span><span class="fontx fx-shopping-cart w3-col l12 m12 s12" style="margin-top:-5px;margin-left:0px;"></span></a</div>');
	
  $('#invoiceAddClientsDiv08').empty(); 
   $('#invoiceAddClientsDiv08').append('<center><div class="body-loader"></div><br/></center>');
   
   
		$.getJSON('https://lukulutowncouncil.cyberdesk.one/xd-modules/agent-module/backend/allClients.php',function(data){

			$('#invoiceAddClientsDiv08').empty();
			$('#invoiceAddClientsDiv08').append('<br/>');
			$('#invoiceAddClientsDiv08').append('<br/ class="w3-hide-large w3-hide-medium">');
			$('#invoiceAddClientsDiv08').append('<br/ class="w3-hide-large w3-hide-medium">');
		$.each(data.freelancedetails, function(i,freelance) {
		  if(freelance.status=='active'){

			 $('#invoiceAddClientsDiv08').append('<div class="inner-data-div w3-col l12 m12 s12" id="addInvoiceClient01" data-address="'+freelance.address+'" data-id="'+freelance.id+'" data-phone="'+freelance.phone+'" data-email="'+freelance.email+'" data-names="'+freelance.names+'" data-orgname="'+freelance.org_name+'" data-businesscategory="'+freelance.business_category+'" data-pacra="'+freelance.company_registration_number+'" data-tpin="'+freelance.tpin+'" data-nrc="'+freelance.nrc+'" data-plotnumber="'+freelance.plot_number+'" data-area="'+freelance.area+'" style="font-weight:400;border-bottom:1px solid #eee;cursor:pointer"><div class="w3-col l12 m12 s9"><span class="w3-col l5 m5 s12" style="padding-left:7px;font-weight:600;color:black;"><span class="w3-col l12 m12 s12">'+freelance.org_name+' <span class="fontx fx-user" style="color:gray;"> '+freelance.names+'</span></span></span><span class="w3-col l3 m3 s12" style="padding-left:7px;"><span class="w3-col l6 m6 s6"> <span class="fontx fx-phone"></span> '+freelance.phone+' </span><span class="w3-col l6 m6 s6"> <spa class="fontx fx-credit-card1"></spa> '+freelance.nrc+'</span></span><span class="w3-col l4 m4 s12" style="padding-left:3px;"><span class="w3-col l6 m6 s6">Pacra: <span style="color: rgba(96, 146, 205,1);"> '+freelance.company_registration_number+'</span></span><span class="w3-col l6 m6 s6">Tpin: <span style="color: rgba(96, 146, 205,1);"> '+freelance.tpin+'</span></span></span></div></div>');
			 
		   }else{
		 //	there are no active clients or something 


		   }
		});

       //$('#invoiceAddClients').append('<div id="backToInvoice0" class="fontx fx-arrow-right" style="position:fixed;height:40px;width:40px;border-radius:50%;color:#fff;background-color: rgba(96, 146, 205,1);line-height:40px;right:10%;bottom:8%;cursor: pointer;"></div></div>');
		
	});

};

// SEARCH USERS SCRIPT
//searchUsers.php

$(document).on('change keyup','.searchUsersForReceiptInvoice',function (event) {
	event.preventDefault(); 
  event.stopPropagation();  
  if($(".searchUsersForReceiptInvoice").val()=='') {	
	addInvoiceClient()
  } else{
   //var searchCategory = $(".invoicesSelect0").val();
	 var searchKey = $(".searchUsersForReceiptInvoice").val(); 
	 datastring='searchKey='+searchKey;
	 $('#invoiceAddClientsDiv08').empty(); 
	 $('#invoiceAddClientsDiv08').append('<center><div class="body-loader"></div><br/></center>');
	 	 
	 $.ajax({
				  
		   data:datastring,
	   url: "https://lukulutowncouncil.cyberdesk.one/xd-modules/agent-module/backend/searchUsers.php",
		   type: "POST"
	   
	  }).done (function(data) {
 
	  var details0 = JSON.parse(data);
	  $('#invoiceAddClientsDiv08').empty(); 
	  $('#invoiceAddClientsDiv08').append('<br/>');
	  $('#invoiceAddClientsDiv08').append('<br/ class="w3-hide-large w3-hide-medium">');
	  $('#invoiceAddClientsDiv08').append('<br/ class="w3-hide-large w3-hide-medium">');
  
	$.each(details0.details, function(i,freelance) {
	//	$('#invoiceAddClientsDiv08').append('<div id="'+freelance.id+'" class="inner-data-div w3-col l12 m12 s12" style="font-weight:600;border-bottom:1px solid #eee;"><div class="w3-col l11 m11 s9"><span class="w3-col l3 m3 s12" style="padding-left:7px;font-weight:600;color:black;"><span class="w3-col l12 m12 s12">'+freelance.org_name+' ('+freelance.business_category+')</span> <span class="w3-col l12 m12 s12" style="color:gray;">'+freelance.names+' ('+freelance.nrc+')</span></span><span class="w3-col l3 m3 s12" style="padding-left:7px;"><span class="w3-col l12 m12 s12"><b>PACRA:</b> <span style="color: rgba(96, 146, 205,1);"> '+freelance.company_registration_number+'</span></span><span class="w3-col l12 m12 s12"><b>TPIN:</b> <span style="color: rgba(96, 146, 205,1);"> '+freelance.tpin+'</span></span></span><span class="w3-col l2 m2 s12" style="padding-left:7px;"><span class="w3-col l12 m12 s12"> '+freelance.email+'</span><span class="w3-col l12 m12 s12"> '+freelance.phone+'</span></span><span class="w3-col l3 m3 s12"><span class="w3-col l12 m12 s12" style="padding-left:10px;"> '+freelance.address+'</span><span class="w3-col l12 m12 s12" style="padding-left:10px;"> '+freelance.plot_number+' '+freelance.area+'</span></span><span id="addInvoiceClient01" class="w3-col l1 m1 s12" data-address="'+freelance.address+'" data-id="'+freelance.id+'" data-phone="'+freelance.phone+'" data-email="'+freelance.email+'" data-names="'+freelance.names+'" data-orgname="'+freelance.org_name+'" data-businesscategory="'+freelance.business_category+'" data-pacra="'+freelance.company_registration_number+'" data-tpin="'+freelance.tpin+'" data-nrc="'+freelance.nrc+'" data-plotnumber="'+freelance.plot_number+'" data-area="'+freelance.area+'"><a href="#" style="background-color:rgba(96, 146, 205,1);color:#fff;text-decoration:none;float:right;margin-right:17px;padding-right:7px;padding-left:7px;border-radius:4px;height:20px;line-height:20px;">Add</a></span></div></div>');
  $('#invoiceAddClientsDiv08').append('<div class="inner-data-div w3-col l12 m12 s12" id="addInvoiceClient01" data-address="'+freelance.address+'" data-id="'+freelance.id+'" data-phone="'+freelance.phone+'" data-email="'+freelance.email+'" data-names="'+freelance.names+'" data-orgname="'+freelance.org_name+'" data-businesscategory="'+freelance.business_category+'" data-pacra="'+freelance.company_registration_number+'" data-tpin="'+freelance.tpin+'" data-nrc="'+freelance.nrc+'" data-plotnumber="'+freelance.plot_number+'" data-area="'+freelance.area+'" style="font-weight:400;border-bottom:1px solid #eee;cursor:pointer"><div class="w3-col l12 m12 s9"><span class="w3-col l5 m5 s12" style="padding-left:7px;font-weight:600;color:black;"><span class="w3-col l12 m12 s12">'+freelance.org_name+' <span class="fontx fx-user" style="color:gray;"> '+freelance.names+'</span></span></span><span class="w3-col l3 m3 s12" style="padding-left:7px;"><span class="w3-col l6 m6 s6"> <span class="fontx fx-phone"></span> '+freelance.phone+' </span><span class="w3-col l6 m6 s6"> <spa class="fontx fx-credit-card1"></spa> '+freelance.nrc+'</span></span><span class="w3-col l4 m4 s12" style="padding-left:3px;"><span class="w3-col l6 m6 s6">Pacra: <span style="color: rgba(96, 146, 205,1);"> '+freelance.company_registration_number+'</span></span><span class="w3-col l6 m6 s6">Tpin: <span style="color: rgba(96, 146, 205,1);"> '+freelance.tpin+'</span></span></span></div></div>');
			 	   
	  });
	 
	}); 	
	
	

  } 
  
		  
});
//backToInvoiceItem0
$(document).on('click','#backToInvoice0',function (event) { 
	$('#invoiceAddClients').fadeOut('slow');
	$('.invoice_modal_contents345').fadeIn('slow');

});
//close_create_invoice_modal
$(document).on('click','#close_create_invoice_modal',function (event) { 
	$('#create_invoice_modal').fadeOut('slow');
	 
});
$(document).on('click','.close_invoiceAddClients_div',function (event) {
	$('#invoiceAddClients').fadeOut('slow');
	$('.invoice_modal_contents345').fadeIn('slow');		  
});
//addInvoiceClient01
$(document).on('click','#addInvoiceClient01',function (event) { 
	$('#invoiceAddClients').fadeOut('slow');
	$('.invoice_modal_contents345').fadeIn('slow');
	var id = $(this).data('id'); 
	var names = $(this).data('names');
	var companyname = $(this).data('orgname');
	var address = $(this).data('address');
	 var email = $(this).data('email'); 
	 var phone = $(this).data('phone'); 
	 var pacra =$(this).data('pacra');
	 var tpin =$(this).data('tpin');
	 var nrc = $(this).data('nrc'); 
	 var area =$(this).data('pacra');
	 var plotnumber =$(this).data('plotnumber');
	 var businessCategory=$(this).data('businesscategory');
	 //var plotnumber =$(this).data('tpin');
	 $('#invoicedClientId0').empty();
	 $('#invoicedClientId0').append(id);
	 document.getElementById('invoicedClientName0').vallue='';
	 document.getElementById('invoicedClientName0').value=companyname;
	 $('#invoicedClientName1').empty();
	 $('#invoicedClientName1').append(names);
   document.getElementById('invoicedClientAddress0').value='';
	 document.getElementById('invoicedClientAddress0').value=address;
	 document.getElementById('plotnumber07').value='';
	 document.getElementById('plotnumber07').value= plotnumber;
	 document.getElementById('area07').value='';
	 document.getElementById('area07').value=area;
   document.getElementById('nrc07').vallue='';
	 document.getElementById('nrc07').vallue=nrc;
	 document.getElementById('invoicedClientEmail0').value='';
	 document.getElementById('invoicedClientEmail0').value=email;
	  $('#invoicedClientId0').empty();
	 $('#invoicedClientId0').append(id);
	 $('#pacra00').empty();
	 $('#pacra00').append(pacra); 
	 $('#tpin00').empty();
	 $('#tpin00').append(tpin); 
	 $('#businesscategory00').empty();
	 $('#businesscategory00').append(businessCategory);
	document.getElementById('invoicedClientPhone0').value ='';
	document.getElementById('invoicedClientPhone0').value = phone;
		
});

//addInvoicedItem0
$(document).on('click','#addInvoicedItem0',function (event) {
	addInvoicedItem(); 
  });
  function addInvoicedItem() {	  
	$('#invoiceAddClients').fadeIn('slow'); 
 // var div34 = document.getElementById('transact_modal');
  document.getElementById('transact_modal').scroll({top:0,behavior:'smooth'});
 // div34.scrollTop = 0;
	$('.invoice_modal_contents345').fadeOut('slow');
	$('#invoiceAddClientsTopnav').empty();
	$('#invoiceAddClientsTopnav').append('<div class="w3-col l12 m12 s12 w3-top w3-card-2" style="background-color:#fff;height:40px;line-height:40px;"><div class="close_invoiceAddClients_div w3-col l1 m1 s1" style="padding-top: 5px;cursor:pointer;"><span class="fontx fx-arrow-left" style="color:rgba(96, 146, 205,1);font-size:1.5em;"></span></div><div class="w3-col l9 m9 s9" style="color:rgba(96, 146, 205,1);font-weight:600;"><div class="w3-col l12 m12 s12 w3-center" style="margin-top:0px;"><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-search" style="color:rgba(0,0,0,0.3);font-size:1.5em"></span></div><div class="w3-col l10 m10 s10 w3-center"><input class="searchProductsForReceiptInvoice" type="text" placeholder="Search & add items to cart..." style="font-weight:400;outline:none;color:gray;border:none;border-bottom:none;width:100%;height:30px;background-color:transparent;padding-left:7px;"/></div><div class="w3-col l1 m1 s1 w3-center" style="display:none;padding-top: 5px;"><span class="fontx fx-filter" style="color:rgba(0, 0, 0,0.3);font-size:1.3em"></span></div></div></div><div class="w3-col l2 m2 s2" style="padding-top: 0px;"><a href="#" id="cart-btn" style="text-decoration:none;outline:none;background-color:transparent;color:rgba(96, 146, 205,1);padding-top:0px;font-size:1.3em;margin-top:5px;float:right;"><span id="cart-count0" class="total-count w3-col l12 m12 s12" style="color:white;margin-left:22px;line-height:12px;height:14px;width:14px;background-color:orange;border-radius:50%;font-size:0.4em;padding-left:0px;padding-top:1px;">0</span><span class="fontx fx-shopping-cart w3-col l12 m12 s12" style="margin-top:-5px;margin-left:0px;"></span></a></div>');
	
  $('#invoiceAddClientsDiv08').empty(); 
   $('#invoiceAddClientsDiv08').append('<center><div class="body-loader"></div><br/></center>');
   
   
   $.getJSON('https://lukulutowncouncil.cyberdesk.one/xd-modules/client-portal/backend/allProducts.php',function(data){
	$('#invoiceAddClientsDiv08').empty(); 
	$('#invoiceAddClientsDiv08').append('<br/>');
	$('#invoiceAddClientsDiv08').append('<br/ class="w3-hide-large w3-hide-medium">');
	$('#invoiceAddClientsDiv08').append('<br/ class="w3-hide-large w3-hide-medium">');

 //$('#invoiceAddClientsDiv08').append('<center style="margin-top:17%;"><p>Unfortunately no products/services were added to your account. Contact your superiors!</p></center>');
     $.each(data.freelancedetails, function(i,freelance) {

      $('#invoiceAddClientsDiv08').append('<div class="inner-data-div w3-col l4 m6 s12" style="padding-left:7px;margin-top:3px;"><div class="w3-col l2 m2 s2"><img src="xd-assets/img/logo.png" style="height:45px;width:45px;margin-left:-7px;"/></div><div class="w3-col l9 m9 s9"><b style="color:black;float:left" class="w3-col l12 m12 s12">'+freelance.name+'</b> <span class="w3-col l12 m12 s12">K'+freelance.price+'</span></div><div class="w3-col l1 m1 s1"><input type="checkbox" id="addInvoiceItem045" data-id="'+freelance.id+'" data-name="'+freelance.name+'" data-price="'+freelance.price+'" data-description="'+freelance.description+'" data-productcode="'+freelance.product_code+'" data-category="'+freelance.category+'" data-categorycode="'+freelance.category_code+'" data-depot="'+freelance.depot+'" data-depotid="'+freelance.depot_id+'" data-depotcode="'+freelance.depot_code+'" style="background-color:rgba(96, 146, 205,1);color:#fff;text-decoration:none;float:right;margin-right:10px;padding-right:7px;padding-left:7px;border-radius:4px;height:20px;cursor:pointer;margin-top:15px"/></div></div>');
 
   });
 


	$('#invoiceAddClients').append('<div id="backToInvoice0" class="w3-bottom" style="position:fixed;height:40px;width:100%;color:#fff;background-color:rgba(96, 146, 205,1);line-height:40px;cursor: pointer;font-weight:600;">PROCEED <span class="fontx fx-arrow-right"></span></div></div>');
		

	});

};
// search products or chart of A/C
$(document).on('change keyup','.searchProductsForReceiptInvoice',function (event) {
	event.preventDefault(); 
  event.stopPropagation();  
  if($(".searchProductsForReceiptInvoice").val()=='') {	
	addInvoicedItem();
  } else{
   //var searchCategory = $(".invoicesSelect0").val();
	 var searchKey = $(".searchProductsForReceiptInvoice").val(); 
	 datastring='searchKey='+searchKey;
	 $('#invoiceAddClientsDiv08').empty(); 
	 $('#invoiceAddClientsDiv08').append('<center><div class="body-loader"></div><br/></center>');
	 	 
	 $.ajax({
				  
		   data:datastring,
	     url: "https://lukulutowncouncil.cyberdesk.one/xd-modules/client-portal/backend/searchProducts.php",
		   type: "POST"
	   
	  }).done (function(data) {
 
	  var details0 = JSON.parse(data);
	  $('#invoiceAddClientsDiv08').empty(); 
	  $('#invoiceAddClientsDiv08').append('<br/>');
	  $('#invoiceAddClientsDiv08').append('<br/ class="w3-hide-large w3-hide-medium">');
	  $('#invoiceAddClientsDiv08').append('<br/ class="w3-hide-large w3-hide-medium">');
  
	$.each(details0.details, function(i,freelance) {

    $('#invoiceAddClientsDiv08').append('<div class="inner-data-div w3-col l12 m12 s12" style="padding-left:7px;margin-top:3px;background-color:rgba(250,250,250);"><div class="w3-col l1 m1 s12 w3-hide-small"><b class="w3-hide-large w3-hide-medium" style="color:black;">ID:</b>'+freelance.id+'</div><div class="w3-col l1 m1 s12 w3-hide-small"><b class="w3-hide-large w3-hide-medium" style="color:black;">Charge:</b>  '+freelance.price+'</div><div class="w3-col l2 m2 s12"><b style="color:black;">'+freelance.name+'</b></div><div class="w3-col l4 m4 s12 w3-hide-small"><b class="w3-hide-large w3-hide-medium" style="color:black;">Desc:</b> '+freelance.description+'</a></div><div class="w3-col l1 m1 s12 w3-hide-small"><b class="w3-hide-large w3-hide-medium" style="color:black;">Status:</b> '+freelance.status+'</a></div><div class="w3-col l2 m2 s12 w3-hide-small"><b class="w3-hide-large w3-hide-medium" style="color:black;">Timestamp:</b> '+freelance.datemodified+'</a></div><div class="w3-col l1 m1 s12"><span class="w3-hide-large w3-hide-medium" style="float:left;">K'+freelance.price+'</span><input type="checkbox" id="addInvoiceItem045" data-id="'+freelance.id+'" data-name="'+freelance.name+'" data-price="'+freelance.price+'" data-description="'+freelance.description+'"  data-productcode="'+freelance.product_code+'" data-category="'+freelance.category+'" data-categorycode="'+freelance.category_code+'" style="background-color:rgba(96, 146, 205,1);color:#fff;text-decoration:none;float:right;margin-right:10px;padding-right:7px;padding-left:7px;border-radius:4px;height:20px;line-height:20px;cursor:pointer;"/></div></div>');
  
	  });
	 
	}); 	
	
	

  } 
  
		  
});
// end of search products or chart of A/C

 //sum invoice
 $(document).on('click','#backToInvoice0',function (event) {

	var total = 0;
	$('.invoiceItemTotalPrice0').each(function(){
		total += parseFloat($(this).text().replace(/,/g,''))
	});
	//$('.total').text(total)
	//alert(total);
	$('#invoiceSubTotal').empty();
	$('#invoiceSubTotal').append(total);
	//invoiceTaxTotal0
	var taxPercent = total*0.10;
	$('#invoiceTaxTotal0').empty();
	$('#invoiceTaxTotal0').append(taxPercent);
    //invoiceTotal0
	var invoiceTotal = total-taxPercent;
	$('#invoiceTotal0').empty();
	$('#invoiceTotal0').append(invoiceTotal);
 
});

//CHANGING INVOICE UNITS AND SUMING UP THE TOTAL INVOICE

$(document).on('click','.invoiceItemDiv0',function (event) {

	var count = $(this).closest(".invoiceItemDiv0").find(".invoiceUnits0").val();
	var unitPrice = $(this).closest(".invoiceItemDiv0").find(".invoiceItemPrice0").html();
	var totalItemPrice = unitPrice*count;
	//alert(count);alert(totalItemPrice);
	$(this).closest(".invoiceItemDiv0").find(".invoiceItemTotalPrice0").empty();
	$(this).closest(".invoiceItemDiv0").find(".invoiceItemTotalPrice0").append(totalItemPrice);
	
	// NOW WE TOTAL UP THE INVOICE TOTAL PRICE FOR EACH ITEM
	var total = 0;
	$('.invoiceItemTotalPrice0').each(function(){
		total += parseFloat($(this).text().replace(/,/g,''))
	});
	//$('.total').text(total)
	//alert(total);
	$('#invoiceSubTotal').empty();
	$('#invoiceSubTotal').append(total);
	//invoiceTaxTotal0
	var taxPercent = total*0.10;
	$('#invoiceTaxTotal0').empty();
	$('#invoiceTaxTotal0').append(taxPercent);
	//invoiceTotal0
	var invoiceTotal = total-taxPercent;
	$('#invoiceTotal0').empty();
	$('#invoiceTotal0').append(invoiceTotal);
	
	});
	
//CHANGING INVOICE UNITS AND SUMING UP THE TOTAL INVOICE
 