var shoppingCart = (function() {
  let cart = [];

  // Constructor with balanceCF added
  function Item(name, price, charge_rate, count, id, productcode, category, categorycode, depot, depotid, depotcode, total_charge, balance_bf, balance, balanceCF) {
    this.name = name;
    this.price = parseFloat(price);
    this.charge_rate = parseFloat(charge_rate);
    this.count = parseFloat(count); // Supports decimal count
    this.id = id;
    this.productcode = productcode;
    this.category = category;
    this.categorycode = categorycode;
    this.depot = depot;
    this.depotid = depotid;
    this.depotcode = depotcode;
    this.total_charge = parseFloat(total_charge)-parseFloat(total_charge);
    this.balance_bf = parseFloat(balance_bf);
    this.balance = parseFloat(balance);
    this.balanceCF = parseFloat(balanceCF); // Initialize balanceCF
  }

  // Save cart to sessionStorage
  function saveCart() {
    sessionStorage.setItem('shoppingCart', JSON.stringify(cart));
  }

  // Load cart from sessionStorage
  function loadCart() {
    cart = JSON.parse(sessionStorage.getItem('shoppingCart')) || [];
  }

  if (sessionStorage.getItem("shoppingCart") != null) {
    loadCart();
  }

  const obj = {};

  // Add Item to Cart
  obj.addItemToCart = function(name, price, charge_rate, count, id, productcode, category, categorycode, depot, depotid, depotcode, total_charge, balance_bf, balance) {
    let item = new Item(name, price, charge_rate, count, id, productcode, category, categorycode, depot, depotid, depotcode, total_charge, balance_bf, balance, 0);
    item.balanceCF = calculateBalanceCF(item.balance_bf);
    cart.push(item);
    saveCart();
  };
// Remove all instances of an item from the cart by name
obj.removeItemFromCartAll = function(name) {
  cart = cart.filter(item => item.name !== name); // Remove all items with the specified name
  saveCart(); // Save updated cart to sessionStorage
};

  // Calculate balanceCF
  function calculateBalanceCF(balance_bf) {
    return parseFloat(balance_bf);
  }

  // Update item count
  obj.setCountForItem = function(name, newCount) {
    cart.forEach(item => {
      if (item.name === name) {
        item.count = parseFloat(newCount);
        const totalItemCost = item.price * item.count;
       // item.balanceCF = calculateBalanceCF(item.balance_bf, item.total_charge, totalItemCost);
        item.balanceCF = calculateBalanceCF(item.balance_bf);
      }
    });
    saveCart();
  };

  // Update total item cost and recalculate balanceCF
  obj.setTotalItemCost = function(name, newTotalCost) {
    cart.forEach(item => {
      if (item.name === name) {
        const newCount = parseFloat(newTotalCost) / item.price;
        item.count = newCount;
        item.balanceCF = calculateBalanceCF(item.balance_bf);
      }
    });
    saveCart();
  };

  // Clear the entire cart
  obj.clearCart = function() {
    cart = [];
    saveCart();
  };

  // List all items in the cart
  obj.listCart = function() {
    return cart.map(item => ({
      ...item,
      total: (item.price * item.count).toFixed(2),
      balanceCF: (isNaN(item.balanceCF) ? 0 : item.balanceCF).toFixed(2),
    }));
  };

  return obj;
})();

// *****************************************
// Triggers / Events
// *****************************************

// Utility function for debouncing
function debounce(func, delay) {
  let timer;
  return function(...args) {
    clearTimeout(timer);
    timer = setTimeout(() => func.apply(this, args), delay);
  };
}


// Clear cart button
 
$(document).on('click', '.clearReceiptItems', function() {
  shoppingCart.clearCart();
  displayCart(); 
});


// Handle changes in item count
$(document).on("input", ".show-cart .item-count", debounce(function() {
  const name = $(this).data('name');
  const count = parseFloat($(this).val());
  shoppingCart.setCountForItem(name, count);
  displayCart();
}, 2300));

// Handle changes in total item cost
$(document).on("input", ".show-cart .item-total-cost", debounce(function() {
  const name = $(this).data('name');
  const totalCost = parseFloat($(this).val());
  shoppingCart.setTotalItemCost(name, totalCost);
  displayCart();
}, 2300));

// Display the cart
 function displayCart() {
  const cartArray = shoppingCart.listCart();
  let output = "";

  // Initialize totals
  let totalBalanceBroughttForward = 0,
      totalInvoicePrices = 0,
      totalInvoiceUnits = 0,
      totalBilledAmounts = 0,
      totalPaymentAmounts = 0,
      closingBalanceTotal = 0;

  // Generate HTML output and calculate totals
  cartArray.forEach(item => {
    const itemTotal = parseFloat(item.total); // Total cost per item
    const itemCount = parseFloat(item.count); // Quantity of the item
    const balanceCF = parseFloat(item.balanceCF); // Closing balance per item

    // Accumulate totals
    totalBalanceBroughttForward += parseFloat(item.balance_bf);
    totalInvoicePrices += item.price;
    totalInvoiceUnits += itemCount;
    totalBilledAmounts += itemTotal; // Accumulates total billed amounts
    totalPaymentAmounts += parseFloat(item.total_charge); // Correctly accumulate payment amounts
    closingBalanceTotal += balanceCF;

    // Append item row to the cart output
    output += `
      <div class="w3-col l12 m12 s12" style="float:left;padding-left:0px;">
        <div class="w3-col l7 m7 s8" style="float:left;padding-left:5px;text-align:left;">
          <b>${item.name}</b>
        </div>
        <div class="w3-col l2 m2 s1 w3-hide-small">K${item.price.toFixed(2)}</div>

        <div class="w3-col l1 m1 s1 w3-hide-small">
          <input type="number" step="0.001" class="item-count" data-name="${item.name}" 
                 value="${item.count.toFixed(2)}" style="background-color:transparent;border:none;outline:none;max-width:60px;">
        </div>
        
        <div class="w3-col l2 m2 s2">
          <input type="number" step="0.01" class="item-total-cost" data-name="${item.name}" 
                 value="${itemTotal.toFixed(2)}" style="background-color:transparent;border:none;outline:none;">
        </div> 
      </div>`;
  });

  // Render the cart items in the `.show-cart` div
  $('.show-cart').html(output);

  // Update totals in the corresponding summary divs
  const updateDiv = (selector, value) => {
    $(selector).html(`K${value.toFixed(2)}`);
  };

  updateDiv('.totalBalanceBroughttForward', totalBalanceBroughttForward);
  updateDiv('.totalInvoicePrices', totalInvoicePrices);
  updateDiv('.totalInvoiceUnits', totalInvoiceUnits);
  updateDiv('.totalBilledAmounts', totalBilledAmounts);
  updateDiv('.totalPaymentAmounts', totalPaymentAmounts); // Ensure this is correctly reflected
  updateDiv('.closingBalanceTotal', closingBalanceTotal);
}
// Initially display the cart
displayCart();

	// MAKING PAYMET FOR DUE IVOICES
	// MAKING PAYMET FOR DUE IVOICES


  //$('#invoice_modal_div_2').append('<div class="inner-data-div w3-col l4 m6 s12" id="addProductToReceipt102" style="cursor:pointer;padding-left:7px;margin-top:3px;"><div class="w3-col l2 m2 s2"><img src="xd-assets/img/logo.png" style="height:45px;width:45px;margin-left:-7px;"/></div><div class="w3-col l9 m9 s9"><b style="color:black;float:left" class="w3-col l12 m12 s12">'+freelance.name+'</b> <span class="w3-col l12 m12 s12">K'+freelance.price+'</span></div><div class="w3-col l1 m1 s1"><input type="checkbox" id="addProductToInvoiceCheckbox102" data-id="'+freelance.id+'" data-name="'+freelance.name+'" data-balancebroughtforward="'+freelance.balancebroughtforward+'" data-price="'+freelance.price+'" data-chargerate="'+freelance.charge_rate+'" data-description="'+freelance.description+'" data-productcode="'+freelance.product_code+'" data-category="'+freelance.category+'" data-categorycode="'+freelance.category_code+'" data-depot="'+freelance.area+'" data-depotid="'+freelance.depot_id+'" data-depotcode="'+freelance.area_code+'" style="background-color:rgba(96, 146, 205,1);color:#fff;text-decoration:none;float:right;margin-right:10px;padding-right:7px;padding-left:7px;border-radius:4px;height:20px;cursor:pointer;margin-top:15px"/></div></div>');
 
  $(document).on('click', '#addProductToReceipt102', function (event) {
    // Locate the checkbox inside the clicked div
    const checkbox = $(this).find('input[type="checkbox"]');
    // Toggle the checkbox state
    checkbox.prop('checked', !checkbox.prop('checked'));

      // Toggle background color based on checkbox state
      if (checkbox.is(':checked')) {
        $(this).css('background-color', 'rgba(96, 146, 205,0.3)'); // Add green background when checked
    } else {
        $(this).css('background-color', ''); // Remove background color when unchecked
    }
    // Retrieve data attributes from the checkbox
    var name = checkbox.data('name');
    var category = checkbox.data('category');
    var price = parseFloat(checkbox.data('price')) || 0;  // Parse as a number
    // Continue with the rest of the data attributes
    
    var charge_rate = $(this).data('chargerate');
    var id = $(this).data('id');
    var categorycode = $(this).data('categorycode');
    var productcode = $(this).data('productcode');
    var depot = $(this).data('depot');
    var depotid = $(this).data('depotid');
    var depotcode = $(this).data('depotcode');
    var balancebroughtforward = parseFloat($(this).data('balancebroughtforward')) || 0;  // Parse as number
    var balanceCF = '00'; // Default balanceCF value
    // Verify checkbox state and add/remove item accordingly
    if (checkbox.is(':checked')) {
        // Add item to cart
        shoppingCart.addItemToCart(name,price,charge_rate,1,id,productcode,category,categorycode,depot,depotid,depotcode,price,balancebroughtforward,price,balanceCF);
        displayCart();
       // console.log(`Item added: ${name}`);
      
    } else {
        // Remove item from cart
        shoppingCart.removeItemFromCartAll(name);
        console.log(`Item removed: ${name}`);
    }

    // Refresh the invoice display
    displayCart();
});


  


  
  
    // end of MAKING PAYMET FOR DUE IVOICES
    // end of MAKING PAYMET FOR DUE IVOICES


  


// add product to receipt
        // add client to invoice
        
        $(document).on('click','#addProductToReceipt101',function (event) {
         addProductToReceipt();
  
          });



          function addProductToReceipt() {	
          
           var useridX = parseInt(document.getElementById('invoicedClientId0')?.textContent, 10) || 0;
          $('#invoice_modal_div_0').fadeOut('slow'); 
          $('.invoiceDivActions101').fadeOut('slow');
          $('#invoice_modal_div_1').empty().fadeIn('slow'); 
           
          $('#invoice_modal_div_1').append('<div class="w3-col l12 m12 s12 w3-card-2 w3-top" style="background-color:#fff;height:40px;line-height:40px;"><div class="close_receipt_modal_div_1 w3-col l1 m1 s1" style="padding-top: 5px;cursor:pointer;"><span class="fontx fx-arrow-left" style="color:rgba(96, 146, 205,1);font-size:1.5em;"></span></div><div class="w3-col l9 m9 s9" style="color:rgba(96, 146, 205,1);font-weight:600;"><div class="w3-col l12 m12 s12 w3-center" style="margin-top:0px;"><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-search" style="color:rgba(0,0,0,0.3);font-size:1.5em"></span></div><div class="w3-col l10 m10 s10 w3-center"><input class="searchProductsToAddToReceipt77" type="text" placeholder="Search & add items to cart..." style="font-weight:400;outline:none;color:gray;border:none;border-bottom:none;width:100%;height:30px;background-color:transparent;padding-left:7px;"/></div><div class="w3-col l1 m1 s1 w3-center" style="display:none;padding-top: 5px;"><span class="fontx fx-filter" style="color:rgba(0, 0, 0,0.3);font-size:1.3em"></span></div></div></div><div class="w3-col l2 m2 s2" style="padding-top: 0px;"><a href="#" id="cart-btn" style="text-decoration:none;outline:none;background-color:transparent;color:rgba(96, 146, 205,1);padding-top:0px;font-size:1.3em;margin-top:5px;float:right;"><span id="cart-count0" class="total-count w3-col l12 m12 s12" style="color:white;margin-left:22px;line-height:12px;height:14px;width:14px;background-color:orange;border-radius:50%;font-size:0.4em;padding-left:0px;padding-top:1px;">0</span><span class="fontx fx-shopping-cart w3-col l12 m12 s12" style="margin-top:-5px;margin-left:0px;"></span></a></div>');
          $('#invoice_modal_div_1').append('<div id="invoice_modal_div_2" class="w3-col l12 m12 s12" style="margin-top:50px;"></div>');
          $('#invoice_modal_div_2').empty().append('<center><div class="body-loader"></div><br/></center>');
          
         
          datastring='useridX='+useridX;			  
          
          $.ajax({         
            data:datastring,
            url: "xd-modules/revenue-accountant/backend/getProductsToAddToReceipt.php",
            type: "POST"
           }).done (function(data) {
            var details = JSON.parse(data);
            $('#invoice_modal_div_2').empty();
           $.each(details.details, function(i,freelance) {
            $('#invoice_modal_div_2').append('<div class="inner-data-div w3-col l4 m6 s12" id="addProductToReceipt102" data-id="'+freelance.id+'" data-name="'+freelance.name+'" data-balancebroughtforward="'+freelance.balancebroughtforward+'" data-price="'+freelance.price+'" data-chargerate="'+freelance.charge_rate+'" data-description="'+freelance.description+'" data-productcode="'+freelance.product_code+'" data-category="'+freelance.category+'" data-categorycode="'+freelance.category_code+'" data-depot="'+freelance.depot+'" data-depotid="'+freelance.depot_id+'" data-depotcode="'+freelance.depot_code+'" style="cursor:pointer;padding-left:7px;margin-top:3px;"><div class="w3-col l11 m11 s11"><b style="color:black;float:left" class="w3-col l12 m12 s12">'+freelance.name+'</b> <span class="w3-col l12 m12 s12">K'+freelance.price+'</span></div><div class="w3-col l1 m1 s1"><input type="checkbox" id="addProductToInvoiceCheckbox102" data-id="'+freelance.id+'" data-name="'+freelance.name+'" data-balancebroughtforward="'+freelance.balancebroughtforward+'" data-price="'+freelance.price+'" data-chargerate="'+freelance.charge_rate+'" data-description="'+freelance.description+'" data-productcode="'+freelance.product_code+'" data-category="'+freelance.category+'" data-categorycode="'+freelance.category_code+'" data-depot="'+freelance.area+'" data-depotid="'+freelance.depot_id+'" data-depotcode="'+freelance.area_code+'" style="display:none;background-color:rgba(96, 146, 205,1);color:#fff;text-decoration:none;float:right;margin-right:10px;padding-right:7px;padding-left:7px;border-radius:4px;height:20px;cursor:pointer;margin-top:15px"/></div></div>');
     
           
            });
      
           $('#invoice_modal_div_1').append('<div class="close_receipt_modal_div_1 w3-bottom w3-hide-large" style="position:fixed;height:40px;width:100%;color:#fff;background-color:rgba(96, 146, 205,1);line-height:40px;cursor: pointer;font-weight:600;">PROCEED <span class="fontx fx-arrow-right"></span></div></div>');
          
          });
      
        
        };
        

        // search products or chart of A/C
$(document).on('change keyup','.searchProductsToAddToReceipt77',function (event) {
	event.preventDefault(); 
  event.stopPropagation();  

  var userid = parseInt(document.getElementById('invoicedClientId0').textContent, 10);
  var searchKey = $(".searchProductsToAddToReceipt77").val(); 
  datastring='searchKey='+searchKey+'&userid='+userid;
 
  $('#invoice_modal_div_2').empty().append('<center><div class="body-loader"></div><br/></center>');
         
  $.ajax({
         
      data:datastring,
      url: "xd-modules/revenue-accountant/backend/searchProductsToAddToReceipt.php",
      type: "POST"
    
   }).done (function(data) {

   var details0 = JSON.parse(data);
   $('#invoice_modal_div_2').empty();
         
 $.each(details0.details, function(i,freelance) {
  // $('#invoice_modal_div_2').append('<div class="inner-data-div w3-col l4 m6 s12" id="addProductToReceipt102" data-id="'+freelance.id+'" data-name="'+freelance.name+'" data-balancebroughtforward="'+freelance.balancebroughtforward+'" data-price="'+freelance.price+'" data-chargerate="'+freelance.charge_rate+'" data-description="'+freelance.description+'" data-productcode="'+freelance.product_code+'" data-category="'+freelance.category+'" data-categorycode="'+freelance.category_code+'" data-depot="'+freelance.depot+'" data-depotid="'+freelance.depot_id+'" data-depotcode="'+freelance.depot_code+'" style="cursor:pointer;padding-left:7px;margin-top:3px;"><div class="w3-col l2 m2 s2"><img src="xd-assets/img/logo.png" style="height:45px;width:45px;margin-left:-7px;border-radius:50%;"/></div><div class="w3-col l9 m9 s9"><b style="color:black;float:left" class="w3-col l12 m12 s12">'+freelance.name+'</b> <span class="w3-col l12 m12 s12">K'+freelance.price+'</span></div><div class="w3-col l1 m1 s1"><input type="checkbox" id="addProductToInvoiceCheckbox102" data-id="'+freelance.id+'" data-name="'+freelance.name+'" data-balancebroughtforward="'+freelance.balancebroughtforward+'" data-price="'+freelance.price+'" data-chargerate="'+freelance.charge_rate+'" data-description="'+freelance.description+'" data-productcode="'+freelance.product_code+'" data-category="'+freelance.category+'" data-categorycode="'+freelance.category_code+'" data-depot="'+freelance.area+'" data-depotid="'+freelance.depot_id+'" data-depotcode="'+freelance.area_code+'" style="display:none;background-color:rgba(96, 146, 205,1);color:#fff;text-decoration:none;float:right;margin-right:10px;padding-right:7px;padding-left:7px;border-radius:4px;height:20px;cursor:pointer;margin-top:15px"/></div></div>');
  $('#invoice_modal_div_2').append('<div class="inner-data-div w3-col l4 m6 s12" id="addProductToReceipt102" data-id="'+freelance.id+'" data-name="'+freelance.name+'" data-balancebroughtforward="'+freelance.balancebroughtforward+'" data-price="'+freelance.price+'" data-chargerate="'+freelance.charge_rate+'" data-description="'+freelance.description+'" data-productcode="'+freelance.product_code+'" data-category="'+freelance.category+'" data-categorycode="'+freelance.category_code+'" data-depot="'+freelance.depot+'" data-depotid="'+freelance.depot_id+'" data-depotcode="'+freelance.depot_code+'" style="cursor:pointer;padding-left:7px;margin-top:3px;"><div class="w3-col l11 m11 s11"><b style="color:black;float:left" class="w3-col l12 m12 s12">'+freelance.name+'</b> <span class="w3-col l12 m12 s12">K'+freelance.price+'</span></div><div class="w3-col l1 m1 s1"><input type="checkbox" id="addProductToInvoiceCheckbox102" data-id="'+freelance.id+'" data-name="'+freelance.name+'" data-balancebroughtforward="'+freelance.balancebroughtforward+'" data-price="'+freelance.price+'" data-chargerate="'+freelance.charge_rate+'" data-description="'+freelance.description+'" data-productcode="'+freelance.product_code+'" data-category="'+freelance.category+'" data-categorycode="'+freelance.category_code+'" data-depot="'+freelance.area+'" data-depotid="'+freelance.depot_id+'" data-depotcode="'+freelance.area_code+'" style="display:none;background-color:rgba(96, 146, 205,1);color:#fff;text-decoration:none;float:right;margin-right:10px;padding-right:7px;padding-left:7px;border-radius:4px;height:20px;cursor:pointer;margin-top:15px"/></div></div>');
         
   });
  
 }); 	
 
 
 
  
		  
});
// end of search products or chart of A/C

        //// Event for adding items to the invoice

    // Listen for changes on checkboxes



// CLOSING DIV AND ADDING CHECKED ITEMS TO CART    
$(document).on('click', '.close_receipt_modal_div_1', function (event) {
  // Loop through all checked checkboxes inside #invoice_modal_div_2
  $('#invoice_modal_div_0').fadeIn('slow'); 
  $('.invoiceDivActions101').fadeIn('slow');
  $('#invoice_modal_div_1').fadeOut('slow'); 
 
});
// END OF CLOSING DIV AND ADDING CHECKED ITEMS TO CART 
// end of dding product to receipt


// MAKE PAYMENT
$(document).on('click','.transact0',function (event) {
transact101();
});


// RECEIPT PAYMENT
function transact101(){
  
    let today = new Date().toISOString().slice(0, 10).replace(/-/g, "/");
     shoppingCart.clearCart();
      $('#addInvoiceClientDiv').empty();
      $('#addInvoiceClientDiv').append('<span style="float:left;font-weight:600;color:rgba(96, 146, 205,1);">BILLED TO: </span>');
      
      $('#external_page_contents').empty().append('<div id="invoice_modal" class="w3-modal w3-center" style=" background-color:rgba(255,255,255,255);z-index:99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999"></div>');
      $('#invoice_modal').append('<div id="invoice_modal_div_0" style="background-color:white;height:100vh;"></div>');
     // modal acttion buttons
      $('#invoice_modal').append('<div class="w3-col l12 m12 s12 w3-top w3-card-2 invoiceDivActions101 hideOnPrint" style="padding:5px;color:gray;"><span class="close_invoice_modal" style="float:left;cursor:pointer;"><span class="fontx fx-x" style="font-size:1.5em;color:red;"></span></span> <div id="invoicePaymentDiv02"><span class="bankTransact0" style="float:right;cursor:pointer;margin-left:3px;"><span class="w3-card-2" style="font-size:0.9em;padding:5px;background-color:rgba(96, 146, 205,0.2);"> Make Bank Payment</span></span></div><div class="top-right-navigation-icons101 fileDiv101"><span class="fontx fx-file"></span><input name="depositslipfile" id="depositslipfile" type="file" /></div> <div class="top-right-navigation-icons101 penDiv101"><span class="fontx fx-edit-2 pen101" style="margin-top:-20px;margin-right:10px;"></span></div><span class="top-right-navigation-icons101"><span class="fontx fx-trash-2 clearReceiptItems" style="margin-right:7px;margin-top:-20px;"></span></span></div>');
       // modal acttion buttons

      $('#invoice_modal_div_0').append('<div class="w3-center w3-col l12 m12 s12"><img src="xd-assets/img/logo.png" class="w3-hide-small" style="height:100px;width:100px;margin-top:30px;border-radius:50%;cursor: pointer;text-align:center;"/><img src="xd-assets/img/logo.png" class="w3-hide-large w3-hide-medium" style="height:70px;width:70px;margin-top:30px;border-radius:50%;cursor: pointer;text-align:center;"/></div>');
      $('#invoice_modal_div_0').append('<div class="w3-center w3-col l12 m12 s12"><b>MONGU MUNICIPAL COUNCIL<b/></div>');
      $('#invoice_modal_div_0').append('<div class="w3-center w3-col l12 m12 s12 w3-hide-small"> P.O Box 910026</div>');
      $('#invoice_modal_div_0').append('<div class="w3-center w3-col l12 m12 s12 w3-hide-small"> Independence Avenue Mongu Zambia.</div>');
      $('#invoice_modal_div_0').append('<div class="w3-center w3-col l12 m12 s12" style="margin-top:0px;margin-bottom:0px;color:rgba(51, 153, 102,0.9);font-size:1.2em"><b>RECEIPT</b></div>');
       $('#invoice_modal_div_0').append('<div class="w3-center w3-col l12 m12 s12" style="margin-top:-20px;margin-bottom:0px;"><span id="receiptTitle00" style="margin-left:2px;font-weight:400;font-size:1em"><span id="hiddenInvoiceNumber" class="clearOnTransactionSuccess" style="display: none;"></span>  <div id="invoiceDueDateDiv" style="margin-left:5px;">No: </span><span id="invoiceNumber" style="color:red;font-weight: 400;font-size:1em">00</span> <input id="invoiceDueDate"  placeholder="'+today+'" value="'+today+'" style="margin-left:5px;margin-top:0px;border: none;cursor: pointer;font-size:0.9em;max-width:100px;color: black;font-weight: 400;"/> <span class="showOnPrint" style="display:none;">Printed: '+today+'</span></div></div>');
     $('#invoice_modal_div_0').append('<div class="w3-col l8 m8 s12 bankInvoiceDetailsDiv"><div class="w3-col l12 m12 s12 modeOfPaymentDiv0" style="margin-top:0px;"><select id="modeOfPayment" style="outline: none;margin-bottom:0px;color:black;margin-left:10px;float:left;margin-top:0px;border:none;font-weight:600;font-size:1em;background-color: transparent;-moz-appearance: none;-webkit-appearance: none;appearance: none;background-image: none;text-indent: 0.01px;text-transform:uppercase;"><option value="BANK">Bank Deposit</option><option value="CASH">Cash payment</option><option value="MOMO">Mobile Payment</option><option value="BANK TRANSFER">Bank Transfer</option></select></div><span class="w3-col l12 m12 s12 bankAccoutDiv101"><span style="float:left;color:gray;font-weight: 600;font-size:0.9em;margin-left: 7px;"><select id="bankname99" style="-moz-appearance: none;-webkit-appearance: none;appearance: none;background-image: none;text-indent: 0.01px;background-color: transparent;border: none;outline: none;color:black;text-transform:capitalize;margin-left:5px;"><option>Indo Transit Account</option></select></span></span><div class="w3-col l12 m12 s12 bankDepositSlipIdDiv101"><span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:0.9em">Ref/ID: </span><input id="bankDepositSlipId" class="clearOnTransactionSuccess" type="text" placeholder="Enter here" style="float:left;border:none;outline: none;font-size:0.9em;background-color:transparent;font-weight: 400;width:70%;"/></div><div class="w3-col l12 m12 s12 bankAccountNumberDiv101 w3-hide-small"><span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:1em">A/C: </span><span id="bankAccountNumber" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;"> 0262020000045</span></div><div class="w3-col l12 m12 s12 bankBranchDiv101 w3-hide-small"><span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:0.9em">Branch: </span><span id="bankBranch99" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;"> Mongu Branch</span></div><div class="w3-center w3-col l12 m12 s12 w3-hide-small"> <span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:0.9em">Phone: </span><span id="bankSortCode99" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;"> 0217221039</span></div><div class="w3-center w3-col l12 m12 s12 w3-hide-small"> <span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:0.9em">Email: </span><span id="bankSortCode99" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;">mongubilling@gmail.com</span></div></div>');
     
       $('#invoice_modal_div_0').append('<div class="w3-col l4 m4 s12 clientDetailsDiv101" style="padding-right: 0px;padding-left:8px;"><span class="w3-col l12 m12 s12" id="addInvoiceClientDiv" style="cursor: pointer;margin-top:0px;"> <button id="addClientToInvoice0" type="button" style="float:left;font-weight:600;color:black;height: 25px;background-color:transparent;border:none;outline:none;margin-left:-5px;">BILLED TO:</button></span><span class="w3-col l6 m6 s8 invoicedClientName0Div" style="margin-top:0px;font-weight: 600;"><span id="invoicedClientId0" class="clearOnTransactionSuccess" style="display: none;float:left;"></span><input id="invoicedClientName0" class="clearOnTransactionSuccess"  Placeholder="Client name:" type="text" style="float:left;border:none;background-color:transparent;outline:none;color:gray"/> </span><span class="w3-col l6 m6 s12" style="display:none;"><span id="invoicedClientName1" class="clearOnTransactionSuccess" style="float:left;margin-left: 3px;"></span></span><span class="w3-col l12 m12 s12 plotnumber07Div  w3-hide-small"  style="margin-top:0px;"><input id="plotnumber07" Placeholder="Plot No:" class="clearOnTransactionSuccess" type="text" style="display:none;float:left;border:none;background-color:transparent;outline:none;width:100px;"/><input id="invoicedClientAddress0" class="clearOnTransactionSuccess" Placeholder="Address:" type="address" style="float:left;border:none;background-color:transparent;outline:none;min-width:410px"/><input id="area07" Placeholder="Area" type="text" class="w3-hide-small"  style="display:none;float:left;border:none;background-color:transparent;outline:none;"/></span><div class="w3-col l12 m12 s12"  style="margin-top:0px;"><input id="tpin07" Placeholder="TPIN No:" class="w3-hide-small" type="text" style="float:left;border:none;background-color:transparent;outline:none;max-width: 150px;"/><input id="nrc07" Placeholder="Nrc No:" type="text" style="display:none;float:left;border:none;background-color:transparent;outline:none;max-width: 150px;"/> </span><span class="w3-col l12 m12 s4 invoicedClientEmail0Div"  style="margin-top:0px;"><input id="invoicedClientEmail0" class="w3-hide-small" Placeholder="Email:" type="email"  style="float:left;border:none;background-color:transparent;outline:none;min-width:250px;"/></span><span class="w3-col l12 m12 s4 invoicedClientPhone0Div"  style="margin-top:0px;"><input id="invoicedClientPhone0" placeholder="Phone Number:" type="number" style="float:left;border:none;background-color:transparent;outline:none;max-width: 130px;-webkit-appearance: none;appearance: none;background-image: none;text-indent: 0.01px;"/></span></div>');
     $('#invoice_modal_div_0').append('<div class="inner-data-div w3-col l12 m12 s12" style="margin-top:0px;background-color:rgba(51, 153, 102,0.3);font-weight:600;"><div class="w3-col l7 m7 s8"><span id="addProductToReceipt101" style="padding:7px;cursor:pointer;">Product/Account<span class="fontx fx-plus"></span></span></div><div class="w3-col l2 m2 s1 w3-hide-small">Price</div><div class="w3-col l1 m1 s1 w3-hide-small">Units</div><div class="w3-col l2 m2 s2">Amount</div></div>');
       $('#invoice_modal_div_0').append('<div class="show-cart inner-data-div w3-col l12 m12 s12" style="margin-top:0px;background-color:rgba(51, 153, 102,0.1);padding-left:7px;"></div>');
       $('#invoice_modal_div_0').append('<div class="inner-data-div w3-col l12 m12 s12" style="margin-top:0px;background-color:rgba(51, 153, 102,0.03);font-weight:600;border-bottom:1px solid gray"><div class="w3-col l7 m7 s7"><span style="padding:7px;cursor:pointer;"><b>Totals: </b></span></div><div class="w3-col l2 m2 s1 totalInvoicePrices w3-hide-small">00</div><div class="w3-col l1 m1 s1 totalInvoiceUnits w3-hide-small" style="display:none;">00</div><div class="w3-col l1 m1 s3  w3-hide-small" style="color:transparent;">00</div><div class="w3-col l2 m2 s3 totalBilledAmounts" style="color:red;">00</div></div>');
      
       $('#invoice_modal_div_0').append('<div class="w3-col l12 m12 s12 commentDiv101" style="display:none;"><textarea id="comment101" placeholder="Write your comment here..."></textarea></div>');
       $('#invoice_modal_div_0').append('<p class="w3-col l12 m12 s12"><span class="w3-col l6 m6 s12"style="float:left;margin-top: 0px;">Prepared by: <span class="preparedBy" style="color:gray"></span></span><span class="w3-col l6 m6 s12 w3-hide-small" style="float:left;margin-top: 0px;"> Signature: <span id="agentSignature" style="color:gray">______________________</span</span></p>');
      
       $('#invoice_modal').append('<div id="invoice_modal_div_1" style="display:none;background-color:white;height:100vh;marg-top:-100px;padding:5px;"></div>');
      $('#invoice_modal').fadeIn('slow');
      $('#invoice_modal').css('display', 'block'); // Ensure modal is displayed
      
      //fetch bank details
      $.getJSON('xd-modules/agent-module/backend/getBankAccounts.php',function(data){
      $('#bankname99').empty();
      $.each(data.details, function(i,cyberdesk) {
        $('#bankname99').append('<option value="'+cyberdesk.account_name+'" data-bankid="'+cyberdesk.bank_id+'" data-accountnumber="'+cyberdesk.account_number+'" data-sortcode="'+cyberdesk.sort_code+'" data-branch="'+cyberdesk.branch+'">'+cyberdesk.account_name+'</option>');
      });
       
      });       
    
     
}
// END OF RECEIPT PAYMENT

 //comment  section
 $(document).on('click','.pen101',function (event) {
  $('.penDiv101').empty('slow').append('<span class="fontx fx-edit-2 pen102" style="margin-top: -34px;color:green;"></span>');
  $('.commentDiv101').fadeIn('slow');
 });
 $(document).on('click','.pen102',function (event) {
  $('.penDiv101').empty('slow').append('<span class="fontx fx-edit-2 pen101" style="margin-top: -34px;"></span>');
  $('.commentDiv101').fadeOut('slow');
 });

$(document).on('click','.invoices0',function (event) {
  invoicing();
});

function invoicing() {
  $('#page-title3434').empty();
  $('#page-options').empty();
  $('#page-options').append('<span style="font-weight:400;font-size:1em;margin-top:-7px;"><select class="invoicesSelect0" style="text-transform:uppercase;border:none;background-color:transparent;color:gray;outline:none;"><option value="All">All invoices</option></select><span id="record01" class="w3-hide-small" style="font-size:0.8em;background-color:transparent;padding:3px;border-radius:8%;width:;color:gray;">0</span></span>');
  
  $.getJSON('xd-modules/agent-module/backend/currentRota.php',function(data){
    $('.invoicesSelect0').empty();
    $('.invoicesSelect0').append('<option value="All" class="invoicesSelect004">All Invoices</option>');
    $.each(data.freelancedetails, function(i,cyberdesk) {
      $('.invoicesSelect0').append('<option class="invoicesSelect004" value="'+cyberdesk.rota_code+'">'+cyberdesk.name+'</option>');
      });
  // this script trims long title texts
  $('.invoicesSelect004').each(function() {
    var title = $(this).text();
    if (title.length > 14) {
    title = title.substr(0, 14) + '...';    
    }
    $(this).text(title);
  });

  });

  $('#sub_top_nav').empty();
  $('#sub_top_nav').append('<div class="w3-col l12 m12 s12 w3-center" style="height:30px;background-color:#eee;margin-top:-1px;border-bottom:1px solid aliceblue;"><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-search" style="color:gray;font-size:1.5em"></span></div><div class="w3-col l10 m10 s10 w3-center"><input id="searchAgentInvoices" type="text" placeholder="Search invoices..." style="font-weight:400;outline:none;color:black;border:none;border-bottom:none;width:100%;height:30px;background-color:transparent;padding-left:7px;"/></div><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-filter" style="color:rgb(95, 44, 62);font-size:1.3em"></span></div></div>');
  $('#sub_top_nav').append('<ul id="tabs" class="tabs"><li class="invoices0" style="color:rgba(96, 146, 205,1);background-color:#fff;border:1px solid rgba(96, 146, 205,1);border-radius:10px;">Invoices</li><li class="trasactions0">Trasactions</li><li  class="collectionSummary101">Summary</li><li  class="deposits0">Deposit</li><li class="revenueTasks">Tasks</li></ul>');
  $('#right_nav_options0').empty();
  $('#main-body').empty(); 
  $('#main-body').append('<center><div class="body-loader"></div><br/></center>');

  $.getJSON('xd-modules/agent-module/backend/due_invoices.php',function(data){

    if(data.details=='No Data'){

   //alert('No Data');
   $('#main-body').empty();
   $('#main-body').append('<center style="margin-top:17%;"><p>You have no invoices. Click the transact button to start make a trasaction.</p></center>');
   transactions();
   
  }else{
      $('#main-body').empty();
      $('#record01').empty();
      $('#record01').append('<span>K'+data.total+' ('+data.numofrows+')</span>');
     //  $('#main-body').append('</br></br>');
      $.each(data.details,function(i,cyberdesk) {
        
	alert(cyberdesk.invoice_no);
     $('#main-body').append('<div class="inner-data-div w3-col l12 m12 s12" id="invoiceMakePayment0" data-userid="'+cyberdesk.client_id+'" data-names="'+cyberdesk.client_name+'" data-companyname="'+cyberdesk.company_name+'" data-phone="'+cyberdesk.phone_contact+'" data-email="'+cyberdesk.email_contact+'" data-address="'+cyberdesk.delivery_address+'" data-productid="'+cyberdesk.product_id+'" data-productname="'+cyberdesk.product_name+'" data-productcharge="'+cyberdesk.balance+'" data-pacra="'+cyberdesk.company_registration_number+'" data-tpin="'+cyberdesk.tpin+'" data-businesscategory="'+cyberdesk.business_category+'"  data-plotnumber="'+cyberdesk.plot_number+'" data-area="'+cyberdesk.area+'" data-nrc="'+cyberdesk.nrc+'" data-productcode="'+cyberdesk.product_code+'" data-category="'+cyberdesk.category+'" data-categorycode="'+cyberdesk.category_code+'" data-depot="'+cyberdesk.depot+'" data-depotid="'+cyberdesk.depot_id+'" data-depotcode="'+cyberdesk.depot_code+'" style="cursor:pointer;font-weight:600;float:left;transition: all 1s;margin-top:0px;text-align:left;font-size:1em;color:gray;background-color:trasparent;padding-left:10px;line-height:23px;"><div class="w3-col l4 m4 s12 w3-hide-small" style="font-size:0.8em"><span style="color:black;"><span style="text-transform:uppercase;font-weight:400;">'+cyberdesk.company_name+'</span> <span style="color:gray">('+cyberdesk.business_category+')</span></span><br/><span style="color:gray;">'+cyberdesk.client_name+' ('+cyberdesk.phone_contact+') <a href="#" id="sendSms0" data-id="'+cyberdesk.b_id+'" data-names="'+cyberdesk.client_name+'" data-phone="'+cyberdesk.phone_contact+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/sms.png"style="height:15px;width:15px;"/></a><a href="#" id="sendEmail0" data-email="'+cyberdesk.email_contact+'" data-names="'+cyberdesk.client_name+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/mail2.png" style="height:15px;width:15px;"/></a></span></div><div class="w3-col l4 m4 s12 w3-hide-large" style="font-size:0.8em"><span style="color:gray;"><span style="color:black;text-transform:uppercase">'+cyberdesk.company_name+'</span> ('+cyberdesk.client_name+') <a href="#" id="sendSms0" data-id="'+cyberdesk.b_id+'" data-names="'+cyberdesk.client_name+'" data-phone="'+cyberdesk.phone_contact+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/sms.png"style="height:15px;width:15px;"/></a><a href="#" id="sendEmail0" data-email="'+cyberdesk.email_contact+'" data-names="'+cyberdesk.client_name+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/mail2.png" style="height:15px;width:15px;"/></a></span></div><div class="w3-col l2 m2 s12 w3-hide-small" style="font-size:0.8em;color:#6092cd;font-weight:400;"><span class="w3-col l12 m12 s12"><span style="color:black;">TPIN: </span> '+cyberdesk.tpin+'</span><span class="w3-col l12 m12 s12"><span style="color:black;">REG NO:</span> '+cyberdesk.company_registration_number+'</span></div><div class="w3-col l3 m3 s12  w3-hide-small" style="font-size:0.8em;font-weight:400;"><div class="w3-col l12 m12 s12"><a href="#"><span class="fontx fx-map-pin" style="color:#6092cd;"></span> '+cyberdesk.delivery_address+'</a></div><div class="w3-col l12 m12 s12">'+cyberdesk.plot_number+' '+cyberdesk.area+'</div></div><div class="w3-col l3 m3 s12" style="font-size:0.8em"><span class="w3-col l12 m12 s12"><span style="color:gray;font-weight:400;"><b>'+cyberdesk.product_name+':</b></span> <span style="float:right;margin-right:10px;color:rgba(96, 146, 205,1);font-weight:600;">K'+cyberdesk.total_charge+'</span></span><span class="w3-col l12 m12 s12"><span style="color:rgba(96, 146, 205,1);font-weight:600;">Paid: K'+cyberdesk.paid+'</span> <span style="color:rgba(96, 146, 205,1);float:right;margin-right:10px;font-weight:600;"><span>Balance:</span> K'+cyberdesk.balance+'</span></span></div></div>');
    
    });
    }



});

 }

  //  SEARCH invoices
$(document).on('change keyup','#searchAgentInvoices',function (event) {
	event.preventDefault(); 
  event.stopPropagation();  
  if($("#searchAgentInvoices").val()=='') {	
	invoicing();
  } else{
   var searchCategory = $(".invoicesSelect0").val();
	 var searchKey = $("#searchAgentInvoices").val();
	  //var key45 = ($("#searchKey45").text());	 
	 datastring='searchKey='+searchKey+'&searchCategory='+searchCategory;
   $('#main-body').empty(); 
   $('#main-body').append('<center><div class="body-loader"></div><br/></center>');
 
			 
	 $.ajax({
				  
		   data:datastring,
	   url: "xd-modules/agent-module/backend/searchDueInvoices.php",
		   type: "POST"
	   
	  }).done (function(data) {

	   $('#main-body').empty();  
	  var details0 = JSON.parse(data); 
    $('#main-body').empty();
    //record01
    $('#record01').empty();
    $('#record01').append('<span>K'+details0.total+' ('+details0.numofrows+')</span>');
 
    if(details0.numofrows>0){
     // $('#main-body').append('</br></br>');
      $.each(details0.details,function(i,cyberdesk) {
    $('#main-body').append('<div class="inner-data-div w3-col l12 m12 s12" id="invoiceMakePayment0" data-userid="'+cyberdesk.client_id+'" data-names="'+cyberdesk.client_name+'" data-companyname="'+cyberdesk.company_name+'" data-phone="'+cyberdesk.phone_contact+'" data-email="'+cyberdesk.email_contact+'" data-address="'+cyberdesk.delivery_address+'" data-productid="'+cyberdesk.product_id+'" data-productname="'+cyberdesk.product_name+'" data-productcharge="'+cyberdesk.balance+'" data-pacra="'+cyberdesk.company_registration_number+'" data-tpin="'+cyberdesk.tpin+'" data-businesscategory="'+cyberdesk.business_category+'"  data-plotnumber="'+cyberdesk.plot_number+'" data-area="'+cyberdesk.area+'" data-nrc="'+cyberdesk.nrc+'" data-productcode="'+cyberdesk.product_code+'" data-category="'+cyberdesk.category+'" data-categorycode="'+cyberdesk.category_code+'" data-depot="'+cyberdesk.depot+'" data-depotid="'+cyberdesk.depot_id+'" data-depotcode="'+cyberdesk.depot_code+'" style="cursor:pointer;font-weight:600;float:left;transition: all 1s;margin-top:0px;text-align:left;font-size:1em;color:gray;background-color:trasparent;padding-left:10px;line-height:23px;"><div class="w3-col l4 m4 s12 w3-hide-small" style="font-size:0.8em"><span style="color:black;"><span style="text-transform:uppercase;font-weight:400;">'+cyberdesk.company_name+'</span> <span style="color:gray">('+cyberdesk.business_category+')</span></span><br/><span style="color:gray;">'+cyberdesk.client_name+' ('+cyberdesk.phone_contact+') <a href="#" id="sendSms0" data-id="'+cyberdesk.b_id+'" data-names="'+cyberdesk.client_name+'" data-phone="'+cyberdesk.phone_contact+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/sms.png"style="height:15px;width:15px;"/></a><a href="#" id="sendEmail0" data-email="'+cyberdesk.email_contact+'" data-names="'+cyberdesk.client_name+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/mail2.png" style="height:15px;width:15px;"/></a></span></div><div class="w3-col l4 m4 s12 w3-hide-large" style="font-size:0.8em"><span style="color:gray;"><span style="color:black;text-transform:uppercase">'+cyberdesk.company_name+'</span> ('+cyberdesk.client_name+') <a href="#" id="sendSms0" data-id="'+cyberdesk.b_id+'" data-names="'+cyberdesk.client_name+'" data-phone="'+cyberdesk.phone_contact+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/sms.png"style="height:15px;width:15px;"/></a><a href="#" id="sendEmail0" data-email="'+cyberdesk.email_contact+'" data-names="'+cyberdesk.client_name+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/mail2.png" style="height:15px;width:15px;"/></a></span></div><div class="w3-col l2 m2 s12 w3-hide-small" style="font-size:0.8em;color:#6092cd;font-weight:400;"><span class="w3-col l12 m12 s12"><span style="color:black;">TPIN: </span> '+cyberdesk.tpin+'</span><span class="w3-col l12 m12 s12"><span style="color:black;">REG NO:</span> '+cyberdesk.company_registration_number+'</span></div><div class="w3-col l3 m3 s12  w3-hide-small" style="font-size:0.8em;font-weight:400;"><div class="w3-col l12 m12 s12"><a href="#"><span class="fontx fx-map-pin" style="color:#6092cd;"></span> '+cyberdesk.delivery_address+'</a></div><div class="w3-col l12 m12 s12">'+cyberdesk.plot_number+' '+cyberdesk.area+'</div></div><div class="w3-col l3 m3 s12" style="font-size:0.8em"><span class="w3-col l12 m12 s12"><span style="color:gray;font-weight:400;"><b>'+cyberdesk.product_name+':</b></span> <span style="float:right;margin-right:10px;color:rgba(96, 146, 205,1);font-weight:600;">K'+cyberdesk.total_charge+'</span></span><span class="w3-col l12 m12 s12"><span style="color:rgba(96, 146, 205,1);font-weight:600;">Paid: K'+cyberdesk.paid+'</span> <span style="color:rgba(96, 146, 205,1);float:right;margin-right:10px;font-weight:600;"><span>Balance:</span> K'+cyberdesk.balance+'</span></span></div></div>');
    
    });
    }else{
      $('#main-body').append('<center><p style="margin-top:20%">There are no results for your search.</p></center>');
    }
 
	}); 	
	

  } 
    
});
// end of SEARCH invoices
// SELECT IVOICES CATEGORIES 
$(document).on('change keyup','.invoicesSelect0',function (event) {
  var searchCategory = $(".invoicesSelect0").val(); 
  //  alert(searchCategory);
  datastring='searchCategory='+searchCategory;
  $('#main-body').empty(); 
  $('#main-body').append('<center><div class="body-loader"></div><br/></center>');
  
  $.ajax({
      
  data:datastring,
  url: "xd-modules/agent-module/backend/searchDueInvoicesByCategory.php",
  type: "POST"
  
  }).done (function(data) {
  $('#main-body').empty();  
  var details0 = JSON.parse(data);
  //alert(details.numofrows);
  // alert(details0.details);
  //var details1 = JSON.stringify(details.freelancedetails);
  $('#main-body').empty();
  //record01
  $('#record01').empty();
  $('#record01').append('<span>K'+details0.total+' ('+details0.numofrows+')</span>');
  
  if(details0.numofrows>0){
  $('#main-body').append('</br></br>');
  $.each(details0.details,function(i,cyberdesk) {
    $('#main-body').append('<div class="inner-data-div w3-col l12 m12 s12" id="invoiceMakePayment0" data-userid="'+cyberdesk.client_id+'" data-names="'+cyberdesk.client_name+'" data-companyname="'+cyberdesk.company_name+'" data-phone="'+cyberdesk.phone_contact+'" data-email="'+cyberdesk.email_contact+'" data-address="'+cyberdesk.delivery_address+'" data-productid="'+cyberdesk.product_id+'" data-productname="'+cyberdesk.product_name+'" data-productcharge="'+cyberdesk.balance+'" data-pacra="'+cyberdesk.company_registration_number+'" data-tpin="'+cyberdesk.tpin+'" data-businesscategory="'+cyberdesk.business_category+'"  data-plotnumber="'+cyberdesk.plot_number+'" data-area="'+cyberdesk.area+'" data-nrc="'+cyberdesk.nrc+'" data-productcode="'+cyberdesk.product_code+'" data-category="'+cyberdesk.category+'" data-categorycode="'+cyberdesk.category_code+'" data-depot="'+cyberdesk.depot+'" data-depotid="'+cyberdesk.depot_id+'" data-depotcode="'+cyberdesk.depot_code+'" style="cursor:pointer;font-weight:600;float:left;transition: all 1s;margin-top:0px;text-align:left;font-size:1em;color:gray;background-color:trasparent;padding-left:10px;line-height:23px;"><div class="w3-col l4 m4 s12 w3-hide-small" style="font-size:0.8em"><span style="color:black;"><span style="text-transform:uppercase;font-weight:600;">'+cyberdesk.company_name+'</span> <span style="color:gray">('+cyberdesk.business_category+')</span></span><br/><span style="color:gray;">'+cyberdesk.client_name+' ('+cyberdesk.phone_contact+') <a href="#" id="sendSms0" data-id="'+cyberdesk.b_id+'" data-names="'+cyberdesk.client_name+'" data-phone="'+cyberdesk.phone_contact+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/sms.png"style="height:15px;width:15px;"/></a><a href="#" id="sendEmail0" data-email="'+cyberdesk.email_contact+'" data-names="'+cyberdesk.client_name+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/mail2.png" style="height:15px;width:15px;"/></a></span></div><div class="w3-col l4 m4 s12 w3-hide-large" style="font-size:0.8em"><span style="color:gray;"><span style="color:black;text-transform:uppercase">'+cyberdesk.company_name+'</span> ('+cyberdesk.client_name+') <a href="#" id="sendSms0" data-id="'+cyberdesk.b_id+'" data-names="'+cyberdesk.client_name+'" data-phone="'+cyberdesk.phone_contact+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/sms.png"style="height:15px;width:15px;"/></a><a href="#" id="sendEmail0" data-email="'+cyberdesk.email_contact+'" data-names="'+cyberdesk.client_name+'" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/mail2.png" style="height:15px;width:15px;"/></a></span></div><div class="w3-col l2 m2 s12 w3-hide-small" style="font-size:0.8em;color:#6092cd;font-weight:400;"><span class="w3-col l12 m12 s12"><span style="color:black;">TPIN: </span> '+cyberdesk.tpin+'</span><span class="w3-col l12 m12 s12"><span style="color:black;">REG NO:</span> '+cyberdesk.company_registration_number+'</span></div><div class="w3-col l3 m3 s12  w3-hide-small" style="font-size:0.8em;font-weight:400;"><div class="w3-col l12 m12 s12"><a href="#"><span class="fontx fx-map-pin" style="color:#6092cd;"></span> '+cyberdesk.delivery_address+'</a></div><div class="w3-col l12 m12 s12">'+cyberdesk.plot_number+' '+cyberdesk.area+'</div></div><div class="w3-col l3 m3 s12" style="font-size:0.8em"><span class="w3-col l12 m12 s12"><span style="color:gray;font-weight:400;"><b>'+cyberdesk.product_name+':</b></span> <span style="float:right;margin-right:10px;color:rgba(96, 146, 205,1);font-weight:600;">K'+cyberdesk.total_charge+'</span></span><span class="w3-col l12 m12 s12"><span style="color:rgba(96, 146, 205,1);font-weight:600;">Paid: K'+cyberdesk.paid+'</span> <span style="color:rgba(96, 146, 205,1);float:right;margin-right:10px;font-weight:600;"><span>Balance:</span> K'+cyberdesk.balance+'</span></span></div></div>');
    
  });
  }else{
  $('#main-body').append('<center><p style="margin-top:20%">There are no results for your search.</p></center>');
  }
  
  
  }); 
  
  });
  //ed of SELECT IVOICE CATEGORY
  $(document).on('click', '.invoiceTransactions0', function(event){
    event.preventDefault();
    event.stopPropagation();
    var productname = $(this).data('productname');
     var names = $(this).data('names');
    // var companyname = $(this).data('companyname');
    var userid = $(this).data('userid');
    $('#generalmodalLarge').fadeIn('slow');
    $('#generalmodalLargeMainDiv').hide();
    //$('#generalmodalLarge').append();
    $('#generalmodalLarge').append('<div id="tempDiv00"></div>');
    $('#tempDiv00').append('<div class="w3-top" style="height:50px;width:100%;color:#eee;background-color:rgba(96, 146, 205,1);"><div class="w3-col l1 m1 s1" style="margin-top:12px;"><span class="fontx fx-arrow-left closeLargeModal99" style="font-size:1.6em;cursor:pointer;float:left;padding-left:10px;"></span></div><div class="w3-col l10 m10 s10"><div id="userTitle93" class="w3-col l12 m12 s12" style="text-transform:uppercase;float:left;"></div><div id="productTitle93" class="w3-col l12 m12 s12"></div></div><div class="w3-col l1 m1 s1" style="margin-top:12px;"><span class="fontx fx-more-vertical" style="font-size:1.6em;cursor:pointer;float:right;"></span><span id="productuserid93" style="display:none"></span></div></div>');
    $('#tempDiv00').append('<div class="w3-top w3-center" style="height:30px;background-color:#eee;margin-top:50px;border-bottom:1px solid aliceblue;"><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-search" style="color:gray;font-size:1.5em"></span></div><div class="w3-col l10 m10 s10 w3-center"><input id="searchInvoiceTrasactions" type="text" placeholder="Search invoice transactions..." style="font-weight:400;outline:none;color:black;border:none;border-bottom:none;width:100%;height:30px;background-color:transparent;padding-left:7px;"/></div><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-filter" style="color:rgb(95, 44, 62);font-size:1.3em"></span></div></div>');
   $('#tempDiv00').append('<div id="tempTransactionsDiv" class="w3-col l12 m12 s12" style="background-color:#fff;height:100vh;margin-top:-50px;padding-top:80px"><center><div class="body-loader"></div><br/></center></div>')
  $('#userTitle93').empty();
   $('#userTitle93').append(names);
   $('#productTitle93').empty();
   $('#productTitle93').append(productname);
   $('#productuserid93').empty();
   $('#productuserid93').append(userid);
  
   if(productname=='' && userid=='') {	
    // do nothing
    } else{
     //var searchKey = $("#searchInvoices0").val();
      //var key45 = ($("#searchKey45").text());	 
     datastring='productname='+productname+'&userid='+userid;
         
     $.ajax({
            
         data:datastring,
       url: "xd-modules/agent-module/backend/invoiceTransactions.php",
         type: "POST"
      }).done (function(data) {
  
        $('#tempTransactionsDiv').empty();
      var details = JSON.parse(data);
      var details1 = JSON.stringify(details.freelancedetails);
      //alert(details.numofrows);
      var arr = JSON.parse(details1);
     for (i in arr) {
     var companyname= arr[i].cfname;
     var clientname= arr[i].clname;
     var payment_mode= arr[i].payment_mode;
     var transaction_date= arr[i].transaction_date;
     var transaction_time= arr[i].transaction_time;
     //var invoiceNumber= arr[i].invoiceNumber;
     var cphone= arr[i].cphone;
     var cemail= arr[i].cemail;
     var delivery_address= arr[i].delivery_address;
     var receipt_date= arr[i].receipt_date;
     var user_id = arr[i].user_id;
     var businessCategory = arr[i].business_category;
     var transaction_status = arr[i].transaction_status;
     var transaction_reference = arr[i].transaction_reference;
     var area = arr[i].area;
     var plot_no = arr[i].plot_no;
     var receipt_no = arr[i].receipt_no;
     var bank_name = arr[i].bank_name;
     var bank_account_name = arr[i].bank_account_name;
     var bank_deposit_slip = arr[i].bank_deposit_slip;
     var bank_deposit_id = arr[i].bank_deposit_id;
    
     //alert(payment_mode);
    var detailsxy = JSON.parse(arr[i].order_details);
     // alert(detailsxy);
    
    // $('#tempTransactionsDiv').append('<br/>');
      for (i in detailsxy) {
    //	alert(detailsxy[i].name);
    if(payment_mode=='BANK'){
    $('#tempTransactionsDiv').append('<div class="inner-data-div w3-col l12 m12 s12" style="font-weight:600;float:left;transition: all 1s;margin-left:10px;text-align:left;font-size:0.7em;color:gray;background-color:rgba(0,0,0,0.0);padding:0px;line-height:25px;border-bottom:2px solid #eee;"><div class="w3-col l3 m3 s12"><span class="w3-col l12 m12 s12" style="color:black;font-weight:600;"> <span style="text-transform:uppercase;">'+companyname+'</span> <span style="color:gray">('+businessCategory+')</span></span><span class="w3-col l12 m12 s12" style="color:gray">'+clientname+' ('+cphone+')</span></div><div class="w3-col l3 m3 s12" style=""><span class="w3-col l12 m12 s12" style="color:black;font-weight:600;"><span class="fontx fx-map-pin" style="color:#6092cd;"></span> '+delivery_address+'</span><span class="w3-col l12 m12 s12">'+plot_no+'</span></div><div class="w3-col l2 m2 s12"><span class="class="w3-col l12 m12 s12"><b style="color:black;">Ref:</b>'+transaction_reference+'</span><span class="w3-col l12 m12 s12"><b style="color:black">Date:</b> '+transaction_date+' ('+transaction_time+')</span></div><div class="w3-col l3 m3 s12"><b style="color:gray;">  <span class="w3-col l12 m12 s12"><span style="color:black;font-weight:600;">'+detailsxy[i].name+':</span> <span style="float:right;margin-right:10px;color:rgba(96, 146, 205,1);">K'+detailsxy[i].price+'</span></span><span class="w3-col l12 m12 s12"><span>Rpt no: <span style="color:red;">'+receipt_no+'</span></span> <span style="color:rgba(96, 146, 205,1);float:right;margin-right:10px;">K'+detailsxy[i].total+'<span style="color:gray;">('+payment_mode+')</span></span></span></div><div class="w3-col l1 m1 s12" style="padding-top:10px;"><span id="invoicePayment0" class="fontx fx-printer" data-invoicenumber="'+receipt_no+'" data-names="'+clientname+'" data-email="'+cemail+'" data-phone="'+cphone+'" data-address="'+delivery_address+'" data-userid="'+user_id+'" style="margin-right:12px;float:right;cursor:pointer;background-color:transparent;padding-left:3px;padding-right:3px;color:gray;margin-top:0px;border-radius:3px;font-size:1.5em"></span><span class="fontx fx-file-text bankdepositslip0" data-invoicenumber="'+receipt_no+'" data-names="'+clientname+'" data-bankname="'+bank_name+'" data-bankaccountname="'+bank_account_name+'" data-bankdepositslip="'+bank_deposit_slip+'" data-bankdepositid="'+bank_deposit_id+'" style="margin-right:7px;float:right;cursor:pointer;background-color:transparent;padding-left:3px;padding-right:3px;color:gray;margin-top:0px;border-radius:3px;font-size:1.5em"></span></div></div>');
    
    }else{
    $('#tempTransactionsDiv').append('<div class="inner-data-div w3-col l12 m12 s12" style="font-weight:600;float:left;transition: all 1s;margin-left:10px;text-align:left;font-size:0.7em;color:gray;background-color:rgba(0,0,0,0.0);padding:0px;line-height:25px;border-bottom:2px solid #eee;"><div class="w3-col l3 m3 s12"><span class="w3-col l12 m12 s12" style="color:black;font-weight:600;"> <span style="text-transform:uppercase;">'+companyname+'</span> <span style="color:gray">('+businessCategory+')</span></span><span class="w3-col l12 m12 s12" style="color:gray">'+clientname+' ('+cphone+')</span></div><div class="w3-col l3 m3 s12" style=""><span class="w3-col l12 m12 s12" style="color:black;font-weight:600;"><span class="fontx fx-map-pin" style="color:#6092cd;"></span> '+delivery_address+'</span><span class="w3-col l12 m12 s12">'+plot_no+'</span></div><div class="w3-col l2 m2 s12"><span class="class="w3-col l12 m12 s12"><b style="color:black;">Ref:</b>'+transaction_reference+'</span><span class="w3-col l12 m12 s12"><b style="color:black">Date:</b> '+transaction_date+' ('+transaction_time+')</span></div><div class="w3-col l3 m3 s12"><b style="color:gray;">  <span class="w3-col l12 m12 s12"><span style="color:black;font-weight:600;">'+detailsxy[i].name+':</span> <span style="float:right;margin-right:10px;color:rgba(96, 146, 205,1);">K'+detailsxy[i].price+'</span></span><span class="w3-col l12 m12 s12"><span>Rpt no: <span style="color:red;">'+receipt_no+'</span></span> <span style="color:rgba(96, 146, 205,1);float:right;margin-right:10px;">K'+detailsxy[i].total+'<span style="color:gray;">('+payment_mode+')</span></span></span></div><div class="w3-col l1 m1 s12" style="padding-top:10px;"><span id="invoicePayment0" class="fontx fx-printer" data-invoicenumber="'+receipt_no+'" data-names="'+clientname+'" data-email="'+cemail+'" data-phone="'+cphone+'" data-address="'+delivery_address+'" data-userid="'+user_id+'" style="margin-right:12px;float:right;cursor:pointer;background-color:transparent;padding-left:3px;padding-right:3px;color:gray;margin-top:0px;border-radius:3px;font-size:1.5em"></span></div></div>');
    
    }
    
      }
    }
      
     
    }); 	
    
    
  
    } 
    
  });
  // searchInvoiceTrasactions
  // search products or chart of A/C
  $(document).on('change keyup','#searchInvoiceTrasactions',function (event) {
    event.preventDefault(); 
    event.stopPropagation();  
    if($("#searchInvoiceTrasactions").val()=='') {	
    //addInvoicedItem();
    } else{
     //var searchCategory = $(".invoicesSelect0").val();
     var searchKey = $("#searchInvoiceTrasactions").val(); 
     var productuserid = $("#productuserid93").html();
     var productTitle = $("#productTitle93").html();
     datastring='searchKey='+searchKey+'&productuserid='+productuserid+'&productTitle='+productTitle;
     $('#tempTransactionsDiv').empty(); 
     $('#tempTransactionsDiv').append('<center><div class="body-loader"></div><br/></center>');
        
     $.ajax({
            
         data:datastring,
       url: "xd-modules/agent-module/backend/searchInvoiceTrasactions.php",
         type: "POST"
       
      }).done (function(data) {
    
       $('#tempTransactionsDiv').empty();
      var details = JSON.parse(data);
      var details1 = JSON.stringify(details.freelancedetails);
      //alert(details.numofrows);
      var arr = JSON.parse(details1);
     for (i in arr) {
     var companyname= arr[i].cfname;
     var clientname= arr[i].clname;
     var payment_mode= arr[i].payment_mode;
     var transaction_date= arr[i].transaction_date;
     var transaction_time= arr[i].transaction_time;
     var invoiceNumber= arr[i].invoiceNumber;
     var cphone= arr[i].cphone;
     var cemail= arr[i].cemail;
     var delivery_address= arr[i].delivery_address;
     var receipt_date= arr[i].receipt_date;
     var user_id = arr[i].user_id;
     var businessCategory = arr[i].business_category;
     var transaction_status = arr[i].transaction_status;
     var transaction_reference = arr[i].transaction_reference;
     var area = arr[i].area;
     var plot_no = arr[i].plot_no;
     var receipt_no = arr[i].receipt_no;
     var bank_name = arr[i].bank_name;
     var bank_account_name = arr[i].bank_account_name;
     var bank_deposit_slip = arr[i].bank_deposit_slip;
     var bank_deposit_id = arr[i].bank_deposit_id;
    
     //alert(payment_mode);
    var detailsxy = JSON.parse(arr[i].order_details);
     // alert(detailsxy);
    
    // $('#tempTransactionsDiv').append('<br/>');
      for (i in detailsxy) {
    //	alert(detailsxy[i].name);
    if(payment_mode=='BANK'){
    $('#tempTransactionsDiv').append('<div class="inner-data-div w3-col l12 m12 s12" style="font-weight:600;float:left;transition: all 1s;margin-left:10px;text-align:left;font-size:0.7em;color:gray;background-color:rgba(0,0,0,0.0);padding:0px;line-height:25px;border-bottom:2px solid #eee;"><div class="w3-col l3 m3 s12"><span class="w3-col l12 m12 s12" style="color:black;font-weight:600;"> <span style="text-transform:uppercase;">'+companyname+'</span> <span style="color:gray">('+businessCategory+')</span></span><span class="w3-col l12 m12 s12" style="color:gray">'+clientname+' ('+cphone+')</span></div><div class="w3-col l3 m3 s12" style=""><span class="w3-col l12 m12 s12" style="color:black;font-weight:600;"><span class="fontx fx-map-pin" style="color:#6092cd;"></span> '+delivery_address+'</span><span class="w3-col l12 m12 s12">'+plot_no+'</span></div><div class="w3-col l2 m2 s12"><span class="class="w3-col l12 m12 s12"><b style="color:black;">Ref:</b>'+transaction_reference+'</span><span class="w3-col l12 m12 s12"><b style="color:black">Date:</b> '+transaction_date+' ('+transaction_time+')</span></div><div class="w3-col l3 m3 s12"><b style="color:gray;">  <span class="w3-col l12 m12 s12"><span style="color:black;font-weight:600;">'+detailsxy[i].name+':</span> <span style="float:right;margin-right:10px;color:rgba(96, 146, 205,1);">K'+detailsxy[i].price+'</span></span><span class="w3-col l12 m12 s12"><span>Rpt no: <span style="color:red;">'+receipt_no+'</span></span> <span style="color:rgba(96, 146, 205,1);float:right;margin-right:10px;">K'+detailsxy[i].total+'<span style="color:gray;">('+payment_mode+')</span></span></span></div><div class="w3-col l1 m1 s12" style="padding-top:10px;"><span id="invoicePayment0" class="fontx fx-printer" data-invoicenumber="'+receipt_no+'" data-names="'+clientname+'" data-email="'+cemail+'" data-phone="'+cphone+'" data-address="'+delivery_address+'" data-userid="'+user_id+'" style="margin-right:12px;float:right;cursor:pointer;background-color:transparent;padding-left:3px;padding-right:3px;color:gray;margin-top:0px;border-radius:3px;font-size:1.5em"></span><span class="fontx fx-file-text bankdepositslip0" data-invoicenumber="'+receipt_no+'" data-names="'+clientname+'" data-bankname="'+bank_name+'" data-bankaccountname="'+bank_account_name+'" data-bankdepositslip="'+bank_deposit_slip+'" data-bankdepositid="'+bank_deposit_id+'" style="margin-right:7px;float:right;cursor:pointer;background-color:transparent;padding-left:3px;padding-right:3px;color:gray;margin-top:0px;border-radius:3px;font-size:1.5em"></span></div></div>');
    
    }else{
    $('#tempTransactionsDiv').append('<div class="inner-data-div w3-col l12 m12 s12" style="font-weight:600;float:left;transition: all 1s;margin-left:10px;text-align:left;font-size:0.7em;color:gray;background-color:rgba(0,0,0,0.0);padding:0px;line-height:25px;border-bottom:2px solid #eee;"><div class="w3-col l3 m3 s12"><span class="w3-col l12 m12 s12" style="color:black;font-weight:600;"> <span style="text-transform:uppercase;">'+companyname+'</span> <span style="color:gray">('+businessCategory+')</span></span><span class="w3-col l12 m12 s12" style="color:gray">'+clientname+' ('+cphone+')</span></div><div class="w3-col l3 m3 s12" style=""><span class="w3-col l12 m12 s12" style="color:black;font-weight:600;"><span class="fontx fx-map-pin" style="color:#6092cd;"></span> '+delivery_address+'</span><span class="w3-col l12 m12 s12">'+plot_no+'</span></div><div class="w3-col l2 m2 s12"><span class="class="w3-col l12 m12 s12"><b style="color:black;">Ref:</b>'+transaction_reference+'</span><span class="w3-col l12 m12 s12"><b style="color:black">Date:</b> '+transaction_date+' ('+transaction_time+')</span></div><div class="w3-col l3 m3 s12"><b style="color:gray;">  <span class="w3-col l12 m12 s12"><span style="color:black;font-weight:600;">'+detailsxy[i].name+':</span> <span style="float:right;margin-right:10px;color:rgba(96, 146, 205,1);">K'+detailsxy[i].price+'</span></span><span class="w3-col l12 m12 s12"><span>Rpt no: <span style="color:red;">'+receipt_no+'</span></span> <span style="color:rgba(96, 146, 205,1);float:right;margin-right:10px;">K'+detailsxy[i].total+'<span style="color:gray;">('+payment_mode+')</span></span></span></div><div class="w3-col l1 m1 s12" style="padding-top:10px;"><span id="invoicePayment0" class="fontx fx-printer" data-invoicenumber="'+receipt_no+'" data-names="'+clientname+'" data-email="'+cemail+'" data-phone="'+cphone+'" data-address="'+delivery_address+'" data-userid="'+user_id+'" style="margin-right:12px;float:right;cursor:pointer;background-color:transparent;padding-left:3px;padding-right:3px;color:gray;margin-top:0px;border-radius:3px;font-size:1.5em"></span></div></div>');
    
    }
    
      }
    }
     
    }); 	
    
    
  
    } 
    
        
  });
  // end of search products or chart of A/C
  
  // selectig mode of paymet
     $(document).on('change keyup','#modeOfPayment',function (event) {
	   var modeOfPayment = $("#modeOfPayment").val(); 
        
      if(modeOfPayment=="CASH"){
        $('#invoicePaymentDiv02').empty().append('<span class="cashTransact01" style="float:right;cursor:pointer;margin-left:3px;"><span class="w3-card-2" style="font-size:0.9em;padding:5px;background-color:rgba(96, 146, 205,0.2);"> Cash Payment</span></span>');
         
        $('.bankDepositSlipIdDiv101').fadeOut('slow');
        $('.bankAccountNumberDiv101').fadeOut('slow');
        $('.bankBranchDiv101').fadeOut('slow');
        $('#bankname99').fadeOut('slow'); 
        }else if(modeOfPayment=="BANK"){
               
          $('#invoicePaymentDiv02').empty().append('<span class="bankTransact0" style="float:right;cursor:pointer;margin-left:3px;"><span class="w3-card-2" style="font-size:0.9em;padding:5px;background-color:rgba(96, 146, 205,0.2);"> Make Bank Payment</span></span>');
          $('.bankDepositSlipIdDiv101').fadeIn('slow');
          $('.bankAccountNumberDiv101').fadeIn('slow');
          $('.bankBranchDiv101').fadeIn('slow');
          $('#bankname99').fadeIn('slow'); 
          $.getJSON('xd-modules/agent-module/backend/getBankAccounts.php',function(data){
            $('#bankName').empty();
            $.each(data.details, function(i,cyberdesk) {
              $('#bankname99').append('<option value="'+cyberdesk.account_name+'" data-bankid="'+cyberdesk.bank_id+'" data-accountnumber="'+cyberdesk.account_number+'" data-sortcode="'+cyberdesk.sort_code+'" data-branch="'+cyberdesk.branch+'">'+cyberdesk.account_name+'</option>');

          });
             
            });

            
            }else if(modeOfPayment=="MOMO"){
              $('#invoicePaymentDiv02').empty().append('<span class="momoTransact0" style="float:right;cursor:pointer;margin-left:3px;"><span class="w3-card-2" style="font-size:0.9em;padding:5px;background-color:rgba(96, 146, 205,0.2);"> Mobile Payment</span></span>');
              $('.bankDepositSlipIdDiv101').fadeOut('slow');
              $('.bankAccountNumberDiv101').fadeOut('slow');
              $('.bankBranchDiv101').fadeOut('slow');
              $('#bankname99').fadeOut('slow'); 
            }else if(modeOfPayment=="BANK TRANSFER"){
              $('#invoicePaymentDiv02').empty().append('<span class="bankTransact0" style="float:right;cursor:pointer;margin-left:3px;"><span class="w3-card-2" style="font-size:0.9em;padding:5px;background-color:rgba(96, 146, 205,0.2);"> Bank transfer</span></span>');
              $('.bankDepositSlipIdDiv101').fadeIn('slow');
              $('.bankAccountNumberDiv101').fadeOut('slow');
              $('.bankBranchDiv101').fadeOut('slow');
              $('#bankname99').fadeIn('slow'); 
            }
    });
  

// close large modal
$(document).on('click','.closeLargeModal99',function (event) {
  $('#tempDiv00').remove();
  $('#generalmodalLarge').fadeOut();
 $('#generalmodalLargeMainDiv').show();
});

//bankrefid
$(document).on('click', '.bankdepositslip0', function(event){
  event.preventDefault();
  event.stopPropagation();
  var bankname = $(this).data('bankname');
  var bankaccountname = $(this).data('bankaccountname');
  var bankdepositslip = $(this).data('bankdepositslip');
  var bankdepositid = $(this).data('bankdepositid');
  $('#generalmodalLarge').fadeIn('slow');
  $('#div_title342').empty();
	$('#div_title342').append('<h4 style="margin-top:-7px;font-weight:600;">DEPOSIT SLIP DETAILS</h4>');
	$('#div_body342').empty();
  $('#div_body342').append('<b>'+bankname+'</b>: <span>'+bankaccountname+'</span><br/>');
  $('#div_body342').append('<b>Referece Id</b>: <span>'+bankdepositid+'</span>');
  $('#div_body342').append('<img src="xd-uploads/documents/deposits-slips/'+bankdepositslip+'" style="margin-top:20px;height:500px;width:100%;"/>');
  //$('#div_body342').append('<p id="closeModal876" style="background-color:transparent;color:green;height:35px;line-height:30px;width:100px;border-radius:15px;border:2px solid green;font-weight:600;cursor:pointer;">Send</p>');

});


  // MOMO TRANSACTION

  $(document).on('click', '.momoTransact0', function(event){
    event.preventDefault();
    event.stopPropagation();
    var amount = $('.total-cart').html();
   // var userid = $("#invoicedClientId0").html();
   var userid = parseInt(document.getElementById('invoicedClientId0')?.textContent, 10) || 0;

    var fname = $("#invoicedClientName0").val();
    var lname =  $("#invoicedClientName1").html();
    var email = $("#invoicedClientEmail0").val();
    var productid = $("#productid").html();
    var deliveryaddress = $("#invoicedClientAddress0").val();
    var pacra = $("#pacra00").html(); 
    var tpin = $("#tpin00").html(); 
    var businessCategory = $("#businesscategory00").html();
    var plotnumber = $("#plotnumber07").val(); 
    var area = $("#area07").val(); 
    var nrc = $("#nrc07").val();
    var transtype = 'RECEIPT';
    var phone =  $("#invoicedClientPhone0").val();
    var invoiceNumber= $("#invoiceNumber").html();
    var invoiceDueDate= $("#invoiceDueDate").val();
    var deliverylat = $('#lat0').val();
    var deliverylng = $('#lng0').val();  
    var comment = $('#comment101').val(); 
// Get the cart list from invoicePaymentCart
var cartlist = invoicePaymentCart.listCart();

// Check if cartlist is empty or null
if (!cartlist || cartlist.length === 0) { 
    // If empty or null, fall back to shoppingCart
    cartlist = shoppingCart.listCart();
}
// Convert the cart list to a JSON string
var cartlistDetails = JSON.stringify(cartlist);

    

		if(phone != '' && cartlistDetails != '')
		{
      datastring='userid='+userid+'&phone='+phone+'&fname='+fname+'&lname='+lname+'&email='+email+'&orderDetails='+cartlistDetails+'&amount='+amount+'&deliverylat='+deliverylat+'&deliverylng='+deliverylng+'&deliveryaddress='+deliveryaddress+'&transtype='+transtype+'&invoiceNumber='+invoiceNumber+'&invoiceDueDate='+invoiceDueDate+'&productid='+productid+'&businessCategory='+businessCategory+'&pacra='+pacra+'&tpin='+tpin+'&plotnumber='+plotnumber+'&area='+area+'&nrc='+nrc+'&comment='+comment;
      $('#invoicePaymentDiv02').empty().append('<span class="transactProgress043" style="float:right;cursor:pointer;margin-left:3px;"><span class="w3-card-2" style="font-size:0.9em;padding:5px;background-color:rgba(96, 146, 205,0.2);"> <span id="transactioReferenceStorage01">Sending prompt:</span> <div id="container_count_down"><div id="countdown"><span id="timer"></span></div></div></span></span>');
   
	    $.ajax({
				 					
	        data:datastring,
			url: "xd-modules/payment-processing/momoPay.php",
	        type: "POST"	
				
	    }).done (function(data) {
			  
			 var newdata = JSON.parse(data);
 
    function cntDown() {
      let sec = 45;
      const el = document.getElementById("timer");
      const timer = setInterval(() => {
        el.innerHTML = sec--;
        if (sec < 15) el.style.color = "#ff0";
        if (sec < 7) el.style.color = "#f00";
        if (sec < 0){
          clearInterval(timer);
           $("#timer").empty().append('Try again!');
         
        }
      }, 1000);
    }
   
    cntDown();
    
			 $('#transactioReferenceStorage01').empty();
			 $('#transactioReferenceStorage01').append(newdata.transactionReference);
			 //var reference = ;
			 
			 
	 setInterval(function(){
                
                      var tref = $('#transactioReferenceStorage01').html();
		
                   if(tref != ''){
					 
						datastring='tref='+tref;

						$.ajax({

						data:datastring,
						url: "xd-modules/payment-processing/verifyPayment.php",
						type: "POST"	

						}).done (function(data) {

						 var newdata = JSON.parse(data);
						 
						  //alert(data);
              // alert(newdata.transaction_status);
						  
							$.each(newdata.details, function(i,cyberdesk) {
 
     if(cyberdesk.transaction_status == 'approved'){

      $('#invoicePaymentDiv02').empty().append('<span class="transactProgress043" style="float:right;cursor:pointer;margin-left:3px;"><span class="w3-card-2" style="font-size:0.9em;padding:5px;background-color:rgba(96, 146, 205,0.2);"> Success</span></span>');
      
        $(".invoiceDivActions101").hide();
      
      $("#topInvoiceNavContents").hide();
      $('#payment-btns-div01').hide();
      $('#invoiceNumber').empty();
      $('#invoiceNumber').append(response.receiptnumber);
      document.getElementById('invoiceDueDate').value = '';
      document.getElementById('invoiceDueDate').value = response.date;
     // document.getElementById('trasactionTime34').value = '';
     // document.getElementById('trasactionTime34').value = response.time;
       setTimeout(function(){ 
          window.print(); 
          setTimeout(function(){ 
            $(".invoiceDivActions101").show();
            $('#invoicePaymentDiv02').empty().append('<span class="momoTransact0" style="float:right;cursor:pointer;margin-left:3px;"><span class="w3-card-2" style="font-size:0.9em;padding:5px;background-color:rgba(96, 146, 205,0.2);"> Mobile Payment</span></span>');
           }, 700);
      }, 200);
 
 

	} else if(cyberdesk.transaction_status == 'failed'){
                    
    $('#invoicePaymentDiv02').empty().append('<span class="transactProgress043" style="float:right;cursor:pointer;margin-left:3px;"><span class="w3-card-2" style="font-size:0.9em;padding:5px;background-color:rgba(96, 146, 205,0.2);color:red;">Failed!</span></span>');
    
    }
 
							
	});
						  
						}); 
			 
					}else{
						
						
					}
				 

             }, 6000);
     //console.log(newdata.transactionReference);
		 
				  
		}); 	
		
		 
		}
		else
		{
		
		    location.reload();
         alert('Please fill in all data!');
		}
		
		
	});
  //MOMO TRASACTIO


  
// CASH TRASACTION PAYMENT
$(document).on('click', '.cashTransact01', function(event) {
  event.preventDefault();
  event.stopPropagation();
  $('.bankAccoutDiv101').hide(); 
  // Gather data for the transaction
  var amount = $('.total-cart').html();
 // var userid = $("#invoicedClientId0").html();
 var userid = parseInt(document.getElementById('invoicedClientId0')?.textContent, 10) || 0;

 // alert(userid);
  var fname = $("#invoicedClientName0").val();
  var lname = $("#invoicedClientName1").html();
  var email = $("#invoicedClientEmail0").val();
  var productid = $("#productid").html();
  var deliveryaddress = $("#invoicedClientAddress0").val();
  var pacra = $("#pacra00").html(); 
  var tpin = $("#tpin00").html(); 
  var businessCategory = $("#businesscategory00").html();
  var plotnumber = $("#plotnumber07").val(); 
  var area = $("#area07").val(); 
  var nrc = $("#nrc07").val();
  var transtype = 'RECEIPT';
  var phone = $("#invoicedClientPhone0").val();
  var invoiceNumber = $("#invoiceNumber").html();
  var hiddenInvoiceNumber = $("#hiddenInvoiceNumber").html();
  var invoiceDueDate = $("#invoiceDueDate").val();
  var deliverylat = $('#lat0').val();
  var deliverylng = $('#lng0').val(); 
  var comment = $('#comment101').val();
// Get the cart list from invoicePaymentCart
var cartlist = invoicePaymentCart.listCart();

// Check if cartlist is empty or null
if (!cartlist || cartlist.length === 0) { 
    // If empty or null, fall back to shoppingCart
    cartlist = shoppingCart.listCart();
}

// Convert the cart list to a JSON string
var cartlistDetails = JSON.stringify(cartlist);



  
  
  if (phone != '' && cartlistDetails != '') {

      var datastring = 'userid=' + userid + '&phone=' + phone + '&fname=' + fname + '&lname=' + lname +
                       '&email=' + email + '&orderDetails=' + cartlistDetails + '&amount=' + amount +
                       '&deliverylat=' + deliverylat + '&deliverylng=' + deliverylng + '&deliveryaddress=' +
                       deliveryaddress + '&transtype=' + transtype + '&invoiceNumber=' + invoiceNumber +'&hiddenInvoiceNumber='+hiddenInvoiceNumber+
                       '&invoiceDueDate=' + invoiceDueDate + '&productid=' + productid + '&businessCategory=' +
                       businessCategory + '&pacra=' + pacra + '&tpin=' + tpin + '&plotnumber=' + plotnumber +
                       '&area=' + area + '&nrc=' + nrc +'&comment='+comment;

    $('#invoicePaymentDiv02').empty().append('<span class="transactProgress043" style="float:right;cursor:pointer;margin-left:3px;"><span class="w3-card-2" style="font-size:0.9em;padding:5px;background-color:rgba(96, 146, 205,0.2);"> Processing...</span></span>');
   
      $.ajax({    
          data: datastring,
          url: "xd-modules/agent-module/backend/cashTransact.php",
          type: "POST"   
      }).done(function(data) {
          var response = JSON.parse(data);

          if (response.status == 'created') {
            
            $('#invoicePaymentDiv02').empty().append('<span class="transactProgress043" style="float:right;cursor:pointer;margin-left:3px;"><span class="w3-card-2" style="font-size:0.9em;padding:5px;background-color:rgba(96, 146, 205,0.2);"> Success</span></span>');
             $(".invoiceDivActions101").hide();
          
            $("#topInvoiceNavContents").hide();
            $('#payment-btns-div01').hide();
            $('#invoiceNumber').empty();
            $('#invoiceNumber').append(response.receiptnumber);
            document.getElementById('invoiceDueDate').value = '';
            document.getElementById('invoiceDueDate').value = response.date;
          //  document.getElementById('trasactionTime34').value = '';
           // document.getElementById('trasactionTime34').value = response.time;
             setTimeout(function(){ 
                window.print(); 
                setTimeout(function(){ 
                  $(".invoiceDivActions101").show();
                  $('#invoicePaymentDiv02').empty().append('<span class="cashTransact01" style="float:right;cursor:pointer;margin-left:3px;"><span class="w3-card-2" style="font-size:0.9em;padding:5px;background-color:rgba(96, 146, 205,0.2);"> Cash Payment</span></span>');
                 }, 700);
            }, 200);


          } else {
            $('#invoicePaymentDiv02').empty().append('<span class="transactProgress043" style="float:right;cursor:pointer;margin-left:3px;"><span class="w3-card-2" style="font-size:0.9em;padding:5px;background-color:rgba(96, 146, 205,0.2);color:red;">Failed!</span></span>');
    
          }
      });
  } else {
      alert('Please fill in all data!');
  }
});

// end CASH TRANSACTION PAYMENT

 
/// TRANSACTING BY BANK ACCOUNT
/// TRANSACTING BY BANK ACCOUNT
/// TRANSACTING BY BANK ACCOUNT
/// TRANSACTING BY BANK ACCOUNT
$(document).on('click', '.bankTransact0', function(event) {
  event.preventDefault();
  event.stopPropagation(); 
  var fileInput = $('#depositslipfile');
  var file = fileInput[0].files[0]; // File may be undefined if no file is selected
  // Retrieve other necessary data
  var amount = $('.total-cart').html();
 // var userid = parseInt(document.getElementById('invoicedClientId0').textContent, 10); // Fetch and convert to integer
  var userid = parseInt(document.getElementById('invoicedClientId0')?.textContent, 10) || 0;
  var fname = $("#invoicedClientName0").val();
  var lname = $("#invoicedClientName1").html();
  var email = $("#invoicedClientEmail0").val();
  var deliveryaddress = $("#invoicedClientAddress0").val();
  var productid = $("#productid").html();
  var pacra = $("#pacra00").html(); 
  var tpin = $("#tpin00").html(); 
  var businessCategory = $("#businesscategory00").html();
  var plotnumber = $("#plotnumber07").val(); 
  var area = $("#area07").val(); 
  var nrc = $("#nrc07").val();
  var transtype = 'RECEIPT';
  var phone = $("#invoicedClientPhone0").val();
  var invoiceDueDate = $("#invoiceDueDate").val();
  var deliverylat = $('#lat0').val();
  var deliverylng = $('#lng0').val();
  var bankDepositSlipId = $('#bankDepositSlipId').val();
  var bankAccountName = $('#bankname99').val();
  var bankId = document.querySelector("#bankname99 option:checked").dataset.bankid;
  var myBankAccountNumber44 = document.querySelector("#bankname99 option:checked").dataset.accountnumber;
  var bankName = $('#bankname99').val();
  var hiddenInvoiceNumber = $("#hiddenInvoiceNumber").html();
  var comment = $('#comment101').val();
  // Get the cart list from invoicePaymentCart
var cartlist = invoicePaymentCart.listCart();
// Check if cartlist is empty or null
if (!cartlist || cartlist.length === 0) { 
    // If empty or null, fall back to shoppingCart
    cartlist = shoppingCart.listCart();
}
// Convert the cart list to a JSON string
var cartlistDetails = JSON.stringify(cartlist);

  if (phone != '' && cartlistDetails != '' && bankDepositSlipId != '' && bankAccountName != '' && bankName != '' && myBankAccountNumber44 !='' && bankId !='') {
      // Create FormData object for file and other data
      var formData = new FormData();
      // Only append the file if it exists
      if (file) {
          formData.append('field-upload', file);
      }

      formData.append('userid', userid);
      formData.append('phone', phone);
      formData.append('fname', fname);
      formData.append('lname', lname);
      formData.append('email', email);
      formData.append('orderDetails', cartlistDetails);
      formData.append('amount', amount);
      formData.append('deliverylat', deliverylat);
      formData.append('deliverylng', deliverylng);
      formData.append('deliveryaddress', deliveryaddress);
      formData.append('transtype', transtype);
      formData.append('invoiceDueDate', invoiceDueDate);
      formData.append('bankDepositSlipId', bankDepositSlipId);
      formData.append('bankAccountName', bankAccountName);
      formData.append('bankName', bankName);
      formData.append('productid', productid);
      formData.append('businessCategory', businessCategory);
      formData.append('pacra', pacra);
      formData.append('tpin', tpin);
      formData.append('plotnumber', plotnumber);
      formData.append('area', area);
      formData.append('nrc', nrc);
      formData.append('hiddenInvoiceNumber', hiddenInvoiceNumber);
      formData.append('bankId', bankId); 
      formData.append('myBankAccountNumber44', myBankAccountNumber44);
      formData.append('comment', comment);
 
      $('#invoicePaymentDiv02').empty().append('<span class="transactProgress043" style="float:right;cursor:pointer;margin-left:3px;"><span class="w3-card-2" style="font-size:0.9em;padding:5px;background-color:rgba(96, 146, 205,0.2);"> Processing...</span></span>');
      // AJAX request with progress
      $.ajax({
          url: "xd-modules/agent-module/backend/bankTransact.php",
          type: "POST",
          data: formData,
          contentType: false,
          processData: false,
          xhr: function() {
              var xhr = new XMLHttpRequest();
              xhr.upload.addEventListener('progress', function(event) {
                  if (event.lengthComputable) {
                      var percentComplete = Math.round((event.loaded / event.total) * 100);
                      // Update the progress in the div
                      $('.transactProgress043').text('Uploading: ' + percentComplete + '%');
                  }
              }, false);
              return xhr;
          },
      }).done(function(data) {
          var response = JSON.parse(data);
          if (response.status == 'created') { 

            $('#invoicePaymentDiv02').empty().append('<span class="transactProgress043" style="float:right;cursor:pointer;margin-left:3px;"><span class="w3-card-2" style="font-size:0.9em;padding:5px;background-color:rgba(96, 146, 205,0.2);"> Success</span></span>');
           $(".invoiceDivActions101").hide();
            
              $("#topInvoiceNavContents").hide();
              $('#payment-btns-div01').hide();
              $('#invoiceNumber').empty();
              $('#invoiceNumber').append(response.receiptnumber);
              document.getElementById('invoiceDueDate').value = '';
              document.getElementById('invoiceDueDate').value = response.date;
             // document.getElementById('trasactionTime34').value = '';
             // document.getElementById('trasactionTime34').value = response.time;
             
               setTimeout(function(){ 
                  window.print(); 
                  setTimeout(function(){ 
                    $(".invoiceDivActions101").show();
                    $('#invoicePaymentDiv02').empty().append('<span class="bankTransact0" style="float:right;cursor:pointer;margin-left:3px;"><span class="w3-card-2" style="font-size:0.9em;padding:5px;background-color:rgba(96, 146, 205,0.2);"> Make Bank Payment</span></span>');
                   }, 700);
              }, 200);
 

          } else {

            $('#invoicePaymentDiv02').empty().append('<span class="transactProgress043" style="float:right;cursor:pointer;margin-left:3px;"><span class="w3-card-2" style="font-size:0.9em;padding:5px;background-color:rgba(96, 146, 205,0.2);color:red;">Failed!</span></span>');
    
          }
      });
  } else {
      alert('Please fill in all data...deposit slip id or reference!');
  }
});
//// END OF TRANSACTING BY BANK
/// TRANSACTING BY BANK ACCOUNT
/// TRANSACTING BY BANK ACCOUNT
/// TRANSACTING BY BANK ACCOUNT

//bankTransact02
$(document).on('submit', '#depositslipform', function(event){
  event.preventDefault();
  event.stopPropagation();
   var invoiceNumber01 = $('#invoiceNumber01').val();
   
  var extension = $('#imageInput').val().split('.').pop().toLowerCase();
   
  if(extension != ''){
      if(jQuery.inArray(extension, ['gif','png','jpg','jpeg']) == -1)
      {
          alert("Invalid Image File");
          $('#imageInput').val('');
          return false;
      }
  }	
    
  
  if(extension != '')
  {
   $('#payment-btns-div01').empty();
   $('#payment-btns-div01').append('<center><p>Uploading...</p></center>');
        
      $.ajax({
          url:"xd-modules/payment-processing/uploadDepositSlip.php",
          method:'POST',
          data:new FormData(this),
          contentType:false,
          processData:false,
          catche:false,
          success:function(data)
          {
          
          var postStatus = JSON.parse(data);
             
             
                if(postStatus.status=='uploaded'){
                
              $("#depositslipform").trigger('reset'); //jquery
              $("#topInvoiceNavContents").hide();
              $("#topResponse98").empty();
              $("#topResponse98").append('Payment succesful!');  
              $('#payment-btns-div01').empty();
              $('#payment-btns-div01').append('<a href="" id="closeDepositSlipProcess" class="w3-col l12 m12 s12" style="color:white;"><p style="background-color:white;width:100px;color:rgba(96, 146, 205,1);padding:7px;border-radius:4px;">CLose</p></a>');     
                  
            } else{
              $("#depositslipform").trigger('reset'); //jquery
              
              
             }
                     
              
              
                
          }
      });
  }
  else
  {
  
            // $('#upload_media_form0946').hide();
             $('#status44').empty();
             $('#status44').append('Please fill in all data!');
                
  }
});
/// opting out of uploadig deposit slip
$(document).on('click', '#bankTransact03', function(event){
 // alert('you can upload or capture deposit slip later ');
  shoppingCart.clearCart();
  displayCart();
  $('#plotnumber07').empty();
  $('#area07').empty();
  $('#nrc07').empty();
  $('#transact_modal').fadeOut('slow');
  setTimeout(function(){
   // location.reload();
	}, 500);
});
/// opting out of uploadig deposit slip

//closeDepositSlipProcess
$(document).on('click','#closeDepositSlipProcess',function (event){
  $("#paymentresponseDivTop").empty();
  $("#paymentresponseDivTop").hide();
  $("#paymentresponseDivBottom").empty();
  $("#paymentresponseDivBottom").hide();
  $("#topInvoiceNavContents").show();
  $('#plotnumber07').empty();
  $('#area07').empty();
  $('#nrc07').empty(); 
//  $("#payment-btns-div0").hide();
  $("#payment-btns01").show();
  document.getElementsByClassName('carddetailsinput').value ='';
  shoppingCart.clearCart();
  displayCart();
  //var randReceipt=(Math.floor(100000 + Math.random() * 900000));
 //$('#invoiceNumber').empty();
 //$('#invoiceNumber').append(randReceipt);
 let today = new Date().toLocaleDateString();
 document.getElementById('invoiceDueDate').value ='';
 document.getElementById('invoiceDueDate').value = today;

});

 

/// POST TRANSACTION FOR ANOTHER USER
/// POST TRANSACTION FOR ANOTHER USER
/// POST TRANSACTION FOR ANOTHER USER
/// POST TRANSACTION FOR ANOTHER USER
/// POST TRANSACTION FOR ANOTHER USER
$(document).on('click', '.transactionPost2000', function(event){
    event.preventDefault(); 
    event.stopPropagation();    
    $('#general-modal713').fadeIn('slow');
    $('#div_title341').empty();
    $('#div_title341').append('<p style="font-size:1.5em;margin-top:-20px;color:#7da6ff;">Post Transaction</p>');
    $('#div_body341').empty();
    $('#div_body341').append('<div><select type="text"  id="staffAgent12" name="staffAgent12" style="border:none;margin-top:10px;outline:none;background-color:transparent;max-width:300px" required><option value="">Select Staff/Revenue Collecttor</option></select></div>');
    $('#div_body341').append('<div><select type="text" id="addProduct34" name="addProduct34" style="border:none;margin-top:15px;outline:none;background-color:transparent;max-width:300px" required><option value="">Select Product/Chart of Account</option></select></div>');
   $('#div_body341').append('<div><select type="text" id="revenuePoint55" name="revenuePoint55" style="border:none;margin-top:15px;outline:none;background-color:transparent;max-width:300px" required><option value="">Select Revenue Point</option></select></div>');
   
    $('#div_body341').append('<div><select type="text"  name="bankName451" id="bankName451" style="border:none;margin-top:10px;outline:none;background-color:transparent;" required><option value="">Select Bank Account</option><select></div>');
  
    $('#div_body341').append('<div class="input-cont"><input type="number"  id="amount54" name="amount54" autocomplete="on" required><label for="amount54" class="label-name"><span class="content-name">Enter Amount</span></label></div>');
    $('#div_body341').append('<div class="input-cont"><input type="text" id="units310" name="units310"  autocomplete="on" required><label for="units310" class="label-name"><span class="content-name">Enter Units</span></label></div>');
 
    $('#div_body341').append('<div class="input-cont"><input type="text"  id="depositid54" name="depositid54" autocomplete="on" required><label for="depositid54" class="label-name"><span class="content-name">Enter deposit id</span></label></div>');
   $('#div_body341').append('<div class="input-cont"><p style="color:gray"> Date Deposited</p></div>');
    $('#div_body341').append('<div class="input-cont" style="margin-top:-30px;"><input type="date" id="depositSlipDate54" name="depositSlipDate54"  autocomplete="on" required><label for="depositSlipDate54" class="label-name"><span class="content-name"></span></label></div>');
    $('#div_body341').append('<div class="input-cont"><p style="color:gray"> Transaction Date</p></div>');
    $('#div_body341').append('<div class="input-cont" style="margin-top:-30px;"><input type="date" id="transactionDate54" name="depositSlipDate54"  autocomplete="on" required><label for="depositSlipDate54" class="label-name"><span class="content-name"></span></label></div>');
    $('#div_body341').append('<div class="input-cont" style="margin-top:10px;"><textarea id="postComment54" name="postComment54"  autocomplete="on" required>Enter comment/rceipt range</textarea>');
 
    $('#div_body341').append('<div id="submitDiv"><button id="postTransaction44000" style="background-color:rgba(96, 146, 205,1);cursor:pointer;color:white;height:40px;line-height:40px;width:100px;border-radius:8px;border:none;margin-top:25px;">Post</button></div>');
  
    $.getJSON('xd-modules/cashier-module/backend/getAgents.php',function(data){
    $.each(data.freelancedetails, function(i,freelance) {
      $('#staffAgent12').append('<option value="'+freelance.id+'" data-phone="'+freelance.phone+'" data-agentname="'+freelance.names+'">'+freelance.names+' ('+freelance.phone+')</option>');
  
    });
    });
    $.getJSON('xd-modules/accounts-module/backend/products-services.php',function(data){
    $.each(data.freelancedetails, function(i,freelance) {
    $('#addProduct34').append('<option value="'+freelance.id+'" data-productname="'+freelance.name+'" data-productcode="'+freelance.product_code+'" data-productcategory="'+freelance.category+'" data-productcategorycode="'+freelance.category_code+'" data-price="'+freelance.price+'">'+freelance.name+' (K'+freelance.price+')</option>');
    });
    });

    $.getJSON('xd-modules/admin-modules/backend/depots.php',function(data){
    $.each(data.details, function(i,cyberdesk) {
    $('#revenuePoint55').append('<option value="'+cyberdesk.depot_id+'" data-depotname="'+cyberdesk.depot_name+'">'+cyberdesk.depot_name+'</option>');
    });
    });

    $.getJSON('xd-modules/agent-module/backend/getBankAccounts.php',function(data){
    $.each(data.details, function(i,cyberdesk) {
      $('#bankName451').append('<option value="'+cyberdesk.account_name+'" data-bankid="'+cyberdesk.bank_id+'" data-accountnumber="'+cyberdesk.account_number+'" data-sortcode="'+cyberdesk.sort_code+'" data-branch="'+cyberdesk.branch+'">'+cyberdesk.account_name+'</option>');
  });
      
    });
    
    });
 
    $(document).on('click','#postTransaction44000',function (event) {
      event.preventDefault(); 
      event.stopPropagation();      
      var agentId = document.getElementById("staffAgent12").value;
      var agentName = document.querySelector("#staffAgent12 option:checked").dataset.agentname; 
      var agentPhone = document.querySelector("#staffAgent12 option:checked").dataset.phone; 

      var productId = document.getElementById("addProduct34").value;
      var productName = document.querySelector("#addProduct34 option:checked").dataset.productname; 
      var totalAmount = document.getElementById("amount54").value; 
      var units310 = document.getElementById("units310").value; 
      var productcode = document.querySelector("#addProduct34 option:checked").dataset.productcode;
      var productcategory = document.querySelector("#addProduct34 option:checked").dataset.productcategory;
      var productcategorycode = document.querySelector("#addProduct34 option:checked").dataset.productcategorycode;

      var revenuePointId = document.getElementById("revenuePoint55").value;
      var depotname = document.querySelector("#revenuePoint55 option:checked").dataset.depotname; 
     
      var bankName = document.getElementById("bankName451").value;
      var bankId = document.querySelector("#bankName451 option:checked").dataset.bankid;
      var accountnumber = document.querySelector("#bankName451 option:checked").dataset.accountnumber;

      var depositId = document.getElementById("depositid54").value;
      var depositSlipDate = document.getElementById("depositSlipDate54").value;
      var transactionDate = document.getElementById("transactionDate54").value;
      var postComment54  = document.getElementById("postComment54").value;
       if(agentId != '' && agentName != '' && productId != '' && productName != '' && productcode != '' && bankName != '' && accountnumber != '' && bankId !=''){

         $('#submitDiv').empty();$('#submitDiv').append('<button id="" style="background-color:gray;cursor:pointer;color:white;height:40px;line-height:40px;width:100px;border-radius:8px;border:none;margin-top:25px;">Posting...</button>');

       datastring='agentId='+agentId+'&agentName='+agentName+'&agentPhone='+agentPhone+'&productId='+productId+'&productName='+productName+'&totalAmount='+totalAmount+'&units310='+units310+'&productcode='+productcode+'&productcategory='+productcategory+'&productcategorycode='+productcategorycode+'&revenuePointId='+revenuePointId+'&depotname='+depotname+'&bankName='+bankName+'&accountnumber='+accountnumber+'&depositSlipDate='+depositSlipDate+'&depositId='+depositId+'&bankId='+bankId+'&transactionDate='+transactionDate+'&postComment='+postComment54;
               
       $.ajax({
        data: datastring,
        url: "xd-modules/cashier-module/backend/postTransaction.php",
        type: "POST"
      }).done(function(data) {
        console.log("Raw response from server:", data); // Log raw response for debugging
        
        try {
          var response = JSON.parse(data); // Parse the JSON response
          
          console.log("Parsed JSON response:", response); // Log parsed response
      
          if (response.status == 'success') {
            
           // $('#div_body341').empty().append(
              '<p>Transaction post was successful with receipt number <b style="color:red;">' + 
             // response.receiptnumber + 
           //   '</b>. To verify the post go to collection summary and select <b>'+agentName+'</b> collection details.</span></p>'
           // );
      
          
           $('#submitDiv').empty();$('#submitDiv').append('<button id="postTransactionSuccess" style="background-color:green;cursor:pointer;color:white;height:40px;line-height:40px;width:200px;border-radius:8px;border:none;margin-top:25px;">Post Successfull</button>');
            
            reportByBankAccounts101();
            setTimeout(function() {
              // $('#general-modal713').fadeOut('slow');
              $('#submitDiv').empty();$('#submitDiv').append('<button id="postTransaction44000" style="background-color:rgba(96, 146, 205,1);cursor:pointer;color:white;height:40px;line-height:40px;width:100px;border-radius:8px;border:none;margin-top:25px;">Post</button>');
              revenuReportByRevenueCollector();
             }, 2000);

          
          } else {
            $('#submitDiv').empty().append('<p style="color:red;">Something went wrong. Please reload and try again.</p>');
          }
        } catch (e) {
          console.error("Failed to parse JSON response:", e);
          $('#submitDiv').empty().append('<p style="color:red;">Invalid response received from the server.</p>');
        }
      });
      
    
       }else{
       
       alert('Something wet wrong try again!');
       
       }
       
      
    });

/// END POST TRANSACTTION FOR ANOTHER USER
/// END POST TRANSACTTION FOR ANOTHER USER
/// END POST TRANSACTTION FOR ANOTHER USER
/// END POST TRANSACTTION FOR ANOTHER USER
/// END POST TRANSACTTION FOR ANOTHER USER
 