<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../../xd-assets/backend/config/dbconfig.php';

$userid = filter_input(INPUT_POST, "userid"); 
$invoicenumber = filter_input(INPUT_POST, "invoicenumber"); 

$getproductsquery = "
   SELECT 
       b_id,
       product_name,
       product_id,
       product_code,
       units,
       unit_price,
       total_charge,
       product_category,
       product_category_code,
       billing_interval,
       balance,
       balance_cf,
       payment_advance,
       invoice_no,
       due_date,
       due_time,
       delivery_address,
       plot_number,
       area,
       user_id,
       DATE(timestamp) AS invoicedate,
       depot,
       depot_id,
       depot_code,
       COALESCE(
           (SELECT SUM(balance)
            FROM billing_subscription AS b2
            WHERE b2.client_id = :userid 
            AND b2.product_id = bs.product_id
            AND b2.document_type = 'INVOICE' 
            AND b2.invoice_no <= :invoicenumber
           ), 
       0) AS balance_bf
   FROM billing_subscription AS bs
   WHERE document_type = 'INVOICE'
   AND invoice_no = :invoicenumber
   AND client_id = :userid";

$getproducts = $conn->prepare($getproductsquery);

$getproducts->bindParam(':userid', $userid, PDO::PARAM_INT);
$getproducts->bindParam(':invoicenumber', $invoicenumber, PDO::PARAM_INT);

$getproducts->execute();

$getproducts->setFetchMode(PDO::FETCH_ASSOC); 

if ($getproducts->rowCount() == 0) {
    $totalrecords = $getproducts->rowCount();
    $json_data = array(
        'numofrows' => $totalrecords 
    );
    echo json_encode($json_data);
    exit;
} else if ($getproducts->rowCount() > 0) {
    $totalrecords = $getproducts->rowCount();
    $nestedData = array();
    while($row = $getproducts->fetch()) {
        $nestedData[] = $row;
    }
    $json_data = array(
        "details" => $nestedData,
        'numofrows' => $totalrecords
    );
    echo json_encode($json_data);
    exit;
}
?>
