<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
  //  $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
   // $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Get input parameters
    $agent_id = filter_input(INPUT_POST, "agentKey");
    $startDateInput = filter_input(INPUT_POST, "startDate");
    $endDateInput = filter_input(INPUT_POST, "endDate");
    $searchKey = filter_input(INPUT_POST, "searchKey");

    // Validate input parameters
    if (empty($startDateInput) && empty($endDateInput) && empty($searchKey)) {
        echo json_encode(["error" => "At least one input parameter is required"]);
        exit;
    }

    // Create variables to store the conditions for the SQL query
    $conditions = [];
    $parameters = [];

    // Check if each input parameter is not empty and add it to the conditions array
    if (!empty($startDateInput)) {
        $conditions[] = "transaction_date >= :start_date";
        $parameters[':start_date'] = date('Y-m-d', strtotime($startDateInput));
    }
    if (!empty($endDateInput)) {
        $conditions[] = "transaction_date <= :end_date";
        $parameters[':end_date'] = date('Y-m-d', strtotime($endDateInput));
    }
    if (!empty($searchKey)) {
        $conditions[] = "(product_name LIKE :search_key OR product_id LIKE :search_key)";
        $parameters[':search_key'] = '%' . $searchKey . '%';
    }

    // Prepare the SQL query with the conditions
    $getproductsquery = "
        SELECT 
            COUNT(id) AS transactions,
            SUM(transaction_amount) AS totalSales,
            product_name, product_id, product_code, agent_name, agent_id, cash_in_status,
            SUM(CASE WHEN payment_mode = 'CASH' THEN transaction_amount ELSE 0 END) AS totalCash,
            SUM(CASE WHEN payment_mode = 'MOMO' THEN transaction_amount ELSE 0 END) AS totalMomo,
            SUM(CASE WHEN payment_mode = 'BANK' THEN transaction_amount ELSE 0 END) AS totalBank
        FROM transaction_details 
        WHERE 
            trans_type='RECEIPT' 
            AND (transaction_status='active' OR transaction_status='approved' OR transaction_status='Cashed In')
            AND agent_id = :agent_id";

    $parameters[':agent_id'] = $agent_id;

    if (!empty($conditions)) {
        $getproductsquery .= " AND " . implode(" AND ", $conditions);
    }

    $getproductsquery .= " GROUP BY product_id ORDER BY transaction_date DESC";

    $getproducts = $conn->prepare($getproductsquery);
    $getproducts->execute($parameters);
    $getproducts->setFetchMode(PDO::FETCH_ASSOC);

    $agentData = [];

    if ($getproducts->rowCount() > 0) {
        while ($row = $getproducts->fetch()) {
            $productId = $row['product_id'];
            $cashInStatus = $row['cash_in_status'];

            if (!isset($agentData[$productId])) {
                $agentData[$productId] = [
                    'product_id' => $productId,
                    'product_name' => $row['product_name'],
                    'product_code' => $row['product_code'],
                    'agent_name' => $row['agent_name'],
                    'agent_id' => $row['agent_id'],
                    'totalCashed' => 0,
                    'totalNotCashed' => 0,
                    'totalCash' => 0,
                    'totalMomo' => 0,
                    'totalBank' => 0,
                    'transactions' => 0,
                    'totalSales' => 0, 
                ];
            }

            if ($cashInStatus == 'approved') {
                $agentData[$productId]['totalCashed'] += $row['totalCash'];
            } elseif ($cashInStatus == 'Pending') {
                $agentData[$productId]['totalNotCashed'] += $row['totalCash'];
            }

            $agentData[$productId]['transactions'] += $row['transactions'];
            $agentData[$productId]['totalSales'] += $row['totalSales'];
            $agentData[$productId]['totalCash'] += $row['totalCash'];
            $agentData[$productId]['totalMomo'] += $row['totalMomo'];
            $agentData[$productId]['totalBank'] += $row['totalBank'];
        }
    }

    $totalAmountsCollected = array_sum(array_column($agentData, 'totalCash')) + array_sum(array_column($agentData, 'totalMomo')) + array_sum(array_column($agentData, 'totalBank'));
    $totalCashed = array_sum(array_column($agentData, 'totalCashed'));
    $totalNotCashed = array_sum(array_column($agentData, 'totalNotCashed'));

    $jsonData = [
        'details' => array_values($agentData),
        'numofrows' => count($agentData),
        'totalAmountsCollected' => $totalAmountsCollected,
        'totalCashed' => $totalCashed,
        'totalNotCashed' => $totalNotCashed
    ];

    echo json_encode($jsonData);
} catch (PDOException $e) {
    echo json_encode(['error' => $e->getMessage()]);
    exit;
}
?>
