<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    $userloggedid = $_SESSION["userid"];

    // Retrieve and validate input
    $startDateInput = filter_input(INPUT_POST, "startDate");
    $endDateInput = filter_input(INPUT_POST, "endDate"); 
    $searchKey = filter_input(INPUT_POST, "searchKey");
   
    if (empty($startDateInput)) {
        // Fallback to a default start date if not provided
        $startDateInput = '1970-01-01';
        error_log("startDateInput is empty, using fallback value: " . $startDateInput);
    }

    $startDate = date_create_from_format('Y-m-d', $startDateInput);
    $endDate = $endDateInput ? date_create_from_format('Y-m-d', $endDateInput) : new DateTime();

    if ($startDate === false) {
        throw new Exception("Invalid start date format: $startDateInput");
    }

    if ($endDate < $startDate) {
        throw new Exception("End date cannot be before start date");
    }

    $startDateFormatted = $startDate->format('Y-m-d');
    $endDateFormatted = $endDate->format('Y-m-d');

    // Prepare SQL query
    $conditions = [];
    $parameters = [];

    if (!empty($searchKey)) {
        $conditions[] = "(bank_deposit_id = :searchKey OR agent_name = :searchKey)";
        $parameters[':searchKey'] = $searchKey;
    }
    if (!empty($startDateFormatted)) {
        $conditions[] = "transaction_date >= :start_date";
        $parameters[':start_date'] = $startDateFormatted;
    }
    if (!empty($endDateFormatted)) {
        $conditions[] = "transaction_date <= :end_date";
        $parameters[':end_date'] = $endDateFormatted;
    }

    $conditions[] = "(payment_mode='CASH' OR payment_mode='BANK')";
    $conditions[] = "deposit_status='Pending Approval'";
    //$conditions[] = "transaction_status='approved'"; 
    $getDriversQuery = "
        SELECT COUNT(id) AS totaltraansactions,SUM(transaction_amount) AS totaldeposit,id,cfname,clname,cemail,cphone,product_name,product_id,transaction_amount,
        quantity,transaction_reference,transaction_status,user_id,agent_name,agent_id,trans_type,delivery_address,area,plot_no,nrc,lat,lng,
        transaction_date,transaction_time,receipt_no,invoiceNumber,receipt_date,payment_mode,
        bank_id,bank_name,bank_account_name,bank_account_number,bank_deposit_slip,bank_deposit_id,deposit_slip_date,deposit_status,business_category,pacra,tpin
        FROM transaction_details
        WHERE " . implode(" AND ", $conditions) . "
        GROUP BY bank_deposit_id ORDER BY deposit_slip_date DESC";

    $getDrivers = $conn->prepare($getDriversQuery);

    foreach ($parameters as $key => $value) {
        $getDrivers->bindValue($key, $value);
    }

    $getDrivers->execute();

    // Process results
    $totaldeposit = 0;
    $details = [];
    $totalAmountsCollected = 0; 

    while ($rowDs = $getDrivers->fetch(PDO::FETCH_ASSOC)) {
        $details[] = $rowDs;
        $totaldeposit += $rowDs['totaldeposit'];
    }

    // Prepare JSON response
    $json_data = [
        "details" => $details,
        'numofrows' => count($details),
        'total' => $totaldeposit, 
    ];

    echo json_encode($json_data);
    exit;
} catch (PDOException $e) {
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
