<?php
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

    session_start();
    require_once '../../../xd-assets/backend/config/dbconfig.php';

    // Fetch input data securely
    $agentname = filter_input(INPUT_POST, "agentname", FILTER_DEFAULT);
    $agentid = filter_input(INPUT_POST, "agentid", FILTER_DEFAULT);

    // First query to get deposit details
    $getDepositQuery = "
        SELECT bank_deposit_slip, bank_deposit_id, bank_account_name, bank_account_number
        FROM transaction_details 
        WHERE 
        (transaction_status = 'approved' OR transaction_status = 'active')
        AND deposit_status='Pending'
        AND agent_name = :agentname AND agent_id = :agentid
        AND payment_mode = 'CASH'
        GROUP BY bank_deposit_id";

    $getDeposit = $conn->prepare($getDepositQuery);
    $getDeposit->bindParam(':agentname', $agentname);
    $getDeposit->bindParam(':agentid', $agentid);
    $getDeposit->execute();
    $getDeposit->setFetchMode(PDO::FETCH_ASSOC);

    $depositDetails = [];
    while ($rowDeposit = $getDeposit->fetch()) {
        $depositDetails[] = array(
            'bank_account_name' => $rowDeposit['bank_account_name'],
            'bank_account_number' => $rowDeposit['bank_account_number'],
            'bank_deposit_slip' => $rowDeposit['bank_deposit_slip'],
            'bank_deposit_id' => $rowDeposit['bank_deposit_id']
        );
    }

    if (count($depositDetails) == 0) {
        $json_data = array(
            'numofrows' => 0,
            'depositDetails' => []
        );
        echo json_encode($json_data);
        exit;
    }

    // Second query to get products and transactions
    $getproductsquery = "
        SELECT 
            SUM(transaction_amount) AS totalSales,
            COUNT(id) AS transactions,
            agent_name, 
            agent_id, 
            product_code, 
            product_name,
            transaction_amount, 
            quantity, 
            bank_account_name, 
            bank_account_number 
        FROM transaction_details 
        WHERE 
        (transaction_status = 'approved' OR transaction_status = 'active') 
        AND deposit_status='Pending'
        AND agent_name = :agentname AND agent_id = :agentid
        AND payment_mode = 'CASH'
        GROUP BY product_id 
        ORDER BY product_name ASC";

    $getproducts = $conn->prepare($getproductsquery);
    $getproducts->bindParam(':agentname', $agentname);
    $getproducts->bindParam(':agentid', $agentid);
    $getproducts->execute();
    $getproducts->setFetchMode(PDO::FETCH_ASSOC);

    if ($getproducts->rowCount() == 0) {
        $json_data = array(
            'numofrows' => 0,
            'details' => [],
            'depositDetails' => $depositDetails
        );
        echo json_encode($json_data);
        exit;
    }

    $totalrecords = $getproducts->rowCount();
    $totalQuantities = 0;
    $totalAmountsCollected = 0;
    $nestedData = [];

    while ($row = $getproducts->fetch()) {
        $nestedData[] = $row;
        $totalQuantities += $row['transactions'];
        $totalAmountsCollected += $row['totalSales'];
    }

    // Third query to get newest and oldest transaction dates
    $getDatesQuery = "
        SELECT 
            MAX(transaction_date) AS newestTransactionDate,
            MIN(transaction_date) AS oldestTransactionDate
        FROM transaction_details
        WHERE 
        (transaction_status = 'approved' OR transaction_status = 'active')
        AND deposit_status = 'Pending'
        AND agent_name = :agentname AND agent_id = :agentid
        AND payment_mode = 'CASH'";

    $getDates = $conn->prepare($getDatesQuery);
    $getDates->bindParam(':agentname', $agentname);
    $getDates->bindParam(':agentid', $agentid);
    $getDates->execute();
    $datesResult = $getDates->fetch(PDO::FETCH_ASSOC);

    $json_data = array(
        'totalQuantities' => $totalQuantities,
        'totalAmountsCollected' => $totalAmountsCollected,
        'details' => $nestedData,
        'depositDetails' => $depositDetails,
        'numofrows' => $totalrecords,
        'newestTransactionDate' => $datesResult['newestTransactionDate'],
        'oldestTransactionDate' => $datesResult['oldestTransactionDate']
    );

    echo json_encode($json_data);
    exit;
?>
