<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
   // Retrieve input values
   $bankname = filter_input(INPUT_POST, 'bankname', FILTER_SANITIZE_FULL_SPECIAL_CHARS);
   $depositslipid = filter_input(INPUT_POST, 'depositslipid', FILTER_SANITIZE_FULL_SPECIAL_CHARS);
   $agentid = filter_input(INPUT_POST, 'agentid', FILTER_SANITIZE_FULL_SPECIAL_CHARS);
   $depositslip = filter_input(INPUT_POST, 'depositslip', FILTER_SANITIZE_FULL_SPECIAL_CHARS);
   $status = 'Pending';
    
   // User session variables
   $userloggedid = $_SESSION["userid"];
   $orgName = $_SESSION["orgname"];
   $orgId = $_SESSION["orgid"];
 
   $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

   // Process each transaction
   $json_data = [];
   foreach (json_decode(filter_input(INPUT_POST, "transactionIdsDetails"), true) as $item) {
       $transactionIdsId = $item["id"];
       $receipt = $item["receipt"]; 

       // Prepare the SQL query with placeholders for update
       $updateQuery = "UPDATE `transaction_details` 
                        SET 
                            `transaction_status` = 'active', 
                            `bank_deposit_id` = 'Restored',
                            `deposit_status` = :status, 
                            `approved_by` = :userloggedid 
                        WHERE 
                            `agent_id` = :agentid 
                            AND `bank_deposit_id` = :depositslipid   
                            AND `bank_account_name` = :bankname  
                            AND `bank_deposit_slip` = :depositslip
                            AND receipt_no = :receipt
                            AND `id` = :transactionIdsId";

       // Prepare the statement
       $updated = $conn->prepare($updateQuery);

       // Bind the parameters to the statement
       $updated->bindParam(':status', $status);
       $updated->bindParam(':userloggedid', $userloggedid);
       $updated->bindParam(':agentid', $agentid);
       $updated->bindParam(':depositslipid', $depositslipid);
       $updated->bindParam(':depositslip', $depositslip);
       $updated->bindParam(':bankname', $bankname);
       $updated->bindParam(':receipt', $receipt);
       $updated->bindParam(':transactionIdsId', $transactionIdsId);

       // Execute the update statement
       if ($updated->execute()) {
           $json_data = [
               'status' => 'Restored',
               'reference' => $depositslipid,
               'ids' => $updated->rowCount(),
           ];
       } else {
           $json_data = [
               'status' => 'Failed to Update'
           ];
       }
   }

   // Return JSON response
   echo json_encode($json_data);
   exit;
} catch (PDOException $e) {
    echo json_encode(['error' => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
    exit;
}
?>
