<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

// Insert into the database after successful upload of the database
require_once '../../../xd-assets/backend/config/dbconfig.php';

$userloggedid = $_SESSION["userid"];
$agentId = filter_input(INPUT_POST, "agentId");

// Corrected SQL query with ORDER BY clause
$getproductsquery = "SELECT 
    COUNT(id) AS transactions,
    SUM(transaction_amount) AS totalSales,
    id,
    product_id,
    product_name,
    product_code,
    agent_name,
    agent_id,
    cash_in_status
FROM transaction_details 
WHERE 
    trans_type = 'RECEIPT'  
    AND payment_mode = 'CASH'
    AND (transaction_status = 'active' OR transaction_status = 'approved') 
    AND deposit_status='Pending'
    AND agent_id = :agentId
GROUP BY 
    product_id, 
    product_name 
ORDER BY 
    product_name ASC";  // Correctly place ASC in ORDER BY clause

$getproducts = $conn->prepare($getproductsquery);
$getproducts->bindParam(':agentId', $agentId);
$getproducts->execute();

$getproducts->setFetchMode(PDO::FETCH_ASSOC);

if ($getproducts->rowCount() == 0) {
    $totalrecords = $getproducts->rowCount();
    $json_data = array(
        'numofrows' => $totalrecords
    );
    echo json_encode($json_data);
    exit;
} else if ($getproducts->rowCount() > 0) {
    $totalrecords = $getproducts->rowCount();
    $nestedData = array();
    $totalSales = 0;
    $transactions = 0;
    while ($row = $getproducts->fetch()) {
        $nestedData[] = $row;
        $totalSales += $row['totalSales'];
        $transactions += $row['transactions'];
    }

    $json_data = array(
        "details" => $nestedData,   // total data array
        'numofrows' => $totalrecords,
        'totalSales' => $totalSales,
        'transactions' => $transactions
    );

    echo json_encode($json_data);  // send data as json format
    exit;
}
?>
