<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    // Get input parameters
    $agent_id = filter_input(INPUT_POST, "agentid", FILTER_SANITIZE_NUMBER_INT);
    $depositslipid = filter_input(INPUT_POST, "depositslipid", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $depositslip = filter_input(INPUT_POST, "depositslip", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    //$searchKey = filter_input(INPUT_POST, "searchKey", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
   // $productId = filter_input(INPUT_POST, "productId", FILTER_SANITIZE_NUMBER_INT);
    $bankname =  filter_input(INPUT_POST, "bankname", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    // Create variables to store the conditions for the SQL query
    
    // Prepare the SQL query
    $getproductsquery = "
        SELECT id, cfname, clname, cemail, cphone, product_name, product_id, product_code,
               transaction_amount, quantity, transaction_reference, transaction_status, agent_name, agent_id,trans_type, 
               delivery_address, area, plot_no, nrc, lat, lng, transaction_date, transaction_time, receipt_no, offline_receipt,
               invoiceNumber, comment, receipt_date, payment_mode, bank_name, bank_account_name, bank_deposit_slip, 
               bank_deposit_id, business_category, pacra, tpin
        FROM transaction_details 
        WHERE   
            bank_account_name = '$bankname'
            AND agent_id = '$agent_id'
            AND bank_deposit_id = '$depositslipid'
            AND bank_deposit_slip = '$depositslip' 
            ORDER  BY id";
  
    $getproducts = $conn->prepare($getproductsquery);
 
    $getproducts->execute();
    $getproducts->setFetchMode(PDO::FETCH_ASSOC);

    $agentData = [];
    $totalQuantities = 0;
    $totalAmountsCollected = 0;

    if ($getproducts->rowCount() > 0) {
        while ($row = $getproducts->fetch()) {
            $agentData[] = $row;
            $totalQuantities += (float)$row['quantity'];
            $totalAmountsCollected += (float)$row['transaction_amount'];
        }
    }

    $jsonData = [
        'details' => $agentData,
        'numofrows' => count($agentData),
        'totalQuantities' => $totalQuantities,
        'totalAmountsCollected' => $totalAmountsCollected
    ];

    echo json_encode($jsonData);
} catch (PDOException $e) {
    echo json_encode(['error' => $e->getMessage()]);
    exit;
}
?>
