<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../xd-assets/backend/config/dbconfig.php';

// Fetch and sanitize input data
$agentid = filter_input(INPUT_POST, "agentid", FILTER_DEFAULT);
$agentname = filter_input(INPUT_POST, "agentname", FILTER_DEFAULT);
$depositslipid = filter_input(INPUT_POST, "depositslipid", FILTER_DEFAULT);
$depositslip = filter_input(INPUT_POST, "depositslip", FILTER_DEFAULT);
$bankname = filter_input(INPUT_POST, "bankname", FILTER_DEFAULT);

// Debugging: Log input values
error_log("Agent ID: $agentid");
error_log("Agent Name: $agentname");
error_log("Deposit Slip ID: $depositslipid");
error_log("Deposit Slip: $depositslip");
error_log("Bank Name: $bankname");

try {
    // Query to fetch existing products
    $getproductsquery = "
        SELECT 
            product_id,
            product_name, 
            product_code, 
            bank_account_name, 
            bank_account_number,
            SUM(transaction_amount) AS totalSales,
            COUNT(id) AS transactions,
            SUM(quantity) AS totalQuantity 
        FROM transaction_details 
        WHERE 
            bank_deposit_slip = :depositslip 
            AND bank_name = :bankname 
            AND bank_deposit_id = :depositslipid   
            AND agent_id = :agentid 
            AND (payment_mode = 'CASH' OR payment_mode = 'BANK')
        GROUP BY product_id, product_name
        ORDER BY product_name ASC";

    $getproducts = $conn->prepare($getproductsquery);
    $getproducts->bindParam(':depositslip', $depositslip, PDO::PARAM_STR);
    $getproducts->bindParam(':bankname', $bankname, PDO::PARAM_STR);
    $getproducts->bindParam(':depositslipid', $depositslipid, PDO::PARAM_STR);
    $getproducts->bindParam(':agentid', $agentid, PDO::PARAM_STR);
    $getproducts->execute();
    $getproducts->setFetchMode(PDO::FETCH_ASSOC);

    // Query to fetch pending deposits
    $getPendingDepositsQuery = "
        SELECT 
            SUM(transaction_amount) AS pendingDeposits
        FROM transaction_details 
        WHERE 
            (transaction_status = 'approved' OR transaction_status = 'active') 
            AND deposit_status = 'Pending' 
            AND agent_id = :agentid
            AND payment_mode = 'CASH'";

    $getPendingDeposits = $conn->prepare($getPendingDepositsQuery);
  //  $getPendingDeposits->bindParam(':agentname', $agentname, PDO::PARAM_STR);
    $getPendingDeposits->bindParam(':agentid', $agentid, PDO::PARAM_STR);
    $getPendingDeposits->execute();
    $pendingDepositsData = $getPendingDeposits->fetch(PDO::FETCH_ASSOC);

    // Query to fetch transaction dates
    $getDatesQuery = "
        SELECT 
            MAX(transaction_date) AS newestTransactionDate,
            MIN(transaction_date) AS oldestTransactionDate
        FROM transaction_details
        WHERE 
            bank_deposit_slip = :depositslip 
            AND bank_name = :bankname 
            AND bank_deposit_id = :depositslipid  
            AND agent_id = :agentid 
            AND  (payment_mode = 'CASH' OR payment_mode = 'BANK')";

    $getDates = $conn->prepare($getDatesQuery);
    $getDates->bindParam(':depositslip', $depositslip, PDO::PARAM_STR);
    $getDates->bindParam(':bankname', $bankname, PDO::PARAM_STR);
    $getDates->bindParam(':depositslipid', $depositslipid, PDO::PARAM_STR);
    $getDates->bindParam(':agentid', $agentid, PDO::PARAM_STR);
    $getDates->execute();
    $dateData = $getDates->fetch(PDO::FETCH_ASSOC);

    // Process results
    $totalrecords = $getproducts->rowCount();
    $totalQuantities = 0;
    $totalAmountsCollected = 0;
    $nestedData = [];

    while ($row = $getproducts->fetch()) {
        $nestedData[] = $row;
        $totalQuantities += $row['transactions'];
        $totalAmountsCollected += $row['totalSales'];
    }

    // Prepare response
    $pendingDeposits = $pendingDepositsData['pendingDeposits'] ?? 0;
    $newestTransactionDate = $dateData['newestTransactionDate'] ?? null;
    $oldestTransactionDate = $dateData['oldestTransactionDate'] ?? null;

    $json_data = [
        'totalQuantities' => $totalQuantities,
        'totalAmountsCollected' => $totalAmountsCollected,
        'pendingDeposits' => $pendingDeposits,
        'newestTransactionDate' => $newestTransactionDate,
        'oldestTransactionDate' => $oldestTransactionDate,
        'details' => $nestedData,
        'numofrows' => $totalrecords
    ];

    // Return JSON response
    echo json_encode($json_data);

} catch (PDOException $e) {
    error_log("Database error: " . $e->getMessage());
    echo json_encode(['error' => 'An error occurred while processing the request.']);
}
exit;

?>
