<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $userloggedid = $_SESSION["userid"];

    // Retrieve and validate the start date
    $startDateInput = filter_input(INPUT_POST, "startDate");
    $endDateInput = filter_input(INPUT_POST, "endDate");
    $searchKey = filter_input(INPUT_POST, "searchKey");
    if (empty($startDateInput)) {
        throw new Exception("startDate parameter is empty");
    }

    $startDate = date_create_from_format('Y-m-d', $startDateInput);
    $endDate = $endDateInput ? date_create_from_format('Y-m-d', $endDateInput) : new DateTime();
    
    if ($startDate === false) {
        throw new Exception("Invalid start date format: $startDateInput");
    }
    
    // Validate date range
    if ($endDate < $startDate) {
        throw new Exception("End date cannot be before start date");
    }

    $startDateFormatted = $startDate->format('Y-m-d');
    $endDateFormatted = $endDate->format('Y-m-d');

    // Prepare and execute the SQL statement
    $getDriversQuery = "
    SELECT 
        transaction_details.id,
        transaction_details.product_name,
        transaction_details.product_id,
        SUM(transaction_details.transaction_amount) AS total_amount,
        rota.target AS individual_target,
        total_target.total_target AS total_target,
        total_amount.total_amount AS total_transaction_amount,
        transaction_details.agent_id
    FROM 
        transaction_details 
    LEFT JOIN 
        rota ON rota.user_id = transaction_details.agent_id AND rota.rota_code = transaction_details.product_id
    LEFT JOIN 
        (SELECT user_id, SUM(target) AS total_target FROM rota WHERE user_id = :userloggedid GROUP BY user_id) AS total_target
        ON total_target.user_id = transaction_details.agent_id
    LEFT JOIN 
        (SELECT agent_id, SUM(transaction_amount) AS total_amount FROM transaction_details WHERE transaction_date >= :start_date AND transaction_date <= :end_date GROUP BY agent_id) AS total_amount
        ON total_amount.agent_id = transaction_details.agent_id
    WHERE 
        transaction_details.agent_id = :userloggedid
        AND transaction_details.transaction_date >= :start_date AND transaction_details.transaction_date <= :end_date
    GROUP BY 
        transaction_details.product_id";

    $getDrivers = $conn->prepare($getDriversQuery);
    $getDrivers->bindParam(':userloggedid', $userloggedid);
    $getDrivers->bindParam(':start_date', $startDateFormatted);
    $getDrivers->bindParam(':end_date', $endDateFormatted);
    $getDrivers->execute();

    // Process results
    $jobdetails = [];
    while ($rowDs = $getDrivers->fetch(PDO::FETCH_ASSOC)) {
        $jobdetails[] = $rowDs;
    }

    // Prepare JSON response
    $json_data = [
        "details" => $jobdetails,
        'numofrows' => count($jobdetails),
    ];

    // Return JSON response
    echo json_encode($json_data);
    exit;
} catch (PDOException $e) {
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
?>
