<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    $amount = filter_input(INPUT_POST, 'amount', FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $depositslipid = filter_input(INPUT_POST, 'depositslipid', FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $agentid = filter_input(INPUT_POST, 'agentid', FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $bankId = filter_input(INPUT_POST, 'bankId', FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $bankname = filter_input(INPUT_POST, 'bankname', FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $bankaccountnumber = filter_input(INPUT_POST, 'bankaccountnumber', FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $depositslip = filter_input(INPUT_POST, 'depositslip', FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $status = 'Approved';
    $transactionType = 'CREDIT'; // Example transaction type

    $userloggedid = $_SESSION["userid"];
    $orgName = $_SESSION["orgname"];
    $orgId = $_SESSION["orgid"];

 // Check if a record already exists in bank_accounts_transactions
$checkBankTransactionsQuery = "SELECT COUNT(*) FROM `bank_accounts_transactions` 
WHERE `bank_id` = :bankId 
AND `account_number` = :bankaccountnumber 
AND `reference` = :depositslipid";

$checkBankTransactionsStmt = $conn->prepare($checkBankTransactionsQuery);
$checkBankTransactionsStmt->bindParam(':bankId', $bankId);
$checkBankTransactionsStmt->bindParam(':bankaccountnumber', $bankaccountnumber);
$checkBankTransactionsStmt->bindParam(':depositslipid', $depositslipid);
$checkBankTransactionsStmt->execute();
$bankTransactionExists = $checkBankTransactionsStmt->fetchColumn();

if ($bankTransactionExists > 0) {
// If a matching record already exists, return a response and stop further execution
echo json_encode(['status' => 'Transaction reference already exists in the bank.']);
exit;
}else {
        // Prepare the SQL query with placeholders for update
        $updateQuery = "UPDATE `transaction_details` 
                        SET 
                            `transaction_status` = 'approved', 
                            `deposit_status` = :status, 
                            `approved_by` = :userloggedid 
                        WHERE 
                            `agent_id` = :agentid 
                            AND `bank_deposit_id` = :depositslipid  
                            AND `bank_id` = :bankId 
                            AND `bank_account_name` = :bankname 
                            AND `bank_account_number` = :bankaccountnumber
                            AND `bank_deposit_slip` = :depositslip
                            AND `deposit_status` = 'Pending Approval'";

        // Prepare the statement
        $updated = $conn->prepare($updateQuery);

        // Bind the parameters to the statement
        $updated->bindParam(':status', $status);
        $updated->bindParam(':userloggedid', $userloggedid);
        $updated->bindParam(':agentid', $agentid);
        $updated->bindParam(':depositslipid', $depositslipid);
        $updated->bindParam(':bankId', $bankId);
        $updated->bindParam(':bankname', $bankname);
        $updated->bindParam(':bankaccountnumber', $bankaccountnumber);
        $updated->bindParam(':depositslip', $depositslip);

        // Execute the statement
        if ($updated->execute()) {
            // Insert into `bank_accounts_transactions` after successful update
            $insertQuery = "INSERT INTO `bank_accounts_transactions` 
                            (`bank_id`, `bank_name`, `account_name`, `account_number`, `amount`, `reference`, `transaction_type`, `status`, `sessionUserId`, `org_name`, `org_id`) 
                            VALUES 
                            (:bankId, :bankname, :account_name, :account_number, :amount, :reference, :transaction_type, :status, :sessionUserId, :org_name, :org_id)";

            $insert = $conn->prepare($insertQuery);
            // Bind parameters for insert
            $insert->bindParam(':bankId', $bankId);
            $insert->bindParam(':bankname', $bankname);
            $insert->bindParam(':account_name', $bankname); // Replace if there's an account name
            $insert->bindParam(':account_number', $bankaccountnumber);
            $insert->bindParam(':amount', $amount);
            $insert->bindParam(':reference', $depositslipid);
            $insert->bindParam(':transaction_type', $transactionType);
            $insert->bindParam(':status', $status);
            $insert->bindParam(':sessionUserId', $userloggedid);
            $insert->bindParam(':org_name', $orgName);
            $insert->bindParam(':org_id', $orgId);

            if ($insert->execute()) {
                $json_data = [
                    'status' => 'Approved',
                    'reference' => $depositslipid
                ];
            } else {
                $json_data = [
                    'status' => 'Update Approved but Insert Failed'
                ];
            }
        } else {
            $json_data = [
                'status' => 'Approval Failed!'
            ];
        }
    }

    // Return JSON response
    echo json_encode($json_data);
    exit;
} catch (PDOException $e) {
    echo json_encode(['error' => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
    exit;
}
?>
