<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    // Get input parameters
    $agent_id = filter_input(INPUT_POST, "agentId", FILTER_SANITIZE_NUMBER_INT);
    $startDateInput = filter_input(INPUT_POST, "startDate", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $endDateInput = filter_input(INPUT_POST, "endDate", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $searchKey = filter_input(INPUT_POST, "searchKey", FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $productId = filter_input(INPUT_POST, "productId", FILTER_SANITIZE_NUMBER_INT);

    // Create variables to store the conditions for the SQL query
    $conditions = [];
    $parameters = [];

    // Add conditions based on input parameters
    if (!empty($startDateInput)) {
        $conditions[] = "transaction_date >= :start_date";
        $parameters[':start_date'] = date('Y-m-d', strtotime($startDateInput));
    }
    if (!empty($endDateInput)) {
        $conditions[] = "transaction_date <= :end_date";
        $parameters[':end_date'] = date('Y-m-d', strtotime($endDateInput));
    }
    if (!empty($searchKey)) {
        $conditions[] = "(product_name LIKE :search_key OR product_id LIKE :search_key)";
        $parameters[':search_key'] = '%' . $searchKey . '%';
    }

    // Prepare the SQL query
    $getproductsquery = "
        SELECT 
            id, cfname, clname, cemail, cphone, product_name, product_id, transaction_amount,
            quantity, transaction_reference, transaction_status, order_details, user_id, agent_id, trans_type, depot,
            delivery_address, area, plot_no, nrc, lat, lng, transaction_date, transaction_time, receipt_no,
            invoiceNumber, receipt_date, payment_mode, bank_name, bank_account_name, bank_deposit_slip, bank_deposit_id,business_category, pacra, tpin
        FROM transaction_details 
        WHERE 
            trans_type = 'RECEIPT' 
            AND agent_id = :agent_id
            AND product_id = :product_id
            AND (transaction_status = 'active' OR transaction_status = 'approved' OR transaction_status = 'Cashed In')";

    if (!empty($conditions)) {
        $getproductsquery .= " AND " . implode(" AND ", $conditions);
    }

    $getproductsquery .= " ORDER BY transaction_date DESC";

    $getproducts = $conn->prepare($getproductsquery);

    // Bind parameters
    $parameters[':agent_id'] = $agent_id;
    $parameters[':product_id'] = $productId;

    $getproducts->execute($parameters);
    $getproducts->setFetchMode(PDO::FETCH_ASSOC);

    $agentData = [];
    $totalQuantities = 0;
    $totalAmountsCollected = 0;

    if ($getproducts->rowCount() > 0) {
        while ($row = $getproducts->fetch()) {
            $agentData[] = $row;
            $totalQuantities += $row['quantity'];
            $totalAmountsCollected += $row['transaction_amount'];
        }
    }

    $jsonData = [
        'details' => $agentData,
        'numofrows' => count($agentData),
        'totalQuantities' => $totalQuantities,
        'totalAmountsCollected' => $totalAmountsCollected
    ];

    echo json_encode($jsonData);
} catch (PDOException $e) {
    echo json_encode(['error' => $e->getMessage()]);
    exit;
}
?>
