var invoicePaymentCart = (function() {
    let cart = [];

    // Constructor with balanceCF added
    function Item(name, price, charge_rate, count, id, productcode, category, categorycode, depot, depotid, depotcode, total_charge, balance_bf, balance, balanceCF) {
        this.name = name;
        this.price = parseFloat(price);
        this.charge_rate = parseFloat(charge_rate);
        this.count = parseFloat(count);
        this.id = id;
        this.productcode = productcode;
        this.category = category;
        this.categorycode = categorycode;
        this.depot = depot;
        this.depotid = depotid;
        this.depotcode = depotcode;
        this.total_charge = parseFloat(total_charge);
        this.balance_bf = parseFloat(balance_bf);
        this.balance = parseFloat(balance);
        this.balanceCF = parseFloat(balanceCF);
    }

    // Save cart to sessionStorage
    function saveCart() {
        sessionStorage.setItem('invoicePaymentCart', JSON.stringify(cart));
    }

    // Load cart from sessionStorage
    function loadCart() {
        cart = JSON.parse(sessionStorage.getItem('invoicePaymentCart')) || [];
    }

    if (sessionStorage.getItem("invoicePaymentCart") != null) {
        loadCart();
    }

    const obj = {};

    // Add Item to Cart
    obj.addItemToCart = function(name, price, charge_rate, count, id, productcode, category, categorycode, depot, depotid, depotcode, total_charge, balance_bf, balance) {
        let item = new Item(name, price, charge_rate, count, id, productcode, category, categorycode, depot, depotid, depotcode, total_charge, balance_bf, balance, 0);
        item.balanceCF = calculateBalanceCF(item.balance_bf, item.total_charge, item.price * item.count);
        cart.push(item);
        saveCart();
    };

    // Remove all instances of an item from the cart by name
    obj.removeItemFromCartAll = function(name) {
        cart = cart.filter(item => item.name !== name);
        saveCart();
    };

    // Calculate balanceCF
    function calculateBalanceCF(balance_bf, total_charge, totalItemCost) {
        return parseFloat(balance_bf) + parseFloat(total_charge) - parseFloat(totalItemCost);
    }

    // Update item count
    obj.setCountForItemAt = function(idx, newCount) {
    const item = cart[idx];
    if (!item) return;
    item.count = parseFloat(newCount);
    item.balanceCF = parseFloat(item.balance_bf) - (item.price * item.count);
    saveCart();
    };

    // Update total item cost and recalculate balanceCF
 obj.setTotalItemCostAt = function(idx, newTotalCost) {
  const item = cart[idx];
  if (!item) return;
  item.count = parseFloat(newTotalCost) / item.price;
  item.balanceCF = parseFloat(item.balance_bf) - parseFloat(newTotalCost);
  saveCart();
};

    // Clear the entire cart
    obj.clearCart = function() {
        cart = [];
        saveCart();
    };

    // List all items in the cart
    obj.listCart = function() {
        return cart.map(item => ({
            ...item,
            total: (item.price * item.count).toFixed(2),
            balanceCF: (isNaN(item.balanceCF) ? 0 : item.balanceCF).toFixed(2),
        }));
    };

      obj._resetAllToBalanceBF = function() {
    cart.forEach(item => {
      item.count     = item.price > 0 ? item.balance_bf / item.price : 0;
      item.balanceCF = 0;
    });
    saveCart();
  };

    return obj;
})();

// *****************************************
// Triggers / Events
// *****************************************

// Utility function for debouncing
function debounce(func, delay) {
    let timer;
    return function(...args) {
        clearTimeout(timer);
        timer = setTimeout(() => func.apply(this, args), delay);
    };
}

// Clear cart button
$(document).on('click', '.clearReceiptItems', function() {
    invoicePaymentCart.clearCart();
    displayInvoicePaymentCart();
});

 
// Handle changes in item count
$(document).on("input", ".invoicePaymentCart .invoice-item-count", debounce(function() {
  // ① Read data-index
  const idx   = +$(this).data('index');
  const count = parseFloat($(this).val());
  // ② Pass idx (not “name”) to your setter
  invoicePaymentCart.setCountForItemAt(idx, count);
  // ③ Redisplay (defaults isInitial=false)
  displayInvoicePaymentCart();
}, 2300));

// Handle changes in total item cost
$(document).on("input", ".invoicePaymentCart .invoice-item-total-cost", debounce(function() {
  const idx       = +$(this).data('index');
  const totalCost = parseFloat($(this).val());
  invoicePaymentCart.setTotalItemCostAt(idx, totalCost);
  displayInvoicePaymentCart();
}, 2300));


// Display the cart
function displayInvoicePaymentCart(isInitial = false) {
      if (isInitial) {
    // mutate the real cart array first
    invoicePaymentCart._resetAllToBalanceBF();
  }
    const cartArray = invoicePaymentCart.listCart();
    let output = "";
    // Initialize totals
    let totalBalanceBroughttForward = 0,
        totalInvoicePrices = 0,
        totalInvoiceUnits = 0,
        totalBilledAmounts = 0,
        totalPaymentAmounts = 0,
        closingBalanceTotal = 0;

    // Generate HTML output and calculate totals
 cartArray.forEach((item, idx) => {
    let itemTotal, balanceCF, itemCount;

    if (isInitial) {
        itemTotal = parseFloat(item.balance_bf);
        balanceCF = 0;
        itemCount = item.price > 0 ? (item.balance_bf / item.price) : 0;
    } else {
        itemTotal = parseFloat(item.total);
        balanceCF = parseFloat(item.balanceCF);
        itemCount = parseFloat(item.count);
    }

    // Accumulate totals
    totalBalanceBroughttForward += parseFloat(item.balance_bf);
    totalInvoicePrices += item.price;
    totalInvoiceUnits += itemCount;
    totalBilledAmounts += itemTotal;
    totalPaymentAmounts += parseFloat(item.total_charge);
    closingBalanceTotal += balanceCF;

    // Append item row to the cart output
    output += `
        <div class="w3-col l12 m12 s12" style="float:left;padding-left:0px;">
            <div class="w3-col l4 m4 s8" style="float:left;padding-left:5px;text-align:left;">
                <b>${item.name}</b>
            </div>
            <div class="w3-col l2 m2 s2 w3-hide-small">K${item.balance_bf.toFixed(2)}</div>
            <div class="w3-col l1 m1 s1 w3-hide-small">K${item.price.toFixed(2)}</div>

            <div class="w3-col l1 m1 s1 w3-hide-small">
                <input type="number" step="0.001" class="invoice-item-count" data-index="${idx}" 
                       value="${itemCount.toFixed(2)}" style="background-color:transparent;border:none;outline:none;max-width:60px;">
            </div>
            <div class="w3-col l1 m1 s1 w3-hide-small" style="display:none;">K${item.total_charge.toFixed(2)}</div>

            <div class="w3-col l2 m2 s2">
                <input type="number" step="0.01" class="invoice-item-total-cost" data-index="${idx}" 
                       value="${itemTotal.toFixed(2)}" style="background-color:transparent;border:none;outline:none;">
            </div>
            <div class="w3-col l2 m2 s2">K${balanceCF.toFixed(2)}</div>
        </div>`;
});


    // Render the cart items in the `.invoicePaymentCart` div
    $('.invoicePaymentCart').html(output);

    // Update totals in the corresponding summary divs
    const updateDiv = (selector, value) => {
      $(selector).html(`${value.toFixed(2)}`);
    };

    updateDiv('.totalBalanceBroughttForward', totalBalanceBroughttForward);
    updateDiv('.totalInvoicePrices', totalInvoicePrices);
    updateDiv('.totalInvoiceUnits', totalInvoiceUnits);
    updateDiv('.totalBilledAmounts', totalBilledAmounts);
    updateDiv('.totalPaymentAmounts', totalPaymentAmounts);
    updateDiv('.closingBalanceTotal', closingBalanceTotal);
}

// Initially display the cart with isInitial = true
displayInvoicePaymentCart(true);

 


 $(document).on('change keyup', '.innerDivInvoiceSelectKey', function (event) {
    const selectedValue = $(this).val(); // Get the selected value
    const selectedOption = $(this).find('option:selected'); // Get the selected option
    
    const clientname = selectedOption.data('names') || '';
    const companyname = selectedOption.data('companyname') || '';
    const phone = selectedOption.data('phone') || '';
    const email = selectedOption.data('email') || '';
    const address = selectedOption.data('address') || '';
    const userid = selectedOption.data('userid') || '';
    const pacra = selectedOption.data('pacra') || '';
    const plotnumber = selectedOption.data('plotnumber') || '';
    const area = selectedOption.data('area') || '';
    const nrc = selectedOption.data('nrc') || ''; 
    const tpin = selectedOption.data('tpin') || '';
    const businessCategory = selectedOption.data('businesscategory') || '';
    const dudate = selectedOption.data('duedate') || '';
    const invoicenumber = selectedOption.data('invoicenumber') || '';
 
    if (userid) {

      if (selectedValue === "invoiceMakePayment") {
      
        invoiceMakePayment(clientname,phone,email,address,userid,pacra,plotnumber,area,nrc,tpin,businessCategory,dudate,invoicenumber); // Call the function with valid data

      }else if(selectedValue === "displayIvoice"){ 
          viewInvoice(clientname,phone,email,address,userid,pacra,plotnumber,area,nrc,tpin,businessCategory,dudate,invoicenumber); // Call the function with valid data

      } 
    
    } else {
        console.error("Invalid user Id");
        console.log("Selected Option:", selectedOption);
    }
 
  });


 function invoiceMakePayment(clientname,phone,email,address,userid,pacra,plotnumber,area,nrc,tpin,businessCategory,dudate,invoicenumber){ 
     
    let today = new Date().toISOString().slice(0, 10).replace(/-/g, "/");
    invoicePaymentCart.clearCart();
   // alert('You are about to make a payment for invoice number: ' + invoicenumber);
      $('#external_page_contents').empty().append('<div id="invoice_modal" class="w3-modal w3-center" style=" background-color:rgba(255,255,255,255);z-index:99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999"></div>');
      $('#invoice_modal').append('<div id="invoice_modal_div_0" style="background-color:white;height:100vh;"></div>');
     // modal acttion buttons
     $('#invoice_modal').append('<div class="w3-col l12 m12 s12 w3-card-2 w3-top invoiceDivActions101 hideOnPrint" style="height:40px;color:gray;"><span class="close_invoice_modal" style="float:left;cursor:pointer;margin-top:5px;margin-right:10px;margin-left:10px;"><span class="fontx fx-arrow-left" style="font-size:1.7em;color:var(--primary-color);"></span></span> <div id="invoicePaymentDiv02"><span class="bankTransact0" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span> Make Bank Payment</span></span></div> <span class="top-right-navigation-icons101" style="margin-top:3px;float:left;margin-right:7px;"><span class="fontx fx-trash-2 clearInvoiceItems" style="margin-top:-10px;"></span></span><div class="top-right-navigation-icons101 fileDiv101" style="margin-top:3px;float:left;margin-right:12px;"><span class="fontx fx-file"></span><input name="depositslipfile" id="depositslipfile" type="file" /></div><div class="top-right-navigation-icons101 addInvoiceComment" style="margin-top:3px;float:left;"><span class="fontx fx-edit-2" style="margin-top:-30px;margin-right:10px;"></span></div></div>');
     
     // modal acttion buttons
  
     $('#invoice_modal_div_0').append(`
        <div class="w3-center w3-col l12 m12 s12 receiptTitles00">
          <div class="w3-center w3-col l12 m12 s12 org_logo_div"></div>
          <div class="w3-center w3-col l12 m12 s12"><b class="org_name" style="text-transform:uppercase"></b></div>
           <div class="w3-center w3-col l12 m12 s12 w3-hide-small pobox"></div>
          <div class="w3-center w3-col l12 m12 s12 w3-hide-small org_address" style="font-size: 0.7em;"></div>
      
            
            <div class="w3-center w3-col l12 m12 s12" style="margin-top:0px;margin-bottom:5px;color:var(--primary-color);font-size:1.3em"><b>RECEIPT</b></div>
            <div class="w3-center w3-col l12 m12 s12" style="margin-top:0px;margin-bottom:0px;">
                
               <div id="invoiceDueDateDiv" class="w3-col l12 m12 s12" style="margin-left:5px;">
               <span id="receiptTitle00" style="margin-left:12px;font-weight:400;font-size:1em">No: </span>
                  <span id="invoiceNumber" style="color:red;font-weight:400;font-size:1em">00</span>
                <span id="hiddenInvoiceNumber" class="clearOnTransactionSuccess" style="display:none;">${invoicenumber}</span>  
              
                    Created: <input id="invoiceDueDate" placeholder="${dudate}" value="${dudate}" style="margin-left:5px;margin-top:0px;border:none;cursor:pointer;font-size:0.9em;max-width:100px;color:black;font-weight:400;"/>
                    <span class="showOnPrint" style="display:none;">Printed: ${today}</span>
                </div>
            </div>
        </div>
    `);
  
  $('#invoice_modal_div_0').append('<div class="w3-col l8 m8 s12 bankInvoiceDetailsDiv"><div class="w3-col l12 m12 s12 modeOfPaymentDiv0" style="margin-top:0px;"><select id="modeOfPayment" style="outline: none;margin-bottom:0px;color:black;margin-left:10px;float:left;margin-top:0px;border:none;font-weight:600;font-size:1em;background-color: transparent;-moz-appearance: none;-webkit-appearance: none;appearance: none;background-image: none;text-indent: 0.01px;text-transform:uppercase;"><option value="MOMO">Digital Payment</option><option value="BANK">Bank Deposit</option><option value="CASH">Cash payment</option><option value="BANK TRANSFER">Bank Transfer</option></select></div><span class="w3-col l12 m12 s12 bankAccoutDiv101"><span style="float:left;color:gray;font-weight: 600;font-size:0.9em;margin-left: 7px;"><select id="bankname99" style="-moz-appearance: none;-webkit-appearance: none;appearance: none;background-image: none;text-indent: 0.01px;background-color: transparent;border: none;outline: none;color:black;text-transform:capitalize;margin-left:5px;"><option>Indo Transit Account</option></select></span></span><div class="w3-col l12 m12 s12 bankDepositSlipIdDiv101"><span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:0.9em">Ref/ID: </span><input id="bankDepositSlipId" class="clearOnTransactionSuccess" type="text" placeholder="Enter here" style="float:left;border:none;outline: none;font-size:0.9em;background-color:transparent;font-weight: 400;width:70%;"/></div><div class="w3-col l12 m12 s12 bankAccountNumberDiv101 w3-hide-small"><span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:1em">A/C: </span><span id="bankAccountNumber" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;"> 0262020000045</span></div><div class="w3-col l12 m12 s12 bankBranchDiv101 w3-hide-small"><span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:0.9em">Branch: </span><span id="bankBranch99" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;"> Mongu Branch</span></div><div class="w3-center w3-col l12 m12 s12 w3-hide-small"> <span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:0.9em">Phone: </span><span id="bankSortCode99" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;"> 0217221039</span></div><div class="w3-center w3-col l12 m12 s12 w3-hide-small"> <span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:0.9em">Email: </span><span id="bankSortCode99" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;">mongubilling@gmail.com</span></div></div>');
     
  $('#invoice_modal_div_0').append('<div class="w3-col l4 m4 s12 clientDetailsDiv101" style="padding-right: 0px;padding-left:8px;"><span class="w3-col l12 m12 s12" id="addInvoiceClientDiv" style="cursor: pointer;margin-top:0px;"> <button type="button" style="float:left;font-weight:600;color:black;height: 25px;background-color:transparent;border:none;outline:none;margin-left:-5px;">BILLED TO:</button></span><span class="w3-col l6 m6 s8 invoicedClientName0Div" style="margin-top:0px;font-weight: 600;"><span id="invoicedClientId0" class="clearOnTransactionSuccess" style="display: none;float:left;"></span><input id="invoicedClientName0" class="clearOnTransactionSuccess"  Placeholder="Client name:" type="text" style="float:left;border:none;background-color:transparent;outline:none;color:gray" readonly/> </span><span class="w3-col l6 m6 s12" style="display:none;"><span id="invoicedClientName1" class="clearOnTransactionSuccess" style="float:left;margin-left: 3px;"></span></span><span class="w3-col l12 m12 s12 plotnumber07Div  w3-hide-small"  style="margin-top:0px;"><input id="plotnumber07" Placeholder="Plot No:" class="clearOnTransactionSuccess" type="text" style="display:none;float:left;border:none;background-color:transparent;outline:none;width:100px;"/><input id="invoicedClientAddress0" class="clearOnTransactionSuccess" Placeholder="Address:" type="address" style="float:left;border:none;background-color:transparent;outline:none;min-width:410px"/><input id="area07" Placeholder="Area" type="text" class="w3-hide-small"  style="display:none;float:left;border:none;background-color:transparent;outline:none;"/></span><div class="w3-col l12 m12 s12"  style="margin-top:0px;"><input id="tpin07" Placeholder="TPIN No:" class="w3-hide-small" type="text" style="float:left;border:none;background-color:transparent;outline:none;max-width: 150px;"/><input id="nrc07" Placeholder="Nrc No:" type="text" style="display:none;float:left;border:none;background-color:transparent;outline:none;max-width: 150px;"/> </span><span class="w3-col l12 m12 s4 invoicedClientEmail0Div"  style="margin-top:0px;"><input id="invoicedClientEmail0" class="w3-hide-small" Placeholder="Email:" type="email"  style="float:left;border:none;background-color:transparent;outline:none;min-width:250px;"/></span><span class="w3-col l12 m12 s4 invoicedClientPhone0Div"  style="margin-top:0px;"><input id="invoicedClientPhone0" placeholder="Phone Number:" type="number" style="float:left;border:none;background-color:transparent;outline:none;max-width: 130px;-webkit-appearance: none;appearance: none;background-image: none;text-indent: 0.01px;"/></span></div>');
   
 
    $('#invoice_modal_div_0').append('<div class="inner-data-div w3-col l12 m12 s12" style="border: 1px solid var(--primary-color-transparent1);margin-top:5px;background-color:var(--primary-color-transparent2);font-weight:600;"><div class="w3-col l4 m4 s7"><span style="padding:7px;cursor:pointer;">Product/Account<span class="fontx fx-plus"></span></span></div><div class="w3-col l2 m2 s2 w3-hide-small">Balance BF</div><div class="w3-col l1 m1 s1 w3-hide-small">Price/Unit</div><div class="w3-col l1 m1 s1 w3-hide-small">Units</div><div class="w3-col l1 m1 s1 w3-hide-small" style="display:none;">Bill</div><div class="w3-col l2 m2 s3"><span class="w3-hide-small">Payment</span><span class="w3-hide-large w3-hide-medium">Payment</span></div><div class="w3-col l2 m2 s2"><span class="w3-hide-small">Balance</span><span class="w3-hide-large w3-hide-medium">Bal.</span></div></div>');
       $('#invoice_modal_div_0').append('<div class="invoicePaymentCart inner-data-div w3-col l12 m12 s12" style="margin-top:0px;background-color:var(--primary-color-transparent);padding-left:7px;border:1px solid var(--primary-color-transparent1);"></div>');
     $('#invoice_modal_div_0').append('<div class="inner-data-div w3-col l12 m12 s12" style="margin-top:0px;background-color:var(--primary-color-transparent1);font-weight:600;border-bottom:2px solid var(--primary-color-transparent1);border-left:1px solid var(--primary-color-transparent1);border-right:1px solid var(--primary-color-transparent1);"><div class="w3-col l4 m4 s7"><span style="padding:7px;cursor:pointer;"><b>Totals: </b></span></div><div class="w3-col l1 m1 s3 totalBalanceBroughttForward w3-hide-small">00</div><div class="w3-col l1 m1 s1 totalInvoicePrices w3-hide-small">00</div><div class="w3-col l1 m1 s1 totalInvoiceUnits w3-hide-small">00</div><div class="w3-col l1 m1 s3 totalPaymentAmounts w3-hide-small">00</div><div class="w3-col l2 m2 s3 totalBilledAmounts" style="color:red;">0.0</div><div class="w3-col l2 m2 s2 closingBalanceTotal">00</div></div>');
     //  $('#invoice_modal_div_0').append('<div>Amount in words: <span id="amountInWords"></span></div>');
      $('#invoice_modal_div_0').append('<div class="w3-col l12 m12 s12 commentDiv101" style="display:none;"><textarea id="comment101" placeholder="Write your comment here..."></textarea></div>');
          
       $('#invoice_modal_div_0').append('<p class="w3-col l12 m12 s12"><span class="w3-col l6 m6 s12"style="float:left;margin-top: 0px;">Prepared by: <span class="preparedBy" style="color:gray"></span></span><span class="w3-col l6 m6 s12 w3-hide-small" style="float:left;margin-top: 0px;"> Signature: <span id="agentSignature" style="color:gray">______________________</span</span></p>');
      
       $('#invoice_modal').append('<div id="invoice_modal_div_1" style="display:none;background-color:white;height:100vh;marg-top:-100px;padding:5px;"></div>');
      $('#invoice_modal').fadeIn('slow');
      $('#invoice_modal').css('display', 'block'); // Ensure modal is displayed


          ///fetching user data from the database
        getUserFromIndexedDB()  // Retrieve user data from IndexedDB the script is in mainScript.js
        .then((userData) => {
            if (userData.length > 0) {
                const user = userData[0]; // Assuming the first user record is the relevant one
    
                // Update the UI elements with user data 
                $('.org_name').empty().append(user.orgname);              
                $('.org_email').empty().append(user.org_email);
                $('.org_contacts').empty().append(user.org_contacts);
                $('.org_address').empty().append(user.org_address); 
                $('.pobox').empty().append(user.org_p_o_box);
                $('.preparedBy').empty().append(user.username); 
    
                // Check if the user has an org logo stored as a Blob
                if (user.org_logo) {
                    // Convert Blob to a URL that can be used in the `img` element
                    const logoURL = URL.createObjectURL(user.org_logo);
    
                    // Create an img element and set its source to the Blob URL
                    const imgElement = $('<img>', {
                        src: logoURL,  // Set the image source (Blob URL)
                        alt: 'Organization Logo', // Alt text for the image
                        class: 'org_logo',   // Optional: Add a class for styling
                    });
    
                    // Append the image to the DOM
                    $('.org_logo_div').empty().append(imgElement); // Assuming there's a container with class 'org-logo-container'
                } else {
                    console.error('No organization logo found in user data.');
                }
                
                // console.log('User data successfully displayed while offline:', user);
            } else {
                // console.error('No user data found in IndexedDB while offline.');
            }
        })
        .catch((error) => {
            console.error('Error retrieving user data from IndexedDB:', error);
        });


        $('#invoicePaymentDiv02').empty().append('<span class="momoTransact0" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span> MAKE PAYMENT</span></span>');
        $('.bankDepositSlipIdDiv101').fadeOut('slow');
        $('.bankAccountNumberDiv101').fadeOut('slow');
        $('.bankBranchDiv101').fadeOut('slow');
        $('#bankname99').fadeOut('slow'); 

      //fetch bank details
      $.getJSON('xd-modules/agent-module/backend/getBankAccounts.php',function(data){
      $('#bankname99').empty();
      $.each(data.details, function(i,cyberdesk) {
      $('#bankname99').append('<option value="'+cyberdesk.account_name+'" data-accountnumber="'+cyberdesk.account_number+'" data-sortcode="'+cyberdesk.sort_code+'" data-branch="'+cyberdesk.branch+'">'+cyberdesk.account_name+'</option>');
      });
       
      });
  
      document.getElementById('invoicedClientName0').value='';
     document.getElementById('invoicedClientName0').value=clientname;
      document.getElementById('invoicedClientAddress0').vallue='';
      document.getElementById('invoicedClientAddress0').value=address;
      document.getElementById('plotnumber07').value='';
      document.getElementById('plotnumber07').value=plotnumber;
      document.getElementById('area07').value='';
      document.getElementById('area07').value=area;
      document.getElementById('nrc07').value='';
      document.getElementById('nrc07').value=nrc;
     
      document.getElementById('tpin07').value='';
      document.getElementById('tpin07').value=tpin;
      
      document.getElementById('invoicedClientEmail0').value='';
      document.getElementById('invoicedClientEmail0').value=email;
      $('#invoicedClientId0').empty();
      $('#invoicedClientId0').append(userid);
      $('#pacra00').empty();
      $('#pacra00').append(pacra); 
     
      $('#businesscategory00').empty();
      $('#businesscategory00').append(businessCategory); 
      document.getElementById('invoicedClientPhone0').value ='';
      document.getElementById('invoicedClientPhone0').value = phone;
   
    if(userid!='' && invoicenumber!=''){
    
      datastring='invoicenumber='+invoicenumber+'&userid='+userid;
               
      $.ajax({         
        data:datastring,
      url: "xd-modules/cashier-module/billing/backend/getInvoiceProductDetails.php",
        type: "POST"
      
       }).done (function(data) {
      var detailsx = JSON.parse(data);
      
      // Add all items first
      $.each(detailsx.details, function(i,cyberdesk) {
        invoicePaymentCart.addItemToCart(cyberdesk.product_name,cyberdesk.unit_price,cyberdesk.billing_interval,cyberdesk.units,cyberdesk.product_id,cyberdesk.product_code,cyberdesk.product_category,cyberdesk.product_category_code,cyberdesk.depot,cyberdesk.depot_id,cyberdesk.depot_code,cyberdesk.total_charge,cyberdesk.balance_bf,cyberdesk.balance);
      });
      // Now display with isInitial = true
      displayInvoicePaymentCart(true);
      
      });
    
    }else{
    alert('Something went wrong tryreload or refresh and try again!');
    
    }
    
    
    
    
    };