// Debounce function
function debounce(func, wait) {
  let timeout;
  return function (...args) {
      const context = this;
      clearTimeout(timeout);
      timeout = setTimeout(() => func.apply(context, args), wait);
  };
}

// ************************************************
// Invoice Cart API
// ************************************************
var invoiceCart = (function () {
  let cart = [];
  let totalBalanceCF = 0;

  function Item(name, price, charge_rate, count, id, productcode, category, categorycode, depot, depotid, depotcode, balancebroughtforward, balanceCF) {
      this.name = name;
      this.price = price;
      this.charge_rate = charge_rate;
      this.count = count;
      this.id = id;
      this.productcode = productcode;
      this.category = category;
      this.categorycode = categorycode;
      this.depot = depot;
      this.depotid = depotid;
      this.depotcode = depotcode;
      this.balancebroughtforward = balancebroughtforward;
      this.balanceCF = price*count+balancebroughtforward;
  }

  function saveCart() {
      sessionStorage.setItem('invoiceCart', JSON.stringify(cart));
  }

  function loadCart() {
      cart = JSON.parse(sessionStorage.getItem('invoiceCart')) || [];
  }

  if (sessionStorage.getItem('invoiceCart') != null) {
      loadCart();
  }

  let obj = {};
  obj.addItemToCart = function (name, price, charge_rate, count, id, productcode, category, categorycode, depot, depotid, depotcode, balancebroughtforward) {
    let found = false;

    for (let item of cart) {
        if (item.name === name) {
            found = true;
            item.count += count;

            // Ensure balanceCF is updated correctly
            item.balanceCF = (
                parseFloat(item.price) * item.count + parseFloat(item.balancebroughtforward)
            ).toFixed(2);

            console.log(`Updated Item: ${item.name}, New Count: ${item.count}, New BalanceCF: ${item.balanceCF}`);
            saveCart();
            break;
        }
    }

    if (!found) {
        // Ensure proper calculation of balanceCF when adding a new item
        let balanceCF = (parseFloat(price) + parseFloat(balancebroughtforward)).toFixed(2);
        let newItem = new Item(name, price, charge_rate, count, id, productcode, category, categorycode, depot, depotid, depotcode, balancebroughtforward, balanceCF);

        cart.push(newItem);
        console.log(`Added New Item: ${newItem.name}, BalanceCF: ${newItem.balanceCF}`);
        saveCart();
    }
};
 


  obj.clearCart = function () {
      cart = [];
      saveCart();
  };

  obj.removeItemFromCartAll = function (name) {
      cart = cart.filter(item => item.name !== name);
      saveCart();
  };

  obj.setCountForItem = function (name, count) {
      for (let item of cart) {
          if (item.name === name) {
              item.count = Math.max(count, 0); // Allow fractional counts, including 0
              item.balanceCF = (item.price * item.count + item.balancebroughtforward).toFixed(2); // Update balanceCF accordingly and round off
              saveCart();
              return;
          }
      }
  };

  obj.setBalanceCFForItem = function (name, newTotal) {
      for (let item of cart) {
          if (item.name === name) {
              item.balanceCF = newTotal.toFixed(2); // Round off to 2 decimal places
              saveCart();
              return;
          }
      }
  };

  obj.getPriceForItem = function (name) {
      let item = cart.find(item => item.name === name);
      return item ? item.price : 0;
  };

  obj.listCart = function () {
      let cartCopy = [];
      totalBalanceCF = 0;
      cart.forEach(item => {
          let itemCopy = { ...item };
          itemCopy.total = (item.price * item.count).toFixed(2); // Round off total to 2 decimal places
          totalBalanceCF += parseFloat(item.balanceCF);
          cartCopy.push(itemCopy);
      });
      return cartCopy;
  };

  obj.totalBalanceCF = function () {
      return totalBalanceCF.toFixed(2); // Round off totalBalanceCF to 2 decimal places
  };

  return obj;
})();

// ************************************************
// Event Handlers with Pure JavaScript
// ************************************************

// Clear cart event
document.addEventListener('click', function (event) {
  if (event.target.classList.contains('clearInvoiceItems')) {
      invoiceCart.clearCart();
      displayInvoice();
  }
});

// Delete item event
document.addEventListener('click', function (event) {
  if (event.target.classList.contains('delete-item')) {
      let name = event.target.dataset.name;
      invoiceCart.removeItemFromCartAll(name);
      displayInvoice();
  }
});

// Update item count with debouncing
const updateItemCount = debounce(function (event) {
  if (event.target.classList.contains('invoice-item-count')) {
      let name = event.target.dataset.name;
      let count = parseFloat(event.target.value) || 0; // Parse as float to allow decimals
      invoiceCart.setCountForItem(name, count);
      displayInvoice();
  }
}, 2500); // Increased delay to 500 milliseconds

// Update total price and balanceCF with debouncing
const updateTotalPrice = debounce(function (event) {
  if (event.target.classList.contains('invoiceItemTotal')) {
      let name = event.target.dataset.name;
      let newTotal = parseFloat(event.target.value) || 0; // Allow any total, even lower than current
      let price = invoiceCart.getPriceForItem(name);
      let item = invoiceCart.listCart().find(item => item.name === name); // Get the item

      if (price > 0 && item) {
          // Calculate new count based on the new total
          let newCount = newTotal / price;
          invoiceCart.setCountForItem(name, newCount);
          // Update balanceCF to be the sum of balancebroughtforward and newTotal
          let newBalanceCF = parseFloat(item.balancebroughtforward) + newTotal; // Ensure balancebroughtforward is a float
          invoiceCart.setBalanceCFForItem(name, newBalanceCF);
      }
      displayInvoice();
  }
}, 2500); // Increased delay to 500 milliseconds

// Attach the debounced events
document.addEventListener('input', function (event) {
  updateItemCount(event);
  updateTotalPrice(event);
});

// ************************************************
// Display Invoice Cart
// ************************************************
// ************************************************
// Display Invoice Cart with Totals
// ************************************************
function displayInvoice() {
  let cartArray = invoiceCart.listCart();
  let output = '';

  // Calculate totals
  let totalBalanceBroughttForward = 0;
  let totalInvoicePrices = 0;
  let totalInvoiceUnits = 0;
  let totalBilledAmounts = 0;
  let closingBalanceTotal = 0;

  cartArray.forEach(item => {
      let totalItemCost = (item.count * item.price).toFixed(2);
      totalBalanceBroughttForward += parseFloat(item.balancebroughtforward);
      totalInvoicePrices += parseFloat(item.price);
      totalInvoiceUnits += parseFloat(item.count);
      totalBilledAmounts += parseFloat(totalItemCost);
      closingBalanceTotal += parseFloat(item.balanceCF);

      output += `
      <div class="w3-col l12 m12 s12" style="float:left; padding-left:0px;">
          <div class="w3-col l4 m4 s6" style="float:left; padding-left:5px; text-align:left;">
             <b>${item.name}</b>
          </div>
          <div class="w3-col l2 m2 s2">K${item.balancebroughtforward}</div>
          <div class="w3-col l1 m1 s1 w3-hide-small">K${item.price}</div>
          <div class="w3-col l1 m1 s1 w3-hide-small">
              <input type="number" step="0.1" class="invoice-item-count" 
                     data-name="${item.name}" value="${item.count}" 
                     style="max-width:40px; border:none;background-color:transparent;">
          </div>
          <div class="w3-col l2 m2 s2">
              <input type="number" step="0.1" class="invoiceItemTotal" 
                     data-name="${item.name}" value="${totalItemCost}" 
                     style="border:none; font-size:0.8em; font-weight:600; outline:none;background-color:transparent;">
          </div>
          <div class="w3-col l2 m2 s2">K${item.balanceCF}</div>
      </div>`;
  });

  document.querySelector('.displayInvoice77').innerHTML = output;

  // Safely update totals
  const updateDiv = (selector, value) => {
      let element = document.querySelector(selector);
      if (element) element.innerHTML = 'K' + value.toFixed(2);
      else console.error(`Element with selector ${selector} not found.`);
  };

  updateDiv('.totalBalanceBroughttForward', totalBalanceBroughttForward);
  updateDiv('.totalInvoicePrices', totalInvoicePrices);
  updateDiv('.totalInvoiceUnits', totalInvoiceUnits);
  updateDiv('.totalBilledAmounts', totalBilledAmounts);
  updateDiv('.closingBalanceTotal', closingBalanceTotal);
}

// Initialize display safely
document.addEventListener('DOMContentLoaded', displayInvoice);
  

  //// CREATING INVOICE SCRIPTS
  //// CREATING INVOICE SCRIPTS
    //// CREATING INVOICE SCRIPTS
	  //// CREATING INVOICE SCRIPTS
	    //// CREATING INVOICE SCRIPTS
		  //// CREATING INVOICE SCRIPTS
		    //// CREATING INVOICE SCRIPTS

         $(document).on('click', '.createInvoice0', function(event){ 
         creatInvoice101();

         });

          function creatInvoice101(){ 
          let today = new Date().toISOString().slice(0,10).replace(/-/g, "/");
          $('#external_page_contents').empty().append('<div id="invoice_modal" class="w3-modal w3-center" style=" background-color:rgba(255,255,255,255);z-index:99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999"></div>');
          $('#invoice_modal').append('<div id="invoice_modal_div_0" style="background-color:white;height:100vh;"></div>');
        // $('#invoice_modal').append('<div class="w3-col l12 m12 s12 hideOnPrint w3-top invoiceDivActions101" style="padding:5px;color:gray;"><span class="close_invoice_modal" style="float:left;cursor:pointer;"><span class="fontx fx-x" style="font-size:1.5em;color:red;margin-top:10px;"></span> </span> <div id="createInvoiceDiv02"><span id="createInvoice02" style="float:right;cursor:pointer;margin-left:3px;"><span class="w3-card-2" style="float:right;cursor:pointer;margin-left:3px;height:35px;font-size:0.9em;padding:5px;color:white;background-color:rgba(96, 146, 205,1);;"> Create Invoice</span></span></div><span class="top-right-navigation-icons101"><span class="fontx fx-share-2" style="margin-top:10px;margin-right:10px;"></span></span> <span class="top-right-navigation-icons101 addInvoiceComment"><span class="fontx fx-edit-2" style="margin-top:10px;margin-right:10px;"></span></span><span class="top-right-navigation-icons101"><span class="fontx fx-trash-2 clearInvoiceItems" style="margin-right:7px;margin-top:10px;"></span></span></div>');
          $('#invoice_modal').append('<div class="w3-col l12 m12 s12 w3-card-2 w3-bottom invoiceDivActions101 hideOnPrint" style="height:40px;color:gray;"><span class="close_invoice_modal" style="float:left;cursor:pointer;margin-top:5px;margin-right:10px;margin-left:10px;"><span class="fontx fx-arrow-left" style="font-size:1.7em;color:var(--primary-color)"></span></span> <div id="createInvoiceDiv02"><span id="createInvoice02" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span> Create Invoice</span></span></div> <span class="top-right-navigation-icons101" style="margin-top:3px;float:left;margin-right:7px;"><span class="fontx fx-trash-2 clearInvoiceItems" style="margin-top:-10px;"></span></span><div class="top-right-navigation-icons101 fileDiv101" style="margin-top:3px;float:left;margin-right:12px;"><span class="fontx fx-file"></span><input name="depositslipfile" id="depositslipfile" type="file" /></div> <div class="top-right-navigation-icons101 addInvoiceComment" style="margin-top:3px;float:left;"><span class="fontx fx-edit-2" style="margin-top:-30px;margin-right:10px;"></span></div></div>');
         
          $('#invoice_modal_div_0').append(' <div class="w3-center w3-col l12 m12 s12 receiptTitles00"><div class="w3-center w3-col l12 m12 s12 org_logo_div"></div>');
           $('#invoice_modal_div_0').append(' <div class="w3-center w3-col l12 m12 s12"><b class="org_name" style="text-transform:uppercase"></b></div>');
          $('#invoice_modal_div_0').append('<div class="w3-center w3-col l12 m12 s12 w3-hide-small pobox"></div>');
          $('#invoice_modal_div_0').append('<div class="w3-center w3-col l12 m12 s12 w3-hide-small org_address" style="font-size: 0.7em;"></div>');
      
          //$('#invoice_modal_div_0').append('<div class="w3-center w3-col l12 m12 s12"> Phone: 0217221039.</div>');
          //$('#invoice_modal_div_0').append('<div class="w3-center w3-col l12 m12 s12"> Email: mongubilling@gmail.com.</div>');
          $('#invoice_modal_div_0').append('<div class="w3-center w3-col l12 m12 s12" style="margin-top:0px;margin-bottom:5px;color:var(--primary-color);font-size:1.6em"><b>INVOICE</b></div>');
           $('#invoice_modal_div_0').append('<div class="w3-center w3-col l12 m12 s12" style="margin-top:0px;margin-bottom:0px;"><span id="receiptTitle00" style="margin-left:12px;font-weight:400;font-size:1em">No: </span><span id="invoiceNumber" style="color:red;font-weight: 400;font-size:1em">0000</span><span id="hiddenInvoiceNumber" style="display: none;"></span>  <div id="invoiceDueDateDiv" class="w3-col l12 m12 s12" style="margin-left:5px;">Created: <input id="invoiceDueDate"  placeholder="'+today+'" value="'+today+'" style="margin-left:5px;margin-top:0px;border: none;cursor: pointer;font-size:0.9em;max-width:100px;color: black;font-weight: 400;"/> <span class="showOnPrint" style="display:none;">Printed: '+today+'</span></div></div>');
        
          $('#invoice_modal_div_0').append('<div class="w3-col l8 m8 s12 bankInvoiceDetailsDiv"><span class="w3-col l12 m12 s12 bankAccoutDiv101"><span style="float:left;color:gray;font-weight: 600;font-size:0.9em;margin-left: 7px;"><select id="bankname99" style="-moz-appearance: none;-webkit-appearance: none;appearance: none;background-image: none;text-indent: 0.01px;background-color: transparent;border: none;outline: none;color:black;text-transform:uppercase"><option>Indo Transit Account</option></select></span></span><span class="w3-col l12 m12 s12 bankAccoutDiv101"><span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:1em">A/c: </span><span id="bankAccountNumber" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;"> 0262020000045</span></span><div class="w3-col l12 m12 s12 bankAccoutDiv101"><span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:0.9em">Branch: </span><span id="bankBranch99" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;"> Mongu Branch</span></div><div class="w3-col l12 m12 s12 w3-hide-small bankAccoutDiv101"><span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:0.9em">Sort Code: </span><span id="bankSortCode99" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;"> 013151</span></div><div class="w3-col l12 m12 s12 w3-hide-small bankAccoutDiv101"><span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:0.9em">Tpin: </span><span id="bankSortCode99" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;"> 1004335069</span></div><div class="w3-center w3-col l12 m12 s12 w3-hide-small"> <span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:0.9em">Phone: </span><span id="bankSortCode99" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;"> 0217221039</span></div><div class="w3-center w3-col l12 m12 s12 w3-hide-small"> <span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:0.9em">Email: </span><span id="bankSortCode99" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;">lukulutowncouncil@gmail.com</span></div></div>');
         
          $('#invoice_modal_div_0').append('<div class="w3-col l4 m4 s12" style="padding-right: 0px;padding-left:8px;"><span class="w3-col l12 m12 s12" id="addInvoiceClientDiv" style="cursor: pointer;margin-top:0px;"> <button id="addClientToInvoice101" type="button" style="float:left;font-weight:600;color:black;height: 25px;background-color:transparent;border:none;outline:none;margin-left:-5px;">BILLED TO:</button></span><span class="w3-col l6 m6 s8 invoicedClientName0Div" style="margin-top:0px;font-weight: 600;"><span id="invoicedClientId0" class="clearOnTransactionSuccess" style="display: none;float:left;"></span><input id="invoicedClientName0" class="clearOnTransactionSuccess"  Placeholder="Client name:" type="text" style="float:left;border:none;background-color:transparent;outline:none;color:gray"/> </span><span class="w3-col l6 m6 s12" style="display:none;"><span id="invoicedClientName1" class="clearOnTransactionSuccess" style="float:left;margin-left: 3px;"></span></span><span class="w3-col l12 m12 s12 plotnumber07Div  w3-hide-small"  style="margin-top:0px;"><input id="plotnumber07" Placeholder="Plot No:" class="clearOnTransactionSuccess" type="text" style="display:none;float:left;border:none;background-color:transparent;outline:none;width:100px;"/><input id="invoicedClientAddress0" class="clearOnTransactionSuccess" Placeholder="Address:" type="address" style="float:left;border:none;background-color:transparent;outline:none;min-width:410px"/><input id="area07" Placeholder="Area" type="text" class="w3-hide-small"  style="display:none;float:left;border:none;background-color:transparent;outline:none;"/></span><div class="w3-col l12 m12 s12"  style="margin-top:0px;"><input id="tpin07" Placeholder="TPIN No:" class="w3-hide-small" type="text" style="float:left;border:none;background-color:transparent;outline:none;max-width: 150px;"/><input id="nrc07" Placeholder="Nrc No:" type="text" style="display:none;float:left;border:none;background-color:transparent;outline:none;max-width: 150px;"/> </span><span class="w3-col l12 m12 s4 invoicedClientEmail0Div"  style="margin-top:0px;"><input id="invoicedClientEmail0" class="w3-hide-small" Placeholder="Email:" type="email"  style="float:left;border:none;background-color:transparent;outline:none;min-width:250px;"/></span><span class="w3-col l12 m12 s4 invoicedClientPhone0Div"  style="margin-top:0px;"><input id="invoicedClientPhone0" placeholder="Phone Number:" type="number" style="float:left;border:none;background-color:transparent;outline:none;max-width: 130px;-webkit-appearance: none;appearance: none;background-image: none;text-indent: 0.01px;"/></span></div>');
          $('#invoice_modal_div_0').append('<div class="inner-data-div w3-col l12 m12 s12" style="margin-top:20px;background-color:var(--primary-color-transparent2);font-weight:600;"><div class="w3-col l4 m4 s6"><span id="addProductToInvoice101" style="padding:7px;cursor:pointer;">Product/Account<span class="fontx fx-plus"></span></span></div><div class="w3-col l2 m2 s2"><span class="w3-hide-large w3-hide-medium">BBF</span><span class="w3-hide-small">Balance BF</span></div><div class="w3-col l1 m1 s1 w3-hide-small">Price</div><div class="w3-col l1 m1 s1 w3-hide-small">Units</div><div class="w3-col l2 m2 s2">Bill</div><div class="w3-col l2 m2 s2"><span class="w3-hide-small">Closing Balance</span><span class="w3-hide-large w3-hide-meddium">C. Bal</span></div></div>');
           $('#invoice_modal_div_0').append('<div class="displayInvoice77 inner-data-div w3-col l12 m12 s12" style="margin-top:0px;background-color:var(--primary-color-transparent);padding-left:7px;"></div>');
           $('#invoice_modal_div_0').append('<div class="inner-data-div w3-col l12 m12 s12" style="margin-top:0px;background-color:var(--primary-color-transparent1);font-weight:600;border-bottom:1px solid gray"><div class="w3-col l4 m4 s4"><span style="padding:7px;cursor:pointer;"><b>Totals: </b></span></div><div class="w3-col l2 m2 s3 totalBalanceBroughttForward">00</div><div class="w3-col l1 m1 s1 totalInvoicePrices w3-hide-small" style="color:transparent">00</div><div class="w3-col l1 m1 s1 totalInvoiceUnits w3-hide-small" style="color:transparent">00</div><div class="w3-col l2 m2 s3 totalBilledAmounts">00</div><div class="w3-col l2 m2 s2 closingBalanceTotal">00</div></div>');
          $('#invoice_modal_div_0').append('<div class="w3-col l12 m12 s12 commentDiv101" style="display:none;"><textarea id="comment101" placeholder="Write your comment here..."></textarea></div>');
           $('#invoice_modal_div_0').append('<p class="w3-col l12 m12 s12"><span class="w3-col l6 m6 s12"style="float:left;margin-top: 0px;">Prepared by: <span class="preparedBy" style="color:gray"></span></span><span class="w3-col l6 m6 s12 w3-hide-small" style="float:left;margin-top: 0px;"> Signature: <span id="agentSignature" style="color:gray">______________________</span</span></p>');
          
 
         
           $('#invoice_modal').append('<div id="invoice_modal_div_1" style="display:none;background-color:white;height:100vh;marg-top:-100px;padding:5px;"></div>');
          $('#invoice_modal').fadeIn('slow');
          invoiceCart.clearCart();

          //fetch bank details
          $.getJSON('xd-modules/agent-module/backend/getBankAccounts.php',function(data){
            $('#bankname99').empty();
            $.each(data.details, function(i,cyberdesk) {
            $('#bankname99').append('<option value="'+cyberdesk.account_name+'" data-accountnumber="'+cyberdesk.account_number+'" data-sortcode="'+cyberdesk.sort_code+'" data-branch="'+cyberdesk.branch+'">'+cyberdesk.account_name+'</option>');
            });
             
            });
           ///fetching user data from the database
        getUserFromIndexedDB()  // Retrieve user data from IndexedDB the script is in mainScript.js
        .then((userData) => {
            if (userData.length > 0) {
                const user = userData[0]; // Assuming the first user record is the relevant one
    
                // Update the UI elements with user data 
                $('.org_name').empty().append(user.orgname);              
                $('.org_email').empty().append(user.org_email);
                $('.org_contacts').empty().append(user.org_contacts);
                $('.org_address').empty().append(user.org_address); 
                $('.pobox').empty().append(user.org_p_o_box);
                $('.preparedBy').empty().append(user.username); 
    
                // Check if the user has an org logo stored as a Blob
                if (user.org_logo) {
                    // Convert Blob to a URL that can be used in the `img` element
                    const logoURL = URL.createObjectURL(user.org_logo);
    
                    // Create an img element and set its source to the Blob URL
                    const imgElement = $('<img>', {
                        src: logoURL,  // Set the image source (Blob URL)
                        alt: 'Organization Logo', // Alt text for the image
                        class: 'org_logo',   // Optional: Add a class for styling
                    });
    
                    // Append the image to the DOM
                    $('.org_logo_div').empty().append(imgElement); // Assuming there's a container with class 'org-logo-container'
                } else {
                    console.error('No organization logo found in user data.');
                }
                
                // console.log('User data successfully displayed while offline:', user);
            } else {
                // console.error('No user data found in IndexedDB while offline.');
            }
        })
        .catch((error) => {
            console.error('Error retrieving user data from IndexedDB:', error);
        }); 

          }

       

        ///adding and remnoving the comment on the invoice or receipt
      $(document).on('click', '.addInvoiceComment', function(event){
       $('.commentDiv101').fadeIn('slow');
       $('.addInvoiceComment').addClass("removeInvoiceComment");
       $('.addInvoiceComment').empty().append('<span class="fontx fx-edit-2" style="margin-top:-20px;margin-right:10px;color:green;"></span>');
        });

        $(document).on('click', '.removeInvoiceComment', function(event){
       $('.commentDiv101').fadeOut('slow');
       $('.addInvoiceComment').removeClass("removeInvoiceComment").empty().append('<span class="fontx fx-edit-2" style="margin-top:-20px;margin-right:10px;"></span>');
        });

        // CHANGE BANK DETAILS ON CHANGE
        $(document).on('change keyup','#bankname99',function (event) {
          var accountnumber = document.querySelector("#bankname99 option:checked").dataset.accountnumber;
          var sortcode = document.querySelector("#bankname99 option:checked").dataset.sortcode;
          var branch = document.querySelector("#bankname99 option:checked").dataset.branch;
          $('#bankAccountNumber').empty().append(accountnumber);
          $('#bankSortCode99').empty().append(sortcode);
          $('#bankBranch99').empty().append(branch);
        });
        // closing the invoice_modal
        
        $(document).on('click', '.close_invoice_modal', function(event){
           $('#invoice_modal').fadeOut('slow'); 
            $('#invoice_statement_modal').fadeIn('slow');
        });
    
        // end of closing the invoice_modal
        
       
// CLOSING invoice_modal_div_0    
  $(document).on('click', '.close_invoice_modal_div_1', function (event) {
    // Loop through all checked checkboxes inside #invoice_modal_div_2
    $('#invoice_modal_div_0').fadeIn('slow'); 
    $('.invoiceDivActions101').fadeIn('slow');
    $('#invoice_modal_div_1').fadeOut('slow'); 
  
});
// END OF CLOSING invoice_modal_div_0

        // adding client to invoice
        $(document).on('click','#addClientToInvoice101',function (event) {
          addClientToInvoice101();
          });


    function addClientToInvoice101() {
           $('#invoice_modal_div_0').fadeOut('slow'); 
           $('.invoiceDivActions101').fadeOut('slow');
           $('#invoice_modal_div_1').fadeIn('slow'); 
           $('#invoice_modal_div_1').empty().append('<div class="w3-col l12 m12 s12 w3-top w3-card-2" style="background-color:#fff;height:40px;line-height:40px;"><div class="close_invoice_modal_div_1 w3-col l1 m1 s1" style="padding-top: 5px;cursor:pointer;"><span class="fontx fx-arrow-left" style="font-size:1.7em;color:var(--primary-color)"></span></div><div class="w3-col l10 m10 s10" style="color:rgba(96, 146, 205,1);font-weight:600;"><div class="w3-col l12 m12 s12 w3-center" style="margin-top:0px;"><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-search" style="color:rgba(0,0,0,0.3);font-size:1.5em"></span></div><div class="w3-col l10 m10 s10 w3-center"><input class="searchUsersForInvoicing77" type="text" placeholder="Search clients..." style="font-weight:400;outline:none;color:gray;border:none;border-bottom:none;width:100%;height:30px;background-color:transparent;padding-left:7px;"/></div><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-filter" style="color:rgba(0,0,0,0.3);font-size:1.3em"></span></div></div></div><div class="w3-col l1 m1 s1" style="padding-top: 5px;"><span class="fontx fx-more-vertical" style="color:rgba(96, 146, 205,1);font-size:1.3em;"></span></div></div>');
         
          $('#invoice_modal_div_1').append('<div id="invoice_modal_div_2" style="margin-top:50px"></div>');
          $('#invoice_modal_div_2').empty().append('<center><div class="body-loader"></div><br/></center>');
           
           
            $.getJSON('xd-modules/agent-module/backend/allClients.php',function(data){
        
            $('#invoice_modal_div_2').empty();
            $.each(data.freelancedetails, function(i,cyberdesk) {
             
            //  $('#invoice_modal_div_2').append('<div class="inner-data-div w3-col l12 m12 s12" id="addClientToInvoice1" data-address="'+freelance.address+'" data-id="'+freelance.id+'" data-phone="'+freelance.phone+'" data-email="'+freelance.email+'" data-names="'+freelance.names+'" data-businesscategory="'+freelance.business_category+'" data-pacra="'+freelance.company_registration_number+'" data-tpin="'+freelance.tpin+'" data-nrc="'+freelance.nrc+'" data-plotnumber="'+freelance.plot_number+'" data-area="'+freelance.area+'" style="font-weight:400;border-bottom:1px solid #eee;cursor:pointer"><div class="w3-col l12 m12 s9"><span class="w3-col l5 m5 s12" style="padding-left:7px;font-weight:600;color:black;"><span class="w3-col l12 m12 s12">'+freelance.org_name+' <span class="fontx fx-user" style="color:gray;"> '+freelance.names+'</span></span></span><span class="w3-col l3 m3 s12" style="padding-left:7px;"><span class="w3-col l6 m6 s6"> <span class="fontx fx-phone"></span> '+freelance.phone+' </span><span class="w3-col l6 m6 s6"> <spa class="fontx fx-credit-card1"></spa> '+freelance.nrc+'</span></span><span class="w3-col l4 m4 s12" style="padding-left:3px;"><span class="w3-col l6 m6 s6">Pacra: <span style="color: rgba(96, 146, 205,1);"> '+freelance.company_registration_number+'</span></span><span class="w3-col l6 m6 s6">Tpin: <span style="color: rgba(96, 146, 205,1);"> '+freelance.tpin+'</span></span></span></div></div>');
               $('#invoice_modal_div_2').append('<div class="inner-data-div w3-col l12 m12 s12" id="addClientToInvoice1" data-address="'+cyberdesk.address+'" data-id="'+cyberdesk.id+'" data-phone="'+cyberdesk.phone+'" data-email="'+cyberdesk.email+'" data-names="'+cyberdesk.names+'" data-businesscategory="'+cyberdesk.category_name+'" data-pacra="'+cyberdesk.company_registration_number+'" data-tpin="'+cyberdesk.tpin+'" data-nrc="'+cyberdesk.nrc+'" data-plotnumber="'+cyberdesk.plot_number+'" data-area="'+cyberdesk.area+'"><div class="w3-col l12 m12 s12"><span class="w3-col l4 m4 s10" style="padding-left:7px;font-weight:600;color:gray;"><img src="'+cyberdesk.avatar+'" style="height:22px;width:22px;border-radius:5px;margin-top:2px;"/> <span>'+cyberdesk.names+'</span> <a href="https://wa.me/26'+cyberdesk.phone+'"  target="_blank" class="w3-hide-large w3-hide-medium" style="text-decoration:none;font-weight:200;float:right;">'+cyberdesk.phone+'</a></span><span class="w3-col l2 m2 s4 w3-hide-small" style="padding-left:5px;color:#6092cd"><a href="https://wa.me/26'+cyberdesk.phone+'"  target="_blank" style="text-decoration:none;margin-right:10px;"><img src="xd-assets/img/whatsApp_icon.png"style="height:15px;width:15px;"/> '+cyberdesk.phone+'</a></span></span><span class="w3-col l3 m3 s7 w3-hide-small"><span class="fontx fx-mail" style="margin-left:5px;"></span> <span style="cursor:pointer;color:var(--primary-color);"> '+cyberdesk.email+'</span></span><span class="w3-col l2 m2 s12 w3-hide-small"> '+cyberdesk.nrc+'</span><span class="w3-col l1 m1 s2"><select class="innerDivClientSelectKey inner-data-more-actions"><option value="select-actions">Select Action</option><option value="view-more-details"  data-id="'+cyberdesk.id+'" data-avatar="'+cyberdesk.avatar+'" data-name="'+cyberdesk.names+'" data-email="'+cyberdesk.email+'" data-phone="'+cyberdesk.phone+'" data-address="'+cyberdesk.address+'" data-area="'+cyberdesk.depot_name+'"  data-depotid="'+cyberdesk.depot_id+'" data-pacra="'+cyberdesk.company_registration_number+'" data-tpin="'+cyberdesk.tpin+'" data-status="'+cyberdesk.status+'" data-businesscategory="'+cyberdesk.business_category+'" data-businesscategoryname="'+cyberdesk.category_name+'" data-usertype="'+cyberdesk.user_type+'" data-nrc="'+cyberdesk.nrc+'">Account Details</option><option value="client-invoices" data-id="'+cyberdesk.id+'" data-name="'+cyberdesk.names+'">Invoices</option><option value="client-products" data-id="'+cyberdesk.id+'" data-name="'+cyberdesk.names+'">Products/Services</option><option value="client-statemnts">View Statements</option><option value="send-email">Send Email</option><option value="send-whatsapp">WhatsApp</option></select><input type="checkbox" name="invoicecheckbox101" class="inner-data-checkbox hideOnPrint" value="'+cyberdesk.id+'" data-phone="'+cyberdesk.phone+'" data-names="'+cyberdesk.names+'" data-email="'+cyberdesk.email+'"/></div></div>');
			
              
            });
         
          });
        
        };

         
        
        $(document).on('click','#addClientToInvoice1',function (event) { 
         $('#invoice_modal_div_0').fadeIn('slow'); 
          $('.invoiceDivActions101').fadeIn('slow');
          $('#invoice_modal_div_1').fadeOut('slow');
          var id = $(this).data('id');  
          var names = $(this).data('names'); 
           var address = $(this).data('address');
           var email = $(this).data('email'); 
           var phone = $(this).data('phone'); 
           var pacra =$(this).data('pacra');
           var tpin =$(this).data('tpin');
           var nrc = $(this).data('nrc'); 
           var area =$(this).data('pacra');
           var plotnumber =$(this).data('plotnumber');
           var businessCategory=$(this).data('businesscategory');
           //var plotnumber =$(this).data('tpin');
           $('#invoicedClientId0').empty();
           $('#invoicedClientId0').append(id);
           document.getElementById('invoicedClientName0').vallue='';
           document.getElementById('invoicedClientName0').value=names;
           $('#invoicedClientName1').empty();
           $('#invoicedClientName1').append(names);
           document.getElementById('invoicedClientAddress0').value='';
           document.getElementById('invoicedClientAddress0').value=address;
           document.getElementById('plotnumber07').value='';
           document.getElementById('plotnumber07').value= plotnumber;
           document.getElementById('area07').value='';
           document.getElementById('area07').value=area;
           document.getElementById('nrc07').vallue='';
           document.getElementById('nrc07').vallue=nrc;
           document.getElementById('invoicedClientEmail0').value='';
           document.getElementById('invoicedClientEmail0').value=email;
            $('#invoicedClientId0').empty();
           $('#invoicedClientId0').append(id);
           $('#pacra00').empty();
           $('#pacra00').append(pacra); 
           document.getElementById('tpin07').value='';
           document.getElementById('tpin07').value=tpin;
            $('#businesscategory00').empty();
           $('#businesscategory00').append(businessCategory);
          document.getElementById('invoicedClientPhone0').value ='';
          document.getElementById('invoicedClientPhone0').value = phone;
            
        });
        // end of adding client to invoicee
        
        // add client to invoice
        
        $(document).on('click','#addProductToInvoice101',function (event) {
          addProductToInvoice();
          });


          function addProductToInvoice() {	
          
          var userid = parseInt(document.getElementById('invoicedClientId0').textContent, 10);
        
          if (!isNaN(userid)) {
            $('#invoice_modal_div_0').fadeOut('slow'); 
            $('.invoiceDivActions101').fadeOut('slow');
            $('#invoice_modal_div_1').empty().fadeIn('slow'); 
             
            $('#invoice_modal_div_1').append('<div class="w3-col l12 m12 s12 w3-card-2 w3-top" style="background-color:#fff;height:40px;line-height:40px;"><div class="close_invoice_modal_div_1 w3-col l1 m1 s1" style="padding-top: 5px;cursor:pointer;"><span class="fontx fx-arrow-left" style="font-size:1.7em;color:var(--primary-color)"></span></div><div class="w3-col l9 m9 s9" style="color:rgba(96, 146, 205,1);font-weight:600;"><div class="w3-col l12 m12 s12 w3-center" style="margin-top:0px;"><div class="w3-col l1 m1 s1 w3-center" style="padding-top: 5px;"><span class="fontx fx-search" style="color:rgba(0,0,0,0.3);font-size:1.5em"></span></div><div class="w3-col l10 m10 s10 w3-center"><input class="searchProductsToAddToInvoice77" type="text" placeholder="Search & add items to cart..." style="font-weight:400;outline:none;color:gray;border:none;border-bottom:none;width:100%;height:30px;background-color:transparent;padding-left:7px;"/></div><div class="w3-col l1 m1 s1 w3-center" style="display:none;padding-top: 5px;"><span class="fontx fx-filter" style="color:rgba(0, 0, 0,0.3);font-size:1.3em"></span></div></div></div><div class="w3-col l2 m2 s2" style="padding-top: 0px;"><a href="#" id="cart-btn" style="text-decoration:none;outline:none;background-color:transparent;color:rgba(96, 146, 205,1);padding-top:0px;font-size:1.3em;margin-top:5px;float:right;"><span id="cart-count0" class="total-count w3-col l12 m12 s12" style="color:white;margin-left:22px;line-height:12px;height:14px;width:14px;background-color:orange;border-radius:50%;font-size:0.4em;padding-left:0px;padding-top:1px;">0</span><span class="fontx fx-shopping-cart w3-col l12 m12 s12" style="margin-top:-5px;margin-left:0px;"></span></a></div>');
            $('#invoice_modal_div_1').append('<div id="invoice_modal_div_2" class="w3-col l12 m12 s12" style="margin-top:50px;"></div>');
            $('#invoice_modal_div_2').empty().append('<center><div class="body-loader"></div><br/></center>');
            
           
            datastring='userid='+userid;			  
            
            $.ajax({         
              data:datastring,
              url: "xd-modules/billing-module/billing/backend/getProductsToAddToInvoice.php",
              type: "POST"
             }).done (function(data) {
              var details = JSON.parse(data);
              $('#invoice_modal_div_2').empty();
             $.each(details.details, function(i,freelance) {
  // Append your product dynamically
  $('#invoice_modal_div_2').append(`
    <div class="inner-data-div w3-col l4 m6 s12" id="addProductToInvoice102" style="cursor:pointer; padding-left:7px; margin-top:3px;">
        <div class="w3-col l2 m2 s2">
            <img src="xd-assets/img/logo.png" style="height:45px; width:45px; margin-left:-7px;border-radius:50%;" />
        </div>
        <div class="w3-col l9 m9 s9">
            <b style="color:black; float:left;" class="w3-col l12 m12 s12">${freelance.name}</b>
            <span class="w3-col l12 m12 s12">K${freelance.price}</span>
        </div>
        <div class="w3-col l1 m1 s1">
            <input type="checkbox" class="addProductToInvoiceCheckbox" style="display:none;"
                   data-id="${freelance.id}" 
                   data-name="${freelance.name}" 
                   data-balancebroughtforward="${freelance.balancebroughtforward}" 
                   data-price="${freelance.price}" 
                   data-chargerate="${freelance.charge_rate}" 
                   data-description="${freelance.description}" 
                   data-productcode="${freelance.product_code}" 
                   data-category="${freelance.category}" 
                   data-categorycode="${freelance.category_code}" 
                   data-depot="${freelance.area}" 
                   data-depotid="${freelance.depot_id}" 
                   data-depotcode="${freelance.area_code}" 
                   style="background-color:rgba(96, 146, 205, 1); color:#fff; float:right; margin-right:10px; padding: 5px; border-radius:4px; cursor:pointer;" />
        </div>
    </div>
  `); 
            
            });
        
             $('#invoice_modal_div_1').append('<div class="close_invoice_modal_div_1 w3-bottom w3-hide-large" style="position:fixed;height:40px;width:100%;color:#fff;background-color:rgba(96, 146, 205,1);line-height:40px;cursor: pointer;font-weight:600;">PROCEED <span class="fontx fx-arrow-right"></span></div></div>');
            
            });
        
        
        
          }else{
        
            alert('Please add client to invoice before selecting products');
          }
        
        };
        

        // search products or chart of A/C
$(document).on('change keyup','.searchProductsToAddToInvoice77',function (event) {
	event.preventDefault(); 
  event.stopPropagation();  
  if($(".searchProductsToAddToInvoice77").val()=='') {	
	//addInvoicedItem();
  } else{
  var userid = parseInt(document.getElementById('invoicedClientId0').textContent, 10);
	 var searchKey = $(".searchProductsToAddToInvoice77").val(); 
	 datastring='searchKey='+searchKey+'&userid='+userid;
	
   $('#invoice_modal_div_2').empty().append('<center><div class="body-loader"></div><br/></center>');
          
	 $.ajax({
				  
		   data:datastring,
	     url: "xd-modules/billing-module/billing/backend/searchProductsToAddToInvoice.php",
		   type: "POST"
	   
	  }).done (function(data) {
 
	  var details0 = JSON.parse(data);
    $('#invoice_modal_div_2').empty();
          
	$.each(details0.details, function(i,freelance) {
  // Append your product dynamically
$('#invoice_modal_div_2').append(`
  <div class="inner-data-div w3-col l4 m6 s12" id="addProductToInvoice102" style="cursor:pointer; padding-left:7px; margin-top:3px;">
      <div class="w3-col l2 m2 s2">
          <img src="xd-assets/img/logo.png" style="height:45px; width:45px; margin-left:-7px;border-radius:50%;" />
      </div>
      <div class="w3-col l9 m9 s9">
          <b style="color:black; float:left;" class="w3-col l12 m12 s12">${freelance.name}</b>
          <span class="w3-col l12 m12 s12">K${freelance.price}</span>
      </div>
      <div class="w3-col l1 m1 s1">
          <input type="checkbox" class="addProductToInvoiceCheckbox" style="display:none;"
                 data-id="${freelance.id}" 
                 data-name="${freelance.name}" 
                 data-balancebroughtforward="${freelance.balancebroughtforward}" 
                 data-price="${freelance.price}" 
                 data-chargerate="${freelance.charge_rate}" 
                 data-description="${freelance.description}" 
                 data-productcode="${freelance.product_code}" 
                 data-category="${freelance.category}" 
                 data-categorycode="${freelance.category_code}" 
                 data-depot="${freelance.area}" 
                 data-depotid="${freelance.depot_id}" 
                 data-depotcode="${freelance.area_code}" 
                 style="background-color:rgba(96, 146, 205, 1); color:#fff; float:right; margin-right:10px; padding: 5px; border-radius:4px; cursor:pointer;" />
      </div>
  </div>
`);      
	  });
	 
	}); 	
	
	

  } 
  
		  
});
// end of search products or chart of A/C

        //// Event for adding items to the invoice
        
   // Listen for changes on checkboxes
   $(document).on('click', '#addProductToInvoice102', function (event) {
    // Locate the checkbox inside the clicked div
    const checkbox = $(this).find('input[type="checkbox"]');
    
    // Toggle the checkbox state
    checkbox.prop('checked', !checkbox.prop('checked'));

      // Toggle background color based on checkbox state
      if (checkbox.is(':checked')) {
        $(this).css('background-color', 'rgba(96, 146, 205,0.3)'); // Add green background when checked
    } else {
        $(this).css('background-color', ''); // Remove background color when unchecked
    }
    // Retrieve data attributes from the checkbox
    const name = checkbox.data('name');
    const category = checkbox.data('category');
    const price = parseFloat(checkbox.data('price')) || 0;
    const charge_rate = checkbox.data('chargerate');
    const id = checkbox.data('id');
    const categorycode = checkbox.data('categorycode');
    const productcode = checkbox.data('productcode');
    const depot = checkbox.data('depot');
    const depotid = checkbox.data('depotid');
    const depotcode = checkbox.data('depotcode');
    const balancebroughtforward = parseFloat(checkbox.data('balancebroughtforward')) || 0;

    // Verify checkbox state and add/remove item accordingly
    if (checkbox.is(':checked')) {
        // Add item to cart
        invoiceCart.addItemToCart(
            name, price, charge_rate, 1, id, productcode,
            category, categorycode, depot, depotid, depotcode, balancebroughtforward
        );
        console.log(`Item added: ${name}`);
    } else {
        // Remove item from cart
        invoiceCart.removeItemFromCartAll(name);
        console.log(`Item removed: ${name}`);
    }

    // Refresh the invoice display
    displayInvoice();
});

        
        
        $(document).on('click', '#createInvoice02', function(event){
          event.preventDefault();
          event.stopPropagation(); 
          var amount = $('.total-cart').html();
          var userid = $("#invoicedClientId0").html();
          var fname = $("#invoicedClientName0").val();
          var lname =  $("#invoicedClientName1").html();
          var email = $("#invoicedClientEmail0").val();
          var productid = $("#productid").html();
          var deliveryaddress = $("#invoicedClientAddress0").val();
          var pacra = $("#pacra00").html(); 
          var tpin = $("#tpin07").val(); 
          var businessCategory = $("#businesscategory00").html();
          var plotnumber = $("#plotnumber07").val(); 
          var area = $("#area07").val(); 
          var nrc = $("#nrc07").val(); 
          var phone =  $("#invoicedClientPhone0").val();
          var invoiceNumber= $("#invoiceNumber").html();
          var invoiceDueDate= $("#invoiceDueDate").val();
           var comment= $("#comment101").val();
          var deliverylat = $('#lat0').val();
          var deliverylng = $('#lng0').val();   
          var cartlist = invoiceCart.listCart();
          var cartlistDetails = JSON.stringify(cartlist);
          $('#createInvoiceDiv02').empty().append('<span style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:rgba(96, 146, 205,1);"><span> Processing...</span></span>');
         
          if(phone != '' && cartlistDetails != '' && userid !='')
           {
            datastring='userid='+userid+'&phone='+phone+'&fname='+fname+'&lname='+lname+'&email='+email+'&orderDetails='+cartlistDetails+'&amount='+amount+'&deliverylat='+deliverylat+'&deliverylng='+deliverylng+'&deliveryaddress='+deliveryaddress+'&invoiceNumber='+invoiceNumber+'&invoiceDueDate='+invoiceDueDate+'&productid='+productid+'&businessCategory='+businessCategory+'&pacra='+pacra+'&tpin='+tpin+'&plotnumber='+plotnumber+'&area='+area+'&nrc='+nrc+'&comment='+comment;
           
           $.ajax({    
             data:datastring,
           url: "xd-modules/billing-module/billing/backend/createInvoice.php",
             type: "POST"	
           
           }).done (function(data) {
          var response = JSON.parse(data);
          //alert(response.status);
          if(response.status=='created'){
            allInvoices();
            
           $(".invoiceDivActions101").hide();
           $('#invoiceNumber').empty();
           $('#invoiceNumber').append(response.receiptnumber);
          document.getElementById('invoiceDueDate').value ='';
          document.getElementById('invoiceDueDate').value =response.date;
         // document.getElementById('trasactionTime34').value = '';
         // document.getElementById('trasactionTime34').value = response.time;
          $('#createInvoiceDiv02').empty().append('<span style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:var(--active-color);"><span> Created</span></span>');
         $('.printReceiptBtn102').fadeIn('slow');


            setTimeout(function(){ 
            window.print(); 
              $('#createInvoiceDiv02').empty().append('<span style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:var(--active-color);"><span> Sending email...</span></span>');
       
            // Use jsPDF and html2canvas to capture and create the PDF
            // Use jsPDF and html2canvas to capture and create the PDF
            // Use jsPDF and html2canvas to capture and create the PDF
            // Only run on larger devices (e.g., screen width greater than 768px)
            if (window.innerWidth > 768) {
            html2canvas(document.querySelector("#invoice_modal_div_0")).then(canvas => {
            let imgData = canvas.toDataURL('image/png');
            let pdf = new jsPDF('p', 'pt', 'a4');
            pdf.addImage(imgData, 'PNG', 20, 20, canvas.width / 2, canvas.height / 2);

            // Convert to blob to send to server
            let pdfBlob = pdf.output('blob');

            // Prepare FormData to send the file
            let formData = new FormData();
            formData.append("pdfFile", pdfBlob, "invoice.pdf");
            formData.append("invoiceNumber", response.receiptnumber); // Include invoice number if needed
            formData.append("email", email); // Include email if you want to send it
            formData.append("firstname", fname);
            formData.append("lastname", lname);

            // AJAX call to send to server
            $.ajax({
            url: 'xd-modules/billing-module/billing/backend/sendInvoicePDF.php',
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(pdfResponse) {
            alert('PDF Invoice sent to ' + email + '');
            console.log("PDF sent response:", pdfResponse);
            $('#createInvoiceDiv02').empty().append('<span style="float:right;cursor:pointer;margin-left:3px;"><span class="w3-card-2" style="font-size:0.9em;padding:5px;background-color:green;color:white;">Email Sent!</span></span>');
            setTimeout(function() { 
            $('#createInvoiceDiv02').fadeOut('slow');
            $(".invoiceDivActions101").show();
            }, 700);
            },
            error: function(error) {
            console.error("Error sending invoice:", error);
            }
            });
            });
            } else {
            console.log("Not running on mobile or small device.");
            }
            // end of Use jsPDF and html2canvas to capture and create the PDF
            // end of  Use jsPDF and html2canvas to capture and create the PDF
            setTimeout(function(){ 
            $(".invoiceDivActions101").show();
            }, 700);

            }, 200);
           

              setTimeout(function(){ 
                creatInvoice101();
            $(".invoiceDivActions101").show(); 
            $('#createInvoiceDiv02').empty().append('<span id="createInvoice02" style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:var(--primary-color);"><span> Create Invoice</span></span>');
          //  $('#invoice_modal').fadeOut('slow'); 
            }, 700);

           
          
    
          }else{

            //$('#createInvoiceDiv02').empty().append('<span style="float:right;cursor:pointer;margin-left:3px;"><span class="w3-card-2" style="font-size:0.9em;padding:5px;background-color:red;color:white;">Failed!</span></span>');
            $('#createInvoiceDiv02').empty().append('<span style="float:right;cursor:pointer;margin-left:3px;height:40px;font-size:0.9em;padding:10px;color:white;background-color:var(--warning-color);"><span> Fsiled try again!</span></span>');
       
          }
           //console.log(newdata.transactionReference);   
          }); 	
          
          }
          else
          {
           //location.reload();
            alert('Please enter phone number and nrc!');
          }
          
          
          }); 
          
          //// end of CREATE INVOICE
           //// end of CREATE INVOICE
            //// end of CREATE INVOICE
           //// end of CREATE INVOICE
            //// end of CREATE INVOICE 
            //// end of CREATE INVOICE
             //// end of CREATE INVOICE


        //// DISPLAYING INVOICE
       //triger function is in invoicePaymentCart.js
      function  viewInvoice(clientname,phone,email,address,userid,pacra,plotnumber,area,nrc,tpin,businessCategory,dudate,invoicenumber){

      let today = new Date().toISOString().slice(0,10).replace(/-/g, "/");

      $('#external_page_contents').empty().append('<div id="invoice_modal" class="w3-modal w3-center" style=""></div>');
      $('#invoice_modal').append('<div id="invoice_modal_div_0" style="background-color:white;height:100vh;"></div>');

      $('#invoice_modal_div_0').append(' <div class="w3-center w3-col l12 m12 s12 receiptTitles00"><div class="w3-center w3-col l12 m12 s12 org_logo_div"></div>');
      $('#invoice_modal_div_0').append(' <div class="w3-center w3-col l12 m12 s12"><b class="org_name" style="text-transform:uppercase"></b></div>');
      $('#invoice_modal_div_0').append('<div class="w3-center w3-col l12 m12 s12 w3-hide-small pobox"></div>');
      $('#invoice_modal_div_0').append('<div class="w3-center w3-col l12 m12 s12 w3-hide-small org_address" style="font-size: 0.7em;"></div>');


      $('#invoice_modal_div_0').append('<div class="w3-center w3-col l12 m12 s12" style="margin-top:20px;margin-bottom:5px;color:var(--primary-color);font-size:1.6em"><b>INVOICE</b></div>');
      $('#invoice_modal_div_0').append('<div class="w3-center w3-col l12 m12 s12" style="margin-top:0px;margin-bottom:30px;"><span id="receiptTitle00" style="margin-left:12px;font-weight:400;font-size:1em">No: </span><span id="invoiceNumber" style="color:red;font-weight: 400;font-size:1em">'+invoicenumber+'</span><span id="hiddenInvoiceNumber" class="clearOnTransactionSuccess" style="display: none;">'+invoicenumber+'</span>  <div id="invoiceDueDateDiv" class="w3-col l12 m12 s12" style="margin-left:5px;">Created: <input id="invoiceDueDate"  placeholder="" value="" style="margin-left:5px;margin-top:0px;border: none;cursor: pointer;font-size:0.9em;max-width:100px;color: black;font-weight: 400;"/> <span class="showOnPrint" style="display:none;">Printed: '+today+'</span></div></div>');

      $('#invoice_modal_div_0').append('<div class="w3-col l7 m7 s12 bankInvoiceDetailsDiv"><span class="w3-col l12 m12 s12 bankAccoutDiv101"><span style="float:left;color:gray;font-weight: 600;font-size:0.9em;margin-left: 7px;"><select id="bankname99" style="-moz-appearance: none;-webkit-appearance: none;appearance: none;background-image: none;text-indent: 0.01px;background-color: transparent;border: none;outline: none;color:black;text-transform:uppercase"><option>Indo Transit Account</option></select></span></span><span class="w3-col l12 m12 s12 bankAccoutDiv101"><span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:1em">A/c: </span><span id="bankAccountNumber" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;"> 0262020000045</span></span><div class="w3-col l12 m12 s12 bankAccoutDiv101"><span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:0.9em">Branch: </span><span id="bankBranch99" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;"> Mongu Branch</span></div><div class="w3-col l12 m12 s12 w3-hide-small bankAccoutDiv101"><span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:0.9em">Sort Code: </span><span id="bankSortCode99" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;"> 013151</span></div><div class="w3-col l12 m12 s12 w3-hide-small bankAccoutDiv101"><span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:0.9em">Tpin: </span><span id="bankSortCode99" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;"> 1004335069</span></div><div class="w3-center w3-col l12 m12 s12 w3-hide-small"> <span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:0.9em">Phone: </span><span id="bankSortCode99" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;"> 0217221039</span></div><div class="w3-center w3-col l12 m12 s12 w3-hide-small"> <span style="margin-left:12px;float:left;color:black;font-weight:400;font-size:0.9em">Email: </span><span id="bankSortCode99" style="float:left;color:gray;font-weight: 400;font-size:0.9em;margin-left: 7px;">mongubilling@gmail.com</span></div></div>');

      $('#invoice_modal_div_0').append('<div class="w3-col l5 m5 s12" style="padding-right: 0px;padding-left:8px;"><span class="w3-col l12 m12 s12" id="addInvoiceClientDiv" style="cursor: pointer;margin-top:0px;"> <button id="addClientToInvoice101-0" type="button" style="float:left;font-weight:600;color:black;height: 25px;background-color:transparent;border:none;outline:none;margin-left:-5px;">BILLED TO:</button></span><span class="w3-col l6 m6 s8 invoicedClientName0Div" style="margin-top:0px;font-weight: 600;"><span id="invoicedClientId0" class="clearOnTransactionSuccess" style="display: none;float:left;"></span><input id="invoicedClientName0" class="clearOnTransactionSuccess"  Placeholder="'+clientname+'" type="text" style="float:left;border:none;background-color:transparent;outline:none;color:gray" readonly/> </span><span class="w3-col l6 m6 s12" style="display:none;"><span id="invoicedClientName1" class="clearOnTransactionSuccess" style="float:left;margin-left: 3px;">'+clientname+'</span></span><span class="w3-col l12 m12 s12 plotnumber07Div  w3-hide-small"  style="margin-top:0px;"><input id="plotnumber07" Placeholder="Plot No:" class="clearOnTransactionSuccess" type="text" style="display:none;float:left;border:none;background-color:transparent;outline:none;width:100px;" readonly/><input id="invoicedClientAddress0" class="clearOnTransactionSuccess" Placeholder="Address:" type="address" style="float:left;border:none;background-color:transparent;outline:none;min-width:410px" readonly/><input id="area07" Placeholder="Area" type="text" class="w3-hide-small clearOnTransactionSuccess"  style="display:none;float:left;border:none;background-color:transparent;outline:none;" readonly/></span><div class="w3-col l12 m12 s12 nrc07Div w3-hide-small"  style="margin-top:0px;"><input id="tpin07" value="'+tpin+'" class="clearOnTransactionSuccess" type="text" style="float:left;border:none;background-color:transparent;outline:none;max-width: 150px;" readonly/><input id="nrc07" Placeholder="Nrc No:" class="clearOnTransactionSuccess" type="text" style="display:none;float:left;border:none;background-color:transparent;outline:none;max-width: 150px;" readonly/> </span><span class="w3-col l12 m12 s4 invoicedClientEmail0Div"  style="margin-top:0px;"><input id="invoicedClientEmail0" class="clearOnTransactionSuccess w3-hide-small" Placeholder="Email:" type="email"  style="float:left;border:none;background-color:transparent;outline:none;min-width:250px;" readonly/></span><span class="w3-col l12 m12 s4 invoicedClientPhone0Div"  style="margin-top:0px;"><input id="invoicedClientPhone0" class="clearOnTransactionSuccess" placeholder="Phone Number:" type="number" style="float:left;border:none;background-color:transparent;outline:none;max-width: 130px;-webkit-appearance: none;appearance: none;background-image: none;text-indent: 0.01px;" readonly/></span></div>');
      $('#invoice_modal_div_0').append('<div class="inner-data-div w3-col l12 m12 s12" style="margin-top:20px;background-color:var(--primary-color-transparent2);font-weight:600;"><div class="w3-col l4 m4 s6"><span id="addProductToInvoice101-0" style="padding:7px;cursor:pointer;">Product/Account<span class="fontx fx-plus"></span></span></div><div class="w3-col l2 m2 s2">Balance BF</div><div class="w3-col l1 m1 s1 w3-hide-small">Price</div><div class="w3-col l1 m1 s1 w3-hide-small">Units</div><div class="w3-col l2 m2 s2">Bill</div><div class="w3-col l2 m2 s2">Closing Balance</div></div>');
      $('#invoice_modal_div_0').append('<div class="displayInvoice77 inner-data-div w3-col l12 m12 s12" style="margin-top:0px;background-color:var(--primary-color-transparent);padding-left:7px;"></div>');
      $('#invoice_modal_div_0').append('<div class="inner-data-div w3-col l12 m12 s12" style="margin-top:0px;background-color:var(--primary-color-transparent1);font-weight:600;border-bottom:1px solid gray"><div class="w3-col l4 m4 s4"><span style="padding:7px;cursor:pointer;"><b>Totals: </b></span></div><div class="w3-col l2 m2 s3 totalBalanceBroughttForward">00</div><div class="w3-col l1 m1 s1 totalInvoicePrices w3-hide-small" style="color:transparent">00</div><div class="w3-col l1 m1 s1 totalInvoiceUnits w3-hide-small" style="color:transparent">00</div><div class="w3-col l2 m2 s3 totalBilledAmounts">00</div><div class="w3-col l2 m2 s2 closingBalanceTotal">00</div></div>');
      $('#invoice_modal_div_0').append('<div class="w3-col l12 m12 s12 commentDiv101" style="display:none;"><textarea id="comment101" placeholder="No comment"></textarea></div>');

      $('#invoice_modal_div_0').append('<p class="w3-col l12 m12 s12"><span class="w3-col l6 m6 s12"style="float:left;margin-top: 0px;">Prepared by: <span class="preparedBy-0" style="color:gray"></span></span><span class="w3-col l6 m6 s12 w3-hide-small" style="float:left;margin-top: 0px;"> Signature: <span id="agentSignature" style="color:gray">______________________</span</span></p>');


      $('#invoice_modal').append('<div class="w3-col l12 m12 s12 w3-top w3-card-2 invoiceDivActions101 hideOnPrint" style="padding:5px;color:gray;"><span class="close_invoice_modal" style="float:left;cursor:pointer;"><span class="fontx fx-arrow-left" style="font-size:1.7em;color:var(--primary-color)"></span></span><span class="top-right-navigation-icons101"><span class="fontx fx-share-2" style="margin-top:-20px;margin-right:10px;"></span></span> <span class="top-right-navigation-icons101"><span class="printReceiptBtn102 fontx fx-printer" style="margin-top:-20px;margin-right:10px;"></span></span><span class="top-right-navigation-icons101"><span class="fontx fx-trash-2 clearInvoiceItems" style="margin-right:7px;margin-top:-20px;"></span></span><div class="top-right-navigation-icons101 addInvoiceComment" style="margin-top:-3px;"><span class="fontx fx-edit-2" style="margin-top:-30px;margin-right:10px;"></span></div></div>');

      $('#invoice_modal').append('<div id="invoice_modal_div_1" style="display:none;background-color:white;height:100vh;marg-top:-100px;padding:5px;"></div>');
      $('#invoice_modal').fadeIn('slow');

      ///fetching user data from the database
      getUserFromIndexedDB()  // Retrieve user data from IndexedDB the script is in mainScript.js
      .then((userData) => {
      if (userData.length > 0) {
      const user = userData[0]; // Assuming the first user record is the relevant one

      // Update the UI elements with user data 
      $('.org_name').empty().append(user.orgname);              
      $('.org_email').empty().append(user.org_email);
      $('.org_contacts').empty().append(user.org_contacts);
      $('.org_address').empty().append(user.org_address); 
      $('.pobox').empty().append(user.org_p_o_box);
      // $('.preparedBy').empty().append(user.username); 

      // Check if the user has an org logo stored as a Blob
      if (user.org_logo) {
      // Convert Blob to a URL that can be used in the `img` element
      const logoURL = URL.createObjectURL(user.org_logo);

      // Create an img element and set its source to the Blob URL
      const imgElement = $('<img>', {
      src: logoURL,  // Set the image source (Blob URL)
      alt: 'Organization Logo', // Alt text for the image
      class: 'org_logo',   // Optional: Add a class for styling
      });

      // Append the image to the DOM
      $('.org_logo_div').empty().append(imgElement); // Assuming there's a container with class 'org-logo-container'
      } else {
      console.error('No organization logo found in user data.');
      }

      // console.log('User data successfully displayed while offline:', user);
      } else {
      // console.error('No user data found in IndexedDB while offline.');
      }
      })
      .catch((error) => {
      console.error('Error retrieving user data from IndexedDB:', error);
      });



      invoiceCart.clearCart();

      //fetch bank details
      $.getJSON('xd-modules/agent-module/backend/getBankAccounts.php',function(data){
      $('#bankname99').empty();
      $.each(data.details, function(i,cyberdesk) {
      $('#bankname99').append('<option value="'+cyberdesk.account_name+'" data-accountnumber="'+cyberdesk.account_number+'" data-sortcode="'+cyberdesk.sort_code+'" data-branch="'+cyberdesk.branch+'">'+cyberdesk.account_name+'</option>');
      });

      });




      document.getElementById('invoicedClientName0').value='';
    document.getElementById('invoicedClientName0').value=clientname;
      document.getElementById('invoicedClientAddress0').vallue='';
      document.getElementById('invoicedClientAddress0').value=address;
      document.getElementById('plotnumber07').value='';
      document.getElementById('plotnumber07').value=plotnumber;
      document.getElementById('area07').value='';
      document.getElementById('area07').value=area;
      document.getElementById('nrc07').value='';
      document.getElementById('nrc07').value=nrc;
      document.getElementById('invoicedClientEmail0').value='';
      document.getElementById('invoicedClientEmail0').value=email;
      $('#invoicedClientId0').empty();
      $('#invoicedClientId0').append(userid);
      $('#pacra00').empty();
      $('#pacra00').append(pacra); 

      $('#businesscategory00').empty();
      $('#businesscategory00').append(businessCategory); 
      document.getElementById('invoicedClientPhone0').value ='';
      document.getElementById('invoicedClientPhone0').value = phone;

      if(userid!='' && invoicenumber!=''){

      datastring='invoicenumber='+invoicenumber+'&userid='+userid;

      $.ajax({         
      data: datastring,
      url: "xd-modules/billing-module/billing/backend/getOriginalInvoice.php",
      type: "POST"
      }).done(function(data) {
      console.log(data); // Log the raw data for inspection
      var detailsx = JSON.parse(data); // Parse the JSON data
      console.log(detailsx); // Log the parsed object to see its structure

      // Initialize sum variables
      let totalBalanceBroughtForward = 0;
      let totalCount = 0;
      let total = 0;
      let totalBalanceCF = 0;

      // Loop through the details to access original_receipt_details
      $.each(detailsx.details, function(index, detail) {

      //append 
      $('.preparedBy-0').empty().append(detail.names); 
      document.getElementById('invoiceDueDate').value='';
      document.getElementById('invoiceDueDate').value=detail.due_date; 
      document.getElementById('comment101').value='';
      document.getElementById('comment101').value=detail.comment; 

      // Parse the original_receipt_details string into an array
      var originalReceiptDetails = JSON.parse(detail.original_receipt_details);

      // Check if originalReceiptDetails is an array
      if (Array.isArray(originalReceiptDetails)) {
      $.each(originalReceiptDetails, function(i, cyberdesk) {
        // Sum the values
        totalBalanceBroughtForward += Number(cyberdesk.balancebroughtforward);
        totalCount += Number(cyberdesk.count);
        total += Number(cyberdesk.total);
        totalBalanceCF += Number(cyberdesk.balanceCF);

        // Construct the HTML string using the properties of the current item
        var htmlString = `
            <div class="w3-col l12 m12 s12" style="float:left; padding-left:0px;">
                <div class="w3-col l4 m4 s6" style="float:left; padding-left:5px; text-align:left;">
                    <b>${cyberdesk.name}</b>
                </div>
                <div class="w3-col l2 m2 s2">K${cyberdesk.balancebroughtforward}</div>
                <div class="w3-col l1 m1 s1 w3-hide-small">K${cyberdesk.price}</div>
                <div class="w3-col l1 m1 s1 w3-hide-small">
                ${cyberdesk.count}
                </div>
                <div class="w3-col l2 m2 s2">
                K${cyberdesk.total}
                  </div>
                <div class="w3-col l2 m2 s2">K${cyberdesk.balanceCF}</div>
            </div>`;

        // Append the constructed HTML to your desired container
        $('.displayInvoice77').append(htmlString);
      });
      } else {
      // console.error("Expected an array but received:", originalReceiptDetails);
      }

      });

      //append totals
      $('.totalBalanceBroughttForward').empty().append('K'+totalBalanceBroughtForward+'');
      $('.totalInvoiceUnits').empty().append(totalCount); 
      $('.totalBilledAmounts').empty().append('K'+total+''); 
      $('.closingBalanceTotal').empty().append('K'+totalBalanceCF+'');

      });



      }else{
      alert('Something went wrong tryreload or refresh and try again!');

      }




      };
      //// end of DISPLAYING INVOICE


