<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../../xd-assets/backend/config/dbconfig.php';

$userloggedid = $_SESSION["userid"];
$orgid0 = $_SESSION["orgid"];
$orgname0 = $_SESSION["orgname"];
$username = $_SESSION["username"];
$workflow_id = filter_input(INPUT_POST, "workflowid");
$reversalAction = filter_input(INPUT_POST, "reversalActtion");
$receiptNumber = filter_input(INPUT_POST, "receiptNumber");
$comment = filter_input(INPUT_POST, "comment");
$type = filter_input(INPUT_POST, "type");
$id = filter_input(INPUT_POST, "id");
$current_step = filter_input(INPUT_POST, "currentstep");
$next_step_plus = ++$current_step;

try {
    // Retrieve next role and step based on current step in workflow_steps
    /*
    $workflowStepstQuery = "SELECT step_order,role, next_step
                            FROM workflow_steps
                            WHERE workflow_id = :workflowid 
                            AND step_order = (SELECT current_step FROM workflow_requests WHERE id = :id)";
*/
$workflowStepstQuery = "SELECT step_order,role, next_step
FROM workflow_steps
WHERE workflow_id = :workflowid 
AND step_order = :nextStepPlus";
    $workflowSteps = $conn->prepare($workflowStepstQuery);
    $workflowSteps->bindParam(':nextStepPlus', $next_step_plus);
   // $workflowSteps->bindParam(':id', $id);
    $workflowSteps->bindParam(':workflowid', $workflow_id);
    $workflowSteps->execute();

    if ($workflowSteps->rowCount() > 0) {
        // Fetch role and next_step
        $stepData = $workflowSteps->fetch(PDO::FETCH_ASSOC);
        $nextRole = $stepData['role'];
        $nextStep = $stepData['next_step'];
        $stepOrder = $stepData['step_order'];
        // Update workflow_requests using the retrieved role and next_step, and approval_date to current timestamp
        $updateQuery = "UPDATE workflow_requests
                        SET response_comment = :comment, 
                            status = :reversalAction, 
                            approved_by = :userloggedid, 
                            approval_date = NOW(),
                            current_step = :stepOrder, 
                            role_in_progress = :nextRole
                            
                        WHERE receipt_number = :receiptNumber 
                        AND workflow_type = :type";

        $updateStmt = $conn->prepare($updateQuery);
        $updateStmt->bindParam(':receiptNumber', $receiptNumber);
        $updateStmt->bindParam(':userloggedid', $userloggedid);
        $updateStmt->bindParam(':comment', $comment);
        $updateStmt->bindParam(':reversalAction', $reversalAction);  // Make sure this binds correctly
        $updateStmt->bindParam(':stepOrder', $stepOrder);
        $updateStmt->bindParam(':nextRole', $nextRole);
        $updateStmt->bindParam(':type', $type);
       
        if ($updateStmt->execute()) {
            // Successful update
            $json_data = [
                'status' => 'Updated',
                'receiptNumber' => $receiptNumber,
            ];
        } else {
            // Update failed
            $json_data = [
                'status' => 'Update failed',
            ];
        }
    } else {
        // No workflow step found for given criteria
        $json_data = [
            'status' => 'No matching workflow step',
        ];
    }
} catch (PDOException $e) {
    $json_data = ["error" => "Database error: " . $e->getMessage()];
} catch (Exception $e) {
    $json_data = ["error" => $e->getMessage()];
}

// Output JSON response
echo json_encode($json_data);
exit;
?>
