<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../../xd-assets/backend/config/dbconfig.php';

$userloggedid = $_SESSION["userid"];  // Make sure this session variable is set
$userid = filter_input(INPUT_POST, "userid", FILTER_SANITIZE_NUMBER_INT);  // Assuming user id is numeric
$searchKey = filter_input(INPUT_POST, "searchKey", FILTER_SANITIZE_FULL_SPECIAL_CHARS);  // Updated sanitation

// Updated SQL query with parameterized placeholders
$getproductsquery = "
    SELECT 
        users.area,
        users.area_id,
        users.area_code,
        tblproduct.id,
        tblproduct.name,
        tblproduct.price,
        tblproduct.charge_rate,
        tblproduct.product_code,
        tblproduct.description,
        tblproduct.category,
        tblproduct.category_code,
        tblproduct.units,
        tblproduct.workAddress,
        tblproduct.lat_area,
        tblproduct.lng_area,
        tblproduct.radius,
        tblproduct.user_id,
        tblproduct.status,
        tblproduct.datemodified,
        COALESCE(SUM(billing_subscription.balance), 0) AS balancebroughtforward
    FROM 
        tblproduct 
    INNER JOIN 
        users ON users.id = :userid
    LEFT JOIN 
        billing_subscription ON billing_subscription.client_id = :userid AND billing_subscription.product_id = tblproduct.id
    WHERE 
        tblproduct.status != 'deleted' 
        AND (tblproduct.name LIKE :searchKey OR tblproduct.product_code LIKE :searchKey)
    GROUP BY 
        tblproduct.id
    ORDER BY 
        tblproduct.name ASC
";

$getproducts = $conn->prepare($getproductsquery);

// Bind the parameters safely
$searchKeyWithWildcards = "%{$searchKey}%";
$getproducts->bindParam(':userid', $userid, PDO::PARAM_INT);
$getproducts->bindParam(':searchKey', $searchKeyWithWildcards, PDO::PARAM_STR);

$getproducts->execute();
$getproducts->setFetchMode(PDO::FETCH_ASSOC);

// Check if data was returned
if ($getproducts->rowCount() == 0) {
    $json_data = array(
        "details" => 'No Data'
    );
    echo json_encode($json_data);
    exit;

} else {
    $totalrecords = $getproducts->rowCount();
    $nestedData = array();

    while ($row = $getproducts->fetch()) {
        $nestedData[] = $row;
    }

    $json_data = array(
        "details" => $nestedData,   // total data array
        'numofrows' => $totalrecords
    );

    echo json_encode($json_data);
    exit;
}
?>
