<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../../xd-assets/backend/config/dbconfig.php';

try {
    
    // Retrieve and validate the input parameters
    $startDateInput = filter_input(INPUT_POST, "startDate");
    $endDateInput = filter_input(INPUT_POST, "endDate");
    $searchKey = filter_input(INPUT_POST, "searchKey");
    $paymentStatus = filter_input(INPUT_POST, "paymentStatus");
   // $billingAccountId=filter_input(INPUT_POST, "billingAccountId");

    // Validate input parameters
    if (empty($startDateInput) && empty($endDateInput) && empty($searchKey) && empty($paymentStatus)) {
        throw new Exception("At least one input parameter is required");
    }

    // Create variables to store the conditions for the SQL query
    $conditions = [];
    $parameters = [];

    // Check if each input parameter is not empty and add it to the conditions array
     //$paymentStatus
     if (!empty($paymentStatus)) {
        if ($paymentStatus === 'Paid') {  // Checking for both string and int zero
            $conditions[] = "balance = 0";
           // $parameters[':paymentStatus'] = 0;
        } elseif ($paymentStatus === 'Due') {
            $conditions[] = "balance > 0";
        } elseif ($paymentStatus === 'Overdue') {
            $conditions[] = "balance > 0 AND due_date < DATE_SUB(CURDATE(), INTERVAL 3 MONTH)";
        }
    }

    if (!empty($startDateInput)) {
        $conditions[] = "due_date >= :start_date";
        $parameters[':start_date'] = date('Y-m-d', strtotime($startDateInput));
    }
    if (!empty($endDateInput)) {
        $conditions[] = "due_date <= :end_date";
        $parameters[':end_date'] = date('Y-m-d', strtotime($endDateInput));
    }
    if (!empty($searchKey)) {
        $conditions[] = "(business_category LIKE :search_key)";
        $parameters[':search_key'] = '%' . $searchKey . '%';
    }
    // Prepare the SQL query with the conditions
  
    $query = "SELECT 
    COUNT(product_id) AS accounts, 
    SUM(paid) AS paid,
    SUM(balance) AS balance,
    SUM(CASE WHEN balance = 0 THEN 1 ELSE 0 END) AS zero_balance_count,
       billing_subscription.product_id,
       billing_subscription.business_category
FROM 
    billing_subscription  
WHERE  document_type = 'INVOICE' AND status = 'Active'";


    if (!empty($conditions)) {
        $query .= " AND " . implode(" AND ", $conditions);
    }

    $query .= " GROUP BY business_category ORDER BY business_category ASC";

    // Prepare and execute the SQL statement
    $getDrivers = $conn->prepare($query);
    $getDrivers->execute($parameters);

    // Process results
    $jobdetails = [];
    $totalProductTotal = 0; 
    while ($rowDs = $getDrivers->fetch(PDO::FETCH_ASSOC)) {
        $jobdetails[] = $rowDs;
        $totalProductTotal += $rowDs['balance']; 
    }

    // Prepare JSON response
    $json_data = [
        "details" => $jobdetails,
        'numofrows' => count($jobdetails),
        "totalProductTotal" => $totalProductTotal
    ];

    // Return JSON response
    echo json_encode($json_data);
    exit;
} catch (PDOException $e) {
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
?>
