<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

// Include database configuration
require_once '../../../../xd-assets/backend/config/dbconfig.php';

try {
    // Connect to the database
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $searchKey = filter_input(INPUT_POST, "searchKey");

    // Query to retrieve product details and their totals
    $getproductsquery = "SELECT  
                            id,cfname,clname,cemail,cphone,product_name,product_id,transaction_amount,quantity,transaction_reference,transaction_status,order_details,user_id,agent_id,trans_type,depot,delivery_address,area,plot_no,nrc,lat,lng,transaction_date,transaction_time,receipt_no,invoiceNumber,receipt_date,payment_mode,bank_name,bank_account_name,bank_deposit_slip,bank_deposit_id,business_category,pacra,tpin
                        FROM 
                            transaction_details 
                        WHERE 
                        tpin=:searchKey
                        AND
                        debit_or_credit='Credit' 
                        AND (transaction_status='approved' OR transaction_status='active' OR transaction_status='Pending') 
                        ORDER BY 
                        id DESC";

    // Execute the query
    $getproducts = $conn->prepare($getproductsquery);
    $getproducts->bindParam(':searchKey',$searchKey);
    $getproducts->execute();
    $getproducts->setFetchMode(PDO::FETCH_ASSOC);

    // Initialize variables
    $nestedData = array(); 
    $totalTransactionAmount = 0; 
	$totalQuantity = 0;
    // Fetch individual records and calculate total sum
    while ($row = $getproducts->fetch()) { 
        $totalTransactionAmount += $row['transaction_amount']; 
		$totalQuantity += $row['quantity']; 
        $nestedData[] = $row;
    }

    // Prepare the response data
    $totalrecords = count($nestedData);
    $json_data = array(
        "details" => $nestedData,   // total data array
        "totalTransactionAmount" => $totalTransactionAmount,
        "totalQuantity" => $totalQuantity,
        "numofrows" => $totalrecords 
    );

    // Send data as JSON format
    echo json_encode($json_data);
    exit;
} catch(PDOException $e) {
    // Handle database connection errors
    $error_message = "Connection failed: " . $e->getMessage();
    echo json_encode(array("error" => $error_message));
    exit;
}
?>
