<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../../xd-assets/backend/config/dbconfig.php';

try {
    // Retrieve and validate the input parameters
    $startDateInput = filter_input(INPUT_POST, "startDate");
    $endDateInput = filter_input(INPUT_POST, "endDate");
    $searchKey = filter_input(INPUT_POST, "searchKey");
    $reversalStatus = filter_input(INPUT_POST, "reversalStatus");

    // Validate input parameters
    if (empty($startDateInput) && empty($endDateInput) && empty($searchKey) && empty($reversalStatus)) {
        throw new Exception("At least one input parameter is required");
    }

    // Create variables to store the conditions for the SQL query
    $conditions = [];
    $parameters = [];

    // Handle reversalStatus
    if (!empty($reversalStatus) && $reversalStatus !== 'All') {
        $validStatuses = ['Approved', 'Pending', 'Declined'];
        if (in_array($reversalStatus, $validStatuses)) {
            $conditions[] = "new_status = :reversal_status";
            $parameters[':reversal_status'] = $reversalStatus;
        }
    }

    // Handle date filters
    if (!empty($startDateInput)) {
        $conditions[] = "change_date >= :start_date";
        $parameters[':start_date'] = date('Y-m-d', strtotime($startDateInput));
    }
    if (!empty($endDateInput)) {
        $conditions[] = "change_date <= :end_date";
        $parameters[':end_date'] = date('Y-m-d', strtotime($endDateInput));
    }

    // Handle search key
    if (!empty($searchKey)) {
        $conditions[] = "(workflow_logs.receipt_number LIKE :search_key OR users.names LIKE :search_key)";
        $parameters[':search_key'] = '%' . $searchKey . '%';
    }

    // Build the SQL query
    $query = "SELECT 
        transaction_details.transaction_amount,workflow_logs.log_id, workflow_logs.workflow_request_id, workflow_logs.receipt_number,
        workflow_logs.previous_status, workflow_logs.new_status, workflow_logs.previous_approved_by, 
        workflow_logs.new_approved_by, workflow_logs.previous_current_step, workflow_logs.new_current_step, 
        workflow_logs.previous_role_in_progress, workflow_logs.new_role_in_progress, workflow_logs.change_date, 
        workflow_logs.changed_by, workflow_requests.approved_by, workflow_requests.requester_name, 
        users.names, users.role
    FROM workflow_logs
    INNER JOIN workflow_requests ON workflow_requests.receipt_number = workflow_logs.receipt_number
    INNER JOIN users ON users.id = workflow_requests.approved_by
    WHERE workflow_logs.log_type = 'RECEIPT' AND workflow_requests.workflow_type = 'RECEIPT'";

    // Add conditions if any
    if (!empty($conditions)) {
        $query .= " AND " . implode(" AND ", $conditions);
    }

    $query .= " ORDER BY workflow_logs.receipt_number DESC LIMIT 500";

    // Debugging: Log query and parameters
    // error_log(print_r(['query' => $query, 'parameters' => $parameters], true));

    // Prepare and execute the query
    $getDrivers = $conn->prepare($query);
    $getDrivers->execute($parameters);

    // Process results
    $jobdetails = [];
    while ($rowDs = $getDrivers->fetch(PDO::FETCH_ASSOC)) {
        $jobdetails[] = $rowDs;
    }

    // Prepare JSON response
    $json_data = [
        "details" => $jobdetails,
        'numofrows' => count($jobdetails),
    ];

    // Return JSON response
    echo json_encode($json_data);
    exit;

} catch (PDOException $e) {
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
