<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../../xd-assets/backend/config/dbconfig.php';

$userloggedid = $_SESSION["userid"];
$userid = filter_input(INPUT_POST, "userid");

// Updated SQL query with LEFT JOIN to include the summed balance from billing_subscription
$getproductsquery = "
    SELECT 
        users.area,
        users.area_id,
        users.area_code,
        tblproduct.id,
        tblproduct.name,
        tblproduct.price,
        tblproduct.charge_rate,
        tblproduct.product_code,
        tblproduct.description,
        tblproduct.category,
        tblproduct.category_code,
        tblproduct.units,
        tblproduct.workAddress,
        tblproduct.lat_area,
        tblproduct.lng_area,
        tblproduct.radius,
        tblproduct.user_id,
        tblproduct.status,
        tblproduct.datemodified,
        COALESCE(SUM(billing_subscription.balance), 0) AS balancebroughtforward  -- Sum balancebroughtforward, default to 0 if NULL
    FROM 
        tblproduct 
    INNER JOIN 
        users ON users.id = '$userid' 
    LEFT JOIN 
        billing_subscription ON billing_subscription.client_id = '$userid' AND billing_subscription.product_id = tblproduct.id
    WHERE 
        tblproduct.status != 'deleted' 
    GROUP BY 
        tblproduct.id  -- Group by product id to sum balancebroughtforward correctly
    ORDER BY 
        tblproduct.name ASC
";

$getproducts = $conn->prepare($getproductsquery);
$getproducts->execute();
$getproducts->setFetchMode(PDO::FETCH_ASSOC);

if ($getproducts->rowCount() == 0) {
    $json_data = array(
        "details" => 'No Data'
    );
    echo json_encode($json_data);  // send data as json format
    exit;

} else if ($getproducts->rowCount() > 0) {
    $totalrecords = $getproducts->rowCount();
    $nestedData = array();

    while ($row = $getproducts->fetch()) {
        $nestedData[] = $row;
    }

    $json_data = array(
        "details" => $nestedData,   // total data array
        'numofrows' => $totalrecords
    );

    echo json_encode($json_data);  // send data as json format
    exit;
}
?>
