<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../../xd-assets/backend/config/dbconfig.php';

$userid = filter_input(INPUT_POST, "userid"); 
$invoicenumber = filter_input(INPUT_POST, "invoicenumber"); 

$getproductsquery = "
   SELECT 
       billing_subscription.b_id, 
       billing_subscription.invoice_no,
       billing_subscription.due_date,
       billing_subscription.due_time,
       delivery_address,
       billing_subscription.plot_number,
       billing_subscription.area,
       billing_subscription.user_id,
       billing_subscription.timestamp AS invoicedate,
       billing_subscription.depot,
       billing_subscription.depot_id,
       billing_subscription.depot_code,
       billing_subscription.original_receipt_details,
       billing_subscription.comment,
       users.names 
   FROM billing_subscription
   LEFT JOIN users ON users.id=billing_subscription.session_id
   WHERE document_type = 'INVOICE'
   AND invoice_no = :invoicenumber
   AND client_id = :userid ORDER BY invoice_no ASC LIMIT 1" ;

$getproducts = $conn->prepare($getproductsquery);

$getproducts->bindParam(':userid', $userid, PDO::PARAM_INT);
$getproducts->bindParam(':invoicenumber', $invoicenumber, PDO::PARAM_INT);

$getproducts->execute();

$getproducts->setFetchMode(PDO::FETCH_ASSOC); 

if ($getproducts->rowCount() == 0) {
    $totalrecords = $getproducts->rowCount();
    $json_data = array(
        'numofrows' => $totalrecords 
    );
    echo json_encode($json_data);
    exit;
} else if ($getproducts->rowCount() > 0) {
    $totalrecords = $getproducts->rowCount();
    $nestedData = array();
    while($row = $getproducts->fetch()) {
        $nestedData[] = $row;
    }
    $json_data = array(
        "details" => $nestedData,
        'numofrows' => $totalrecords
    );
    echo json_encode($json_data);
    exit;
}
?>
