<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
header('Content-Type: application/json');

session_start();
require_once '../../../xd-assets/backend/config/dbconfig.php';

$productId = filter_input(INPUT_POST, 'product_id', FILTER_VALIDATE_INT);
$billingInterval = filter_input(INPUT_POST, 'billing_interval');
$autoBillingEnabled = filter_input(INPUT_POST, 'auto_billing_enabled', FILTER_VALIDATE_BOOLEAN);
//$nextBillingDate = filter_input(INPUT_POST, 'next_billing_date', FILTER_VALIDATE_BOOLEAN);
$autoEmailEnabled = filter_input(INPUT_POST, 'auto_email_enabled', FILTER_VALIDATE_BOOLEAN);
$autoSmsEnabled = filter_input(INPUT_POST, 'auto_sms_enabled', FILTER_VALIDATE_BOOLEAN);

$userId = $_SESSION["userid"] ?? 0;
$orgId = $_SESSION["orgid"] ?? '100';

if (!$productId || !$billingInterval) {
    echo json_encode(['success' => false, 'message' => 'Product ID and billing interval are required']);
    exit;
}

try {
    // Get product details
    $productQuery = "SELECT name, product_code FROM tblproduct WHERE id = ?";
    $productStmt = $conn->prepare($productQuery);
    $productStmt->execute([$productId]);
    $product = $productStmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$product) {
        throw new Exception('Product not found');
    }
    
    // Calculate next billing date based on interval
    $nextBillingDate = calculateNextBillingDate($billingInterval);
    
    // Check if schedule already exists
    $checkQuery = "SELECT id FROM billing_schedules WHERE product_id = ? AND org_id = ?";
    $checkStmt = $conn->prepare($checkQuery);
    $checkStmt->execute([$productId, $orgId]);
    
    if ($checkStmt->rowCount() > 0) {
        // Update existing schedule
        $updateQuery = "UPDATE billing_schedules 
                       SET billing_interval = ?, auto_billing_enabled = ?, 
                           next_billing_date = ?, auto_email_enabled = ?, auto_sms_enabled = ?, status = 'active'
                       WHERE product_id = ? AND org_id = ?";
        $stmt = $conn->prepare($updateQuery);
        $stmt->execute([$billingInterval, $autoBillingEnabled ? 1 : 0, $nextBillingDate, $autoEmailEnabled, $autoSmsEnabled, $productId, $orgId]);
    } else {
        // Insert new schedule
        $insertQuery = "INSERT INTO billing_schedules (
            product_id, product_name, product_code, billing_interval,
            auto_billing_enabled, next_billing_date, status, org_id
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, 'active', ?)";
        
        $stmt = $conn->prepare($insertQuery);
        $stmt->execute([
            $productId, $product['name'], $product['product_code'],
            $billingInterval, $autoBillingEnabled ? 1 : 0, $nextBillingDate, $orgId
        ]);
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'Billing schedule saved successfully'
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error saving schedule: ' . $e->getMessage()
    ]);
}

function calculateNextBillingDate($interval) {
    $today = new DateTime();
    
    switch ($interval) {
        case 'daily':
            return $today->modify('+1 day')->format('Y-m-d');
        case 'weekly':
            return $today->modify('+1 week')->format('Y-m-d');
        case 'monthly':
            return $today->modify('+1 month')->format('Y-m-d');
        case 'quarterly':
            return $today->modify('+3 months')->format('Y-m-d');
        case 'yearly':
            return $today->modify('+1 year')->format('Y-m-d');
        default:
            return $today->modify('+1 month')->format('Y-m-d');
    }
}
?>