<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
header('Content-Type: application/json');

session_start();
require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    $orgId = $_SESSION["orgid"] ?? '100';
    
    // Get billing schedules with product information
    $query = "SELECT 
                bs.id as schedule_id,
                bs.product_id,
                bs.product_name,
                bs.product_code,
                bs.billing_interval,
                bs.status,
                bs.last_billing_date,
                bs.next_billing_date,
                bs.auto_billing_enabled,
                bs.auto_email_enabled,
                bs.auto_sms_enabled,
                p.price,
                p.category,
                COUNT(DISTINCT bsub.client_id) as active_subscribers
              FROM billing_schedules bs
              LEFT JOIN tblproduct p ON p.id = bs.product_id
              LEFT JOIN billing_subscription bsub ON bsub.product_id = bs.product_id 
                AND bsub.b_status = 'Active' 
                AND bsub.org_id = bs.org_id
              WHERE bs.org_id = ?
              GROUP BY bs.id
              ORDER BY bs.next_billing_date ASC, bs.product_name ASC";
    
    $stmt = $conn->prepare($query);
    $stmt->execute([$orgId]);
    $schedules = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'schedules' => $schedules
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?>