<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
header('Content-Type: application/json');

session_start();
require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    $orgId = $_SESSION["orgid"] ?? '100';
    
    // Check if billing_runs table exists
    $tableCheck = $conn->query("SHOW TABLES LIKE 'billing_runs'");
    
    if ($tableCheck->rowCount() > 0) {
        // Updated query to use product_id and product_name from billing_runs table
        $query = "SELECT 
                    br.id,
                    br.product_id,
                    br.product_name,
                    br.run_date,
                    br.run_time,
                    br.run_type,
                    br.total_clients_billed,
                    br.total_invoices_generated,
                    br.total_amount_billed,
                    br.status,
                    br.run_by_user_name
                  FROM billing_runs br
                  WHERE br.org_id = ?
                  ORDER BY br.run_date DESC, br.run_time DESC
                  LIMIT 500";
        
        $stmt = $conn->prepare($query);
        $stmt->execute([$orgId]);
        $history = $stmt->fetchAll(PDO::FETCH_ASSOC);
    } else {
        // If billing_runs table doesn't exist, return empty array
        $history = [];
    }
    
    echo json_encode([
        'success' => true,
        'history' => $history,
        'table_exists' => $tableCheck->rowCount() > 0
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?>