<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    $userloggedid = $_SESSION["userid"];

    // Retrieve and validate input
    $startDateInput = filter_input(INPUT_POST, "startDate");
    $endDateInput = filter_input(INPUT_POST, "endDate");
    $searchKey = filter_input(INPUT_POST, "searchKey");

    if (empty($startDateInput)) {
        throw new Exception("startDate parameter is empty");
    }

    $startDate = date_create_from_format('Y-m-d', $startDateInput);
    $endDate = $endDateInput ? date_create_from_format('Y-m-d', $endDateInput) : new DateTime();

    if ($startDate === false) {
        throw new Exception("Invalid start date format: $startDateInput");
    }

    if ($endDate < $startDate) {
        throw new Exception("End date cannot be before start date");
    }

    $startDateFormatted = $startDate->format('Y-m-d');
    $endDateFormatted = $endDate->format('Y-m-d');

    // Prepare SQL query
    $conditions = [
        "agent_id = :userloggedid",
        "transaction_date >= :start_date",
        "transaction_date <= :end_date",
    ];
    $parameters = [
        ':userloggedid' => $userloggedid,
        ':start_date' => $startDateFormatted,
        ':end_date' => $endDateFormatted,
    ];

    if (!empty($searchKey)) {
        $conditions[] = "(receipt_no LIKE :search_key OR offline_receipt LIKE :search_key OR cfname LIKE :search_key OR clname LIKE :search_key OR cphone LIKE :search_key)";
        $parameters[':search_key'] = '%' . $searchKey . '%';
    }

    $getDriversQuery = "
        SELECT SUM(transaction_amount) AS receipt_total, id, cfname, clname, cemail, cphone, product_name, product_id,product_code, 
               transaction_amount, quantity, transaction_reference, transaction_status, order_details, trans_type, 
               delivery_address, area, plot_no, nrc, lat, lng, transaction_date, transaction_time, receipt_no, offline_receipt,
               invoiceNumber, comment, receipt_date, payment_mode, bank_name, bank_account_name, bank_deposit_slip, 
               bank_deposit_id, business_category, pacra, tpin
        FROM transaction_details
        WHERE " . implode(" AND ", $conditions) . "
        GROUP BY receipt_no
        ORDER BY receipt_no DESC
        LIMIT 500";

    $getDrivers = $conn->prepare($getDriversQuery);

    // Bind parameters
    foreach ($parameters as $key => $value) {
        $getDrivers->bindValue($key, $value);
    }

    $getDrivers->execute();

    // Process results
    $jobdetails = [];
    while ($rowDs = $getDrivers->fetch(PDO::FETCH_ASSOC)) {
        $jobdetails[] = $rowDs;
    }

    // Prepare JSON response
    $json_data = [
        "details" => $jobdetails,
        'numofrows' => count($jobdetails),
    ];

    echo json_encode($json_data);
    exit;
} catch (PDOException $e) {
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
