<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../xd-assets/backend/config/dbconfig.php';

// Set the PDO error mode to exception
$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Retrieve and decode the JSON data from the POST request
$json = file_get_contents('php://input');
$data = json_decode($json, true);

// Check for JSON decode errors
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid JSON data']);
    exit;
}

foreach ($data['transactions'] as $transaction) {
    $userloggedid = $_SESSION["userid"];
    $orgid = $_SESSION["orgid"];
    $orgname = $_SESSION["orgname"];

    $getServiceRequestQuery = "SELECT id, receipt_no FROM transaction_details ORDER BY id DESC LIMIT 1";
    $getServiceRequest = $conn->prepare($getServiceRequestQuery);
    $getServiceRequest->execute();

    $getServiceRequest->setFetchMode(PDO::FETCH_ASSOC); 

    if ($getServiceRequest->rowCount() == 0) {
        echo 'something wrong';
        exit;
    } else if ($getServiceRequest->rowCount() == 1) {
        $row = $getServiceRequest->fetch();
        $last_transaction_id = $row['id'];
        $last_transaction_receipt_no = $row['receipt_no'];  
        $invoiceNumber = ++$last_transaction_receipt_no; 

        // Ensure offline_receipt is not null or empty
        $offline_receipt = isset($transaction['offline_receipt']) ? $transaction['offline_receipt'] : null;
        
        // Check if offline_receipt already exists in the database
        if ($offline_receipt) {
            $checkOfflineReceiptQuery = "SELECT offline_receipt FROM transaction_details WHERE offline_receipt = :offline_receipt";
            $checkOfflineReceiptStmt = $conn->prepare($checkOfflineReceiptQuery);
            $checkOfflineReceiptStmt->bindParam(':offline_receipt', $offline_receipt, PDO::PARAM_STR);
            $checkOfflineReceiptStmt->execute();
            $existingReceipts = $checkOfflineReceiptStmt->fetchAll(PDO::FETCH_ASSOC);

            if (count($existingReceipts) > 0) {
                // Collect all the receipt numbers where the offline_receipt already exists
                $existingReceiptNumbers = array_map(function($receipt) {
                    return $receipt['offline_receipt'];
                }, $existingReceipts);

                echo json_encode([
                    'status' => 'exists',
                    'message' => 'Offline receipt already exists.',
                    'offline_receip' => $existingReceiptNumbers
                ]);
                exit;
            }
        }

        // Get other transaction details
        $agentid = isset($transaction['userid']) ? $transaction['userid'] : null;
        $agentname = isset($transaction['agent_name']) ? $transaction['agent_name'] : null;
        $clientid = isset($transaction['clientid']) ? $transaction['clientid'] : null;
        $phone = isset($transaction['phone']) ? $transaction['phone'] : null;
        $fname = isset($transaction['fname']) ? $transaction['fname'] : null;
        $lname = isset($transaction['lname']) ? $transaction['lname'] : null;
        $email = isset($transaction['email']) ? $transaction['email'] : null;
        $deliverylat = isset($transaction['deliverylat']) ? $transaction['deliverylat'] : null;
        $deliverylng = isset($transaction['deliverylng']) ? $transaction['deliverylng'] : null;
        $deliveryaddress = isset($transaction['deliveryaddress']) ? $transaction['deliveryaddress'] : null;
        $businessCategory = isset($transaction['businessCategory']) ? $transaction['businessCategory'] : null;
        $transtype = isset($transaction['transtype']) ? $transaction['transtype'] : null;
        $pacra = isset($transaction['pacra']) ? $transaction['pacra'] : null;
        $tpin = isset($transaction['tpin']) ? $transaction['tpin'] : null;
        $plotnumber = isset($transaction['plotnumber']) ? $transaction['plotnumber'] : null;
        $area = isset($transaction['area']) ? $transaction['area'] : null;
        $nrc = isset($transaction['nrc']) ? $transaction['nrc'] : null;
        $comment = isset($transaction['comment']) ? $transaction['comment'] : null;
        $payment_mode = isset($transaction['payment_mode']) ? $transaction['payment_mode'] : null;
        $transaction_reference = uniqid('d', true);
        $order_code = uniqid('o', true);
        $payment_mode = 'CASH';
        $debit_or_credit = 'Credit';
        $bankName ='CASH'; 
        $bankAccountName = 'CASH';
        
        // Prepare the date and time values
        $d = strtotime("+2 hours");
        $invoiceDueDate = date("Y-m-d", $d); 
        $transaction_date = date("Y-m-d", $d);
        $transaction_time = date("H:i:s", $d);
        $day = strtotime($transaction_date);
        $day = date('l', $day);

        $datex = new DateTime($transaction_date);
        $month = $datex->format('F'); // Full month name, e.g. January
        $week = $datex->format('W'); // Week number of the year

     
        $productname = 0;
        $category = '';
        $item_price = 0;
        $total_quantity = 0;
        $total_price = 0; 
        $productid =0;
        $productcode =0;
        $categorycode =0;
        $depot = '';
        $depotid = 0;
        $depotcode = 0;
        $balanceCF = 0;
  
        if (!empty($_SESSION["userid"]) && !empty($_SESSION["orgid"]) && !empty($_SESSION["orgname"]) && !empty($transaction['userid']) && !empty($transaction['agent_name'])) {
      foreach ($transaction['orderDetails'] as $item) {
          $productname = $item["name"];
          $category = $item["category"];
          $total_quantity = $item["count"];
          $total_price = ($item["price"] * $item["count"]);
          $productid = $item["id"];
          $productcode = $item["productcode"];
          $categorycode = $item["categorycode"];
          $depot = $item["depot"];
          $depotid = $item["depotid"];
          $depotcode = $item["depotcode"];
          $balance_bf = $item["balance_bf"];
          $balance = $item["balance"];
          $balanceCF = $item["balanceCF"];
          $total = $item["total"];
  
      // Insert the new transaction into the database
      $insertnewuserQuery = "INSERT INTO transaction_details (cfname, clname, cemail, cphone, product_name, product_id, product_code,product_category,product_category_code, balance_bf, transaction_amount, transaction_balance,quantity, order_code, transaction_reference, transaction_status, user_id, agent_name, agent_id, trans_type, debit_or_credit,depot,depot_id,depot_code,delivery_address,area,plot_no,nrc,lat,lng,transaction_date, transaction_time, transaction_month, transaction_week, transaction_day, receipt_no, invoiceNumber, offline_receipt, comment, receipt_date, payment_mode, bank_name, bank_account_name,business_category, pacra, tpin,org_name,org_id,sessionUserId)
      VALUES ('$fname', '$lname', '$email', '$phone', '$productname', '$productid', '$productcode', '$category', '$categorycode', '$balance_bf', '$total', '$balanceCF', '$total_quantity', '$order_code', '$transaction_reference', 'active', '$clientid', '$agentname', '$agentid', '$transtype', '$debit_or_credit', '$depot','$depotid','$depotcode','$deliveryaddress','$area','$plotnumber','$nrc', '$deliverylat', '$deliverylng', '$transaction_date', '$transaction_time', '$month', '$week','$day','$invoiceNumber', '$invoiceNumber', '$offline_receipt','$comment', '$invoiceDueDate', '$payment_mode', '$bankName', '$bankAccountName', '$businessCategory', '$pacra', '$tpin','$orgname','$orgid','$userloggedid');";
      $insertnewUser = $conn->prepare($insertnewuserQuery);
      // $insertnewUser->bindParam(':userid',$userloggedid); 
      // Execute the insert statement
      if ($insertnewUser->execute()) {
        $responses[] = [
            'status' => 'created',
            'receiptnumber' => $invoiceNumber,
            'offline_receipt' => $offline_receipt
        ];
      } else {
          echo json_encode(['status' => 'not created']);
      }
  }

}
//

    }
    // Send all responses as a JSON array
    echo json_encode($responses);
}
?>
