<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo "Connection failed: " . $e->getMessage();
    exit;
}

$startDateInput = filter_input(INPUT_POST, "startDate");
$endDateInput = filter_input(INPUT_POST, "endDate");
$searchKey = filter_input(INPUT_POST, "searchKey");
$selectedClient = filter_input(INPUT_POST, "selectedClient");
$status = filter_input(INPUT_POST, "status");

// Remove the block that prevents fetching when all parameters are empty
// if (empty($startDateInput) && empty($endDateInput) && empty($searchKey)) {
//     echo json_encode(["error" => "At least one input parameter is required"]);
//     exit;
// }

$conditions = [];
$parameters = [];

if (!empty($startDateInput)) {
    $conditions[] = "users.signup >= :start_date";
    $parameters[':start_date'] = date('Y-m-d', strtotime($startDateInput));
}

if (!empty($endDateInput)) {
    $conditions[] = "users.signup <= :end_date";
    $parameters[':end_date'] = date('Y-m-d', strtotime($endDateInput));
}

if (!empty($searchKey)) {
    $conditions[] = "(users.email LIKE :search_key OR users.names LIKE :search_key OR users.phone LIKE :search_key OR users.nrc LIKE :search_key OR users.org_name LIKE :search_key OR users.company_registration_number LIKE :search_key OR users.tpin LIKE :search_key OR users.plot_number LIKE :search_key)";
    $parameters[':search_key'] = '%' . $searchKey . '%';
}

$getproductsquery = "SELECT clients.status, clients.business_category,business_categories.category_name,clients.account_type,clients.client_category, clients.depot_id, depots.depot_name,users.id, users.email, users.names, users.phone, users.address, users.nrc, users.avatar, users.company_registration_number, users.tpin, users.area, users.plot_number, users.user_type, users.signup
                    FROM clients
                    INNER JOIN users ON clients.user_id = users.id
                    INNER JOIN business_categories ON clients.business_category = business_categories.bc_id AND clients.org_id = business_categories.org_id
                    INNER JOIN depots ON clients.depot_id = depots.depot_id AND clients.org_id = depots.org_id";

if (!empty($status)) {
    $getproductsquery .= " AND clients.status = :status";
    $parameters[':status'] = $status;
}

if (!empty($conditions)) {
    $getproductsquery .= " AND " . implode(" AND ", $conditions);
}

$getproductsquery .= " ORDER BY users.names ASC LIMIT 300";

try {
    $getproducts = $conn->prepare($getproductsquery);
    $getproducts->execute($parameters);
} catch (PDOException $e) {
    echo "Query execution failed: " . $e->getMessage();
    exit;
}

$getproducts->setFetchMode(PDO::FETCH_ASSOC);

$totalrecords = $getproducts->rowCount();

$nestedData = [];

while ($row = $getproducts->fetch()) {
    $nestedData[] = $row;
}

if ($totalrecords === 0) {
    echo json_encode(["error" => "No clients found"]);
    exit;
}

$json_data = [
    "freelancedetails" => $nestedData,
    'numofrows' => $totalrecords
];

echo json_encode($json_data);
exit;