<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../xd-assets/backend/config/dbconfig.php';

$userloggedid = $_SESSION["userid"];
$orgid0 = $_SESSION["orgid"];
$orgname0 = $_SESSION["orgname"];
$username = $_SESSION["username"];
$current_step = 1;
$workflow_id = 1;

$receiptNumber = filter_input(INPUT_POST, "receiptNumber");
$comment = filter_input(INPUT_POST, "comment");
$type= filter_input(INPUT_POST, "type");

// Check if the receipt number already exists in the workflow_requests table
$checkReceiptQuery = "SELECT receipt_number FROM workflow_requests WHERE receipt_number = :receiptNumber";
$checkReceipt = $conn->prepare($checkReceiptQuery);
$checkReceipt->bindParam(':receiptNumber', $receiptNumber);
$checkReceipt->execute();

if ($checkReceipt->rowCount() > 0) {
    // Receipt number already exists
    $json_data = array(
        'status' => 'Reversal request already exists for this receipt number!',
        'message' => 'This receipt number already exists in reversal requests.'
    );
} else {
    // Proceed with insertion if receipt number does not exist
    $insertQuery = "INSERT INTO workflow_requests (receipt_number, requested_by, requester_name, comment, workflow_type, current_step, workflow_id, org_name, org_id) 
                    VALUES(:receiptNumber, :userloggedid, :username, :comment, :type, :currentstep, :workflowid, :orgname0, :orgid0)";
    $insertStmt = $conn->prepare($insertQuery);
    $insertStmt->bindParam(':receiptNumber', $receiptNumber);
    $insertStmt->bindParam(':userloggedid', $userloggedid);
    $insertStmt->bindParam(':username', $username);
    $insertStmt->bindParam(':comment', $comment);
    $insertStmt->bindParam(':orgname0', $orgname0);
    $insertStmt->bindParam(':orgid0', $orgid0);
    $insertStmt->bindParam(':type', $type);
    $insertStmt->bindParam(':workflowid', $workflow_id);
    $insertStmt->bindParam(':currentstep', $current_step);

    if ($insertStmt->execute()) {
        // Successful insertion
        // Update transaction_status in transaction_details table
        $updateQuery = "UPDATE transaction_details SET transaction_status = 'Reversal Request', deposit_status = 'Reversal Request' WHERE receipt_no = :receiptNumber";
        $updateStmt = $conn->prepare($updateQuery);
        $updateStmt->bindParam(':receiptNumber', $receiptNumber);
        if ($updateStmt->execute()) {
            $json_data = array(
                'status' => 'Your request has been submitted and transaction status updated to "Reversal Request".',
                'receiptnumber' => $receiptNumber,
            );
        } else {
            // Failed to update transaction_details
            $json_data = array(
                'status' => 'Request submitted but failed to update transaction status.',
                'receiptnumber' => $receiptNumber,
            );
        }
    } else {
        // Insertion failed
        $json_data = array(
            'status' => 'not created'
        );
    }
}

echo json_encode($json_data);  // Send data as JSON format
exit;
?>
