<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Logged-in user
    $userloggedid = $_SESSION["userid"] ?? null;
    $org_id = $_SESSION["orgid"] ?? null; 
    // Get POSTed values
    $amount = filter_input(INPUT_POST, "amount", FILTER_SANITIZE_NUMBER_INT);
    $receiptNumber = filter_input(INPUT_POST, "receiptNumber", FILTER_SANITIZE_NUMBER_INT);
    $clientName = filter_input(INPUT_POST, "clientName", FILTER_UNSAFE_RAW);
    $clientPhone = filter_input(INPUT_POST, "clientPhone", FILTER_UNSAFE_RAW);

    if ($amount && $receiptNumber && $userloggedid) {
        $sql = "INSERT INTO reprints (amount, receipt_number, client_name, client_number, reprinted_by, org_id, timestamp) 
                VALUES (:amount, :receipt_number, :client_name, :client_number, :reprinted_by, :org_id, CURRENT_TIMESTAMP)";
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':amount', $amount, PDO::PARAM_INT);
        $stmt->bindParam(':receipt_number', $receiptNumber, PDO::PARAM_INT);
        $stmt->bindParam(':client_name', $clientName, PDO::PARAM_STR);
        $stmt->bindParam(':client_number', $clientPhone, PDO::PARAM_STR);
        $stmt->bindParam(':reprinted_by', $userloggedid, PDO::PARAM_INT);
        $stmt->bindParam(':org_id', $org_id, PDO::PARAM_INT);

        if ($stmt->execute()) {
            echo json_encode(['status' => 'reprinted']);
        } else {
            echo json_encode(['status' => 'notposted']);
        }
    } else {
        echo json_encode(['status' => 'invalid_input']);
    }

} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>
