<?php
function generateReceiptNumber(PDO $conn, int $orgid): int {
    try {
        $conn->beginTransaction();

        // Lock the receipt counter row for this org
        $query = "SELECT last_receipt_no FROM receipt_counters WHERE org_id = :orgid FOR UPDATE";
        $stmt = $conn->prepare($query);
        $stmt->execute([':orgid' => $orgid]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$row) {
            $newNumber = 1;
            $insert = $conn->prepare("INSERT INTO receipt_counters (org_id, last_receipt_no) VALUES (:orgid, :receipt_no)");
            $insert->execute([':orgid' => $orgid, ':receipt_no' => $newNumber]);
        } else {
            $newNumber = $row['last_receipt_no'] + 1;
            $update = $conn->prepare("UPDATE receipt_counters SET last_receipt_no = :receipt_no WHERE org_id = :orgid");
            $update->execute([':receipt_no' => $newNumber, ':orgid' => $orgid]);
        }

        $conn->commit();
        return $newNumber;
    } catch (Exception $e) {
        $conn->rollBack();
        throw new Exception("Failed to generate receipt number: " . $e->getMessage());
    }
}
?>
