<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    // Retrieve and validate the input parameters
    $startDateInput = filter_input(INPUT_POST, "startDate");
    $endDateInput = filter_input(INPUT_POST, "endDate");
    $searchKey = filter_input(INPUT_POST, "searchKey");
    $paymentStatus = filter_input(INPUT_POST, "paymentStatus");
    $userloggedid=$_SESSION["userid"];
    // Validate input parameters
    if (empty($startDateInput) && empty($endDateInput) && empty($searchKey) && empty($paymentStatus)) {
        throw new Exception("At least one input parameter is required");
    }

    // Create variables to store the conditions for the SQL query
    $conditions = [];
    $parameters = [];

    // Check if each input parameter is not empty and add it to the conditions array
    if (!empty($paymentStatus)) {
        if ($paymentStatus === 'All') {
            // $conditions[] = "status = 0";
        } elseif ($paymentStatus === 'Approved') {
            $conditions[] = "wr.status = 'Approved'";
        } elseif ($paymentStatus === 'Pending') {
            $conditions[] = "wr.status = 'Pending'";
        } elseif ($paymentStatus === 'Declined') {
            $conditions[] = "wr.status = 'Declined'";
        }
    }

    if (!empty($startDateInput)) {
        $conditions[] = "wr.request_date >= :start_date";
        $parameters[':start_date'] = date('Y-m-d', strtotime($startDateInput));
    }
    if (!empty($endDateInput)) {
        $conditions[] = "wr.request_date <= :end_date";
        $parameters[':end_date'] = date('Y-m-d', strtotime($endDateInput));
    }
    if (!empty($searchKey)) {
        $conditions[] = "(wr.receipt_number LIKE :search_key OR wr.requester_name LIKE :search_key)";
        $parameters[':search_key'] = '%' . $searchKey . '%';
    }

    // Prepare the SQL query with the join and conditions
	$query = "SELECT wr.id, wr.receipt_number, wr.requested_by, wr.requester_name, wr.request_date, 
	wr.comment, wr.status, wr.current_step, wr.workflow_id, wr.role_in_progress,
	MAX(td.user_id) AS user_id, MAX(td.clname) AS clname, MAX(td.cfname) AS cfname, 
	MAX(td.cphone) AS cphone, MAX(td.cemail) AS cemail, MAX(td.delivery_address) AS delivery_address, 
	MAX(td.pacra) AS pacra, MAX(td.tpin) AS tpin, MAX(td.business_category) AS business_category, 
	MAX(td.plot_no) AS plot_no, MAX(td.area) AS area, MAX(td.nrc) AS nrc, 
	MAX(td.transaction_date) AS transaction_date 
FROM workflow_requests wr
LEFT JOIN transaction_details td ON wr.receipt_number = td.receipt_no
WHERE wr.workflow_type = 'RECEIPT' AND wr.requested_by='$userloggedid'";

if (!empty($conditions)) {
$query .= " AND " . implode(" AND ", $conditions);
}

$query .= " GROUP BY wr.id ORDER BY wr.id DESC LIMIT 500";



    // Prepare and execute the SQL statement
    $getDrivers = $conn->prepare($query);
    $getDrivers->execute($parameters);

    // Process results
    $jobdetails = [];
    while ($rowDs = $getDrivers->fetch(PDO::FETCH_ASSOC)) {
        $jobdetails[] = $rowDs;
    }

    // Prepare JSON response
    $json_data = [
        "details" => $jobdetails,
        'numofrows' => count($jobdetails),
    ];

    // Return JSON response
    echo json_encode($json_data);
    exit;

} catch (PDOException $e) {
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
?>
