<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../xd-assets/backend/config/dbconfig.php';

//$userid = filter_input(INPUT_POST, "userid"); 
$invoicenumber = filter_input(INPUT_POST, "invoicenumber"); 

$getproductsquery = "
   SELECT 
       id, 
       product_name,
       product_id,
       	transaction_amount,
        	quantity,
            agent_name,
      receipt_no,
      comment,
      payment_mode 
   FROM transaction_details
   WHERE receipt_no = :invoicenumber
    ORDER BY id" ;

$getproducts = $conn->prepare($getproductsquery);

 $getproducts->bindParam(':invoicenumber', $invoicenumber, PDO::PARAM_INT);

$getproducts->execute();

$getproducts->setFetchMode(PDO::FETCH_ASSOC); 

if ($getproducts->rowCount() == 0) {
    $totalrecords = $getproducts->rowCount();
    $json_data = array(
        'numofrows' => $totalrecords 
    );
    echo json_encode($json_data);
    exit;
} else if ($getproducts->rowCount() > 0) {
    $totalrecords = $getproducts->rowCount();
    $nestedData = array();
    while($row = $getproducts->fetch()) {
        $nestedData[] = $row;
    }
    $json_data = array(
        "details" => $nestedData,
        'numofrows' => $totalrecords
    );
    echo json_encode($json_data);
    exit;
}
?>
