<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    $userloggedid = $_SESSION["userid"];

    // Debug: Output received POST data
    // var_dump($_POST);

    // Retrieve and validate the start date
    if (!isset($_POST['startDate']) || empty($_POST['startDate'])) {
        throw new Exception("startDate parameter is empty");
    }

    $startDateInput = $_POST['startDate'];
    $endDateInput = isset($_POST['endDate']) ? $_POST['endDate'] : null;
    $searchKey = isset($_POST['searchKey']) ? $_POST['searchKey'] : null;

    $startDate = $startDateInput ? date_create_from_format('Y-m-d', $startDateInput) : null;
    $endDate = $endDateInput ? date_create_from_format('Y-m-d', $endDateInput) : null;

    if ($startDate === false) {
        throw new Exception("Invalid start date format: $startDateInput");
    }

    $startDateFormatted = $startDate ? $startDate->format('Y-m-d') : null;
    $endDateFormatted = $endDate ? $endDate->format('Y-m-d') : null;

    // SQL query based on date range
    if ($startDateFormatted && !$endDateFormatted) {
        $getServiceRequestQuery = "SELECT SUM(transaction_details.transaction_amount) AS totalprice FROM transaction_details WHERE agent_id=:uid AND payment_mode='CASH' AND deposit_status='Pending' AND transaction_date >= :start_date AND transaction_date <= CURDATE();";
    } elseif (!$startDateFormatted && $endDateFormatted) {
        $getServiceRequestQuery = "SELECT SUM(transaction_details.transaction_amount) AS totalprice FROM transaction_details WHERE agent_id=:uid AND payment_mode='CASH' AND deposit_status='Pending' AND transaction_date <= :end_date;";
    } elseif ($startDateFormatted && $endDateFormatted) {
        $getServiceRequestQuery = "SELECT SUM(transaction_details.transaction_amount) AS totalprice FROM transaction_details WHERE agent_id=:uid AND payment_mode='CASH' AND deposit_status='Pending' AND transaction_date >= :start_date AND transaction_date <= :end_date;";
    }

    $getServiceRequest = $conn->prepare($getServiceRequestQuery);
    $getServiceRequest->bindParam(':uid', $userloggedid);
    if ($startDateFormatted) {
        $getServiceRequest->bindParam(':start_date', $startDateFormatted);
    }
    if ($endDateFormatted) {
        $getServiceRequest->bindParam(':end_date', $endDateFormatted);
    }
    $getServiceRequest->execute();
    $totalpriceRow = $getServiceRequest->fetch(PDO::FETCH_ASSOC);
    $totalprice = $totalpriceRow['totalprice'];

    // Execute query to get transaction details
    if ($startDateFormatted && !$endDateFormatted) {
        $getDriversQuery = "SELECT * FROM transaction_details WHERE agent_id=:uid AND payment_mode='CASH' AND deposit_status='Pending' AND transaction_date >= :start_date AND transaction_date <= CURDATE();";
    } elseif (!$startDateFormatted && $endDateFormatted) {
        $getDriversQuery = "SELECT * FROM transaction_details WHERE agent_id=:uid AND payment_mode='CASH' AND deposit_status='Pending' AND transaction_date <= :end_date;";
    } elseif ($startDateFormatted && $endDateFormatted) {
        $getDriversQuery = "SELECT * FROM transaction_details WHERE agent_id=:uid AND payment_mode='CASH' AND deposit_status='Pending' AND transaction_date >= :start_date AND transaction_date <= :end_date;";
    }

    $getDrivers = $conn->prepare($getDriversQuery);
    $getDrivers->bindParam(':uid', $userloggedid);
    if ($startDateFormatted) {
        $getDrivers->bindParam(':start_date', $startDateFormatted);
    }
    if ($endDateFormatted) {
        $getDrivers->bindParam(':end_date', $endDateFormatted);
    }

    $getDrivers->execute();

    // Process results
    $jobdetails = [];
    while ($rowDs = $getDrivers->fetch(PDO::FETCH_ASSOC)) {
        $jobdetails[] = $rowDs;
    }

    // Prepare JSON response
    $json_data = [
        "details" => $jobdetails,
        'numofrows' => count($jobdetails),
        'total' => $totalprice,
    ];

    // Return JSON response
    echo json_encode($json_data);
    exit;
} catch (PDOException $e) {
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
?>
