<?php
// Error reporting for debugging (remove in production)
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', '/path/to/php_errors.log');

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
header('Content-Type: application/json');

session_start();

// Check authentication
if (!isset($_SESSION["userid"]) || empty($_SESSION["userid"])) {
    http_response_code(401);
    echo json_encode(["error" => "Unauthorized: User not logged in"]);
    exit;
}

$userloggedid = $_SESSION["userid"];

// Verify config file exists
$configPath = '../../../xd-assets/backend/config/dbconfig.php';
if (!file_exists($configPath)) {
    http_response_code(500);
    echo json_encode(["error" => "Configuration file not found"]);
    exit;
}

require_once $configPath;

try {
    // Validate database connection
    if (!$conn) {
        throw new Exception("Database connection failed");
    }

    $searchKey = filter_input(INPUT_POST, "searchKey");

    // Prepare SQL query
    $conditions = [
        "agent_id = :userloggedid",
        "payment_mode = 'CASH'",
        "deposit_status = 'Pending'",
        "transaction_status = 'active'"
    ];
    
    $parameters = [':userloggedid' => $userloggedid];

    if (!empty($searchKey)) {
        $conditions[] = "(receipt_no LIKE :search_key OR offline_receipt LIKE :search_key OR cfname LIKE :search_key OR clname LIKE :search_key OR cphone LIKE :search_key)";
        $parameters[':search_key'] = '%' . $searchKey . '%';
    }

    $getDriversQuery = "
        SELECT transaction_amount, id, cfname, clname, cemail, cphone, product_name, product_id, 
               transaction_amount, quantity, transaction_reference, transaction_status, order_details, trans_type, 
               delivery_address, area, plot_no, nrc, lat, lng, transaction_date, transaction_time, receipt_no, offline_receipt,
               invoiceNumber, comment, receipt_date, payment_mode, bank_name, bank_account_name, bank_deposit_slip, 
               bank_deposit_id, business_category, pacra, tpin
        FROM transaction_details
        WHERE " . implode(" AND ", $conditions) . "
        ORDER BY receipt_no DESC";

    $getDrivers = $conn->prepare($getDriversQuery);
    
    if (!$getDrivers) {
        throw new Exception("Failed to prepare query: " . implode(", ", $conn->errorInfo()));
    }

    // Bind parameters
    foreach ($parameters as $key => $value) {
        $getDrivers->bindValue($key, $value);
    }

    if (!$getDrivers->execute()) {
        throw new Exception("Failed to execute query");
    }

    // Process results
    $totalCash = 0;
    $jobdetails = [];
    
    while ($rowDs = $getDrivers->fetch(PDO::FETCH_ASSOC)) {
        $jobdetails[] = $rowDs;
        $totalCash += floatval($rowDs['transaction_amount']);
    }

    // Prepare JSON response
    $json_data = [
        "totalCash" => $totalCash,
        "details" => $jobdetails,
        'numofrows' => count($jobdetails),
    ];

    // FIX: Output linear JSON (single line)
    echo json_encode($json_data, JSON_UNESCAPED_SLASHES);
    
} catch (PDOException $e) {
    error_log("Database error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(["error" => "Database error occurred"]);
} catch (Exception $e) {
    error_log("General error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(["error" => "An error occurred: " . $e->getMessage()]);
}
exit;