<?php 
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
    $userloggedid = $_SESSION["userid"];

    // Retrieve and validate the start date
    $startDateInput = filter_input(INPUT_POST, "startDate");
    $endDateInput = filter_input(INPUT_POST, "endDate");
    $searchKey = filter_input(INPUT_POST, "searchKey");
    if (empty($startDateInput)) {
        throw new Exception("startDate parameter is empty");
    }

    $startDate = date_create_from_format('Y-m-d', $startDateInput);
    $endDate = $endDateInput ? date_create_from_format('Y-m-d', $endDateInput) : new DateTime();
    
    if ($startDate === false) {
        throw new Exception("Invalid start date format: $startDateInput");
    }
    
    // Validate date range
    if ($endDate < $startDate) {
        throw new Exception("End date cannot be before start date");
    }

    $startDateFormatted = $startDate->format('Y-m-d');
    $endDateFormatted = $endDate->format('Y-m-d');

    // Prepare and execute the SQL statement for grouped details
    $getDriversQuery = "
    SELECT 
        id,
        product_name,
        product_id,
        product_code,
        SUM(transaction_amount) AS total_amount, 
        agent_id
    FROM 
        transaction_details 
    WHERE 
        trans_type='RECEIPT'
        AND (transaction_status='active' OR transaction_status='approved' OR transaction_status='Cashed In')
        AND agent_id = :userloggedid
        AND transaction_date >= :start_date AND transaction_date <= :end_date
    GROUP BY product_id 
    ORDER BY total_amount DESC";

    $getDrivers = $conn->prepare($getDriversQuery);
    $getDrivers->bindParam(':userloggedid', $userloggedid);
    $getDrivers->bindParam(':start_date', $startDateFormatted);
    $getDrivers->bindParam(':end_date', $endDateFormatted);
    $getDrivers->execute();

    // Process grouped results
    $jobdetails = [];
    $totalCollection = 0;
    while ($rowDs = $getDrivers->fetch(PDO::FETCH_ASSOC)) {
        $jobdetails[] = $rowDs;
        $totalCollection += $rowDs['total_amount'];
    }

    // Prepare JSON response
    $json_data = [
        "details" => $jobdetails,
        "numofrows" => count($jobdetails),
        "totalCollection" => $totalCollection,
    ];

    // Return JSON response
    echo json_encode($json_data);
    exit;

} catch (PDOException $e) {
    echo json_encode(["error" => "Database connection error: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}
?>
