<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();

require_once '../../../xd-assets/backend/config/dbconfig.php';

try {
   $userloggedid = $_SESSION["userid"];
 
    $getproductsquery = "
        SELECT 
            transaction_details.id,
            transaction_details.product_name,
            transaction_details.product_id,transaction_details.product_code,
            SUM(transaction_details.transaction_amount) AS total_amount,
            rota.target AS individual_target,
            total_target.total_target AS total_target,
            total_amount.total_amount AS total_transaction_amount,
            transaction_details.agent_id
        FROM 
            transaction_details 
        LEFT JOIN 
            rota ON rota.user_id = transaction_details.agent_id AND rota.rota_code = transaction_details.product_id
        LEFT JOIN 
            (SELECT user_id, SUM(target) AS total_target FROM rota WHERE user_id = :userloggedid GROUP BY user_id) AS total_target
            ON total_target.user_id = transaction_details.agent_id
        LEFT JOIN 
            (SELECT agent_id, SUM(transaction_amount) AS total_amount FROM transaction_details WHERE transaction_date = CURDATE() GROUP BY agent_id) AS total_amount
            ON total_amount.agent_id = transaction_details.agent_id
        WHERE 
            trans_type='RECEIPT'
            AND transaction_details.agent_id = :userloggedid
            AND (transaction_status='active' OR transaction_status='approved'  OR transaction_status='Cashed In')
        GROUP BY 
            transaction_details.product_id";

    $getproducts = $conn->prepare($getproductsquery);
    $getproducts->bindParam(':userloggedid', $userloggedid);
    $getproducts->execute();
    $getproducts->setFetchMode(PDO::FETCH_ASSOC);

    $totalrecords = $getproducts->rowCount();

    if ($totalrecords == 0) {
        $json_data = array(
            'numofrows' => $totalrecords
        );
        echo json_encode($json_data);
        exit;
    } else {
        $nestedData = array();
        while ($row = $getproducts->fetch()) {
            $nestedData[] = $row;
        }

        $json_data = array(
            "details" => $nestedData,
            'numofrows' => $totalrecords
        );

        echo json_encode($json_data);
        exit;
    }
} catch (PDOException $e) {
    echo "Connection failed: " . $e->getMessage();
}
?>
