<?php
       header('Access-Control-Allow-Origin: *');
       header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
       //i want to reduce the balance of 'billing_subscription' table column 'balance' with '$total' where client_id='$userid' AND product_id='$productid'. the query should be able to determine the value in the balance column and subtruct is by that value or amount and then move to the next row, the deduction or subtraction should begin with the oldest invoice_no. when all the other row balances are zero then the current row where invoice_no='$hiddenInvoiceNumber' should be deducted with the remaining total balance.
        session_start();
       
       require_once '../../../xd-assets/backend/config/dbconfig.php';
       
       $conn = new PDO("mysql:host=$servername;dbname=$database", $username, $password);	 
       $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
       
       $agentname = $_SESSION["username"];
       $userloggedid = $_SESSION["userid"];
       $orgid = $_SESSION["orgid"];
       $orgname = $_SESSION["orgname"];
       
     // Generate a new receipt and use its ID as the invoice number
$receiptInsert = $conn->prepare("INSERT INTO receipts (issuer_id, org_id) VALUES (:agent_id, :org_id)");
$receiptInsert->bindParam(':org_id', $orgid, PDO::PARAM_INT);
$receiptInsert->bindParam(':agent_id', $userloggedid, PDO::PARAM_INT);
$receiptInsert->execute();

// Get the auto-incremented ID and use it as invoiceNumber
$receiptNumber = $conn->lastInsertId();
$invoiceNumber = $receiptNumber; // Now this replaces $last_transaction_receipt_no
 
           // File upload handling
           $imagePath = 'xd-uploads/documents/deposits-slips/noslip.png'; // Default value for no file uploaded
           if (isset($_FILES['field-upload']) && $_FILES['field-upload']['error'] == UPLOAD_ERR_OK) {
               $targetDir = "../../../xd-uploads/documents/deposits-slips/";
       
               // Get the original file name, remove spaces, and prepend a unique ID
               $originalName = pathinfo($_FILES["field-upload"]["name"], PATHINFO_FILENAME);
               $extension = pathinfo($_FILES["field-upload"]["name"], PATHINFO_EXTENSION);
               $new_name = uniqid() . '_' . str_replace(' ', '_', $originalName) . '.' . $extension;
       
               $targetPath = $targetDir . $new_name; 
               $imagePath = "xd-uploads/documents/deposits-slips/" . $new_name;
       
               // Move the uploaded file
               if (!move_uploaded_file($_FILES["field-upload"]["tmp_name"], $targetPath)) {
                   // Handle file upload error
                   $json_data = array(
                       'status' => 'upload error'
                   );
                   echo json_encode($json_data);
                   exit;
               }
           }
       
           // Proceed with inserting transaction details
           $userid = filter_input(INPUT_POST, "userid");
           $fname = filter_input(INPUT_POST, "fname");
           $lname = filter_input(INPUT_POST, "lname");
           $email = filter_input(INPUT_POST, "email");
           $phone = filter_input(INPUT_POST, "phone");
           $deliveryaddress = filter_input(INPUT_POST, "deliveryaddress");
           $deliverylat = filter_input(INPUT_POST, "deliverylat");
           $deliverylng = filter_input(INPUT_POST, "deliverylng");
           $transtype = filter_input(INPUT_POST, "transtype");
           $payment_mode = 'BANK';
           $debit_or_credit = 'Credit';
           $invoiceNumber = ++$last_transaction_receipt_no;
           $hiddenInvoiceNumber = filter_input(INPUT_POST, "hiddenInvoiceNumber");
           $invoiceDueDate = filter_input(INPUT_POST, "invoiceDueDate");
           $bankId = filter_input(INPUT_POST, "bankId");
           $bankName = filter_input(INPUT_POST, "bankName");
           $bankAccountName = filter_input(INPUT_POST, "bankAccountName");
           $myBankAccountNumber44 = filter_input(INPUT_POST, "myBankAccountNumber44");
           $bankDepositSlipId = filter_input(INPUT_POST, "bankDepositSlipId");
           $deposit_status = 'Pending Approval';
           $transaction_reference = uniqid('d', true);
           $order_code = uniqid('o', true);
           $cartObject = filter_input(INPUT_POST, "orderDetails");
           $productid = filter_input(INPUT_POST, "productid");
           $pacra = filter_input(INPUT_POST, "pacra");
           $tpin = filter_input(INPUT_POST, "tpin");
           $plotnumber = filter_input(INPUT_POST, "plotnumber");
           $area = filter_input(INPUT_POST, "area");
           $nrc = filter_input(INPUT_POST, "nrc");
           $businessCategory = filter_input(INPUT_POST, "businessCategory");
           $comment = filter_input(INPUT_POST, "comment");
           $d = strtotime("+2 hours");
           $transaction_date = date("Y-m-d", $d);
           $transaction_time = date("H:i:s", $d);
           $datex = new DateTime($transaction_date);
           $month = $datex->format('F');
           $week = $datex->format('W');
           $day = $datex->format('l');
       
           // Insert transaction details
           $productname = '';
           $category = '';
           $item_price = 0;
           $total_quantity = 0;
           $total_price = 0;
           $productid = 0;
           $productcode = 0;
           $categorycode = 0;
           $depot = '';
           $depotid = 0;
           $depotcode = 0;
           $balanceCF = 0;
           foreach (json_decode($cartObject, true) as $item) {
               $productname = $item["name"];
               $category = $item["category"];
               $total_quantity = $item["count"];
               $total_price = ($item["price"] * $item["count"]);
               $productid = $item["id"];
               $productcode = $item["productcode"];
               $categorycode = $item["categorycode"];
               $depot = $item["depot"];
               $depotid = $item["depotid"];
               $depotcode = $item["depotcode"];
               $balance_bf = $item["balance_bf"];
               $balance = $item["balance"];
               $balanceCF = $item["balanceCF"];
               $total = $item["total"];
       
               $insertnewuserQuery = "INSERT INTO `transaction_details` 
               (`cfname`, `clname`, `cemail`, `cphone`, `product_name`, `product_id`, `product_code`,`product_category`,`product_category_code`, `balance_bf`, `transaction_amount`, `transaction_balance`, `quantity`, `order_code`, `transaction_reference`, `transaction_status`, `order_details`, `user_id`, `agent_name`, `agent_id`, `trans_type`,`debit_or_credit`,`depot`,`depot_id`,`depot_code`, `delivery_address`,`area`,`plot_no`,`nrc`,`lat`,`lng`,`transaction_date`,`transaction_time`, `transaction_month`, `transaction_week`, `transaction_day`,`receipt_no`, `invoiceNumber`, `comment`, `receipt_date`, `payment_mode`,`bank_id`,`bank_name`,`bank_account_name`,`bank_account_number`,`bank_deposit_slip`,`bank_deposit_id`, `deposit_slip_date`, `deposit_status`, `business_category`, `pacra`, `tpin`,`org_name`,`org_id`)
               VALUES 
               ('$fname', '$lname', '$email', '$phone', '$productname', '$productid', '$productcode', '$category', '$categorycode',  '$balance_bf', '$total', '$balanceCF', '$total_quantity', '$order_code', '$transaction_reference', 'active', '$cartObject', '$userid', '$agentname', '$userloggedid', '$transtype', '$debit_or_credit', '$depot','$depotid','$depotcode','$deliveryaddress','$area','$plotnumber','$nrc', '$deliverylat', '$deliverylng', '$transaction_date', '$transaction_time', '$month', '$week','$day', '$invoiceNumber', '$hiddenInvoiceNumber', '$comment', '$invoiceDueDate', '$payment_mode','$bankId','$bankName','$bankAccountName','$myBankAccountNumber44','$imagePath', '$bankDepositSlipId','$transaction_date','$deposit_status ', '$businessCategory', '$pacra', '$tpin','$orgname','$orgid');";
       
               $insertnewUser = $conn->prepare($insertnewuserQuery);
               $insertnewUser->execute();



/// UPDATING THE BILLING AND SUBSCRIPTION TABLE
/// UPDATING THE BILLING AND SUBSCRIPTION TABLE
/// UPDATING THE BILLING AND SUBSCRIPTION TABLE


// Fetch all invoices for this client/product with non-zero balance, ordered by oldest invoice_no or b_id
$fetchInvoicesQuery = "SELECT b_id, invoice_no, balance 
                       FROM billing_subscription 
                       WHERE client_id = :userid 
                       AND product_id = :productid
                       AND balance != 0
                       ORDER BY invoice_no ASC"; // Ordered by oldest invoice_no

$fetchInvoices = $conn->prepare($fetchInvoicesQuery);
$fetchInvoices->bindParam(':userid', $userid, PDO::PARAM_INT);
$fetchInvoices->bindParam(':productid', $productid, PDO::PARAM_INT);
$fetchInvoices->execute();
$invoices = $fetchInvoices->fetchAll(PDO::FETCH_ASSOC);

// Check if any invoices exist
if (empty($invoices)) {
    // No invoices with a non-zero balance exist, handle this scenario
  //  echo json_encode(array('status' => 'No invoices to deduct from'));
   // exit;
}

$remainingTotal = $total; // Total amount to deduct from invoices

// Loop through the oldest invoices first
foreach ($invoices as $invoice) {
    $invoice_id = $invoice['b_id'];
    $current_balance = $invoice['balance'];

    if ($remainingTotal <= 0) {
        // No remaining total to deduct, exit the loop
        break;
    }

    if ($remainingTotal >= $current_balance) {
        // Deduct the full balance, and set it to zero
        $remainingTotal -= $current_balance;
        $new_balance = 0;
    } else {
        // Deduct only the remaining amount
        $new_balance = $current_balance - $remainingTotal;
        $remainingTotal = 0; // Remaining total has been fully deducted
    }

    // Update the invoice balance in the database
    $updateInvoiceQuery = "UPDATE billing_subscription 
                           SET balance = :new_balance 
                           WHERE b_id = :invoice_id";

    $updateInvoice = $conn->prepare($updateInvoiceQuery);
    $updateInvoice->bindParam(':new_balance', $new_balance, PDO::PARAM_INT);
    $updateInvoice->bindParam(':invoice_id', $invoice_id, PDO::PARAM_INT);
    $updateInvoice->execute();
}

// If there's any remaining amount, deduct it from the latest invoice regardless of balance
if ($remainingTotal > 0) {
    // Step 1: Get the latest invoice_no for this client and product
    $fetchLatestInvoiceQuery = "SELECT invoice_no, balance
                                FROM billing_subscription 
                                WHERE client_id = :userid 
                                AND product_id = :productid 
                                ORDER BY invoice_no DESC LIMIT 1";

    $fetchLatestInvoice = $conn->prepare($fetchLatestInvoiceQuery);
    $fetchLatestInvoice->bindParam(':userid', $userid, PDO::PARAM_INT);
    $fetchLatestInvoice->bindParam(':productid', $productid, PDO::PARAM_INT);
    $fetchLatestInvoice->execute();
    $latestInvoice = $fetchLatestInvoice->fetch(PDO::FETCH_ASSOC);

    if ($latestInvoice) {
        // Update the latest invoice even if the current balance is zero or negative
        $latestInvoiceNo = $latestInvoice['invoice_no'];
        $latestBalance = $latestInvoice['balance'];

        // Deduct from the latest invoice, even if it has zero or negative balance
        $newBalance = $latestBalance - $remainingTotal;

        $updateLatestInvoiceQuery = "UPDATE billing_subscription 
                                     SET balance = :newBalance 
                                     WHERE client_id = :userid 
                                     AND product_id = :productid 
                                     AND invoice_no = :latestInvoiceNo";

        $updateLatestInvoice = $conn->prepare($updateLatestInvoiceQuery);
        $updateLatestInvoice->bindParam(':newBalance', $newBalance, PDO::PARAM_INT);
        $updateLatestInvoice->bindParam(':userid', $userid, PDO::PARAM_INT);
        $updateLatestInvoice->bindParam(':productid', $productid, PDO::PARAM_INT);
        $updateLatestInvoice->bindParam(':latestInvoiceNo', $latestInvoiceNo, PDO::PARAM_INT);
        $updateLatestInvoice->execute();
    } else {
        // If no latest invoice is found, handle this case (though unlikely)
    //    echo json_encode(array('status' => 'No latest invoice found'));
    //    exit;
    }
}

//echo json_encode(array('status' => 'Deduction complete'));


///  end of UPDATING THE BILLING AND SUBSCRIPTION TABLE
/// end of UPDATING THE BILLING AND SUBSCRIPTION TABLE
/// end of UPDATING THE BILLING AND SUBSCRIPTION TABLE

  
           }
       
           if ($insertnewUser) {
               $json_data = array(
                   'status' => 'created',
                   'date' => $transaction_date,
                   'time' => $transaction_time,
                   'receiptnumber' => $invoiceNumber,
               );
               echo json_encode($json_data);
               exit;
           } else {
               $json_data = array(
                   'status' => 'not created'
               );
               echo json_encode($json_data);
               exit;
           }
       
?>
       