<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

session_start();
require_once '../../../../xd-assets/backend/config/dbconfig.php';
 
// Get session variables
$userloggedid = $_SESSION["userid"];
$orgid = $_SESSION["orgid"];
$orgname = $_SESSION["orgname"];

// Retrieve input variables
$staff = filter_input(INPUT_POST, "staff");
$task = filter_input(INPUT_POST, "task");
$taskname = filter_input(INPUT_POST, "taskname");
$month = filter_input(INPUT_POST, "month");
$year = date('Y');  // Set year to the current year dynamically
$week = filter_input(INPUT_POST, "week");
$day = filter_input(INPUT_POST, "day");
$rotastartdate = filter_input(INPUT_POST, "rotastartdate");
$rotaenddate = filter_input(INPUT_POST, "rotaenddate");
$starttime = filter_input(INPUT_POST, "starttime");
$endtime = filter_input(INPUT_POST, "endtime");
//$target = filter_input(INPUT_POST, "target");
$depot_id = filter_input(INPUT_POST, "revenuePointToRota");
$depot_name = filter_input(INPUT_POST, "revenuePointname");
$depot_code = filter_input(INPUT_POST, "depotCode");
$description = filter_input(INPUT_POST, "description");
//$productcode = filter_input(INPUT_POST, "productcode");
//$category = filter_input(INPUT_POST, "category");
//$categorycode = filter_input(INPUT_POST, "categorycode");
$businessCategoryRota = filter_input(INPUT_POST, "businessCategoryRota");
$businesscategorycode = filter_input(INPUT_POST, "businesscategorycode");
$status = filter_input(INPUT_POST, "status");
$target = filter_input(INPUT_POST, "target");

// Update rota table
$updateQuery = "
    UPDATE rota 
    SET 
        name = :taskname, description = :description, location = :depot_name, 
        start_date = :rotastartdate, 
        end_date = :rotaenddate, start_time = :starttime, end_time = :endtime, 
        day = :day, status = :status, week = :week, month = :month, 
        year = :year, user_id = :staff, creator_id = :userloggedid, 
        depot = :depot_name, depot_id = :depot_id, depot_code = :depot_code, 
        business_category = :businessCategoryRota, business_category_code = :businesscategorycode, 
        org_name = :orgname, org_id = :orgid
    WHERE rota_id = :task AND user_id = :staff
";

// Prepare and bind parameters
$updateStmt = $conn->prepare($updateQuery);
$updateStmt->bindParam(':taskname', $taskname);
$updateStmt->bindParam(':description', $description);
$updateStmt->bindParam(':depot_name', $depot_name);
$updateStmt->bindParam(':task', $task);
//$updateStmt->bindParam(':productcode', $productcode);
//$updateStmt->bindParam(':category', $category);
//$updateStmt->bindParam(':categorycode', $categorycode);
$updateStmt->bindParam(':rotastartdate', $rotastartdate);
$updateStmt->bindParam(':rotaenddate', $rotaenddate);
$updateStmt->bindParam(':starttime', $starttime);
$updateStmt->bindParam(':endtime', $endtime);
$updateStmt->bindParam(':day', $day);
$updateStmt->bindParam(':status', $status);
$updateStmt->bindParam(':week', $week);
$updateStmt->bindParam(':month', $month);
$updateStmt->bindParam(':year', $year);
//$updateStmt->bindParam(':target', $target);
$updateStmt->bindParam(':staff', $staff);
$updateStmt->bindParam(':userloggedid', $userloggedid);
$updateStmt->bindParam(':depot_id', $depot_id);
$updateStmt->bindParam(':depot_code', $depot_code);
$updateStmt->bindParam(':businessCategoryRota', $businessCategoryRota);
$updateStmt->bindParam(':businesscategorycode', $businesscategorycode);
$updateStmt->bindParam(':orgname', $orgname);
$updateStmt->bindParam(':orgid', $orgid);

// Execute the query and handle response
$rotaUpdated = $updateStmt->execute();

// Update revenue_target table if rota update succeeded
if ($rotaUpdated) {
    $updateTargetQuery = "
        UPDATE revenue_target SET 
            revenue_target = :target, status = :status
        WHERE rota_id = :task AND user_id = :staff
    ";
    $updateTargetStmt = $conn->prepare($updateTargetQuery);
    $updateTargetStmt->bindParam(':target', $target);
    $updateTargetStmt->bindParam(':task', $task);
    $updateTargetStmt->bindParam(':staff', $staff);
    $updateTargetStmt->bindParam(':status', $status);
    $targetUpdated = $updateTargetStmt->execute();

    if ($targetUpdated) {
        $json_data = ['status' => 'updated'];
    } else {
        $json_data = ['status' => 'rota updated, target not updated'];
    }
} else {
    $json_data = ['status' => 'not updated'];
}
echo json_encode($json_data);
?>
